/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.uif.field;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.krad.uif.UifConstants;
import org.kuali.kfs.krad.uif.component.Component;
import org.kuali.kfs.krad.uif.component.ComponentBase;
import org.kuali.kfs.krad.uif.component.ComponentSecurity;
import org.kuali.kfs.krad.uif.field.Field;
import org.kuali.kfs.krad.uif.field.FieldSecurity;
import org.kuali.kfs.krad.uif.field.LabelField;
import org.kuali.kfs.krad.uif.util.ComponentFactory;
import org.kuali.kfs.krad.uif.view.View;
import org.kuali.rice.core.api.exception.RiceRuntimeException;

public class FieldBase
extends ComponentBase
implements Field {
    private static final long serialVersionUID = -5888414844802862760L;
    private String shortLabel;
    private LabelField labelField;
    private UifConstants.Position labelPlacement = UifConstants.Position.LEFT;
    private boolean labelFieldRendered = false;

    @Override
    public void performInitialization(View view, Object model) {
        super.performInitialization(view, model);
    }

    @Override
    public void performFinalize(View view, Object model, Component parent) {
        super.performFinalize(view, model, parent);
        if (this.labelField != null) {
            this.labelField.setLabelForComponentId(this.getId());
            if (this.getRequired() != null && this.getRequired().booleanValue()) {
                this.labelField.getRequiredMessageField().setRender(true);
            } else {
                this.setRequired(new Boolean(false));
                this.labelField.getRequiredMessageField().setRender(true);
                String prefixStyle = "";
                if (StringUtils.isNotBlank((String)this.labelField.getRequiredMessageField().getStyle())) {
                    prefixStyle = this.labelField.getRequiredMessageField().getStyle();
                }
                this.labelField.getRequiredMessageField().setStyle(prefixStyle + ";" + "display: none;");
            }
            if (this.labelPlacement.equals((Object)UifConstants.Position.RIGHT)) {
                this.labelField.setRenderColon(false);
            }
            if (this.labelPlacement.equals((Object)UifConstants.Position.TOP) || this.labelPlacement.equals((Object)UifConstants.Position.BOTTOM)) {
                this.labelField.addStyleClass("uif-labelBlock");
            }
        }
    }

    @Override
    public final String getComponentTypeName() {
        return "field";
    }

    @Override
    public List<Component> getComponentsForLifecycle() {
        List<Component> components = super.getComponentsForLifecycle();
        components.add(this.labelField);
        return components;
    }

    @Override
    public String getLabel() {
        if (this.labelField != null) {
            return this.labelField.getLabelText();
        }
        return null;
    }

    @Override
    public void setLabel(String label) {
        if (StringUtils.isNotBlank((String)label) && this.labelField == null) {
            this.labelField = ComponentFactory.getLabelField();
        }
        if (this.labelField != null) {
            this.labelField.setLabelText(label);
        }
    }

    @Override
    public String getShortLabel() {
        return this.shortLabel;
    }

    @Override
    public void setShortLabel(String shortLabel) {
        this.shortLabel = shortLabel;
    }

    public void setShowLabel(boolean showLabel) {
        if (this.labelField != null) {
            this.labelField.setRender(showLabel);
        }
    }

    @Override
    public LabelField getLabelField() {
        return this.labelField;
    }

    @Override
    public void setLabelField(LabelField labelField) {
        this.labelField = labelField;
    }

    public UifConstants.Position getLabelPlacement() {
        return this.labelPlacement;
    }

    public void setLabelPlacement(UifConstants.Position labelPlacement) {
        this.labelPlacement = labelPlacement;
    }

    @Override
    public boolean isLabelFieldRendered() {
        return this.labelFieldRendered;
    }

    @Override
    public void setLabelFieldRendered(boolean labelFieldRendered) {
        this.labelFieldRendered = labelFieldRendered;
    }

    @Override
    public FieldSecurity getFieldSecurity() {
        return (FieldSecurity)super.getComponentSecurity();
    }

    @Override
    public void setComponentSecurity(ComponentSecurity componentSecurity) {
        if (!(componentSecurity instanceof FieldSecurity)) {
            throw new RiceRuntimeException("Component security for Field should be instance of FieldSecurity");
        }
        super.setComponentSecurity(componentSecurity);
    }

    @Override
    protected Class<? extends ComponentSecurity> getComponentSecurityClass() {
        return FieldSecurity.class;
    }
}

