/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.uif.field;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.krad.datadictionary.AttributeDefinition;
import org.kuali.kfs.krad.uif.component.Component;
import org.kuali.kfs.krad.uif.control.CheckboxControl;
import org.kuali.kfs.krad.uif.control.Control;
import org.kuali.kfs.krad.uif.control.MultiValueControl;
import org.kuali.kfs.krad.uif.control.MultiValueControlBase;
import org.kuali.kfs.krad.uif.control.TextAreaControl;
import org.kuali.kfs.krad.uif.field.InputField;
import org.kuali.kfs.krad.uif.util.ComponentFactory;
import org.kuali.kfs.krad.uif.util.ComponentUtils;
import org.kuali.kfs.krad.uif.view.View;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;

public class LookupInputField
extends InputField {
    private static final long serialVersionUID = -8294275596836322699L;
    private boolean treatWildcardsAndOperatorsAsLiteral = false;
    private boolean addAllOption = false;

    @Override
    public void performFinalize(View view, Object model, Component parent) {
        MultiValueControl multiValueControl;
        super.performFinalize(view, model, parent);
        if (this.addAllOption && this.getControl() != null && this.getControl() instanceof MultiValueControl && (multiValueControl = (MultiValueControl)((Object)this.getControl())).getOptions() != null) {
            List<KeyValue> fieldOptions = multiValueControl.getOptions();
            fieldOptions.add(0, (KeyValue)new ConcreteKeyValue("", "All"));
            multiValueControl.setOptions(fieldOptions);
        }
    }

    @Override
    public void copyFromAttributeDefinition(View view, AttributeDefinition attributeDefinition) {
        if (StringUtils.isEmpty((String)this.getLabel())) {
            this.setLabel(attributeDefinition.getLabel());
        }
        if (StringUtils.isEmpty((String)this.getShortLabel())) {
            this.setShortLabel(attributeDefinition.getShortLabel());
        }
        if (this.getDataFieldSecurity().getAttributeSecurity() == null) {
            this.getDataFieldSecurity().setAttributeSecurity(attributeDefinition.getAttributeSecurity());
        }
        if (this.getOptionsFinder() == null) {
            this.setOptionsFinder(attributeDefinition.getOptionsFinder());
        }
        if (this.getControl() == null) {
            Control control = LookupInputField.convertControlToLookupControl(attributeDefinition);
            view.assignComponentIds(control);
            this.setControl(control);
        }
        this.setMaxLength(100);
        if (StringUtils.isEmpty((String)this.getDefaultValue()) && StringUtils.equals((String)this.getPropertyName(), (String)"active")) {
            this.setDefaultValue("Y");
        }
    }

    protected static Control convertControlToLookupControl(AttributeDefinition attributeDefinition) {
        if (attributeDefinition.getControlField() == null) {
            return null;
        }
        Control newControl = null;
        if (CheckboxControl.class.isAssignableFrom(attributeDefinition.getControlField().getClass())) {
            newControl = ComponentFactory.getRadioGroupControlHorizontal();
            ArrayList<KeyValue> options = new ArrayList<KeyValue>();
            options.add((KeyValue)new ConcreteKeyValue("Y", "Yes"));
            options.add((KeyValue)new ConcreteKeyValue("N", "No"));
            options.add((KeyValue)new ConcreteKeyValue("", "Both"));
            ((MultiValueControlBase)newControl).setOptions(options);
        } else {
            newControl = TextAreaControl.class.isAssignableFrom(attributeDefinition.getControlField().getClass()) ? ComponentFactory.getTextControl() : ComponentUtils.copy(attributeDefinition.getControlField(), "");
        }
        return newControl;
    }

    public boolean isTreatWildcardsAndOperatorsAsLiteral() {
        return this.treatWildcardsAndOperatorsAsLiteral;
    }

    public void setTreatWildcardsAndOperatorsAsLiteral(boolean treatWildcardsAndOperatorsAsLiteral) {
        this.treatWildcardsAndOperatorsAsLiteral = treatWildcardsAndOperatorsAsLiteral;
    }

    public boolean isAddAllOption() {
        return this.addAllOption;
    }

    public void setAddAllOption(boolean addAllOption) {
        this.addAllOption = addAllOption;
    }
}

