/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.uif.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;
import org.kuali.kfs.krad.uif.component.ReferenceCopy;
import org.kuali.rice.core.api.exception.RiceRuntimeException;

public class CloneUtils {
    private static final Logger LOG = Logger.getLogger(CloneUtils.class);
    private static final Map<String, Field[]> fieldCache = new HashMap<String, Field[]>();
    private static final Map<String, Field> internalFields = new HashMap<String, Field>();

    public static final <O> O deepClone(O original) {
        try {
            return CloneUtils.deepCloneReflection(original);
        }
        catch (Exception e) {
            throw new RiceRuntimeException((Throwable)e);
        }
    }

    public static final <O> O deepCloneReflection(O original) throws Exception {
        return (O)CloneUtils.deepCloneReflectionInternal(original, new HashMap<Object, Object>(), false);
    }

    protected static final Object deepCloneReflectionInternal(Object original, Map<Object, Object> cache, boolean referenceCollectionCopy) throws Exception {
        if (original == null) {
            return original;
        }
        if (cache.containsKey(original)) {
            return cache.get(original);
        }
        Object clone = null;
        clone = List.class.isAssignableFrom(original.getClass()) ? CloneUtils.deepCloneList(original, cache, referenceCollectionCopy) : (Map.class.isAssignableFrom(original.getClass()) ? CloneUtils.deepCloneMap(original, cache, referenceCollectionCopy) : CloneUtils.deepCloneObject(original, cache));
        return clone;
    }

    protected static Object deepCloneObject(Object original, Map<Object, Object> cache) throws Exception {
        if (original instanceof Number) {
            if (!(original instanceof AtomicInteger) && !(original instanceof AtomicLong)) {
                return original;
            }
        } else {
            if (original instanceof String) {
                return original;
            }
            if (original instanceof Character) {
                return original;
            }
            if (original instanceof Class) {
                return original;
            }
            if (original instanceof Boolean) {
                return new Boolean((Boolean)original);
            }
        }
        Class<?> c = original.getClass();
        Field[] fields = CloneUtils.getFields(c, false);
        try {
            Object copy = CloneUtils.instantiate(original);
            cache.put(original, copy);
            for (Field f : fields) {
                Object object = f.get(original);
                boolean referenceCopy = false;
                boolean referenceCollectionCopy = false;
                ReferenceCopy copyAnnotation = f.getAnnotation(ReferenceCopy.class);
                if (copyAnnotation != null) {
                    referenceCopy = true;
                    referenceCollectionCopy = copyAnnotation.newCollectionInstance();
                }
                if (!referenceCopy || referenceCollectionCopy) {
                    object = CloneUtils.deepCloneReflectionInternal(object, cache, referenceCollectionCopy);
                }
                f.set(copy, object);
            }
            return copy;
        }
        catch (Throwable t) {
            LOG.debug((Object)("Exception during clone (returning original): " + t.getMessage()));
            return original;
        }
    }

    protected static Object deepCloneMap(Object original, Map<Object, Object> cache, boolean referenceCollectionCopy) throws Exception {
        Map clone = (Map)CloneUtils.instantiate(original);
        for (Map.Entry entry : ((Map)original).entrySet()) {
            if (referenceCollectionCopy) {
                clone.put(entry.getKey(), entry.getValue());
                continue;
            }
            clone.put(CloneUtils.deepCloneReflectionInternal(entry.getKey(), cache, false), CloneUtils.deepCloneReflectionInternal(entry.getValue(), cache, false));
        }
        return clone;
    }

    protected static Object deepCloneList(Object original, Map<Object, Object> cache, boolean referenceCollectionCopy) throws Exception {
        List clone = (List)CloneUtils.instantiate(original);
        for (Object object : (List)original) {
            if (referenceCollectionCopy) {
                clone.add(object);
                continue;
            }
            clone.add(CloneUtils.deepCloneReflectionInternal(object, cache, false));
        }
        return clone;
    }

    public static Map<String, Annotation> getFieldsWithAnnotation(Class<?> clazz, Class<? extends Annotation> annotationClass) {
        Field[] fields;
        HashMap<String, Annotation> annotationFields = new HashMap<String, Annotation>();
        for (Field f : fields = CloneUtils.getFields(clazz, false)) {
            Annotation fieldAnnotation = f.getAnnotation(annotationClass);
            if (fieldAnnotation == null) continue;
            annotationFields.put(f.getName(), fieldAnnotation);
        }
        return annotationFields;
    }

    public static boolean fieldHasAnnotation(Class<?> clazz, String propertyName, Class<? extends Annotation> annotationClass) {
        Field[] fields = CloneUtils.getFields(clazz, false);
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if (!field.getName().equals(propertyName)) continue;
            Annotation fieldAnnotation = field.getAnnotation(annotationClass);
            return fieldAnnotation != null;
        }
        return false;
    }

    protected static final Object instantiate(Object original) throws InstantiationException, IllegalAccessException {
        return original.getClass().newInstance();
    }

    public static Field[] getFields(Object object, boolean includeStatic) {
        return CloneUtils.getFields(object, includeStatic, true);
    }

    public static Field[] getFields(Object object, boolean includeStatic, boolean includeTransient) {
        Class<?> c = object.getClass();
        return CloneUtils.getFields(c, includeStatic, includeTransient);
    }

    public static Field[] getFields(Class<?> c, boolean includeStatic) {
        return CloneUtils.getFields(c, includeStatic, true);
    }

    public static Field[] getFields(Class<?> c, boolean includeStatic, boolean includeTransient) {
        String cacheKey = c.getCanonicalName() + ":" + includeStatic;
        Field[] array = fieldCache.get(cacheKey);
        if (array == null) {
            ArrayList<Field> fields = new ArrayList<Field>();
            List<Class<?>> classes = CloneUtils.getClassHierarchy(c, false);
            Collections.reverse(classes);
            for (Class<?> clazz : classes) {
                Field[] allFields;
                for (Field f : allFields = clazz.getDeclaredFields()) {
                    boolean isStatic;
                    if (!includeTransient && (f.getModifiers() & 0x80) == 128 || f.isSynthetic()) continue;
                    boolean bl = isStatic = (f.getModifiers() & 8) == 8;
                    if (isStatic && !includeStatic || f.getName().equalsIgnoreCase("serialVersionUID")) continue;
                    f.setAccessible(true);
                    fields.add(f);
                }
            }
            array = fields.toArray(new Field[fields.size()]);
            fieldCache.put(cacheKey, array);
        }
        return array;
    }

    protected static final Field internalField(Object object, String fieldName) {
        if (object == null) {
            System.out.println("Internal Field: " + object + ", " + fieldName);
            return null;
        }
        String key = object.getClass().getCanonicalName() + "." + fieldName;
        Field field = internalFields.get(key);
        if (field == null) {
            Field[] fields;
            for (Field f : fields = CloneUtils.getFields(object.getClass(), false)) {
                String name = f.getName();
                if (!name.equals(fieldName)) continue;
                field = f;
                internalFields.put(key, field);
                break;
            }
        }
        return field;
    }

    protected static List<Class<?>> getClassHierarchy(Class<?> c, boolean includeInterfaces) {
        ArrayList classes = new ArrayList();
        while (c != Object.class) {
            classes.add(c);
            if (includeInterfaces) {
                Class<?>[] interfaces;
                for (Class<?> i : interfaces = c.getInterfaces()) {
                    classes.add(i);
                }
            }
            if ((c = c.getSuperclass()) != null) continue;
            break;
        }
        return classes;
    }
}

