/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.uif.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kfs.krad.uif.component.Configurable;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;

public class UifBeanFactoryPostProcessor
implements BeanFactoryPostProcessor {
    private static final Log LOG = LogFactory.getLog(UifBeanFactoryPostProcessor.class);

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        HashSet<String> processedBeanNames = new HashSet<String>();
        LOG.info((Object)"Beginning post processing of bean factory for UIF expressions");
        String[] beanNames = beanFactory.getBeanDefinitionNames();
        for (int i = 0; i < beanNames.length; ++i) {
            String beanName = beanNames[i];
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition(beanName);
            this.processBeanDefinition(beanName, beanDefinition, beanFactory, processedBeanNames);
        }
        LOG.info((Object)"Finished post processing of bean factory for UIF expressions");
    }

    protected void processBeanDefinition(String beanName, BeanDefinition beanDefinition, ConfigurableListableBeanFactory beanFactory, Set<String> processedBeanNames) {
        PropertyValue[] pvArray;
        Class<?> beanClass = this.getBeanClass(beanDefinition, beanFactory);
        if (beanClass == null || !Configurable.class.isAssignableFrom(beanClass)) {
            return;
        }
        if (processedBeanNames.contains(beanName)) {
            return;
        }
        LOG.debug((Object)("Processing bean name '" + beanName + "'"));
        MutablePropertyValues pvs = beanDefinition.getPropertyValues();
        if (pvs.getPropertyValue("propertyExpressions") != null) {
            return;
        }
        ManagedMap propertyExpressions = new ManagedMap();
        Map<String, String> parentPropertyExpressions = this.getPropertyExpressionsFromParent(beanDefinition.getParentName(), beanFactory, processedBeanNames);
        boolean parentExpressionsExist = !parentPropertyExpressions.isEmpty();
        for (PropertyValue pv : pvArray = pvs.getPropertyValues()) {
            if (this.hasExpression(pv.getValue())) {
                String strValue = this.getStringValue(pv.getValue());
                propertyExpressions.put(pv.getName(), strValue);
                pvs.removePropertyValue(pv.getName());
            } else {
                Object newValue = this.processPropertyValue(pv.getName(), pv.getValue(), parentPropertyExpressions, (Map<String, String>)propertyExpressions, beanFactory, processedBeanNames);
                pvs.removePropertyValue(pv.getName());
                pvs.addPropertyValue(pv.getName(), newValue);
            }
            if (parentPropertyExpressions.containsKey(pv.getName())) {
                parentPropertyExpressions.remove(pv.getName());
            }
            if (!StringUtils.contains((String)pv.getName(), (String)".")) continue;
        }
        if (!propertyExpressions.isEmpty() || parentExpressionsExist) {
            ManagedMap mergedPropertyExpressions = new ManagedMap();
            mergedPropertyExpressions.setMergeEnabled(false);
            mergedPropertyExpressions.putAll(parentPropertyExpressions);
            mergedPropertyExpressions.putAll((Map)propertyExpressions);
            pvs.addPropertyValue("propertyExpressions", (Object)mergedPropertyExpressions);
        }
        if (StringUtils.isNotBlank((String)beanName) && !StringUtils.contains((String)beanName, (String)"$") && !StringUtils.contains((String)beanName, (String)"#") && !beanFactory.containsBean(beanName)) {
            ((BeanDefinitionRegistry)beanFactory).registerBeanDefinition(beanName, beanDefinition);
        }
        if (StringUtils.isNotBlank((String)beanName)) {
            processedBeanNames.add(beanName);
        }
    }

    protected void removeParentExpressionsOnNested(String propertyName, MutablePropertyValues pvs, String parentBeanName, ConfigurableListableBeanFactory beanFactory) {
        PropertyValue[] pvArray;
        BeanDefinition parentBeanDefinition = beanFactory.getMergedBeanDefinition(parentBeanName);
        MutablePropertyValues parentPvs = parentBeanDefinition.getPropertyValues();
        for (PropertyValue pv : pvArray = parentPvs.getPropertyValues()) {
            ManagedMap nestedPropertyExpressions;
            Object value;
            PropertyValue propertyExpressionsPV;
            BeanDefinition propertyBeanDefinition;
            MutablePropertyValues nestedPvs;
            boolean isNameMatch = false;
            String nestedPropertyName = "";
            if (propertyName.startsWith(pv.getName()) && (nestedPropertyName = StringUtils.removeStart((String)propertyName, (String)pv.getName())).startsWith(".")) {
                nestedPropertyName = StringUtils.removeStart((String)nestedPropertyName, (String)".");
                isNameMatch = true;
            }
            if (!isNameMatch || !(pv.getValue() instanceof BeanDefinition) && !(pv.getValue() instanceof BeanDefinitionHolder) || !(nestedPvs = (propertyBeanDefinition = pv.getValue() instanceof BeanDefinition ? (BeanDefinition)pv.getValue() : ((BeanDefinitionHolder)pv.getValue()).getBeanDefinition()).getPropertyValues()).contains("propertyExpressions") || (propertyExpressionsPV = nestedPvs.getPropertyValue("propertyExpressions")) == null || (value = propertyExpressionsPV.getValue()) == null || !(value instanceof ManagedMap) || !(nestedPropertyExpressions = (ManagedMap)value).containsKey(nestedPropertyName)) continue;
            ManagedMap copiedPropertyExpressions = new ManagedMap();
            copiedPropertyExpressions.setMergeEnabled(false);
            copiedPropertyExpressions.putAll((Map)nestedPropertyExpressions);
            copiedPropertyExpressions.remove((Object)nestedPropertyName);
            GenericBeanDefinition copiedBeanDefinition = new GenericBeanDefinition(propertyBeanDefinition);
            copiedBeanDefinition.getPropertyValues().add("propertyExpressions", (Object)copiedPropertyExpressions);
            pvs.add(pv.getName(), (Object)copiedBeanDefinition);
        }
    }

    protected Class<?> getBeanClass(BeanDefinition beanDefinition, ConfigurableListableBeanFactory beanFactory) {
        BeanDefinition parentBeanDefinition;
        if (StringUtils.isNotBlank((String)beanDefinition.getBeanClassName())) {
            try {
                return Class.forName(beanDefinition.getBeanClassName());
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        if (StringUtils.isNotBlank((String)beanDefinition.getParentName()) && (parentBeanDefinition = beanFactory.getBeanDefinition(beanDefinition.getParentName())) != null) {
            return this.getBeanClass(parentBeanDefinition, beanFactory);
        }
        return null;
    }

    protected Map<String, String> getPropertyExpressionsFromParent(String parentBeanName, ConfigurableListableBeanFactory beanFactory, Set<String> processedBeanNames) {
        Object value;
        BeanDefinition beanDefinition;
        MutablePropertyValues pvs;
        PropertyValue propertyExpressionsPV;
        HashMap<String, String> propertyExpressions = new HashMap<String, String>();
        if (StringUtils.isBlank((String)parentBeanName) || !beanFactory.containsBeanDefinition(parentBeanName)) {
            return propertyExpressions;
        }
        if (!processedBeanNames.contains(parentBeanName)) {
            this.processBeanDefinition(parentBeanName, beanFactory.getBeanDefinition(parentBeanName), beanFactory, processedBeanNames);
        }
        if ((propertyExpressionsPV = (pvs = (beanDefinition = beanFactory.getBeanDefinition(parentBeanName)).getPropertyValues()).getPropertyValue("propertyExpressions")) != null && (value = propertyExpressionsPV.getValue()) != null && value instanceof ManagedMap) {
            propertyExpressions.putAll((Map<String, String>)((ManagedMap)value));
        }
        return propertyExpressions;
    }

    protected boolean hasExpression(Object propertyValue) {
        String elPlaceholder;
        String strValue;
        return propertyValue != null && (strValue = this.getStringValue(propertyValue)) != null && StringUtils.isNotBlank((String)(elPlaceholder = StringUtils.substringBetween((String)strValue, (String)"@{", (String)"}")));
    }

    protected Object processPropertyValue(String propertyName, Object propertyValue, Map<String, String> parentPropertyExpressions, Map<String, String> propertyExpressions, ConfigurableListableBeanFactory beanFactory, Set<String> processedBeanNames) {
        if (propertyValue == null) {
            return null;
        }
        if (propertyValue instanceof BeanDefinition || propertyValue instanceof BeanDefinitionHolder) {
            BeanDefinition beanDefinition;
            String beanName = null;
            if (propertyValue instanceof BeanDefinition) {
                beanDefinition = (BeanDefinition)propertyValue;
            } else {
                beanDefinition = ((BeanDefinitionHolder)propertyValue).getBeanDefinition();
                beanName = ((BeanDefinitionHolder)propertyValue).getBeanName();
            }
            this.removeExpressionsByPrefix(propertyName, parentPropertyExpressions);
            this.processBeanDefinition(beanName, beanDefinition, beanFactory, processedBeanNames);
            return propertyValue;
        }
        if (propertyValue instanceof Object[]) {
            this.visitArray(propertyName, parentPropertyExpressions, propertyExpressions, (Object[])propertyValue, beanFactory, processedBeanNames);
        } else if (propertyValue instanceof List) {
            this.visitList(propertyName, parentPropertyExpressions, propertyExpressions, (List)propertyValue, beanFactory, processedBeanNames);
        } else if (propertyValue instanceof Set) {
            this.visitSet(propertyName, parentPropertyExpressions, propertyExpressions, (Set)propertyValue, beanFactory, processedBeanNames);
        } else if (propertyValue instanceof Map) {
            this.visitMap(propertyName, parentPropertyExpressions, propertyExpressions, (Map)propertyValue, beanFactory, processedBeanNames);
        }
        return propertyValue;
    }

    protected void removeExpressionsByPrefix(String propertyNamePrefix, Map<String, String> propertyExpressions) {
        HashMap<String, String> adjustedPropertyExpressions = new HashMap<String, String>();
        for (String propertyName : propertyExpressions.keySet()) {
            if (propertyName.startsWith(propertyNamePrefix)) continue;
            adjustedPropertyExpressions.put(propertyName, propertyExpressions.get(propertyName));
        }
        propertyExpressions.clear();
        propertyExpressions.putAll(adjustedPropertyExpressions);
    }

    protected String getStringValue(Object value) {
        if (value instanceof TypedStringValue) {
            TypedStringValue typedStringValue = (TypedStringValue)value;
            return typedStringValue.getValue();
        }
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    protected void visitArray(String propertyName, Map<String, String> parentPropertyExpressions, Map<String, String> propertyExpressions, Object[] arrayVal, ConfigurableListableBeanFactory beanFactory, Set<String> processedBeanNames) {
        for (int i = 0; i < arrayVal.length; ++i) {
            Object elem = arrayVal[i];
            String elemPropertyName = propertyName + "[" + i + "]";
            if (this.hasExpression(elem)) {
                String strValue = this.getStringValue(elem);
                propertyExpressions.put(elemPropertyName, strValue);
                arrayVal[i] = null;
            } else {
                Object newElem;
                arrayVal[i] = newElem = this.processPropertyValue(elemPropertyName, elem, parentPropertyExpressions, propertyExpressions, beanFactory, processedBeanNames);
            }
            if (!parentPropertyExpressions.containsKey(elemPropertyName)) continue;
            parentPropertyExpressions.remove(elemPropertyName);
        }
    }

    protected void visitList(String propertyName, Map<String, String> parentPropertyExpressions, Map<String, String> propertyExpressions, List listVal, ConfigurableListableBeanFactory beanFactory, Set<String> processedBeanNames) {
        boolean isMergeEnabled;
        ArrayList<Object> newList = new ArrayList<Object>();
        for (int i = 0; i < listVal.size(); ++i) {
            Object elem = listVal.get(i);
            String elemPropertyName = propertyName + "[" + i + "]";
            if (this.hasExpression(elem)) {
                String strValue = this.getStringValue(elem);
                propertyExpressions.put(elemPropertyName, strValue);
                newList.add(i, null);
            } else {
                Object newElem = this.processPropertyValue(elemPropertyName, elem, parentPropertyExpressions, propertyExpressions, beanFactory, processedBeanNames);
                newList.add(i, newElem);
            }
            if (!parentPropertyExpressions.containsKey(elemPropertyName)) continue;
            parentPropertyExpressions.remove(elemPropertyName);
        }
        if (listVal instanceof ManagedList && !(isMergeEnabled = ((ManagedList)listVal).isMergeEnabled())) {
            HashMap<String, String> adjustedParentExpressions = new HashMap<String, String>();
            for (Map.Entry<String, String> parentExpression : parentPropertyExpressions.entrySet()) {
                if (parentExpression.getKey().startsWith(propertyName + "[")) continue;
                adjustedParentExpressions.put(parentExpression.getKey(), parentExpression.getValue());
            }
            parentPropertyExpressions.clear();
            parentPropertyExpressions.putAll(adjustedParentExpressions);
        }
        listVal.clear();
        listVal.addAll(newList);
    }

    protected void visitSet(String propertyName, Map<String, String> parentPropertyExpressions, Map<String, String> propertyExpressions, Set setVal, ConfigurableListableBeanFactory beanFactory, Set<String> processedBeanNames) {
        LinkedHashSet<Object> newContent = new LinkedHashSet<Object>();
        for (Object elem : setVal) {
            Object newElem = this.processPropertyValue(propertyName, elem, parentPropertyExpressions, propertyExpressions, beanFactory, processedBeanNames);
            newContent.add(newElem);
        }
        setVal.clear();
        setVal.addAll(newContent);
    }

    protected void visitMap(String propertyName, Map<String, String> parentPropertyExpressions, Map<String, String> propertyExpressions, Map<?, ?> mapVal, ConfigurableListableBeanFactory beanFactory, Set<String> processedBeanNames) {
        LinkedHashMap newContent = new LinkedHashMap();
        boolean isMergeEnabled = false;
        if (mapVal instanceof ManagedMap) {
            isMergeEnabled = ((ManagedMap)mapVal).isMergeEnabled();
        }
        for (Map.Entry<?, ?> entry : mapVal.entrySet()) {
            Object key = entry.getKey();
            Object val = entry.getValue();
            String keyStr = this.getStringValue(key);
            String elemPropertyName = propertyName + "['" + keyStr + "']";
            if (this.hasExpression(val)) {
                String strValue = this.getStringValue(val);
                propertyExpressions.put(elemPropertyName, strValue);
                newContent.put(key, null);
            } else {
                Object newElem = this.processPropertyValue(elemPropertyName, val, parentPropertyExpressions, propertyExpressions, beanFactory, processedBeanNames);
                newContent.put(key, newElem);
            }
            if (!isMergeEnabled || !parentPropertyExpressions.containsKey(elemPropertyName)) continue;
            parentPropertyExpressions.remove(elemPropertyName);
        }
        if (!isMergeEnabled) {
            HashMap<String, String> adjustedParentExpressions = new HashMap<String, String>();
            for (Map.Entry<String, String> parentExpression : parentPropertyExpressions.entrySet()) {
                if (parentExpression.getKey().startsWith(propertyName + "[")) continue;
                adjustedParentExpressions.put(parentExpression.getKey(), parentExpression.getValue());
            }
            parentPropertyExpressions.clear();
            parentPropertyExpressions.putAll(adjustedParentExpressions);
        }
        mapVal.clear();
        mapVal.putAll(newContent);
    }
}

