/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.uif.widget;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.uif.component.Component;
import org.kuali.kfs.krad.uif.view.HistoryEntry;
import org.kuali.kfs.krad.uif.view.View;
import org.kuali.kfs.krad.uif.widget.WidgetBase;

public class BreadCrumbs
extends WidgetBase {
    private static final long serialVersionUID = -2864287914665842251L;
    private boolean displayHomewardPath;
    private boolean displayPassedHistory;
    private boolean displayBreadcrumbsWhenOne;
    private List<HistoryEntry> homewardPathList = new ArrayList<HistoryEntry>();

    @Override
    public void performApplyModel(View view, Object model, Component parent) {
        super.performApplyModel(view, model, parent);
        if (this.homewardPathList != null) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.putAll(view.getContext());
            for (HistoryEntry historyEntry : this.homewardPathList) {
                KRADServiceLocatorWeb.getExpressionEvaluatorService().evaluateObjectExpressions(historyEntry, model, context);
            }
        }
    }

    public boolean isDisplayHomewardPath() {
        return this.displayHomewardPath;
    }

    public void setDisplayHomewardPath(boolean displayHomewardPath) {
        this.displayHomewardPath = displayHomewardPath;
    }

    public boolean isDisplayPassedHistory() {
        return this.displayPassedHistory;
    }

    public void setDisplayPassedHistory(boolean displayPassedHistory) {
        this.displayPassedHistory = displayPassedHistory;
    }

    public List<HistoryEntry> getHomewardPathList() {
        return this.homewardPathList;
    }

    public void setHomewardPathList(List<HistoryEntry> homewardPathList) {
        this.homewardPathList = homewardPathList;
    }

    public boolean isDisplayBreadcrumbsWhenOne() {
        return this.displayBreadcrumbsWhenOne;
    }

    public void setDisplayBreadcrumbsWhenOne(boolean displayBreadcrumbsWhenOne) {
        this.displayBreadcrumbsWhenOne = displayBreadcrumbsWhenOne;
    }
}

