/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.web.bind;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.security.GeneralSecurityException;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.CoreApiServiceLocator;

public class UifEncryptionPropertyEditorWrapper
extends PropertyEditorSupport {
    private static Logger LOG = Logger.getLogger(UifEncryptionPropertyEditorWrapper.class);
    PropertyEditor propertyEditor;

    public UifEncryptionPropertyEditorWrapper(PropertyEditor propertyEditor) {
        this.propertyEditor = propertyEditor;
    }

    @Override
    public String getAsText() {
        try {
            if (this.propertyEditor != null && CoreApiServiceLocator.getEncryptionService().isEnabled()) {
                return CoreApiServiceLocator.getEncryptionService().encrypt((Object)this.propertyEditor.getAsText());
            }
            if (CoreApiServiceLocator.getEncryptionService().isEnabled()) {
                return CoreApiServiceLocator.getEncryptionService().encrypt(this.getValue());
            }
            return null;
        }
        catch (GeneralSecurityException e) {
            LOG.error((Object)"Unable to encrypt value");
            throw new RuntimeException("Unable to encrypt value.");
        }
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        try {
            String value = "";
            if (CoreApiServiceLocator.getEncryptionService().isEnabled()) {
                value = CoreApiServiceLocator.getEncryptionService().decrypt(text);
            }
            if (this.propertyEditor != null) {
                this.propertyEditor.setAsText(value);
            } else {
                this.setValue(value);
            }
        }
        catch (GeneralSecurityException e) {
            LOG.error((Object)("Unable to decrypt value: " + text));
            throw new RuntimeException("Unable to decrypt value.");
        }
    }
}

