/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.web.controller;

import java.util.Collection;
import java.util.Properties;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.krad.lookup.CollectionIncomplete;
import org.kuali.kfs.krad.lookup.Lookupable;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.service.ModuleService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.KRADUtils;
import org.kuali.kfs.krad.web.controller.UifControllerBase;
import org.kuali.kfs.krad.web.form.LookupForm;
import org.kuali.kfs.krad.web.form.UifFormBase;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/lookup"})
public class LookupController
extends UifControllerBase {
    private static final Logger LOG = Logger.getLogger(LookupController.class);

    @Override
    protected LookupForm createInitialForm(HttpServletRequest request) {
        return new LookupForm();
    }

    @Override
    @RequestMapping(params={"methodToCall=start"})
    public ModelAndView start(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        LookupForm lookupForm = (LookupForm)form;
        Lookupable lookupable = lookupForm.getLookupable();
        if (lookupable == null) {
            LOG.error((Object)"Lookupable is null.");
            throw new RuntimeException("Lookupable is null.");
        }
        lookupable.initSuppressAction(lookupForm);
        if (!lookupForm.isRedirectedLookup()) {
            Class<?> lookupObjectClass = null;
            try {
                lookupObjectClass = Class.forName(lookupForm.getDataObjectClassName());
            }
            catch (ClassNotFoundException e) {
                throw new RiceRuntimeException("Unable to get class for name: " + lookupForm.getDataObjectClassName());
            }
            ModuleService responsibleModuleService = KRADServiceLocatorWeb.getKualiModuleService().getResponsibleModuleService(lookupObjectClass);
            if (responsibleModuleService != null && responsibleModuleService.isExternalizable(lookupObjectClass)) {
                String lookupUrl = responsibleModuleService.getExternalizableDataObjectLookupUrl(lookupObjectClass, KRADUtils.convertRequestMapToProperties(request.getParameterMap()));
                Properties redirectUrlProps = new Properties();
                redirectUrlProps.put("redirectedLookup", "true");
                GlobalVariables.getUifFormManager().removeForm(form);
                return this.performRedirect(form, lookupUrl, redirectUrlProps);
            }
        }
        return super.start(lookupForm, result, request, response);
    }

    @Override
    @RequestMapping(params={"methodToCall=cancel"})
    public ModelAndView cancel(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        LookupForm lookupForm = (LookupForm)form;
        Lookupable lookupable = lookupForm.getLookupable();
        if (lookupable == null) {
            LOG.error((Object)"Lookupable is null.");
            throw new RuntimeException("Lookupable is null.");
        }
        lookupable.initSuppressAction(lookupForm);
        Properties props = new Properties();
        props.put("methodToCall", "refresh");
        if (StringUtils.isNotBlank((String)lookupForm.getReturnFormKey())) {
            props.put("formKey", lookupForm.getReturnFormKey());
        }
        if (StringUtils.isNotBlank((String)lookupForm.getDocNum())) {
            props.put("docNum", lookupForm.getDocNum());
        }
        GlobalVariables.getUifFormManager().removeForm(form);
        return this.performRedirect(lookupForm, lookupForm.getReturnLocation(), props);
    }

    @RequestMapping(params={"methodToCall=clearValues"})
    public ModelAndView clearValues(@ModelAttribute(value="KualiForm") LookupForm lookupForm, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        Lookupable lookupable = lookupForm.getLookupable();
        if (lookupable == null) {
            LOG.error((Object)"Lookupable is null.");
            throw new RuntimeException("Lookupable is null.");
        }
        lookupable.initSuppressAction(lookupForm);
        lookupForm.setCriteriaFields(lookupable.performClear(lookupForm, lookupForm.getCriteriaFields()));
        return this.getUIFModelAndView(lookupForm);
    }

    @RequestMapping(params={"methodToCall=search"})
    public ModelAndView search(@ModelAttribute(value="KualiForm") LookupForm lookupForm, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        Lookupable lookupable = lookupForm.getLookupable();
        if (lookupable == null) {
            LOG.error((Object)"Lookupable is null.");
            throw new RuntimeException("Lookupable is null.");
        }
        lookupable.initSuppressAction(lookupForm);
        lookupable.validateSearchParameters(lookupForm, lookupForm.getCriteriaFields());
        Collection<?> displayList = lookupable.performSearch(lookupForm, lookupForm.getCriteriaFields(), true);
        if (displayList instanceof CollectionIncomplete) {
            request.setAttribute("reqSearchResultsActualSize", (Object)((CollectionIncomplete)displayList).getActualSizeIfTruncated());
        } else {
            request.setAttribute("reqSearchResultsActualSize", (Object)new Integer(displayList.size()));
        }
        lookupForm.setSearchResults(displayList);
        return this.getUIFModelAndView(lookupForm);
    }

    @RequestMapping(params={"methodToCall=returnSelected"})
    public ModelAndView returnSelected(@ModelAttribute(value="KualiForm") LookupForm lookupForm, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        Properties parameters = new Properties();
        parameters.put("methodToCall", "refresh");
        if (StringUtils.isNotBlank((String)lookupForm.getReturnFormKey())) {
            parameters.put("formKey", lookupForm.getReturnFormKey());
        }
        parameters.put("refreshCaller", lookupForm.getView().getId());
        parameters.put("refreshCallerType", "MULTI_VALUE_LOOKUP");
        parameters.put("refreshDataObjectClass", lookupForm.getDataObjectClassName());
        if (StringUtils.isNotBlank((String)lookupForm.getDocNum())) {
            parameters.put("docNum", lookupForm.getDocNum());
        }
        if (StringUtils.isNotBlank((String)lookupForm.getLookupCollectionName())) {
            parameters.put("lookupCollectionName", lookupForm.getLookupCollectionName());
        }
        if (StringUtils.isNotBlank((String)lookupForm.getReferencesToRefresh())) {
            parameters.put("referencesToRefresh", lookupForm.getReferencesToRefresh());
        }
        String selectedLineValues = "";
        Set<String> selectedLines = lookupForm.getSelectedCollectionLines().get("searchResults");
        if (selectedLines != null) {
            for (String selectedLine : selectedLines) {
                selectedLineValues = selectedLineValues + selectedLine + ",";
            }
            selectedLineValues = StringUtils.removeEnd((String)selectedLineValues, (String)",");
        }
        parameters.put("selectedLineValues", selectedLineValues);
        GlobalVariables.getUifFormManager().removeForm(lookupForm);
        return this.performRedirect(lookupForm, lookupForm.getReturnLocation(), parameters);
    }
}

