/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.kns.datadictionary;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.kns.datadictionary.MaintainableItemDefinition;
import org.kuali.kfs.krad.datadictionary.DataDictionaryDefinitionBase;
import org.kuali.kfs.krad.datadictionary.DataDictionaryException;

public class MaintainableSectionDefinition
extends DataDictionaryDefinitionBase {
    private static final long serialVersionUID = -8615694293159113523L;
    protected String title;
    protected List<MaintainableItemDefinition> maintainableItems = new ArrayList<MaintainableItemDefinition>();
    protected boolean hidden = false;
    protected boolean defaultOpen = true;
    protected String helpUrl;

    public String getTitle() {
        return this.title;
    }

    @Override
    public String getId() {
        if (StringUtils.isBlank((String)this.id)) {
            return this.title;
        }
        return this.id;
    }

    public void setTitle(String title) {
        if (StringUtils.isBlank((String)title)) {
            throw new IllegalArgumentException("invalid (blank) title");
        }
        this.title = title;
    }

    public List<MaintainableItemDefinition> getMaintainableItems() {
        return this.maintainableItems;
    }

    public void completeValidation(Class rootBusinessObjectClass, Class otherBusinessObjectClass) {
        if (StringUtils.contains((String)this.title, (String)",") && StringUtils.isBlank((String)this.id)) {
            throw new DataDictionaryException("The title for maintainable section \"" + this.title + "\" for class " + rootBusinessObjectClass.getName() + " contains a comma.  In this case, the id property must be defined and it may not contain a comma");
        }
        if (StringUtils.contains((String)this.id, (String)",")) {
            throw new DataDictionaryException("The id for maintainable section \"" + this.id + "\" for class " + rootBusinessObjectClass.getName() + " contains a comma, which is not allowed.");
        }
        for (MaintainableItemDefinition maintainableItem : this.maintainableItems) {
            maintainableItem.completeValidation(rootBusinessObjectClass, null);
        }
    }

    public String toString() {
        return "MaintainableSectionDefinition '" + this.getTitle() + "'";
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public void setMaintainableItems(List<MaintainableItemDefinition> maintainableItems) {
        for (MaintainableItemDefinition maintainableItem : maintainableItems) {
            if (maintainableItem != null) continue;
            throw new IllegalArgumentException("invalid (null) maintainableItem");
        }
        this.maintainableItems = maintainableItems;
    }

    public boolean isDefaultOpen() {
        return this.defaultOpen;
    }

    public void setDefaultOpen(boolean defaultOpen) {
        this.defaultOpen = defaultOpen;
    }

    public String getHelpUrl() {
        return this.helpUrl;
    }

    public void setHelpUrl(String helpUrl) {
        this.helpUrl = helpUrl;
    }
}

