/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.kns.datadictionary.validation.charlevel;

import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.krad.datadictionary.exporter.ExportMap;
import org.kuali.kfs.krad.datadictionary.validation.CharacterLevelValidationPattern;

public class CharsetValidationPattern
extends CharacterLevelValidationPattern {
    protected String validChars;

    public String getValidChars() {
        return this.validChars;
    }

    public void setValidChars(String validChars) {
        if (StringUtils.isEmpty((String)validChars)) {
            throw new IllegalArgumentException("invalid (empty) validChars");
        }
        this.validChars = validChars;
    }

    @Override
    protected String getRegexString() {
        if (StringUtils.isEmpty((String)this.validChars)) {
            throw new IllegalStateException("validChars is empty");
        }
        Pattern filteringChars = Pattern.compile("([\\-\\[\\]\\{\\}\\$\\.\\^\\(\\)\\*\\&\\|])");
        String filteredChars = filteringChars.matcher(this.validChars).replaceAll("\\\\$1");
        StringBuffer regexString = new StringBuffer("[");
        regexString.append(filteredChars);
        if (filteredChars.endsWith("\\")) {
            regexString.append("\\");
        }
        regexString.append("]");
        return regexString.toString();
    }

    @Override
    public void extendExportMap(ExportMap exportMap) {
        exportMap.set("type", "charset");
        exportMap.set("validChars", this.getValidChars());
    }

    @Override
    public String[] getValidationErrorMessageParameters(String attributeLabel) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.validChars.length(); ++i) {
            buf.append(this.validChars.charAt(i));
            if (i == this.validChars.length() - 1) continue;
            buf.append(", ");
        }
        String characterList = buf.toString();
        if (this.getMaxLength() != -1) {
            return new String[]{attributeLabel, String.valueOf(this.getMaxLength()), characterList};
        }
        if (this.getExactLength() != -1) {
            return new String[]{attributeLabel, String.valueOf(this.getExactLength()), characterList};
        }
        return new String[]{attributeLabel, "0", characterList};
    }
}

