/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.kns.service.impl;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.kns.document.authorization.BusinessObjectRestrictions;
import org.kuali.kfs.kns.document.authorization.FieldRestriction;
import org.kuali.kfs.kns.service.KNSServiceLocator;
import org.kuali.kfs.kns.service.SecurityLoggingService;
import org.kuali.kfs.kns.util.KNSGlobalVariables;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.datadictionary.AttributeSecurity;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.DataDictionaryService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.rice.krad.bo.BusinessObject;

public class SecurityLoggingServiceImpl
implements SecurityLoggingService {
    private static final Logger SECURITY_LOG = Logger.getLogger((String)"kfsSecurityLog");
    private DataDictionaryService dataDictionaryService;

    @Override
    public void logFullUnmask(BusinessObject bo, String propertyName, Document document, boolean accessGranted, String alternateBusinessObjectIdentifier) {
        this.logFieldAccessRequested(bo, propertyName, "FullUnmask", document, accessGranted, alternateBusinessObjectIdentifier);
    }

    @Override
    public void logPartialUnmask(BusinessObject bo, String propertyName, Document document, boolean accessGranted, String alternateBusinessObjectIdentifier) {
        this.logFieldAccessRequested(bo, propertyName, "PartialUnmask", document, accessGranted, alternateBusinessObjectIdentifier);
    }

    @Override
    public void logView(BusinessObject bo, String propertyName, Document document, boolean accessGranted, String alternateBusinessObjectIdentifier) {
        this.logFieldAccessRequested(bo, propertyName, "View", document, accessGranted, alternateBusinessObjectIdentifier);
    }

    @Override
    public void logFieldAccess(BusinessObject bo, String propertyName, Document document, BusinessObjectRestrictions businessObjectRestrictions, boolean logViewAccess, String alternateBusinessObjectIdentifier) {
        boolean shouldLogUnmask = false;
        boolean shouldLogPartialUnmask = false;
        boolean shouldLogView = false;
        boolean unmaskResult = false;
        boolean partialUnmaskResult = false;
        boolean viewResult = false;
        AttributeSecurity attributeSecurity = this.getDataDictionaryService().getAttributeSecurity(bo.getClass().getName(), propertyName);
        if (attributeSecurity != null) {
            shouldLogUnmask = attributeSecurity.isMask();
            shouldLogPartialUnmask = attributeSecurity.isPartialMask();
            shouldLogView = attributeSecurity.isHide();
            if (businessObjectRestrictions == null) {
                unmaskResult = attributeSecurity.isMask();
                partialUnmaskResult = attributeSecurity.isPartialMask();
                shouldLogView = attributeSecurity.isHide();
            } else {
                FieldRestriction fieldRestriction = businessObjectRestrictions.getFieldRestriction(propertyName);
                if (fieldRestriction == null) {
                    unmaskResult = attributeSecurity.isMask();
                    partialUnmaskResult = attributeSecurity.isPartialMask();
                    viewResult = attributeSecurity.isHide();
                } else {
                    unmaskResult = attributeSecurity.isMask() && !fieldRestriction.isMasked();
                    partialUnmaskResult = attributeSecurity.isPartialMask() && !fieldRestriction.isPartiallyMasked();
                    boolean bl = viewResult = attributeSecurity.isHide() && !fieldRestriction.isViewable();
                }
            }
        }
        if (shouldLogUnmask) {
            this.logFullUnmask(bo, propertyName, document, unmaskResult, alternateBusinessObjectIdentifier);
        }
        if (shouldLogPartialUnmask) {
            this.logPartialUnmask(bo, propertyName, document, partialUnmaskResult, alternateBusinessObjectIdentifier);
        }
        if (logViewAccess && shouldLogView) {
            this.logView(bo, propertyName, document, viewResult, alternateBusinessObjectIdentifier);
        }
    }

    @Override
    public void logCustomString(String message) {
        StringBuilder buf = new StringBuilder(300);
        this.appendSecurityLogPrefix(buf);
        buf.append(message);
        this.writeStringToLog(buf.toString());
    }

    protected void logFieldAccessRequested(BusinessObject bo, String propertyName, String action, Document document, boolean accessGranted, String alternateBusinessObjectIdentifier) {
        Class clazz = ObjectUtils.materializeClassForProxiedObject(bo);
        String className = null;
        if (clazz != null) {
            className = clazz.getSimpleName();
        }
        StringBuilder buf = new StringBuilder(120);
        this.appendSecurityLogPrefix(buf);
        this.appendFieldAccessMessage(buf, action, className, propertyName, accessGranted, bo, document, alternateBusinessObjectIdentifier);
        this.writeStringToLog(buf.toString());
    }

    protected void appendSecurityLogPrefix(StringBuilder buf) {
        buf.append(KNSGlobalVariables.getRemoteIpAddress()).append(",").append(GlobalVariables.getUserSession().getPrincipalName()).append(",");
    }

    protected void appendFieldAccessMessage(StringBuilder buf, String action, String className, String propertyName, boolean accessGranted, BusinessObject bo, Document document, String alternateBusinessObjectIdentifier) {
        buf.append(action).append(",").append(className).append(".").append(propertyName);
        if (accessGranted) {
            buf.append(",SUCCESS");
        } else {
            buf.append(",DENY");
        }
        if (ObjectUtils.isNotNull(bo)) {
            if (bo instanceof PersistableBusinessObject) {
                buf.append(",objectId=").append(((PersistableBusinessObject)bo).getObjectId());
            } else {
                buf.append(",TransientBusinessObject");
            }
        } else {
            buf.append(",null");
        }
        if (StringUtils.isNotBlank((String)alternateBusinessObjectIdentifier)) {
            buf.append(",").append(alternateBusinessObjectIdentifier);
        }
        if (ObjectUtils.isNull(document)) {
            buf.append(",null");
        } else {
            buf.append(",docNbr=").append(document.getDocumentNumber());
        }
    }

    protected void writeStringToLog(String logMessage) {
        SECURITY_LOG.info((Object)logMessage);
    }

    protected DataDictionaryService getDataDictionaryService() {
        if (this.dataDictionaryService == null) {
            this.dataDictionaryService = KNSServiceLocator.getDataDictionaryService();
        }
        return this.dataDictionaryService;
    }
}

