/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.kns.web.comparator;

import java.util.Comparator;
import org.apache.commons.collections.comparators.ComparableComparator;
import org.apache.commons.lang.StringUtils;
import org.displaytag.model.Cell;
import org.jsoup.Jsoup;
import org.jsoup.safety.Whitelist;
import org.kuali.kfs.kns.web.comparator.NullCellComparator;
import org.kuali.kfs.kns.web.comparator.NullValueComparator;
import org.kuali.kfs.kns.web.comparator.NumericCellComparator;
import org.kuali.kfs.kns.web.comparator.StringCellComparator;
import org.kuali.kfs.kns.web.comparator.TemporalCellComparator;
import org.kuali.kfs.krad.comparator.NumericValueComparator;
import org.kuali.kfs.krad.comparator.StringValueComparator;
import org.kuali.kfs.krad.comparator.TemporalValueComparator;
import org.kuali.rice.core.api.util.type.TypeUtils;

public class CellComparatorHelper {
    public static String getSanitizedStaticValue(Cell cell) {
        if (null == cell) {
            return null;
        }
        return null == cell.getStaticValue() ? null : CellComparatorHelper.getSanitizedStaticValue(cell.getStaticValue().toString());
    }

    public static String getSanitizedStaticValue(String staticValue) {
        if (null == staticValue) {
            return null;
        }
        staticValue = StringUtils.replace((String)staticValue, (String)"\r", (String)"");
        staticValue = StringUtils.replace((String)staticValue, (String)"\n", (String)"");
        staticValue = StringUtils.replace((String)staticValue, (String)"\t", (String)"");
        String sanitizedValue = Jsoup.clean((String)staticValue, (Whitelist)Whitelist.none());
        while (sanitizedValue.endsWith("&nbsp;")) {
            sanitizedValue = sanitizedValue.substring(0, sanitizedValue.length() - 6).trim();
        }
        return sanitizedValue;
    }

    public static Comparator getAppropriateComparatorForPropertyClass(Class propClass) {
        if (propClass == null) {
            return new NullCellComparator();
        }
        if (TypeUtils.isDecimalClass((Class)propClass) || TypeUtils.isIntegralClass((Class)propClass)) {
            return new NumericCellComparator();
        }
        if (TypeUtils.isTemporalClass((Class)propClass)) {
            return new TemporalCellComparator();
        }
        if (String.class.equals((Object)propClass)) {
            return new StringCellComparator();
        }
        return ComparableComparator.getInstance();
    }

    public static Comparator getAppropriateValueComparatorForPropertyClass(Class propClass) {
        if (propClass == null) {
            return NullValueComparator.getInstance();
        }
        if (TypeUtils.isDecimalClass((Class)propClass) || TypeUtils.isIntegralClass((Class)propClass)) {
            return NumericValueComparator.getInstance();
        }
        if (TypeUtils.isTemporalClass((Class)propClass)) {
            return TemporalValueComparator.getInstance();
        }
        if (String.class.equals((Object)propClass)) {
            return StringValueComparator.getInstance();
        }
        return ComparableComparator.getInstance();
    }
}

