/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.keyvalues;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.krad.datadictionary.AttributeDefinition;
import org.kuali.kfs.krad.datadictionary.BusinessObjectEntry;
import org.kuali.kfs.krad.keyvalues.KeyValuesBase;
import org.kuali.kfs.krad.keyvalues.KeyValuesFinder;
import org.kuali.kfs.krad.keyvalues.PersistableBusinessObjectValuesFinder;
import org.kuali.kfs.krad.service.DataDictionaryService;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.core.api.util.ClassLoaderUtils;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.api.type.KimType;
import org.kuali.rice.kim.api.type.KimTypeAttribute;
import org.kuali.rice.kim.framework.services.KimFrameworkServiceLocator;
import org.kuali.rice.kim.framework.type.KimTypeService;

public class KimAttributeValuesFinder
extends KeyValuesBase {
    private static final Logger LOG = Logger.getLogger(KimAttributeValuesFinder.class);
    protected String kimTypeId;
    protected String kimAttributeName;
    private DataDictionaryService dataDictionaryService;

    protected DataDictionaryService getDataDictionaryService() {
        if (this.dataDictionaryService == null) {
            this.dataDictionaryService = KRADServiceLocatorWeb.getDataDictionaryService();
        }
        return this.dataDictionaryService;
    }

    @Override
    public List<KeyValue> getKeyValues() {
        KimType kimType = KimApiServiceLocator.getKimTypeInfoService().getKimType(this.kimTypeId);
        if (kimType != null) {
            KimTypeService service = KimFrameworkServiceLocator.getKimTypeService((KimType)kimType);
            if (service != null) {
                return this.getAttributeValidValues(this.kimTypeId, this.kimAttributeName);
            }
            LOG.error((Object)("Unable to get type service " + kimType.getServiceName()));
        } else {
            LOG.error((Object)("Unable to obtain KIM type for kimTypeId=" + this.kimTypeId));
        }
        return Collections.emptyList();
    }

    private List<KeyValue> getAttributeValidValues(String kimTypeId, String attributeName) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getAttributeValidValues(" + kimTypeId + "," + attributeName + ")"));
        }
        KimTypeAttribute attrib = KimApiServiceLocator.getKimTypeInfoService().getKimType(kimTypeId).getAttributeDefinitionByName(attributeName);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Found Attribute definition: " + attrib));
        }
        List<KeyValue> pairs = null;
        if (StringUtils.isNotBlank((String)attrib.getKimAttribute().getComponentName())) {
            try {
                Class.forName(attrib.getKimAttribute().getComponentName());
                try {
                    pairs = this.getLocalDataDictionaryAttributeValues(attrib);
                }
                catch (ClassNotFoundException ex) {
                    LOG.error((Object)"Got a ClassNotFoundException resolving a values finder - since this should have been executing in the context of the host system - this should not happen.");
                    return Collections.emptyList();
                }
            }
            catch (ClassNotFoundException ex) {
                LOG.error((Object)("Got a ClassNotFoundException resolving a component name (" + attrib.getKimAttribute().getComponentName() + ") - since this should have been executing in the context of the host system - this should not happen."));
            }
        } else {
            pairs = this.getCustomValueFinderValues(attrib);
        }
        return pairs;
    }

    protected List<KeyValue> getCustomValueFinderValues(KimTypeAttribute attrib) {
        return Collections.emptyList();
    }

    protected List<KeyValue> getLocalDataDictionaryAttributeValues(KimTypeAttribute attr) throws ClassNotFoundException {
        BusinessObjectEntry entry = this.getDataDictionaryService().getDataDictionary().getBusinessObjectEntry(attr.getKimAttribute().getComponentName());
        if (entry == null) {
            LOG.warn((Object)("Unable to obtain BusinessObjectEntry for component name: " + attr.getKimAttribute().getComponentName()));
            return Collections.emptyList();
        }
        AttributeDefinition definition = entry.getAttributeDefinition(attr.getKimAttribute().getAttributeName());
        if (definition == null) {
            LOG.warn((Object)("No attribute named " + attr.getKimAttribute().getAttributeName() + " found on BusinessObjectEntry for: " + attr.getKimAttribute().getComponentName()));
            return Collections.emptyList();
        }
        ArrayList<KeyValue> pairs = new ArrayList<KeyValue>();
        String keyValuesFinderName = definition.getControl().getValuesFinderClass();
        if (StringUtils.isNotBlank((String)keyValuesFinderName)) {
            try {
                KeyValuesFinder finder = (KeyValuesFinder)Class.forName(keyValuesFinderName).newInstance();
                if (finder instanceof PersistableBusinessObjectValuesFinder) {
                    ((PersistableBusinessObjectValuesFinder)finder).setBusinessObjectClass(ClassLoaderUtils.getClass((String)definition.getControl().getBusinessObjectClass()));
                    ((PersistableBusinessObjectValuesFinder)finder).setKeyAttributeName(definition.getControl().getKeyAttribute());
                    ((PersistableBusinessObjectValuesFinder)finder).setLabelAttributeName(definition.getControl().getLabelAttribute());
                    if (definition.getControl().getIncludeBlankRow() != null) {
                        ((PersistableBusinessObjectValuesFinder)finder).setIncludeBlankRow(definition.getControl().getIncludeBlankRow());
                    }
                    ((PersistableBusinessObjectValuesFinder)finder).setIncludeKeyInDescription(definition.getControl().getIncludeKeyInLabel());
                }
                for (KeyValue pair : finder.getKeyValues()) {
                    pairs.add((KeyValue)new ConcreteKeyValue(pair));
                }
            }
            catch (ClassNotFoundException ex) {
                LOG.info((Object)("Unable to find class: " + keyValuesFinderName + " in the current context."));
                throw ex;
            }
            catch (Exception e) {
                LOG.error((Object)("Unable to build a KeyValuesFinder for " + attr.getKimAttribute().getAttributeName()), (Throwable)e);
            }
        } else {
            LOG.warn((Object)("No values finder class defined on the control definition (" + definition.getControl() + ") on BO / attr = " + attr.getKimAttribute().getComponentName() + " / " + attr.getKimAttribute().getAttributeName()));
        }
        return pairs;
    }

    public String getKimAttributeName() {
        return this.kimAttributeName;
    }

    public void setKimAttributeName(String kimAttributeName) {
        this.kimAttributeName = kimAttributeName;
    }

    public String getKimTypeId() {
        return this.kimTypeId;
    }

    public void setKimTypeId(String kimTypeId) {
        this.kimTypeId = kimTypeId;
    }
}

