/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.lookup;

import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.krad.datadictionary.BusinessObjectEntry;
import org.kuali.kfs.krad.datadictionary.RelationshipDefinition;
import org.kuali.kfs.krad.lookup.LookupUtils;
import org.kuali.kfs.krad.lookup.LookupViewAuthorizerBase;
import org.kuali.kfs.krad.lookup.Lookupable;
import org.kuali.kfs.krad.service.DataObjectAuthorizationService;
import org.kuali.kfs.krad.service.DataObjectMetaDataService;
import org.kuali.kfs.krad.service.DocumentDictionaryService;
import org.kuali.kfs.krad.service.KRADServiceLocator;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.service.LookupService;
import org.kuali.kfs.krad.service.ModuleService;
import org.kuali.kfs.krad.uif.UifConstants;
import org.kuali.kfs.krad.uif.control.Control;
import org.kuali.kfs.krad.uif.control.HiddenControl;
import org.kuali.kfs.krad.uif.control.ValueConfiguredControl;
import org.kuali.kfs.krad.uif.field.InputField;
import org.kuali.kfs.krad.uif.field.LinkField;
import org.kuali.kfs.krad.uif.field.LookupInputField;
import org.kuali.kfs.krad.uif.service.impl.ViewHelperServiceImpl;
import org.kuali.kfs.krad.uif.util.ComponentUtils;
import org.kuali.kfs.krad.uif.util.LookupInquiryUtils;
import org.kuali.kfs.krad.uif.util.ObjectPropertyUtils;
import org.kuali.kfs.krad.uif.view.LookupView;
import org.kuali.kfs.krad.uif.view.View;
import org.kuali.kfs.krad.util.BeanPropertyComparator;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.KRADUtils;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.kfs.krad.web.form.LookupForm;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.encryption.EncryptionService;
import org.kuali.rice.core.api.search.SearchOperator;
import org.kuali.rice.core.api.util.type.TypeUtils;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.bo.ExternalizableBusinessObject;

public class LookupableImpl
extends ViewHelperServiceImpl
implements Lookupable {
    private static final Logger LOG = Logger.getLogger(LookupableImpl.class);
    private Class<?> dataObjectClass;
    private Map<String, String> parameters;
    private List<String> defaultSortAttributeNames;
    private boolean sortAscending;
    private Map<String, String> fieldConversions;
    private List<String> readOnlyFieldsList;
    private transient ConfigurationService configurationService;
    private transient DataObjectAuthorizationService dataObjectAuthorizationService;
    private transient DataObjectMetaDataService dataObjectMetaDataService;
    private transient DocumentDictionaryService documentDictionaryService;
    private transient LookupService lookupService;
    private transient EncryptionService encryptionService;

    @Override
    public void populateViewFromRequestParameters(View view, Map<String, String> parameters) {
        super.populateViewFromRequestParameters(view, parameters);
        this.setParameters(parameters);
    }

    @Override
    public void performInitialization(View view, Object model) {
        if (!LookupView.class.isAssignableFrom(view.getClass())) {
            throw new IllegalArgumentException("View class '" + view.getClass() + " is not assignable from the '" + LookupView.class + "'");
        }
        LookupView lookupView = (LookupView)view;
        this.initializeLookupViewHelperService(lookupView);
        super.performInitialization(view, model);
    }

    protected void initializeLookupViewHelperService(LookupView lookupView) {
        this.setDefaultSortAttributeNames(lookupView.getDefaultSortAttributeNames());
        this.setSortAscending(lookupView.isDefaultSortAscending());
        this.setDataObjectClass(lookupView.getDataObjectClassName());
    }

    @Override
    public void initSuppressAction(LookupForm lookupForm) {
        LookupViewAuthorizerBase lookupAuthorizer = (LookupViewAuthorizerBase)lookupForm.getView().getAuthorizer();
        Person user = GlobalVariables.getUserSession().getPerson();
        ((LookupView)lookupForm.getView()).setSuppressActions(!lookupAuthorizer.canInitiateDocument(lookupForm, user));
    }

    @Override
    public Collection<?> performSearch(LookupForm form, Map<String, String> searchCriteria, boolean bounded) {
        LookupUtils.preprocessDateFields(searchCriteria);
        List<?> displayList = this.getSearchResults(form, LookupUtils.forceUppercase(this.getDataObjectClass(), searchCriteria), !bounded);
        List<String> pkNames = this.getDataObjectMetaDataService().listPrimaryKeyFieldNames(this.getDataObjectClass());
        Person user = GlobalVariables.getUserSession().getPerson();
        for (Object object : displayList) {
            if (!this.isResultReturnable(object)) continue;
            form.setAtLeastOneRowReturnable(true);
        }
        return displayList;
    }

    protected List<?> getSearchResults(LookupForm form, Map<String, String> searchCriteria, boolean unbounded) {
        List<String> defaultSortColumns;
        List searchResults;
        Map<String, String> nonBlankSearchCriteria = this.processSearchCriteria(form, searchCriteria);
        boolean searchUsingOnlyPrimaryKeyValues = this.getLookupService().allPrimaryKeyValuesPresentAndNotWildcard(this.getDataObjectClass(), searchCriteria);
        if (ExternalizableBusinessObject.class.isAssignableFrom(this.getDataObjectClass())) {
            return this.getSearchResultsForEBO(nonBlankSearchCriteria, unbounded);
        }
        try {
            if (LookupUtils.hasExternalBusinessObjectProperty(this.getDataObjectClass(), nonBlankSearchCriteria)) {
                Map<String, String> eboSearchCriteria = this.adjustCriteriaForNestedEBOs(nonBlankSearchCriteria, unbounded);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Passing these results into the lookup service: " + eboSearchCriteria));
                }
                searchResults = (List)this.getLookupService().findCollectionBySearchHelper(this.getDataObjectClass(), eboSearchCriteria, unbounded);
            } else {
                searchResults = (ArrayList)this.getLookupService().findCollectionBySearchHelper(this.getDataObjectClass(), nonBlankSearchCriteria, unbounded);
            }
        }
        catch (IllegalAccessException e) {
            LOG.error((Object)"Error trying to perform search", (Throwable)e);
            throw new RuntimeException("Error trying to perform search", e);
        }
        catch (InstantiationException e1) {
            LOG.error((Object)"Error trying to perform search", (Throwable)e1);
            throw new RuntimeException("Error trying to perform search", e1);
        }
        if (searchResults == null) {
            searchResults = new ArrayList();
        }
        if ((defaultSortColumns = this.getDefaultSortAttributeNames()) != null && defaultSortColumns.size() > 0) {
            Collections.sort(searchResults, new BeanPropertyComparator(defaultSortColumns, true));
        }
        return searchResults;
    }

    protected Map<String, String> processSearchCriteria(LookupForm lookupForm, Map<String, String> searchCriteria) {
        Map<String, InputField> criteriaFields = this.getCriteriaFieldsForValidation((LookupView)lookupForm.getView(), lookupForm);
        HashMap<String, String> nonBlankSearchCriteria = new HashMap<String, String>();
        for (String fieldName : searchCriteria.keySet()) {
            String fieldValue = searchCriteria.get(fieldName);
            LookupView lookupView = (LookupView)lookupForm.getView();
            InputField inputField = criteriaFields.get(fieldName);
            if (inputField.getControl() instanceof HiddenControl || !StringUtils.isNotBlank((String)fieldValue)) continue;
            if (fieldValue.endsWith("(&^#&)")) {
                String encryptedValue = StringUtils.removeEnd((String)fieldValue, (String)"(&^#&)");
                try {
                    if (CoreApiServiceLocator.getEncryptionService().isEnabled()) {
                        fieldValue = this.getEncryptionService().decrypt(encryptedValue);
                    }
                }
                catch (GeneralSecurityException e) {
                    LOG.error((Object)("Error decrypting value for business object class " + this.getDataObjectClass() + " attribute " + fieldName), (Throwable)e);
                    throw new RuntimeException("Error decrypting value for business object class " + this.getDataObjectClass() + " attribute " + fieldName, e);
                }
            }
            nonBlankSearchCriteria.put(fieldName, fieldValue);
        }
        return nonBlankSearchCriteria;
    }

    protected List<?> getSearchResultsForEBO(Map<String, String> searchCriteria, boolean unbounded) {
        ModuleService eboModuleService = KRADServiceLocatorWeb.getKualiModuleService().getResponsibleModuleService(this.getDataObjectClass());
        BusinessObjectEntry ddEntry = eboModuleService.getExternalizableBusinessObjectDictionaryEntry(this.getDataObjectClass());
        HashMap<String, Object> filteredFieldValues = new HashMap<String, Object>();
        for (String fieldName : searchCriteria.keySet()) {
            if (!ddEntry.getAttributeNames().contains(fieldName)) continue;
            filteredFieldValues.put(fieldName, searchCriteria.get(fieldName));
        }
        List<?> searchResults = eboModuleService.getExternalizableBusinessObjectsListForLookup(this.getDataObjectClass(), filteredFieldValues, unbounded);
        return searchResults;
    }

    protected Map<String, String> adjustCriteriaForNestedEBOs(Map<String, String> searchCriteria, boolean unbounded) throws InstantiationException, IllegalAccessException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("has EBO reference: " + this.getDataObjectClass()));
            LOG.debug((Object)("properties: " + searchCriteria));
        }
        Map<String, String> nonEboFieldValues = LookupUtils.removeExternalizableBusinessObjectFieldValues(this.getDataObjectClass(), searchCriteria);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Non EBO properties removed: " + nonEboFieldValues));
        }
        List<String> eboPropertyNames = LookupUtils.getExternalizableBusinessObjectProperties(this.getDataObjectClass(), searchCriteria);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("EBO properties: " + eboPropertyNames));
        }
        for (String eboPropertyName : eboPropertyNames) {
            Class eboParentClass;
            String eboParentPropertyName;
            Map<String, Object> eboFieldValues = LookupUtils.getExternalizableBusinessObjectFieldValues(eboPropertyName, searchCriteria);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("EBO properties for master EBO property: " + eboPropertyName));
                LOG.debug((Object)("properties: " + eboFieldValues));
            }
            ModuleService eboModuleService = KRADServiceLocatorWeb.getKualiModuleService().getResponsibleModuleService(LookupUtils.getExternalizableBusinessObjectClass(this.getDataObjectClass(), eboPropertyName));
            List<Object> eboResults = Collections.emptyList();
            if (eboModuleService != null) {
                eboResults = eboModuleService.getExternalizableBusinessObjectsListForLookup(LookupUtils.getExternalizableBusinessObjectClass(this.getDataObjectClass(), eboPropertyName), eboFieldValues, unbounded);
            } else {
                LOG.debug((Object)("EBO ModuleService is null: " + eboPropertyName));
            }
            if (ObjectUtils.isNestedAttribute(eboPropertyName)) {
                eboParentPropertyName = StringUtils.substringBeforeLast((String)eboPropertyName, (String)".");
                try {
                    eboParentClass = PropertyUtils.getPropertyType(this.getDataObjectClass().newInstance(), (String)eboParentPropertyName);
                }
                catch (Exception ex) {
                    throw new RuntimeException("Unable to create an instance of the business object class: " + this.getDataObjectClass().getName(), ex);
                }
            } else {
                eboParentClass = this.getDataObjectClass();
                eboParentPropertyName = null;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("determined EBO parent class/property name: " + eboParentClass + "/" + eboParentPropertyName));
            }
            RelationshipDefinition rd = this.getDataObjectMetaDataService().getDictionaryRelationship(eboParentClass, eboPropertyName);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Obtained RelationshipDefinition for " + eboPropertyName));
                LOG.debug((Object)rd);
            }
            if (!ObjectUtils.isNotNull(rd)) continue;
            if (rd.getPrimitiveAttributes().size() > 1) {
                throw new RuntimeException("EBO Links don't work for relationships with multiple-field primary keys.");
            }
            String boProperty = rd.getPrimitiveAttributes().get(0).getSourceName();
            String eboProperty = rd.getPrimitiveAttributes().get(0).getTargetName();
            StringBuffer boPropertyValue = new StringBuffer();
            for (Object ebo : eboResults) {
                if (boPropertyValue.length() != 0) {
                    boPropertyValue.append(SearchOperator.OR.op());
                }
                try {
                    boPropertyValue.append(PropertyUtils.getProperty((Object)ebo, (String)eboProperty).toString());
                }
                catch (Exception ex) {
                    LOG.warn((Object)("Unable to get value for " + eboProperty + " on " + ebo));
                }
            }
            if (eboParentPropertyName == null) {
                nonEboFieldValues.put(boProperty, boPropertyValue.toString());
                continue;
            }
            nonEboFieldValues.put(eboParentPropertyName + "." + boProperty, boPropertyValue.toString());
        }
        return nonEboFieldValues;
    }

    @Override
    public Map<String, String> performClear(LookupForm form, Map<String, String> searchCriteria) {
        Map<String, InputField> criteriaFieldMap = this.getCriteriaFieldsForValidation((LookupView)form.getView(), form);
        HashMap<String, String> clearedSearchCriteria = new HashMap<String, String>();
        for (Map.Entry<String, String> searchKeyValue : searchCriteria.entrySet()) {
            String searchPropertyName = searchKeyValue.getKey();
            InputField inputField = criteriaFieldMap.get(searchPropertyName);
            if (inputField != null) {
                clearedSearchCriteria.put(searchPropertyName, inputField.getDefaultValue());
                continue;
            }
            throw new RuntimeException("Invalid search field sent for property name: " + searchPropertyName);
        }
        return clearedSearchCriteria;
    }

    @Override
    public boolean validateSearchParameters(LookupForm form, Map<String, String> searchCriteria) {
        boolean valid = true;
        if (!this.getViewDictionaryService().isLookupable(this.getDataObjectClass())) {
            throw new RuntimeException("Lookup not defined for data object " + this.getDataObjectClass());
        }
        Map<String, InputField> criteriaFields = this.getCriteriaFieldsForValidation((LookupView)form.getView(), form);
        for (Map.Entry<String, String> searchKeyValue : searchCriteria.entrySet()) {
            String searchPropertyName = searchKeyValue.getKey();
            String searchPropertyValue = searchKeyValue.getValue();
            LookupView lookupView = (LookupView)form.getView();
            InputField inputField = criteriaFields.get(searchPropertyName);
            if (inputField != null) {
                if (StringUtils.isBlank((String)searchPropertyValue) && BooleanUtils.isTrue((Boolean)inputField.getRequired())) {
                    GlobalVariables.getMessageMap().putError(inputField.getPropertyName(), "error.required", inputField.getLabel());
                }
                this.validateSearchParameterWildcardAndOperators(inputField, searchPropertyValue);
                continue;
            }
            throw new RuntimeException("Invalid search field sent for property name: " + searchPropertyName);
        }
        if (GlobalVariables.getMessageMap().hasErrors()) {
            valid = false;
        }
        return valid;
    }

    protected Map<String, InputField> getCriteriaFieldsForValidation(LookupView lookupView, LookupForm form) {
        HashMap<String, InputField> criteriaFieldMap = new HashMap<String, InputField>();
        List<InputField> fields = ComponentUtils.getComponentsOfTypeDeep(lookupView.getCriteriaFields(), InputField.class);
        for (InputField field : fields) {
            criteriaFieldMap.put(field.getPropertyName(), field);
        }
        return criteriaFieldMap;
    }

    protected void validateSearchParameterWildcardAndOperators(InputField inputField, String searchPropertyValue) {
        if (StringUtils.isBlank((String)searchPropertyValue)) {
            return;
        }
        boolean found = false;
        for (SearchOperator op : SearchOperator.QUERY_CHARACTERS) {
            String queryCharacter = op.op();
            if (!searchPropertyValue.contains(queryCharacter)) continue;
            found = true;
        }
        if (!found) {
            return;
        }
        String attributeLabel = inputField.getLabel();
        if (LookupInputField.class.isAssignableFrom(inputField.getClass()) && ((LookupInputField)inputField).isTreatWildcardsAndOperatorsAsLiteral()) {
            Object dataObjectExample = null;
            try {
                dataObjectExample = this.getDataObjectClass().newInstance();
            }
            catch (Exception e) {
                LOG.error((Object)("Exception caught instantiating " + this.getDataObjectClass().getName()), (Throwable)e);
                throw new RuntimeException("Cannot instantiate " + this.getDataObjectClass().getName(), e);
            }
            Class<?> propertyType = ObjectPropertyUtils.getPropertyType(this.getDataObjectClass(), inputField.getPropertyName());
            if (TypeUtils.isIntegralClass(propertyType) || TypeUtils.isDecimalClass(propertyType) || TypeUtils.isTemporalClass(propertyType)) {
                GlobalVariables.getMessageMap().putError(inputField.getPropertyName(), "error.wildcards.and.operators.not.allowed.on.field", attributeLabel);
            }
            if (TypeUtils.isStringClass(propertyType)) {
                GlobalVariables.getMessageMap().putInfo(inputField.getPropertyName(), "info.wildcards.and.operators.treated.literally", attributeLabel);
            }
        } else if (this.getDataObjectAuthorizationService().attributeValueNeedsToBeEncryptedOnFormsAndLinks(this.getDataObjectClass(), inputField.getPropertyName()) && !searchPropertyValue.endsWith("(&^#&)")) {
            GlobalVariables.getMessageMap().putError(inputField.getPropertyName(), "error.secureField", attributeLabel);
        }
    }

    @Override
    public void getReturnUrlForResults(LinkField returnLinkField, Object model) {
        LookupForm lookupForm = (LookupForm)model;
        LookupView lookupView = (LookupView)returnLinkField.getContext().get("view");
        Object dataObject = returnLinkField.getContext().get("line");
        if (dataObject == null || !this.isResultReturnable(dataObject)) {
            returnLinkField.setRender(false);
            return;
        }
        String href = this.getReturnUrl(lookupView, lookupForm, dataObject);
        if (StringUtils.isBlank((String)href)) {
            returnLinkField.setRender(false);
            return;
        }
        returnLinkField.setHrefText(href);
        String linkLabel = this.getConfigurationService().getPropertyValueAsString("title.return.url.value.prependtext");
        returnLinkField.setLinkLabel(linkLabel);
        List<String> returnKeys = this.getReturnKeys(lookupView, lookupForm, dataObject);
        Map<String, String> returnKeyValues = KRADUtils.getPropertyKeyValuesFromDataObject(returnKeys, dataObject);
        String title = LookupInquiryUtils.getLinkTitleText(linkLabel, this.getDataObjectClass(), returnKeyValues);
        returnLinkField.setTitle(title);
        String returnTarget = lookupView.getReturnTarget();
        if (returnTarget != null) {
            returnLinkField.setTarget(returnTarget);
            if (!returnTarget.equals("_self")) {
                if (lookupView.isReturnByScript()) {
                    Properties props = this.getReturnUrlParameters(lookupView, lookupForm, dataObject);
                    StringBuilder script = new StringBuilder("e.preventDefault();");
                    for (String returnField : lookupForm.getFieldConversions().values()) {
                        if (!props.containsKey(returnField)) continue;
                        String fieldName = returnField.replace("'", "\\'");
                        Object value = props.get(returnField);
                        script = script.append("returnLookupResultByScript(\"" + returnField + "\", '" + value + "');");
                    }
                    returnLinkField.setOnClickScript(script.append("closeLightbox();").toString());
                } else {
                    returnLinkField.setOnClickScript("e.preventDefault();closeLightbox();createLoading(true);returnLookupResultReload(jQuery(this));");
                }
            }
        } else {
            returnLinkField.setTarget("_self");
        }
    }

    protected String getReturnUrl(LookupView lookupView, LookupForm lookupForm, Object dataObject) {
        Properties props = this.getReturnUrlParameters(lookupView, lookupForm, dataObject);
        String href = "";
        if (StringUtils.isNotBlank((String)lookupForm.getReturnLocation())) {
            href = UrlFactory.parameterizeUrl(lookupForm.getReturnLocation(), props);
        }
        return href;
    }

    protected Properties getReturnUrlParameters(LookupView lookupView, LookupForm lookupForm, Object dataObject) {
        Properties props = new Properties();
        props.put("methodToCall", "refresh");
        if (StringUtils.isNotBlank((String)lookupForm.getReturnFormKey())) {
            props.put("formKey", lookupForm.getReturnFormKey());
        }
        props.put("refreshCaller", lookupView.getId());
        props.put("refreshDataObjectClass", this.getDataObjectClass().getName());
        if (StringUtils.isNotBlank((String)lookupForm.getDocNum())) {
            props.put("docNum", lookupForm.getDocNum());
        }
        if (StringUtils.isNotBlank((String)lookupForm.getReferencesToRefresh())) {
            props.put("referencesToRefresh", lookupForm.getReferencesToRefresh());
        }
        List<String> returnKeys = this.getReturnKeys(lookupView, lookupForm, dataObject);
        Map<String, String> returnKeyValues = KRADUtils.getPropertyKeyValuesFromDataObject(returnKeys, dataObject);
        for (String returnKey : returnKeyValues.keySet()) {
            String returnValue = returnKeyValues.get(returnKey);
            if (lookupForm.getFieldConversions().containsKey(returnKey)) {
                returnKey = lookupForm.getFieldConversions().get(returnKey);
            }
            props.put(returnKey, returnValue);
        }
        return props;
    }

    protected List<String> getReturnKeys(LookupView lookupView, LookupForm lookupForm, Object dataObject) {
        List<String> returnKeys = lookupForm.getFieldConversions() != null && !lookupForm.getFieldConversions().isEmpty() ? new ArrayList<String>(lookupForm.getFieldConversions().keySet()) : this.getDataObjectMetaDataService().listPrimaryKeyFieldNames(this.getDataObjectClass());
        return returnKeys;
    }

    @Override
    public void getMaintenanceActionLink(LinkField actionLinkField, Object model, String maintenanceMethodToCall) {
        List<String> pkNames;
        LookupForm lookupForm = (LookupForm)model;
        LookupView lookupView = (LookupView)actionLinkField.getContext().get("view");
        Object dataObject = actionLinkField.getContext().get("line");
        String href = this.getActionUrlHref(lookupForm, dataObject, maintenanceMethodToCall, pkNames = this.getDataObjectMetaDataService().listPrimaryKeyFieldNames(this.getDataObjectClass()));
        if (StringUtils.isBlank((String)href)) {
            actionLinkField.setRender(false);
            return;
        }
        actionLinkField.setHrefText(href);
        String prependTitleText = actionLinkField.getLinkLabel() + " " + this.getDataDictionaryService().getDataDictionary().getDataObjectEntry(this.getDataObjectClass().getName()).getObjectLabel() + " " + this.getConfigurationService().getPropertyValueAsString("title.action.url.value.prependtext");
        Map<String, String> primaryKeyValues = KRADUtils.getPropertyKeyValuesFromDataObject(pkNames, dataObject);
        String title = LookupInquiryUtils.getLinkTitleText(prependTitleText, this.getDataObjectClass(), primaryKeyValues);
        actionLinkField.setTitle(title);
        actionLinkField.setTarget("_self");
        lookupForm.setAtLeastOneRowHasActions(true);
    }

    protected String getActionUrlHref(LookupForm lookupForm, Object dataObject, String methodToCall, List<String> pkNames) {
        LookupView lookupView = (LookupView)lookupForm.getView();
        Properties props = new Properties();
        props.put("methodToCall", methodToCall);
        Map<String, String> primaryKeyValues = KRADUtils.getPropertyKeyValuesFromDataObject(pkNames, dataObject);
        for (String primaryKey : primaryKeyValues.keySet()) {
            String primaryKeyValue = primaryKeyValues.get(primaryKey);
            props.put(primaryKey, primaryKeyValue);
        }
        if (StringUtils.isNotBlank((String)lookupForm.getReturnLocation())) {
            props.put("returnLocation", lookupForm.getReturnLocation());
        }
        props.put("dataObjectClassName", lookupForm.getDataObjectClassName());
        props.put("viewTypeName", UifConstants.ViewType.MAINTENANCE.name());
        String maintenanceMapping = "maintenance";
        if (StringUtils.isNotBlank((String)lookupView.getMaintenanceUrlMapping())) {
            maintenanceMapping = lookupView.getMaintenanceUrlMapping();
        }
        return UrlFactory.parameterizeUrl(maintenanceMapping, props);
    }

    @Override
    public void setMultiValueLookupSelect(InputField selectField, Object model) {
        LookupForm lookupForm = (LookupForm)model;
        Object lineDataObject = selectField.getContext().get("line");
        if (lineDataObject == null) {
            throw new RuntimeException("Unable to get data object for line from component: " + selectField.getId());
        }
        Control selectControl = selectField.getControl();
        if (selectControl != null && selectControl instanceof ValueConfiguredControl) {
            String lineIdentifier = "";
            Map<String, String> fieldConversions = lookupForm.getFieldConversions();
            ArrayList<String> fromFieldNames = new ArrayList<String>(fieldConversions.keySet());
            Collections.sort(fromFieldNames);
            for (String fromFieldName : fromFieldNames) {
                Object fromFieldValue = ObjectPropertyUtils.getPropertyValue(lineDataObject, fromFieldName);
                if (fromFieldValue != null) {
                    lineIdentifier = lineIdentifier + fromFieldValue;
                }
                lineIdentifier = lineIdentifier + ":";
            }
            lineIdentifier = StringUtils.removeEnd((String)lineIdentifier, (String)":");
            ((ValueConfiguredControl)((Object)selectControl)).setValue(lineIdentifier);
        }
    }

    public boolean allowsMaintenanceNewOrCopyAction() {
        boolean allowsNewOrCopy = false;
        String maintDocTypeName = this.getMaintenanceDocumentTypeName();
        if (StringUtils.isNotBlank((String)maintDocTypeName)) {
            allowsNewOrCopy = this.getDataObjectAuthorizationService().canCreate(this.getDataObjectClass(), GlobalVariables.getUserSession().getPerson(), maintDocTypeName);
        }
        return allowsNewOrCopy;
    }

    public boolean allowsMaintenanceEditAction(Object dataObject) {
        boolean allowsEdit = false;
        String maintDocTypeName = this.getMaintenanceDocumentTypeName();
        if (StringUtils.isNotBlank((String)maintDocTypeName)) {
            allowsEdit = this.getDataObjectAuthorizationService().canMaintain(dataObject, GlobalVariables.getUserSession().getPerson(), maintDocTypeName);
        }
        return allowsEdit;
    }

    public boolean allowsMaintenanceDeleteAction(Object dataObject) {
        boolean allowsMaintain = false;
        boolean allowsDelete = false;
        String maintDocTypeName = this.getMaintenanceDocumentTypeName();
        if (StringUtils.isNotBlank((String)maintDocTypeName)) {
            allowsMaintain = this.getDataObjectAuthorizationService().canMaintain(dataObject, GlobalVariables.getUserSession().getPerson(), maintDocTypeName);
        }
        return (allowsDelete = this.getDocumentDictionaryService().getAllowsRecordDeletion(this.getDataObjectClass()).booleanValue()) && allowsMaintain;
    }

    protected String getMaintenanceDocumentTypeName() {
        DocumentDictionaryService dd = this.getDocumentDictionaryService();
        String maintDocTypeName = dd.getMaintenanceDocumentTypeName(this.getDataObjectClass());
        return maintDocTypeName;
    }

    protected boolean isResultReturnable(Object dataObject) {
        return true;
    }

    @Override
    public void setDataObjectClass(Class<?> dataObjectClass) {
        this.dataObjectClass = dataObjectClass;
    }

    @Override
    public Class<?> getDataObjectClass() {
        return this.dataObjectClass;
    }

    @Override
    public void setFieldConversions(Map<String, String> fieldConversions) {
        this.fieldConversions = fieldConversions;
    }

    @Override
    public void setReadOnlyFieldsList(List<String> readOnlyFieldsList) {
        this.readOnlyFieldsList = readOnlyFieldsList;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public List<String> getDefaultSortAttributeNames() {
        return this.defaultSortAttributeNames;
    }

    public void setDefaultSortAttributeNames(List<String> defaultSortAttributeNames) {
        this.defaultSortAttributeNames = defaultSortAttributeNames;
    }

    public boolean isSortAscending() {
        return this.sortAscending;
    }

    public void setSortAscending(boolean sortAscending) {
        this.sortAscending = sortAscending;
    }

    public List<String> getReadOnlyFieldsList() {
        return this.readOnlyFieldsList;
    }

    public Map<String, String> getFieldConversions() {
        return this.fieldConversions;
    }

    protected ConfigurationService getConfigurationService() {
        if (this.configurationService == null) {
            this.configurationService = KRADServiceLocator.getKualiConfigurationService();
        }
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    protected DataObjectAuthorizationService getDataObjectAuthorizationService() {
        if (this.dataObjectAuthorizationService == null) {
            this.dataObjectAuthorizationService = KRADServiceLocatorWeb.getDataObjectAuthorizationService();
        }
        return this.dataObjectAuthorizationService;
    }

    public void setDataObjectAuthorizationService(DataObjectAuthorizationService dataObjectAuthorizationService) {
        this.dataObjectAuthorizationService = dataObjectAuthorizationService;
    }

    protected DataObjectMetaDataService getDataObjectMetaDataService() {
        if (this.dataObjectMetaDataService == null) {
            this.dataObjectMetaDataService = KRADServiceLocatorWeb.getDataObjectMetaDataService();
        }
        return this.dataObjectMetaDataService;
    }

    public void setDataObjectMetaDataService(DataObjectMetaDataService dataObjectMetaDataService) {
        this.dataObjectMetaDataService = dataObjectMetaDataService;
    }

    public DocumentDictionaryService getDocumentDictionaryService() {
        if (this.documentDictionaryService == null) {
            this.documentDictionaryService = KRADServiceLocatorWeb.getDocumentDictionaryService();
        }
        return this.documentDictionaryService;
    }

    public void setDocumentDictionaryService(DocumentDictionaryService documentDictionaryService) {
        this.documentDictionaryService = documentDictionaryService;
    }

    protected LookupService getLookupService() {
        if (this.lookupService == null) {
            this.lookupService = KRADServiceLocatorWeb.getLookupService();
        }
        return this.lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    protected EncryptionService getEncryptionService() {
        if (this.encryptionService == null) {
            this.encryptionService = CoreApiServiceLocator.getEncryptionService();
        }
        return this.encryptionService;
    }

    public void setEncryptionService(EncryptionService encryptionService) {
        this.encryptionService = encryptionService;
    }
}

