/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.service.impl;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.krad.bo.DocumentHeader;
import org.kuali.kfs.krad.dao.DocumentHeaderDao;
import org.kuali.kfs.krad.service.DocumentHeaderService;
import org.kuali.kfs.krad.service.KRADServiceLocator;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class DocumentHeaderServiceImpl
implements DocumentHeaderService {
    private static Logger LOG = Logger.getLogger(DocumentHeaderServiceImpl.class);
    private DocumentHeaderDao documentHeaderDao;

    @Override
    public Class<? extends DocumentHeader> getDocumentHeaderBaseClass() {
        Class documentHeaderClass = this.documentHeaderDao.getDocumentHeaderBaseClass();
        if (documentHeaderClass == null || !DocumentHeader.class.isAssignableFrom(documentHeaderClass)) {
            throw new RuntimeException("invalid document header base class '" + documentHeaderClass + "' returned by dao '" + this.documentHeaderDao.getClass().getName() + "'");
        }
        return documentHeaderClass;
    }

    @Override
    public DocumentHeader getDocumentHeaderById(String documentHeaderId) {
        if (StringUtils.isBlank((String)documentHeaderId)) {
            throw new IllegalArgumentException("document header id given is blank");
        }
        return this.documentHeaderDao.getByDocumentHeaderId(documentHeaderId);
    }

    @Override
    public void saveDocumentHeader(DocumentHeader documentHeader) {
        KRADServiceLocator.getBusinessObjectService().save(documentHeader);
    }

    @Override
    public void deleteDocumentHeader(DocumentHeader documentHeader) {
        KRADServiceLocator.getBusinessObjectService().delete(documentHeader);
    }

    public void setDocumentHeaderDao(DocumentHeaderDao documentHeaderDao) {
        this.documentHeaderDao = documentHeaderDao;
    }
}

