/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.uif.container;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.uif.component.Component;
import org.kuali.kfs.krad.uif.component.ComponentSecurity;
import org.kuali.kfs.krad.uif.component.DataBinding;
import org.kuali.kfs.krad.uif.container.CollectionFilter;
import org.kuali.kfs.krad.uif.container.CollectionGroup;
import org.kuali.kfs.krad.uif.control.Control;
import org.kuali.kfs.krad.uif.field.ActionField;
import org.kuali.kfs.krad.uif.field.Field;
import org.kuali.kfs.krad.uif.field.FieldGroup;
import org.kuali.kfs.krad.uif.field.InputField;
import org.kuali.kfs.krad.uif.field.RemoteFieldsHolder;
import org.kuali.kfs.krad.uif.layout.CollectionLayoutManager;
import org.kuali.kfs.krad.uif.service.ExpressionEvaluatorService;
import org.kuali.kfs.krad.uif.util.ComponentUtils;
import org.kuali.kfs.krad.uif.util.ExpressionUtils;
import org.kuali.kfs.krad.uif.util.ObjectPropertyUtils;
import org.kuali.kfs.krad.uif.view.View;
import org.kuali.kfs.krad.uif.view.ViewAuthorizer;
import org.kuali.kfs.krad.uif.view.ViewModel;
import org.kuali.kfs.krad.uif.view.ViewPresentationController;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.KRADUtils;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.web.form.UifFormBase;
import org.kuali.rice.core.api.mo.common.active.Inactivatable;
import org.kuali.rice.kim.api.identity.Person;

public class CollectionGroupBuilder
implements Serializable {
    private static final long serialVersionUID = -4762031957079895244L;

    public void build(View view, Object model, CollectionGroup collectionGroup) {
        List modelCollection;
        if (collectionGroup.isRenderAddLine() && !collectionGroup.isReadOnly()) {
            this.buildAddLine(view, model, collectionGroup);
        }
        if ((modelCollection = (List)ObjectPropertyUtils.getPropertyValue(model, collectionGroup.getBindingInfo().getBindingPath())) != null) {
            List<Integer> showIndexes = this.performCollectionFiltering(view, model, collectionGroup, modelCollection);
            for (int index = 0; index < modelCollection.size(); ++index) {
                if (!showIndexes.contains(index)) continue;
                String bindingPathPrefix = collectionGroup.getBindingInfo().getBindingName() + "[" + index + "]";
                if (StringUtils.isNotBlank((String)collectionGroup.getBindingInfo().getBindByNamePrefix())) {
                    bindingPathPrefix = collectionGroup.getBindingInfo().getBindByNamePrefix() + "." + bindingPathPrefix;
                }
                Object currentLine = modelCollection.get(index);
                List<ActionField> actions = this.getLineActions(view, model, collectionGroup, currentLine, index);
                this.buildLine(view, model, collectionGroup, bindingPathPrefix, actions, false, currentLine, index);
            }
        }
    }

    protected List<Integer> performCollectionFiltering(View view, Object model, CollectionGroup collectionGroup, Collection<?> collection) {
        CollectionFilter collectionFilter;
        List<Integer> indexes;
        List<Integer> filteredIndexes = new ArrayList<Integer>();
        for (int i = 0; i < collection.size(); ++i) {
            filteredIndexes.add(new Integer(i));
        }
        if (Inactivatable.class.isAssignableFrom(collectionGroup.getCollectionObjectClass()) && !collectionGroup.isShowInactive()) {
            List<Integer> activeIndexes = collectionGroup.getActiveCollectionFilter().filter(view, model, collectionGroup);
            filteredIndexes = ListUtils.intersection(filteredIndexes, activeIndexes);
        }
        Iterator<CollectionFilter> iterator = collectionGroup.getFilters().iterator();
        while (iterator.hasNext() && !(filteredIndexes = ListUtils.intersection(filteredIndexes, indexes = (collectionFilter = iterator.next()).filter(view, model, collectionGroup))).isEmpty()) {
        }
        return filteredIndexes;
    }

    protected void buildAddLine(View view, Object model, CollectionGroup collectionGroup) {
        boolean addLineBindsToForm = false;
        this.initializeNewCollectionLine(view, model, collectionGroup, false);
        if (StringUtils.isBlank((String)collectionGroup.getAddLinePropertyName())) {
            addLineBindsToForm = true;
        }
        String addLineBindingPath = collectionGroup.getAddLineBindingInfo().getBindingPath();
        List<ActionField> actions = this.getAddLineActions(view, model, collectionGroup);
        Object addLine = ObjectPropertyUtils.getPropertyValue(model, addLineBindingPath);
        this.buildLine(view, model, collectionGroup, addLineBindingPath, actions, addLineBindsToForm, addLine, -1);
    }

    protected void buildLine(View view, Object model, CollectionGroup collectionGroup, String bindingPath, List<ActionField> actions, boolean bindToForm, Object currentLine, int lineIndex) {
        CollectionLayoutManager layoutManager = (CollectionLayoutManager)collectionGroup.getLayoutManager();
        List<? extends Component> lineItems = null;
        String lineSuffix = null;
        if (lineIndex == -1) {
            lineItems = ComponentUtils.copyComponentList(collectionGroup.getAddLineFields(), null);
            lineSuffix = "_add";
        } else {
            lineItems = ComponentUtils.copyComponentList(collectionGroup.getItems(), null);
            lineSuffix = "_line" + Integer.toString(lineIndex);
        }
        if (StringUtils.isNotBlank((String)collectionGroup.getSubCollectionSuffix())) {
            lineSuffix = collectionGroup.getSubCollectionSuffix() + lineSuffix;
        }
        List<Field> lineFields = this.processAnyRemoteFieldsHolder(view, model, collectionGroup, lineItems);
        lineFields = ComponentUtils.copyFieldList(lineFields, bindingPath, lineSuffix);
        boolean readOnlyLine = collectionGroup.isReadOnly();
        if (lineIndex == -1) {
            for (Field f : lineFields) {
                Control control;
                if (!(f instanceof InputField) || (control = ((InputField)f).getControl()) == null) continue;
                control.addStyleClass(collectionGroup.getFactoryId() + "-addField");
                control.addStyleClass("ignoreValid");
            }
            for (ActionField action : actions) {
                if (!action.getActionParameter("actionType").equals("addLine")) continue;
                action.setFocusOnAfterSubmit(lineFields.get(0).getId());
            }
        } else {
            boolean canViewLine = this.checkViewLineAuthorizationAndPresentationLogic(view, (ViewModel)model, collectionGroup, currentLine);
            if (!canViewLine) {
                return;
            }
            if (!collectionGroup.isReadOnly()) {
                readOnlyLine = !this.checkEditLineAuthorizationAndPresentationLogic(view, (ViewModel)model, collectionGroup, currentLine);
            }
            ComponentUtils.pushObjectToContext(lineFields, "readOnlyLine", (Object)readOnlyLine);
            ComponentUtils.pushObjectToContext(actions, "readOnlyLine", (Object)readOnlyLine);
        }
        ComponentUtils.updateContextsForLine(lineFields, currentLine, lineIndex);
        this.applyLineFieldAuthorizationAndPresentationLogic(view, (ViewModel)model, collectionGroup, currentLine, readOnlyLine, lineFields, actions);
        if (bindToForm) {
            ComponentUtils.setComponentsPropertyDeep(lineFields, "bindingInfo.bindToForm", new Boolean(true));
        }
        lineFields = this.removeNonRenderLineFields(view, model, collectionGroup, lineFields, currentLine, lineIndex);
        ArrayList<FieldGroup> subCollectionFields = new ArrayList<FieldGroup>();
        if (lineIndex != -1 && collectionGroup.getSubCollections() != null) {
            for (int subLineIndex = 0; subLineIndex < collectionGroup.getSubCollections().size(); ++subLineIndex) {
                CollectionGroup subCollectionPrototype = collectionGroup.getSubCollections().get(subLineIndex);
                CollectionGroup subCollectionGroup = ComponentUtils.copy(subCollectionPrototype, lineSuffix);
                boolean renderSubCollection = this.checkSubCollectionRender(view, model, collectionGroup, subCollectionGroup);
                if (!renderSubCollection) continue;
                subCollectionGroup.getBindingInfo().setBindByNamePrefix(bindingPath);
                if (subCollectionGroup.isRenderAddLine()) {
                    subCollectionGroup.getAddLineBindingInfo().setBindByNamePrefix(bindingPath);
                }
                String subCollectionSuffix = lineSuffix;
                if (StringUtils.isNotBlank((String)subCollectionGroup.getSubCollectionSuffix())) {
                    subCollectionSuffix = subCollectionGroup.getSubCollectionSuffix() + lineSuffix;
                }
                subCollectionGroup.setSubCollectionSuffix(subCollectionSuffix);
                FieldGroup fieldGroupPrototype = layoutManager.getSubCollectionFieldGroupPrototype();
                FieldGroup subCollectionFieldGroup = ComponentUtils.copy(fieldGroupPrototype, lineSuffix + "_sub" + subLineIndex);
                subCollectionFieldGroup.setGroup(subCollectionGroup);
                ComponentUtils.updateContextForLine(subCollectionFieldGroup, currentLine, lineIndex);
                subCollectionFields.add(subCollectionFieldGroup);
            }
        }
        layoutManager.buildLine(view, model, collectionGroup, lineFields, subCollectionFields, bindingPath, actions, lineSuffix, currentLine, lineIndex);
    }

    protected List<Field> processAnyRemoteFieldsHolder(View view, Object model, CollectionGroup group, List<? extends Component> items) {
        ArrayList<Field> processedItems = new ArrayList<Field>();
        for (Component component : items) {
            if (component instanceof RemoteFieldsHolder) {
                List<InputField> translatedFields = ((RemoteFieldsHolder)component).fetchAndTranslateRemoteFields(view, model, group);
                processedItems.addAll(translatedFields);
                continue;
            }
            processedItems.add((Field)component);
        }
        return processedItems;
    }

    protected List<Field> removeNonRenderLineFields(View view, Object model, CollectionGroup collectionGroup, List<Field> lineFields, Object currentLine, int lineIndex) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field lineField : lineFields) {
            String conditionalRender = lineField.getPropertyExpression("render");
            if (StringUtils.isNotBlank((String)conditionalRender)) {
                Map<String, Object> context = this.getContextForField(view, collectionGroup, lineField);
                conditionalRender = ExpressionUtils.replaceBindingPrefixes(view, lineField, conditionalRender);
                Boolean render = (Boolean)this.getExpressionEvaluatorService().evaluateExpression(model, context, conditionalRender);
                lineField.setRender(render);
            }
            if (!lineField.isRender() && !StringUtils.isNotBlank((String)lineField.getProgressiveRender())) continue;
            fields.add(lineField);
        }
        return fields;
    }

    protected boolean checkViewLineAuthorizationAndPresentationLogic(View view, ViewModel model, CollectionGroup collectionGroup, Object line) {
        ViewPresentationController presentationController = view.getPresentationController();
        ViewAuthorizer authorizer = view.getAuthorizer();
        Person user = GlobalVariables.getUserSession().getPerson();
        boolean canViewLine = authorizer.canViewLine(view, model, collectionGroup, collectionGroup.getPropertyName(), line, user);
        if (canViewLine) {
            canViewLine = presentationController.canViewLine(view, model, collectionGroup, collectionGroup.getPropertyName(), line);
        }
        return canViewLine;
    }

    protected boolean checkEditLineAuthorizationAndPresentationLogic(View view, ViewModel model, CollectionGroup collectionGroup, Object line) {
        ViewPresentationController presentationController = view.getPresentationController();
        ViewAuthorizer authorizer = view.getAuthorizer();
        Person user = GlobalVariables.getUserSession().getPerson();
        boolean canEditLine = authorizer.canEditLine(view, model, collectionGroup, collectionGroup.getPropertyName(), line, user);
        if (canEditLine) {
            canEditLine = presentationController.canEditLine(view, model, collectionGroup, collectionGroup.getPropertyName(), line);
        }
        return canEditLine;
    }

    protected void applyLineFieldAuthorizationAndPresentationLogic(View view, ViewModel model, CollectionGroup collectionGroup, Object line, boolean readOnlyLine, List<Field> lineFields, List<ActionField> actions) {
        ViewPresentationController presentationController = view.getPresentationController();
        ViewAuthorizer authorizer = view.getAuthorizer();
        Person user = GlobalVariables.getUserSession().getPerson();
        for (Field lineField : lineFields) {
            boolean canEditField;
            String propertyName = null;
            if (lineField instanceof DataBinding) {
                propertyName = ((DataBinding)((Object)lineField)).getPropertyName();
            }
            ComponentSecurity componentSecurity = lineField.getComponentSecurity();
            ExpressionUtils.adjustPropertyExpressions(view, componentSecurity);
            Map<String, Object> context = this.getContextForField(view, collectionGroup, lineField);
            this.getExpressionEvaluatorService().evaluateObjectExpressions(componentSecurity, model, context);
            if (!lineField.isRender() || lineField.isHidden()) continue;
            boolean canViewField = authorizer.canViewLineField(view, model, collectionGroup, collectionGroup.getPropertyName(), line, lineField, propertyName, user);
            if (canViewField) {
                canViewField = presentationController.canViewLineField(view, model, collectionGroup, collectionGroup.getPropertyName(), line, lineField, propertyName);
            }
            if (!canViewField) {
                lineField.setHidden(true);
                if (!lineField.getPropertyExpressions().containsKey("hidden")) continue;
                lineField.getPropertyExpressions().remove("hidden");
                continue;
            }
            boolean bl = canEditField = !readOnlyLine;
            if (!readOnlyLine && (canEditField = authorizer.canEditLineField(view, model, collectionGroup, collectionGroup.getPropertyName(), line, lineField, propertyName, user))) {
                canEditField = presentationController.canEditLineField(view, model, collectionGroup, collectionGroup.getPropertyName(), line, lineField, propertyName);
            }
            if (!readOnlyLine && canEditField) continue;
            lineField.setReadOnly(true);
            if (!lineField.getPropertyExpressions().containsKey("readOnly")) continue;
            lineField.getPropertyExpressions().remove("readOnly");
        }
        for (ActionField actionField : actions) {
            if (!actionField.isRender()) continue;
            boolean canPerformAction = authorizer.canPerformLineAction(view, model, collectionGroup, collectionGroup.getPropertyName(), line, actionField, actionField.getActionEvent(), actionField.getId(), user);
            if (canPerformAction) {
                canPerformAction = presentationController.canPerformLineAction(view, model, collectionGroup, collectionGroup.getPropertyName(), line, actionField, actionField.getActionEvent(), actionField.getId());
            }
            if (canPerformAction) continue;
            actionField.setRender(false);
            if (!actionField.getPropertyExpressions().containsKey("render")) continue;
            actionField.getPropertyExpressions().remove("render");
        }
    }

    protected boolean checkSubCollectionRender(View view, Object model, CollectionGroup collectionGroup, CollectionGroup subCollectionGroup) {
        String conditionalRender = subCollectionGroup.getPropertyExpression("render");
        if (StringUtils.isNotBlank((String)conditionalRender)) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.putAll(view.getContext());
            context.put("parent", collectionGroup);
            context.put("component", subCollectionGroup);
            Boolean render = (Boolean)this.getExpressionEvaluatorService().evaluateExpression(model, context, conditionalRender);
            subCollectionGroup.setRender(render);
        }
        return subCollectionGroup.isRender();
    }

    protected List<ActionField> getLineActions(View view, Object model, CollectionGroup collectionGroup, Object collectionLine, int lineIndex) {
        String lineSuffix = "_line" + Integer.toString(lineIndex);
        if (StringUtils.isNotBlank((String)collectionGroup.getSubCollectionSuffix())) {
            lineSuffix = collectionGroup.getSubCollectionSuffix() + lineSuffix;
        }
        List<ActionField> lineActions = ComponentUtils.copyFieldList(collectionGroup.getActionFields(), lineSuffix);
        for (ActionField actionField : lineActions) {
            actionField.addActionParameter("selectedCollectionPath", collectionGroup.getBindingInfo().getBindingPath());
            actionField.addActionParameter("selectedLineIndex", Integer.toString(lineIndex));
            actionField.setJumpToIdAfterSubmit(collectionGroup.getId() + "_div");
            actionField.setClientSideJs("performCollectionAction('" + collectionGroup.getId() + "');");
        }
        ComponentUtils.updateContextsForLine(lineActions, collectionLine, lineIndex);
        return lineActions;
    }

    protected List<ActionField> getAddLineActions(View view, Object model, CollectionGroup collectionGroup) {
        String lineSuffix = "_add";
        if (StringUtils.isNotBlank((String)collectionGroup.getSubCollectionSuffix())) {
            lineSuffix = collectionGroup.getSubCollectionSuffix() + lineSuffix;
        }
        List<ActionField> lineActions = ComponentUtils.copyFieldList(collectionGroup.getAddLineActionFields(), lineSuffix);
        for (ActionField actionField : lineActions) {
            actionField.addActionParameter("selectedCollectionPath", collectionGroup.getBindingInfo().getBindingPath());
            actionField.setJumpToIdAfterSubmit(collectionGroup.getId() + "_div");
            actionField.addActionParameter("actionType", "addLine");
            String baseId = collectionGroup.getFactoryId();
            if (StringUtils.isNotBlank((String)collectionGroup.getSubCollectionSuffix())) {
                baseId = baseId + collectionGroup.getSubCollectionSuffix();
            }
            actionField.setClientSideJs("addLineToCollection('" + collectionGroup.getId() + "', '" + baseId + "');");
        }
        String addLinePath = collectionGroup.getAddLineBindingInfo().getBindingPath();
        Object addLine = ObjectPropertyUtils.getPropertyValue(model, addLinePath);
        ComponentUtils.updateContextsForLine(lineActions, addLine, -1);
        return lineActions;
    }

    protected Map<String, Object> getContextForField(View view, CollectionGroup collectionGroup, Field field) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.putAll(view.getContext());
        context.putAll(field.getContext());
        context.put("parent", collectionGroup);
        context.put("component", field);
        return context;
    }

    public void initializeNewCollectionLine(View view, Object model, CollectionGroup collectionGroup, boolean clearExistingLine) {
        Object newLine = null;
        if (StringUtils.isBlank((String)collectionGroup.getAddLinePropertyName())) {
            if (!(model instanceof UifFormBase)) {
                throw new RuntimeException("Cannot create new collection line for group: " + collectionGroup.getPropertyName() + ". Model does not extend " + UifFormBase.class.getName());
            }
            HashMap newCollectionLines = (HashMap)ObjectPropertyUtils.getPropertyValue(model, "newCollectionLines");
            if (newCollectionLines == null) {
                newCollectionLines = new HashMap();
                ObjectPropertyUtils.setPropertyValue(model, "newCollectionLines", newCollectionLines);
            }
            String newCollectionLineKey = KRADUtils.translateToMapSafeKey(collectionGroup.getBindingInfo().getBindingPath());
            String addLineBindingPath = "newCollectionLines['" + newCollectionLineKey + "']";
            collectionGroup.getAddLineBindingInfo().setBindingPath(addLineBindingPath);
            if (!newCollectionLines.containsKey(newCollectionLineKey) || newCollectionLines.get(newCollectionLineKey) == null || clearExistingLine) {
                newLine = ObjectUtils.newInstance(collectionGroup.getCollectionObjectClass());
                newCollectionLines.put(newCollectionLineKey, newLine);
            }
        } else {
            Object addLine = ObjectPropertyUtils.getPropertyValue(model, collectionGroup.getAddLineBindingInfo().getBindingPath());
            if (addLine == null || clearExistingLine) {
                newLine = ObjectUtils.newInstance(collectionGroup.getCollectionObjectClass());
                ObjectPropertyUtils.setPropertyValue(model, collectionGroup.getAddLineBindingInfo().getBindingPath(), newLine);
            }
        }
        if (newLine != null) {
            view.getViewHelperService().applyDefaultValuesForCollectionLine(view, model, collectionGroup, newLine);
        }
    }

    protected ExpressionEvaluatorService getExpressionEvaluatorService() {
        return KRADServiceLocatorWeb.getExpressionEvaluatorService();
    }
}

