/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.uif.view;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.krad.service.DataObjectMetaDataService;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.uif.util.ObjectPropertyUtils;
import org.kuali.kfs.krad.uif.util.ViewModelUtils;
import org.kuali.kfs.krad.uif.view.HistoryEntry;
import org.kuali.kfs.krad.uif.view.View;
import org.kuali.kfs.krad.web.form.UifFormBase;

public class History
implements Serializable {
    private static final long serialVersionUID = -8279297694371557335L;
    private static final Logger LOG = Logger.getLogger(History.class);
    public static final String ENTRY_TOKEN = "$";
    public static final String VAR_TOKEN = ",";
    private boolean appendHomewardPath;
    private boolean appendPassedHistory;
    private HistoryEntry current;
    private List<HistoryEntry> homewardPath;
    private List<HistoryEntry> historyEntries = new ArrayList<HistoryEntry>();

    public List<HistoryEntry> getHomewardPath() {
        return this.homewardPath;
    }

    public void setHomewardPath(List<HistoryEntry> homewardPath) {
        this.homewardPath = homewardPath;
    }

    public List<HistoryEntry> getHistoryEntries() {
        return this.historyEntries;
    }

    public void setHistoryEntries(List<HistoryEntry> history) {
        this.historyEntries = history;
    }

    public HistoryEntry getCurrent() {
        return this.current;
    }

    private void setCurrent(String viewId, String pageId, String title, String url, String formKey) {
        HistoryEntry entry;
        this.current = entry = new HistoryEntry(viewId, pageId, title, url, formKey);
    }

    public void setCurrent(HistoryEntry current) {
        this.current = current;
    }

    public void buildHistoryFromParameterString(String parameterString) {
        if (StringUtils.isNotEmpty((String)parameterString)) {
            try {
                parameterString = URLDecoder.decode(parameterString, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                LOG.error((Object)"Error decoding history param", (Throwable)e);
            }
            this.historyEntries = new ArrayList<HistoryEntry>();
            if (this.appendPassedHistory) {
                String[] historyTokens;
                for (String token : historyTokens = parameterString.split("\\$")) {
                    String[] params = token.split(VAR_TOKEN);
                    this.pushToHistory(params[0], params[1], params[2], params[3], params[4]);
                }
            }
        }
        if (this.appendHomewardPath) {
            this.historyEntries.addAll(this.homewardPath);
        }
    }

    public String getHistoryParameterString() {
        String historyString = "";
        for (HistoryEntry e : this.historyEntries) {
            if (this.historyEntries.indexOf(e) == 0) {
                historyString = historyString + e.toParam();
                continue;
            }
            historyString = historyString + ENTRY_TOKEN + e.toParam();
        }
        if (this.current != null) {
            historyString = historyString.equals("") ? historyString + this.current.toParam() : historyString + ENTRY_TOKEN + this.current.toParam();
        }
        try {
            historyString = URLEncoder.encode(historyString, "UTF-8");
        }
        catch (Exception e) {
            LOG.error((Object)"Error encoding history param", (Throwable)e);
        }
        return historyString;
    }

    public List<HistoryEntry> getGeneratedBreadcrumbs() {
        ArrayList<HistoryEntry> breadcrumbs = new ArrayList<HistoryEntry>();
        for (int i = 0; i < this.historyEntries.size(); ++i) {
            if (i == 0) {
                breadcrumbs.add(this.copyEntry(this.historyEntries.get(i)));
                continue;
            }
            HistoryEntry breadcrumb = this.copyEntry(this.historyEntries.get(i));
            String historyParam = "";
            for (int j = 0; j < i; ++j) {
                historyParam = historyParam + ENTRY_TOKEN + this.historyEntries.get(j).toParam();
            }
            historyParam = historyParam.replaceFirst("\\$", "");
            try {
                historyParam = URLEncoder.encode(historyParam, "UTF-8");
            }
            catch (Exception e) {
                LOG.error((Object)"Error encoding history param", (Throwable)e);
            }
            String url = "";
            url = breadcrumb.getUrl().contains("?") ? breadcrumb.getUrl() + "&" + "history" + "=" + historyParam : breadcrumb.getUrl() + "?" + "history" + "=" + historyParam;
            breadcrumb.setUrl(url);
            breadcrumbs.add(breadcrumb);
        }
        return breadcrumbs;
    }

    public HistoryEntry getGeneratedCurrentBreadcrumb() {
        if (this.current == null) {
            return new HistoryEntry();
        }
        HistoryEntry breadcrumb = this.copyEntry(this.current);
        String historyParam = "";
        for (int j = 0; j < this.historyEntries.size(); ++j) {
            historyParam = historyParam + ENTRY_TOKEN + this.historyEntries.get(j).toParam();
        }
        historyParam = historyParam.replaceFirst("\\$", "");
        try {
            historyParam = URLEncoder.encode(historyParam, "UTF-8");
        }
        catch (Exception e) {
            LOG.error((Object)"Error encoding history param", (Throwable)e);
        }
        String url = "";
        url = breadcrumb.getUrl().contains("?") ? breadcrumb.getUrl() + "&" + "history" + "=" + historyParam : breadcrumb.getUrl() + "?" + "history" + "=" + historyParam;
        breadcrumb.setUrl(url);
        return breadcrumb;
    }

    private HistoryEntry copyEntry(HistoryEntry e) {
        return new HistoryEntry(e.getViewId(), e.getPageId(), e.getTitle(), e.getUrl(), e.getFormKey());
    }

    public void pushToHistory(String viewId, String pageId, String title, String url, String formKey) {
        HistoryEntry entry = new HistoryEntry(viewId, pageId, title, url, formKey);
        this.historyEntries.add(entry);
    }

    public void setAppendHomewardPath(boolean appendHomewardPath) {
        this.appendHomewardPath = appendHomewardPath;
    }

    public boolean isAppendHomewardPath() {
        return this.appendHomewardPath;
    }

    public void setAppendPassedHistory(boolean appendPassedHistory) {
        this.appendPassedHistory = appendPassedHistory;
    }

    public boolean isAppendPassedHistory() {
        return this.appendPassedHistory;
    }

    public void setCurrent(UifFormBase form, HttpServletRequest request) {
        if (!request.getMethod().equals("POST")) {
            boolean showHomeValue = false;
            boolean pageIdValue = false;
            boolean formKeyValue = false;
            String queryString = "";
            String url = request.getRequestURL().toString();
            Enumeration params = request.getParameterNames();
            while (params.hasMoreElements()) {
                String key = (String)params.nextElement();
                if (!key.equals("history")) {
                    for (String value : request.getParameterValues(key)) {
                        queryString = queryString + "&" + key + "=" + value;
                    }
                    continue;
                }
                if (key.equals("pageId")) {
                    pageIdValue = true;
                    continue;
                }
                if (key.equals("showHome")) {
                    showHomeValue = true;
                    continue;
                }
                if (!key.equals("formKey")) continue;
                formKeyValue = true;
            }
            if (StringUtils.isNotBlank((String)form.getFormKey()) && !formKeyValue) {
                queryString = queryString + "&" + "formKey" + "=" + form.getFormKey();
            }
            if (StringUtils.isNotBlank((String)form.getPageId()) && !pageIdValue) {
                queryString = queryString + "&" + "pageId" + "=" + form.getPageId();
            }
            if (!showHomeValue) {
                queryString = queryString + "&" + "showHome" + "=false";
            }
            if (StringUtils.isNotEmpty((String)(queryString = queryString.replaceFirst("&", "")))) {
                url = url + "?" + queryString;
            }
            this.setCurrent(form.getViewId(), form.getPageId(), this.buildViewTitle(form), url, form.getFormKey());
        }
    }

    protected String buildViewTitle(UifFormBase form) {
        View view = form.getView();
        String title = view.getTitle();
        String viewLabelPropertyName = view.getViewLabelFieldPropertyName();
        if (StringUtils.isBlank((String)viewLabelPropertyName)) {
            Class<?> dataObjectClass = StringUtils.isNotBlank((String)view.getDefaultBindingObjectPath()) ? ObjectPropertyUtils.getPropertyType(form, view.getDefaultBindingObjectPath()) : view.getFormClass();
            DataObjectMetaDataService mds = KRADServiceLocatorWeb.getDataObjectMetaDataService();
            if (dataObjectClass != null) {
                viewLabelPropertyName = mds.getTitleAttribute(dataObjectClass);
            }
        }
        String viewLabelPropertyPath = "";
        if (StringUtils.isNotBlank((String)viewLabelPropertyName)) {
            if (!viewLabelPropertyName.startsWith("#form.")) {
                if (StringUtils.isNotBlank((String)view.getDefaultBindingObjectPath())) {
                    viewLabelPropertyPath = view.getDefaultBindingObjectPath() + "." + viewLabelPropertyName;
                }
            } else {
                viewLabelPropertyPath = StringUtils.removeStart((String)viewLabelPropertyName, (String)"#form.");
            }
        } else {
            String titleAttribute;
            Class<?> dataObjectClass = StringUtils.isNotBlank((String)view.getDefaultBindingObjectPath()) ? ViewModelUtils.getObjectClassForMetadata(view, form, view.getDefaultBindingObjectPath()) : view.getFormClass();
            DataObjectMetaDataService mds = KRADServiceLocatorWeb.getDataObjectMetaDataService();
            if (dataObjectClass != null && StringUtils.isNotBlank((String)(titleAttribute = mds.getTitleAttribute(dataObjectClass)))) {
                viewLabelPropertyPath = view.getDefaultBindingObjectPath() + "." + titleAttribute;
            }
        }
        Object viewLabelPropertyValue = null;
        if (StringUtils.isNotBlank((String)viewLabelPropertyPath) && ObjectPropertyUtils.isReadableProperty(form, viewLabelPropertyPath)) {
            viewLabelPropertyValue = ObjectPropertyUtils.getPropertyValue(form, viewLabelPropertyPath);
        }
        String titleAppend = "";
        if (viewLabelPropertyValue != null) {
            titleAppend = viewLabelPropertyValue.toString();
        }
        if (StringUtils.isNotBlank((String)titleAppend) && view.getAppendOption() != null) {
            if (view.getAppendOption().equalsIgnoreCase("dash")) {
                title = title + " - " + titleAppend;
            } else if (view.getAppendOption().equalsIgnoreCase("parenthesis")) {
                title = title + "(" + titleAppend + ")";
            } else if (view.getAppendOption().equalsIgnoreCase("replace")) {
                title = titleAppend;
            }
        }
        return title;
    }
}

