/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.util;

import org.apache.log4j.Logger;
import org.kuali.rice.krad.bo.ExternalizableBusinessObject;

public final class ExternalizableBusinessObjectUtils {
    private static final Logger LOG = Logger.getLogger(ExternalizableBusinessObjectUtils.class);

    private ExternalizableBusinessObjectUtils() {
        throw new UnsupportedOperationException("do not call");
    }

    public static Class determineExternalizableBusinessObjectSubInterface(Class businessObjectClass) {
        if (businessObjectClass == null) {
            return null;
        }
        if (businessObjectClass.isInterface() && !ExternalizableBusinessObject.class.equals((Object)businessObjectClass) && ExternalizableBusinessObject.class.isAssignableFrom(businessObjectClass)) {
            return businessObjectClass;
        }
        if (ExternalizableBusinessObject.class.isAssignableFrom(businessObjectClass)) {
            for (Class tempClass = businessObjectClass; tempClass != null && !Object.class.equals((Object)tempClass); tempClass = tempClass.getSuperclass()) {
                for (Class<?> tempClassInterface : tempClass.getInterfaces()) {
                    if (ExternalizableBusinessObject.class.equals(tempClassInterface) || !ExternalizableBusinessObject.class.isAssignableFrom(tempClassInterface)) continue;
                    return tempClassInterface;
                }
            }
        }
        return null;
    }

    public static boolean isExternalizableBusinessObjectInterface(Class businessObjectClass) {
        return businessObjectClass != null && businessObjectClass.isInterface() && ExternalizableBusinessObject.class.isAssignableFrom(businessObjectClass);
    }

    public static boolean isExternalizableBusinessObject(Class businessObjectClass) {
        return businessObjectClass != null && ExternalizableBusinessObject.class.isAssignableFrom(businessObjectClass);
    }

    public static boolean isExternalizableBusinessObjectInterface(String businessObjectClassName) {
        try {
            Class<?> businessObjectClass = Class.forName(businessObjectClassName);
            return ExternalizableBusinessObjectUtils.isExternalizableBusinessObjectInterface(businessObjectClass);
        }
        catch (Exception ex) {
            LOG.debug((Object)("Unable to get class object for class name: " + businessObjectClassName), (Throwable)ex);
            return false;
        }
    }
}

