/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.web.controller;

import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.krad.bo.PersistableAttachment;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.datadictionary.MaintenanceDocumentEntry;
import org.kuali.kfs.krad.exception.UnknownDocumentIdException;
import org.kuali.kfs.krad.maintenance.Maintainable;
import org.kuali.kfs.krad.maintenance.MaintenanceDocument;
import org.kuali.kfs.krad.maintenance.MaintenanceUtils;
import org.kuali.kfs.krad.service.KRADServiceLocator;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.service.MaintenanceDocumentService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.web.controller.DocumentControllerBase;
import org.kuali.kfs.krad.web.form.DocumentFormBase;
import org.kuali.kfs.krad.web.form.InitiatedDocumentInfoForm;
import org.kuali.kfs.krad.web.form.MaintenanceForm;
import org.kuali.kfs.krad.web.form.UifFormBase;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/maintenance"})
public class MaintenanceDocumentController
extends DocumentControllerBase {
    protected static final Logger LOG = Logger.getLogger(MaintenanceDocumentController.class);

    @Override
    protected MaintenanceForm createInitialForm(HttpServletRequest request) {
        return new MaintenanceForm();
    }

    @Override
    @RequestMapping(params={"methodToCall=docHandler"})
    public ModelAndView docHandler(@ModelAttribute(value="KualiForm") DocumentFormBase formBase, BindingResult result, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MaintenanceForm form = (MaintenanceForm)formBase;
        if (ArrayUtils.contains((Object[])DOCUMENT_LOAD_COMMANDS, (Object)form.getCommand()) && form.getDocId() != null) {
            try {
                this.loadDocument(form);
            }
            catch (UnknownDocumentIdException udie) {
                ConfigurationService kualiConfigurationService = KRADServiceLocator.getKualiConfigurationService();
                StringBuffer sb = new StringBuffer();
                sb.append(kualiConfigurationService.getPropertyValueAsString("krad.url"));
                sb.append(kualiConfigurationService.getPropertyValueAsString("initiated.document.url"));
                Properties props = new Properties();
                props.put("methodToCall", "start");
                GlobalVariables.getUifFormManager().removeForm(form);
                return this.performRedirect(new InitiatedDocumentInfoForm(), sb.toString(), props);
            }
        } else if ("initiate".equals(form.getCommand())) {
            this.createDocument(form);
        } else {
            LOG.error((Object)"docHandler called with invalid parameters");
            throw new IllegalArgumentException("docHandler called with invalid parameters");
        }
        if ("displayActionListView".equals(form.getCommand()) || "displayDocSearchView".equals(form.getCommand()) || "displaySuperUserView".equals(form.getCommand()) || "displayHelpDeskActionListView".equals(form.getCommand()) && form.getDocId() != null) {
            PersistableAttachment bo;
            form.setMaintenanceAction(form.getDocument().getNewMaintainableObject().getMaintenanceAction());
            Maintainable tmpMaintainable = form.getDocument().getNewMaintainableObject();
            if (tmpMaintainable.getDataObject() instanceof PersistableAttachment && (bo = (PersistableAttachment)((Object)this.getBusinessObjectService().retrieve((PersistableBusinessObject)tmpMaintainable.getDataObject()))) != null) {
                request.setAttribute("fileName", (Object)bo.getFileName());
            }
        } else if ("initiate".equals(form.getCommand())) {
            this.setupMaintenance(form, request, "New");
        } else {
            LOG.error((Object)"We should never have gotten to here");
            throw new IllegalArgumentException("docHandler called with invalid parameters");
        }
        return this.getUIFModelAndView(form);
    }

    @Override
    @RequestMapping(params={"methodToCall=start"})
    public ModelAndView start(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        MaintenanceForm maintenanceForm = (MaintenanceForm)form;
        this.setupMaintenance(maintenanceForm, request, "New");
        return this.getUIFModelAndView(maintenanceForm);
    }

    @RequestMapping(params={"methodToCall=maintenanceEdit"})
    public ModelAndView maintenanceEdit(@ModelAttribute(value="KualiForm") MaintenanceForm form, BindingResult result, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.setupMaintenance(form, request, "Edit");
        return this.getUIFModelAndView(form);
    }

    @RequestMapping(params={"methodToCall=maintenanceCopy"})
    public ModelAndView maintenanceCopy(@ModelAttribute(value="KualiForm") MaintenanceForm form, BindingResult result, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.setupMaintenance(form, request, "Copy");
        return this.getUIFModelAndView(form);
    }

    @RequestMapping(params={"methodToCall=maintenanceNewWithExisting"})
    public ModelAndView maintenanceNewWithExisting(@ModelAttribute(value="KualiForm") MaintenanceForm form, BindingResult result, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.setupMaintenance(form, request, "newWithExisting");
        return this.getUIFModelAndView(form);
    }

    protected void setupMaintenance(MaintenanceForm form, HttpServletRequest request, String maintenanceAction) {
        MaintenanceDocument document = form.getDocument();
        if (document == null) {
            document = this.getMaintenanceDocumentService().setupNewMaintenanceDocument(form.getDataObjectClassName(), form.getDocTypeName(), maintenanceAction);
            form.setDocument(document);
            form.setDocTypeName(document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName());
        }
        form.setMaintenanceAction(maintenanceAction);
        this.getMaintenanceDocumentService().setupMaintenanceObject(document, maintenanceAction, request.getParameterMap());
        if ("New".equals(maintenanceAction)) {
            MaintenanceUtils.checkForLockingDocument(document, false);
        }
        MaintenanceDocumentEntry entry = KRADServiceLocatorWeb.getDocumentDictionaryService().getMaintenanceDocumentEntry(document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName());
        document.setDisplayTopicFieldInNotes(entry.getDisplayTopicFieldInNotes());
    }

    @Override
    @RequestMapping(params={"methodToCall=route"})
    public ModelAndView route(@ModelAttribute(value="KualiForm") DocumentFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        ModelAndView modelAndView = super.route(form, result, request, response);
        MaintenanceDocument document = (MaintenanceDocument)form.getDocument();
        if (document.getNewMaintainableObject().getDataObject() instanceof PersistableAttachment) {
            PersistableAttachment bo = (PersistableAttachment)((Object)this.getBusinessObjectService().retrieve((PersistableBusinessObject)document.getNewMaintainableObject().getDataObject()));
            request.setAttribute("fileName", (Object)bo.getFileName());
        }
        modelAndView = this.getUIFModelAndView(form);
        return modelAndView;
    }

    protected MaintenanceDocumentService getMaintenanceDocumentService() {
        return KRADServiceLocatorWeb.getMaintenanceDocumentService();
    }
}

