/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.coreservice.api.parameter;

import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.w3c.dom.Element;

@XmlRootElement(name="parameterKey")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="ParameterKeyType", propOrder={"applicationId", "namespaceCode", "componentCode", "name", "_futureElements"})
public final class ParameterKey
extends AbstractDataTransferObject {
    private static final long serialVersionUID = -4405355319548951283L;
    @XmlElement(name="applicationId", required=true)
    private final String applicationId;
    @XmlElement(name="namespaceCode", required=true)
    private final String namespaceCode;
    @XmlElement(name="componentCode", required=true)
    private final String componentCode;
    @XmlElement(name="name", required=true)
    private final String name;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private ParameterKey() {
        this.applicationId = null;
        this.namespaceCode = null;
        this.componentCode = null;
        this.name = null;
    }

    private ParameterKey(String applicationId, String namespaceCode, String componentCode, String name) {
        if (StringUtils.isBlank((String)applicationId)) {
            throw new IllegalArgumentException("applicationId is blank");
        }
        if (StringUtils.isBlank((String)namespaceCode)) {
            throw new IllegalArgumentException("namespaceCode is blank");
        }
        if (StringUtils.isBlank((String)componentCode)) {
            throw new IllegalArgumentException("componentCode is blank");
        }
        if (StringUtils.isBlank((String)name)) {
            throw new IllegalArgumentException("name is blank");
        }
        this.applicationId = applicationId;
        this.namespaceCode = namespaceCode;
        this.componentCode = componentCode;
        this.name = name;
    }

    public static ParameterKey create(String applicationId, String namespaceCode, String componentCode, String name) {
        return new ParameterKey(applicationId, namespaceCode, componentCode, name);
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public String getNamespaceCode() {
        return this.namespaceCode;
    }

    public String getComponentCode() {
        return this.componentCode;
    }

    public String getName() {
        return this.name;
    }

    public String getCacheKey() {
        return this.applicationId + ":" + this.namespaceCode + ":" + this.componentCode + ":" + this.name;
    }

    static class Elements {
        static final String APPLICATION_ID = "applicationId";
        static final String NAMESPACE_CODE = "namespaceCode";
        static final String COMPONENT_CODE = "componentCode";
        static final String NAME = "name";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "parameterKey";
        static final String TYPE_NAME = "ParameterKeyType";

        Constants() {
        }
    }
}

