/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.coreservice.impl.style;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.coreservice.api.style.Style;
import org.kuali.kfs.coreservice.api.style.StyleRepositoryService;
import org.kuali.kfs.coreservice.impl.style.StyleBo;
import org.kuali.kfs.coreservice.impl.style.StyleDao;
import org.kuali.kfs.coreservice.impl.style.StyleXmlParser;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.core.api.util.RiceUtilities;

public class StyleRepositoryServiceImpl
implements StyleRepositoryService {
    private static final Logger LOG = Logger.getLogger(StyleRepositoryServiceImpl.class);
    private static final String STYLE_CONFIG_PREFIX = "edl.style";
    private StyleXmlParser styleXmlParser;
    private StyleDao styleDao;

    public void setStyleDao(StyleDao styleDao) {
        this.styleDao = styleDao;
    }

    public void setStyleXmlParser(StyleXmlParser styleXmlParser) {
        this.styleXmlParser = styleXmlParser;
    }

    @Override
    public Style getStyle(String styleName) {
        if (StringUtils.isBlank((String)styleName)) {
            throw new RiceIllegalArgumentException("styleName was null or blank");
        }
        StyleBo style = this.styleDao.getStyle(styleName);
        if (style == null) {
            String propertyName = "edl.style." + styleName;
            String location = ConfigContext.getCurrentContextConfig().getProperty(propertyName);
            if (location != null) {
                InputStream xml;
                try {
                    xml = RiceUtilities.getResourceAsStream((String)location);
                }
                catch (MalformedURLException e) {
                    throw new RiceRuntimeException(this.getUnableToLoadMessage(propertyName, location), (Throwable)e);
                }
                catch (IOException e) {
                    throw new RiceRuntimeException(this.getUnableToLoadMessage(propertyName, location), (Throwable)e);
                }
                if (xml == null) {
                    throw new RiceRuntimeException(this.getUnableToLoadMessage(propertyName, location) + ", no such file");
                }
                LOG.info((Object)("Automatically loading style '" + styleName + "' from '" + location + "' as configured by " + propertyName));
                List<Style> styles = this.styleXmlParser.parseStyles(xml);
                for (Style autoLoadedStyle : styles) {
                    if (!autoLoadedStyle.getName().equals(styleName)) continue;
                    return autoLoadedStyle;
                }
                throw new RiceRuntimeException("Failed to locate auto-loaded style '" + styleName + "' after successful parsing of file from '" + location + "' as configured by " + propertyName);
            }
        }
        return StyleBo.to(style);
    }

    private String getUnableToLoadMessage(String propertyName, String location) {
        return "unable to load resource at '" + location + "' specified by configuration parameter '" + propertyName + "'";
    }

    @Override
    public void saveStyle(Style data) {
        if (data == null) {
            throw new RiceIllegalArgumentException("The given style was null.");
        }
        StyleBo styleToUpdate = StyleBo.from(data);
        this.saveStyleBo(styleToUpdate);
    }

    protected void saveStyleBo(StyleBo styleBo) {
        StyleBo existingData = this.styleDao.getStyle(styleBo.getName());
        if (existingData != null) {
            existingData.setActive(false);
            this.styleDao.saveStyle(existingData);
        }
        this.styleDao.saveStyle(styleBo);
    }

    @Override
    public List<String> getAllStyleNames() {
        return this.styleDao.getAllStyleNames();
    }
}

