/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.kns.web.struts.action;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.ojb.broker.metadata.ClassNotPersistenceCapableException;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.upload.FormFile;
import org.kuali.kfs.kns.datadictionary.MaintainableCollectionDefinition;
import org.kuali.kfs.kns.datadictionary.MaintenanceDocumentEntry;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.document.MaintenanceDocumentBase;
import org.kuali.kfs.kns.document.authorization.MaintenanceDocumentAuthorizer;
import org.kuali.kfs.kns.document.authorization.MaintenanceDocumentRestrictions;
import org.kuali.kfs.kns.lookup.LookupResultsService;
import org.kuali.kfs.kns.maintenance.Maintainable;
import org.kuali.kfs.kns.rule.event.KualiAddLineEvent;
import org.kuali.kfs.kns.service.KNSServiceLocator;
import org.kuali.kfs.kns.service.MaintenanceDocumentDictionaryService;
import org.kuali.kfs.kns.util.KNSGlobalVariables;
import org.kuali.kfs.kns.util.MaintenanceUtils;
import org.kuali.kfs.kns.util.WebUtils;
import org.kuali.kfs.kns.web.struts.action.KualiDocumentActionBase;
import org.kuali.kfs.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.kfs.kns.web.struts.form.KualiForm;
import org.kuali.kfs.kns.web.struts.form.KualiMaintenanceForm;
import org.kuali.kfs.krad.bo.DocumentAttachment;
import org.kuali.kfs.krad.bo.MultiDocumentAttachment;
import org.kuali.kfs.krad.bo.PersistableAttachment;
import org.kuali.kfs.krad.bo.PersistableAttachmentList;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.exception.DocumentTypeAuthorizationException;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.service.LookupService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.encryption.EncryptionService;
import org.kuali.rice.core.api.util.ClassLoaderUtils;
import org.kuali.rice.core.web.format.Formatter;
import org.kuali.rice.kim.api.identity.Person;

public class KualiMaintenanceDocumentAction
extends KualiDocumentActionBase {
    protected static final Logger LOG = Logger.getLogger(KualiMaintenanceDocumentAction.class);
    protected MaintenanceDocumentDictionaryService maintenanceDocumentDictionaryService = KNSServiceLocator.getMaintenanceDocumentDictionaryService();
    protected EncryptionService encryptionService = CoreApiServiceLocator.getEncryptionService();
    protected LookupService lookupService;
    protected LookupResultsService lookupResultsService;

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("maintenanceViewMode", (Object)"maintenance");
        return super.execute(mapping, form, request, response);
    }

    public ActionForward start(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("maintenanceAction", (Object)"New");
        return this.setupMaintenance(mapping, form, request, response, "New");
    }

    public ActionForward copy(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (request.getParameter("document.documentNumber") == null) {
            return this.setupMaintenance(mapping, form, request, response, "Copy");
        }
        throw new UnsupportedOperationException("System does not support copying of maintenance documents.");
    }

    public ActionForward edit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.setupMaintenance(mapping, form, request, response, "Edit");
    }

    public ActionForward delete(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        KNSGlobalVariables.getMessageList().add("message.delete", new String[0]);
        return this.setupMaintenance(mapping, form, request, response, "Delete");
    }

    public ActionForward newWithExisting(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.setupMaintenance(mapping, form, request, response, "newWithExisting");
    }

    protected ActionForward setupMaintenance(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String maintenanceAction) throws Exception {
        KualiMaintenanceForm maintenanceForm = (KualiMaintenanceForm)form;
        MaintenanceDocument document = null;
        if (maintenanceForm.getDocument() == null) {
            if (StringUtils.isEmpty((String)maintenanceForm.getBusinessObjectClassName()) && StringUtils.isEmpty((String)maintenanceForm.getDocTypeName())) {
                throw new IllegalArgumentException("Document type name or bo class not given!");
            }
            String documentTypeName = maintenanceForm.getDocTypeName();
            if (StringUtils.isEmpty((String)documentTypeName)) {
                documentTypeName = this.maintenanceDocumentDictionaryService.getDocumentTypeName(Class.forName(maintenanceForm.getBusinessObjectClassName()));
                maintenanceForm.setDocTypeName(documentTypeName);
            }
            if (StringUtils.isEmpty((String)documentTypeName)) {
                throw new RuntimeException("documentTypeName is empty; does this Business Object have a maintenance document definition? " + maintenanceForm.getBusinessObjectClassName());
            }
            if ("New".equals(maintenanceAction) || "Copy".equals(maintenanceAction)) {
                Class boClass = this.maintenanceDocumentDictionaryService.getDataObjectClass(documentTypeName);
                boolean allowsNewOrCopy = this.getBusinessObjectAuthorizationService().canCreate(boClass, GlobalVariables.getUserSession().getPerson(), documentTypeName);
                if (!allowsNewOrCopy) {
                    LOG.error((Object)("Document type " + documentTypeName + " does not allow new or copy actions."));
                    throw new DocumentTypeAuthorizationException(GlobalVariables.getUserSession().getPerson().getPrincipalId(), "newOrCopy", documentTypeName);
                }
            }
            document = (MaintenanceDocument)this.getDocumentService().getNewDocument(maintenanceForm.getDocTypeName());
            maintenanceForm.setDocument(document);
        } else {
            document = (MaintenanceDocument)maintenanceForm.getDocument();
        }
        if (!"New".equals(maintenanceAction) && !"newWithExisting".equals(maintenanceAction)) {
            boolean allowsDelete;
            PersistableBusinessObject oldBusinessObject;
            Map requestParameters;
            block27: {
                requestParameters = this.buildKeyMapFromRequest(document.getNewMaintainableObject(), request);
                oldBusinessObject = null;
                try {
                    oldBusinessObject = (PersistableBusinessObject)this.getLookupService().findObjectBySearch(Class.forName(maintenanceForm.getBusinessObjectClassName()), requestParameters);
                }
                catch (ClassNotPersistenceCapableException ex) {
                    if (document.getOldMaintainableObject().isExternalBusinessObject()) break block27;
                    throw new RuntimeException("BO Class: " + maintenanceForm.getBusinessObjectClassName() + " is not persistable and is not externalizable - configuration error");
                }
            }
            if (oldBusinessObject == null && !document.getOldMaintainableObject().isExternalBusinessObject()) {
                throw new RuntimeException("Cannot retrieve old record for maintenance document, incorrect parameters passed on maint url: " + requestParameters);
            }
            if (document.getOldMaintainableObject().isExternalBusinessObject()) {
                if (oldBusinessObject == null) {
                    try {
                        oldBusinessObject = (PersistableBusinessObject)document.getOldMaintainableObject().getBoClass().newInstance();
                    }
                    catch (Exception ex) {
                        throw new RuntimeException("External BO maintainable was null and unable to instantiate for old maintainable object.", ex);
                    }
                }
                this.populateBOWithCopyKeyValues(request, oldBusinessObject, document.getOldMaintainableObject());
                document.getOldMaintainableObject().prepareBusinessObject(oldBusinessObject);
                oldBusinessObject = document.getOldMaintainableObject().getBusinessObject();
            }
            PersistableBusinessObject newBusinessObject = (PersistableBusinessObject)((Object)ObjectUtils.deepCopy((Serializable)((Object)oldBusinessObject)));
            Class businessObjectClass = ClassLoaderUtils.getClass((String)maintenanceForm.getBusinessObjectClassName(), PersistableBusinessObject.class);
            document.getOldMaintainableObject().setBusinessObject(oldBusinessObject);
            document.getOldMaintainableObject().setBoClass(businessObjectClass);
            document.getNewMaintainableObject().setBusinessObject(newBusinessObject);
            document.getNewMaintainableObject().setBoClass(businessObjectClass);
            if ("Copy".equals(maintenanceAction)) {
                if (!document.isFieldsClearedOnCopy()) {
                    Class boClass = this.maintenanceDocumentDictionaryService.getDataObjectClass(maintenanceForm.getDocTypeName());
                    if (!this.maintenanceDocumentDictionaryService.getPreserveLockingKeysOnCopy(boClass)) {
                        this.clearPrimaryKeyFields(document);
                    }
                    this.clearUnauthorizedNewFields(document);
                    Maintainable maintainable = document.getNewMaintainableObject();
                    maintainable.processAfterCopy(document, (Map<String, String[]>)request.getParameterMap());
                    document.setFieldsClearedOnCopy(true);
                    maintainable.setGenerateBlankRequiredValues(maintenanceForm.getDocTypeName());
                }
            } else if ("Edit".equals(maintenanceAction)) {
                boolean allowsEdit = this.getBusinessObjectAuthorizationService().canMaintain(oldBusinessObject, GlobalVariables.getUserSession().getPerson(), document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName());
                if (!allowsEdit) {
                    LOG.error((Object)("Document type " + document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName() + " does not allow edit actions."));
                    throw new DocumentTypeAuthorizationException(GlobalVariables.getUserSession().getPerson().getPrincipalId(), "edit", document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName());
                }
                document.getNewMaintainableObject().processAfterEdit(document, (Map<String, String[]>)request.getParameterMap());
            } else if ("Delete".equals(maintenanceAction) && !(allowsDelete = this.getBusinessObjectAuthorizationService().canMaintain(oldBusinessObject, GlobalVariables.getUserSession().getPerson(), document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName()))) {
                LOG.error((Object)("Document type " + document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName() + " does not allow delete actions."));
                throw new DocumentTypeAuthorizationException(GlobalVariables.getUserSession().getPerson().getPrincipalId(), "delete", document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName());
            }
        }
        if ("newWithExisting".equals(maintenanceAction)) {
            PersistableBusinessObject newBO = document.getNewMaintainableObject().getBusinessObject();
            Map parameters = this.buildKeyMapFromRequest(document.getNewMaintainableObject(), request);
            this.copyParametersToBO(parameters, newBO);
            newBO.refresh();
            document.getNewMaintainableObject().setupNewFromExisting(document, (Map<String, String[]>)request.getParameterMap());
        }
        if ("New".equals(maintenanceAction)) {
            document.getNewMaintainableObject().setGenerateDefaultValues(maintenanceForm.getDocTypeName());
            document.getNewMaintainableObject().processAfterNew(document, (Map<String, String[]>)request.getParameterMap());
            MaintenanceUtils.checkForLockingDocument(document.getNewMaintainableObject(), false);
        }
        document.getNewMaintainableObject().setMaintenanceAction(maintenanceAction);
        maintenanceForm.setMaintenanceAction(maintenanceAction);
        MaintenanceDocumentEntry entry = this.maintenanceDocumentDictionaryService.getMaintenanceDocumentEntry(document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("maintenanceForm.getAdditionalScriptFiles(): " + maintenanceForm.getAdditionalScriptFiles()));
        }
        if (maintenanceForm.getAdditionalScriptFiles().isEmpty()) {
            maintenanceForm.getAdditionalScriptFiles().addAll(entry.getWebScriptFiles());
        }
        document.setDisplayTopicFieldInNotes(entry.getDisplayTopicFieldInNotes());
        return mapping.findForward("basic");
    }

    protected void populateBOWithCopyKeyValues(HttpServletRequest request, PersistableBusinessObject oldBusinessObject, Maintainable oldMaintainableObject) throws Exception {
        Map<String, String> parametersToCopy;
        ArrayList<String> keyFieldNamesToCopy = new ArrayList<String>();
        if (!StringUtils.isBlank((String)request.getParameter("cpKys"))) {
            String[] copyKeys;
            for (String copyKey : copyKeys = request.getParameter("cpKys").split(",")) {
                keyFieldNamesToCopy.add(copyKey);
            }
        }
        if ((parametersToCopy = this.getRequestParameters(keyFieldNamesToCopy, oldMaintainableObject, request)) != null && parametersToCopy.size() > 0) {
            this.copyParametersToBO(parametersToCopy, oldBusinessObject);
        }
    }

    protected void copyParametersToBO(Map<String, String> parameters, PersistableBusinessObject newBO) throws Exception {
        for (String parmName : parameters.keySet()) {
            String propertyName;
            String propertyValue = parameters.get(parmName);
            if (!StringUtils.isNotBlank((String)propertyValue) || !PropertyUtils.isWriteable((Object)newBO, (String)(propertyName = parmName))) continue;
            Class type = ObjectUtils.easyGetPropertyType(newBO, propertyName);
            if (type != null && Formatter.getFormatter((Class)type) != null) {
                Formatter formatter = Formatter.getFormatter((Class)type);
                Object obj = formatter.convertFromPresentationFormat((Object)propertyValue);
                ObjectUtils.setObjectProperty(newBO, propertyName, obj.getClass(), obj);
                continue;
            }
            ObjectUtils.setObjectProperty(newBO, propertyName, String.class, propertyValue);
        }
    }

    public ActionForward downloadAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        block14: {
            List attachments;
            int line;
            MaintenanceDocumentBase document;
            block13: {
                byte[] attachmentContent;
                KualiDocumentFormBase documentForm = (KualiDocumentFormBase)form;
                document = (MaintenanceDocumentBase)documentForm.getDocument();
                line = this.getSelectedLine(request);
                if (line >= 0) break block13;
                DocumentAttachment documentAttachment = document.getAttachment();
                if (documentAttachment != null && documentAttachment.getAttachmentContent() != null) {
                    this.streamToResponse(documentAttachment.getAttachmentContent(), documentAttachment.getFileName(), documentAttachment.getContentType(), response);
                    return null;
                }
                PersistableAttachment attachment = (PersistableAttachment)((Object)document.getNewMaintainableObject().getBusinessObject());
                String attachmentPropNm = document.getAttachmentPropertyName();
                FormFile attachmentFromBusinessObject = null;
                String fileName = attachment.getFileName();
                String contentType = attachment.getContentType();
                if (StringUtils.isNotBlank((String)attachmentPropNm)) {
                    String attachmentPropNmSetter = "get" + attachmentPropNm.substring(0, 1).toUpperCase() + attachmentPropNm.substring(1, attachmentPropNm.length());
                    attachmentFromBusinessObject = (FormFile)attachment.getClass().getDeclaredMethod(attachmentPropNmSetter, new Class[0]).invoke((Object)attachment, new Object[0]);
                }
                if (attachmentFromBusinessObject != null && attachmentFromBusinessObject.getInputStream() != null) {
                    attachmentContent = attachmentFromBusinessObject.getFileData();
                    fileName = attachmentFromBusinessObject.getFileName();
                    contentType = attachmentFromBusinessObject.getContentType();
                } else {
                    attachmentContent = attachment.getAttachmentContent();
                }
                if (!StringUtils.isNotBlank((String)fileName) || contentType == null || attachmentContent == null) break block14;
                this.streamToResponse(attachmentContent, fileName, contentType, response);
                break block14;
            }
            PersistableAttachmentList attachmentsBo = (PersistableAttachmentList)((Object)document.getNewMaintainableObject().getBusinessObject());
            if (CollectionUtils.isEmpty(attachmentsBo.getAttachments())) {
                document.populateAttachmentListForBO();
            }
            if (CollectionUtils.isNotEmpty(attachments = attachmentsBo.getAttachments()) && attachments.size() > line) {
                byte[] attachmentContent;
                PersistableAttachment attachment = (PersistableAttachment)attachmentsBo.getAttachments().get(line);
                String fileName = attachment.getFileName();
                String contentType = attachment.getContentType();
                String attachmentPropNm = document.getAttachmentListPropertyName();
                FormFile attachmentFromBusinessObject = null;
                if (StringUtils.isNotBlank((String)attachmentPropNm)) {
                    String attachmentPropNmSetter = "get" + attachmentPropNm.substring(0, 1).toUpperCase() + attachmentPropNm.substring(1, attachmentPropNm.length());
                    attachmentFromBusinessObject = (FormFile)attachment.getClass().getDeclaredMethod(attachmentPropNmSetter, new Class[0]).invoke((Object)attachment, new Object[0]);
                }
                if (attachmentFromBusinessObject != null && attachmentFromBusinessObject.getInputStream() != null) {
                    attachmentContent = attachmentFromBusinessObject.getFileData();
                    fileName = attachmentFromBusinessObject.getFileName();
                    contentType = attachmentFromBusinessObject.getContentType();
                } else {
                    attachmentContent = attachment.getAttachmentContent();
                }
                if (attachmentContent != null) {
                    this.streamToResponse(attachmentContent, fileName, contentType, response);
                } else {
                    List<MultiDocumentAttachment> multiDocumentAttachs = document.getAttachments();
                    if (CollectionUtils.isNotEmpty(multiDocumentAttachs)) {
                        for (MultiDocumentAttachment multiAttach : multiDocumentAttachs) {
                            if (!multiAttach.getFileName().equals(fileName) || !multiAttach.getContentType().equals(contentType)) continue;
                            this.streamToResponse(multiAttach.getAttachmentContent(), multiAttach.getFileName(), multiAttach.getContentType(), response);
                            break;
                        }
                    }
                }
            }
        }
        return null;
    }

    public ActionForward replaceAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        KualiDocumentFormBase documentForm = (KualiDocumentFormBase)form;
        MaintenanceDocumentBase document = (MaintenanceDocumentBase)documentForm.getDocument();
        int lineNum = this.getSelectedLine(request);
        if (lineNum < 0) {
            document.refreshReferenceObject("attachment");
            documentForm.setAttachmentFile(null);
            document.setFileAttachment(null);
            this.getBusinessObjectService().delete(document.getAttachment());
            document.setAttachment(null);
            PersistableAttachment attachment = (PersistableAttachment)((Object)document.getNewMaintainableObject().getBusinessObject());
            attachment.setAttachmentContent(null);
            attachment.setContentType(null);
            attachment.setFileName(null);
            String attachmentPropNm = document.getAttachmentPropertyName();
            String attachmentPropNmSetter = "set" + attachmentPropNm.substring(0, 1).toUpperCase() + attachmentPropNm.substring(1, attachmentPropNm.length());
            Class<?> propNameSetterSig = null;
            try {
                Method[] methods;
                for (Method method : methods = attachment.getClass().getMethods()) {
                    if (!method.getName().equals(attachmentPropNmSetter)) continue;
                    propNameSetterSig = method.getParameterTypes()[0];
                    attachment.getClass().getDeclaredMethod(attachmentPropNmSetter, propNameSetterSig).invoke((Object)attachment, new Object[]{null});
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Not able to get the attachment " + e.getMessage()));
                throw new RuntimeException("Not able to get the attachment  " + e.getMessage());
            }
        } else {
            document.refreshReferenceObject("attachments");
            this.getBusinessObjectService().delete(document.getAttachment());
            PersistableAttachmentList attachmentListBo = (PersistableAttachmentList)((Object)document.getNewMaintainableObject().getBusinessObject());
            PersistableAttachment attachment = (PersistableAttachment)attachmentListBo.getAttachments().get(lineNum);
            attachment.setAttachmentContent(null);
            attachment.setContentType(null);
            attachment.setFileName(null);
            String attachmentPropNm = document.getAttachmentListPropertyName();
            String attachmentPropNmSetter = "set" + attachmentPropNm.substring(0, 1).toUpperCase() + attachmentPropNm.substring(1, attachmentPropNm.length());
            Class<?> propNameSetterSig = null;
            try {
                Method[] methods;
                for (Method method : methods = attachment.getClass().getMethods()) {
                    if (!method.getName().equals(attachmentPropNmSetter)) continue;
                    propNameSetterSig = method.getParameterTypes()[0];
                    attachment.getClass().getDeclaredMethod(attachmentPropNmSetter, propNameSetterSig).invoke((Object)attachment, new Object[]{null});
                    break;
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Not able to get the attachment " + e.getMessage()));
                throw new RuntimeException("Not able to get the attachment  " + e.getMessage());
            }
        }
        return mapping.findForward("basic");
    }

    @Override
    public ActionForward route(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        KualiDocumentFormBase documentForm = (KualiDocumentFormBase)form;
        MaintenanceDocumentBase document = (MaintenanceDocumentBase)documentForm.getDocument();
        ActionForward forward = super.route(mapping, form, request, response);
        PersistableBusinessObject businessObject = document.getNewMaintainableObject().getBusinessObject();
        if (businessObject instanceof PersistableAttachment) {
            document.populateAttachmentForBO();
            String fileName = ((PersistableAttachment)((Object)businessObject)).getFileName();
            if (StringUtils.isEmpty((String)fileName)) {
                PersistableAttachment existingBO = (PersistableAttachment)((Object)this.getBusinessObjectService().retrieve(document.getNewMaintainableObject().getBusinessObject()));
                fileName = existingBO == null ? (document.getAttachment() != null ? document.getAttachment().getFileName() : "") : (existingBO != null ? existingBO.getFileName() : "");
                request.setAttribute("fileName", (Object)fileName);
            }
        }
        return forward;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public ActionForward docHandler(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward af = super.docHandler(mapping, form, request, response);
        if (af.getName().equals("InitiatedDocumentView")) {
            return af;
        }
        KualiMaintenanceForm kualiMaintenanceForm = (KualiMaintenanceForm)form;
        if ("displayActionListView".equals(kualiMaintenanceForm.getCommand()) || "displayDocSearchView".equals(kualiMaintenanceForm.getCommand()) || "displaySuperUserView".equals(kualiMaintenanceForm.getCommand()) || "displayHelpDeskActionListView".equals(kualiMaintenanceForm.getCommand()) && kualiMaintenanceForm.getDocId() != null) {
            if (kualiMaintenanceForm.getDocument() instanceof MaintenanceDocument) {
                kualiMaintenanceForm.setReadOnly(true);
                kualiMaintenanceForm.setMaintenanceAction(((MaintenanceDocument)kualiMaintenanceForm.getDocument()).getNewMaintainableObject().getMaintenanceAction());
                Maintainable tmpMaintainable = ((MaintenanceDocument)kualiMaintenanceForm.getDocument()).getNewMaintainableObject();
                if (!(tmpMaintainable.getBusinessObject() instanceof PersistableAttachment)) return mapping.findForward("basic");
                PersistableAttachment bo = (PersistableAttachment)((Object)this.getBusinessObjectService().retrieve(tmpMaintainable.getBusinessObject()));
                if (bo == null) return mapping.findForward("basic");
                request.setAttribute("fileName", (Object)bo.getFileName());
                return mapping.findForward("basic");
            }
            LOG.error((Object)"Illegal State: document is not a maintenance document");
            throw new IllegalArgumentException("Document is not a maintenance document");
        }
        if ("initiate".equals(kualiMaintenanceForm.getCommand())) {
            kualiMaintenanceForm.setReadOnly(false);
            return this.setupMaintenance(mapping, form, request, response, "New");
        }
        LOG.error((Object)"We should never have gotten to here");
        throw new IllegalArgumentException("docHandler called with invalid parameters");
    }

    @Override
    public ActionForward refresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String lookupResultsSequenceNumber;
        KualiMaintenanceForm maintenanceForm = (KualiMaintenanceForm)form;
        WebUtils.reuseErrorMapFromPreviousRequest(maintenanceForm);
        maintenanceForm.setDerivedValuesOnForm(request);
        this.refreshAdHocRoutingWorkgroupLookups(request, maintenanceForm);
        MaintenanceDocument document = (MaintenanceDocument)maintenanceForm.getDocument();
        HashMap<String, String> requestParams = new HashMap<String, String>();
        Enumeration i = request.getParameterNames();
        while (i.hasMoreElements()) {
            String requestKey = (String)i.nextElement();
            String requestValue = request.getParameter(requestKey);
            requestParams.put(requestKey, requestValue);
        }
        Collection<PersistableBusinessObject> rawValues = null;
        if (StringUtils.equals((String)"multipleValues", (String)maintenanceForm.getRefreshCaller()) && StringUtils.isNotBlank((String)(lookupResultsSequenceNumber = maintenanceForm.getLookupResultsSequenceNumber()))) {
            String lookupResultsBOClassName = maintenanceForm.getLookupResultsBOClassName();
            Class<?> lookupResultsBOClass = Class.forName(lookupResultsBOClassName);
            rawValues = this.getLookupResultsService().retrieveSelectedResultBOs(lookupResultsSequenceNumber, lookupResultsBOClass, GlobalVariables.getUserSession().getPerson().getPrincipalId());
        }
        if (rawValues != null) {
            String collectionName = maintenanceForm.getLookedUpCollectionName();
            document.getNewMaintainableObject().addMultipleValueLookupResults(document, collectionName, rawValues, false, document.getNewMaintainableObject().getBusinessObject());
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"********************doing editing 3 in refersh()***********************.");
            }
            boolean isEdit = "Edit".equals(maintenanceForm.getMaintenanceAction());
            boolean isCopy = "Copy".equals(maintenanceForm.getMaintenanceAction());
            if (isEdit || isCopy) {
                document.getOldMaintainableObject().addMultipleValueLookupResults(document, collectionName, rawValues, true, document.getOldMaintainableObject().getBusinessObject());
                document.getOldMaintainableObject().refresh(maintenanceForm.getRefreshCaller(), requestParams, document);
            }
        }
        document.getNewMaintainableObject().refresh(maintenanceForm.getRefreshCaller(), requestParams, document);
        String fullParameter = (String)request.getAttribute("methodToCallAttribute");
        if (StringUtils.contains((String)fullParameter, (String)"customAction")) {
            String customAction = StringUtils.substringBetween((String)fullParameter, (String)"(((", (String)")))");
            String[] actionValue = new String[]{StringUtils.substringAfter((String)customAction, (String)".")};
            HashMap<String, String[]> paramMap = new HashMap<String, String[]>(request.getParameterMap());
            paramMap.put("customAction", actionValue);
            this.doProcessingAfterPost((KualiForm)((KualiMaintenanceForm)form), paramMap);
        }
        return mapping.findForward("basic");
    }

    protected Map buildKeyMapFromRequest(Maintainable maintainable, HttpServletRequest request) {
        List<String> keyFieldNames = null;
        if (!StringUtils.isBlank((String)request.getParameter("overrideKeys"))) {
            String[] overrideKeys = request.getParameter("overrideKeys").split(",");
            keyFieldNames = new ArrayList<String>();
            for (String overrideKey : overrideKeys) {
                keyFieldNames.add(overrideKey);
            }
        } else {
            keyFieldNames = this.getBusinessObjectMetaDataService().listPrimaryKeyFieldNames(maintainable.getBusinessObject().getClass());
        }
        return this.getRequestParameters(keyFieldNames, maintainable, request);
    }

    protected Map<String, String> getRequestParameters(List keyFieldNames, Maintainable maintainable, HttpServletRequest request) {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        for (String keyPropertyName : keyFieldNames) {
            if (request.getParameter(keyPropertyName) == null) continue;
            String keyValue = request.getParameter(keyPropertyName);
            if (this.getBusinessObjectAuthorizationService().attributeValueNeedsToBeEncryptedOnFormsAndLinks(maintainable.getBoClass(), keyPropertyName)) {
                try {
                    keyValue = StringUtils.removeEnd((String)keyValue, (String)"(&^#&)");
                    if (CoreApiServiceLocator.getEncryptionService().isEnabled()) {
                        keyValue = this.encryptionService.decrypt(keyValue);
                    }
                }
                catch (GeneralSecurityException e) {
                    throw new RuntimeException(e);
                }
            }
            requestParameters.put(keyPropertyName, keyValue);
        }
        return requestParameters;
    }

    String extractCollectionName(HttpServletRequest request, String methodToCall) {
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        String collectionName = null;
        if (StringUtils.isNotBlank((String)parameterName)) {
            collectionName = StringUtils.substringBetween((String)parameterName, (String)(methodToCall + "."), (String)".(");
        }
        return collectionName;
    }

    Collection extractCollection(PersistableBusinessObject bo, String collectionName) {
        Collection maintCollection = (Collection)ObjectUtils.getPropertyValue(bo, collectionName);
        return maintCollection;
    }

    Class extractCollectionClass(String docTypeName, String collectionName) {
        return this.maintenanceDocumentDictionaryService.getCollectionBusinessObjectClass(docTypeName, collectionName);
    }

    public ActionForward addLine(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        KualiMaintenanceForm maintenanceForm = (KualiMaintenanceForm)form;
        MaintenanceDocument document = (MaintenanceDocument)maintenanceForm.getDocument();
        Maintainable oldMaintainable = document.getOldMaintainableObject();
        Maintainable newMaintainable = document.getNewMaintainableObject();
        String collectionName = this.extractCollectionName(request, "addLine");
        if (collectionName == null) {
            LOG.error((Object)"Unable to get find collection name and class in request.");
            throw new RuntimeException("Unable to get find collection name and class in request.");
        }
        if (StringUtils.lastIndexOf((String)collectionName, (String)"]") + 1 == collectionName.length()) {
            collectionName = StringUtils.substringBeforeLast((String)collectionName, (String)"[");
        }
        PersistableBusinessObject bo = newMaintainable.getBusinessObject();
        Collection maintCollection = this.extractCollection(bo, collectionName);
        Class collectionClass = this.extractCollectionClass(((MaintenanceDocument)maintenanceForm.getDocument()).getDocumentHeader().getWorkflowDocument().getDocumentTypeName(), collectionName);
        PersistableBusinessObject addBO = newMaintainable.getNewCollectionLine(collectionName);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("obtained addBO from newCollectionLine: " + addBO));
        }
        this.getBusinessObjectService().linkUserFields(addBO);
        newMaintainable.processBeforeAddLine(collectionName, collectionClass, addBO);
        boolean rulePassed = false;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("about to call AddLineEvent applyRules: document=" + document + "\ncollectionName=" + collectionName + "\nBO=" + addBO));
        }
        if (rulePassed = this.getKualiRuleService().applyRules(new KualiAddLineEvent(document, collectionName, addBO))) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"********************doing editing 4 in addline()***********************.");
            }
            boolean isEdit = "Edit".equals(maintenanceForm.getMaintenanceAction());
            boolean isCopy = "Copy".equals(maintenanceForm.getMaintenanceAction());
            if (isEdit || isCopy) {
                PersistableBusinessObject oldBo = oldMaintainable.getBusinessObject();
                ArrayList oldMaintCollection = (ArrayList)ObjectUtils.getPropertyValue(oldBo, collectionName);
                if (oldMaintCollection == null) {
                    oldMaintCollection = new ArrayList();
                }
                if (PersistableBusinessObject.class.isAssignableFrom(collectionClass)) {
                    PersistableBusinessObject placeholder = (PersistableBusinessObject)collectionClass.newInstance();
                    placeholder.setNewCollectionRecord(true);
                    ((List)oldMaintCollection).add(placeholder);
                } else {
                    LOG.warn((Object)"Should be a instance of PersistableBusinessObject");
                    ((List)oldMaintCollection).add(collectionClass.newInstance());
                }
                ObjectUtils.setObjectProperty(oldBo, collectionName, List.class, oldMaintCollection);
            }
            newMaintainable.addNewLineToCollection(collectionName);
            int subCollectionIndex = 0;
            for (Object aSubCollection : maintCollection) {
                subCollectionIndex += this.getSubCollectionIndex(aSubCollection, maintenanceForm.getDocTypeName());
            }
        }
        this.doProcessingAfterPost((KualiForm)((KualiMaintenanceForm)form), request);
        return mapping.findForward("basic");
    }

    protected int getSubCollectionIndex(Object object, String documentTypeName) {
        int index = 1;
        MaintainableCollectionDefinition theCollectionDefinition = null;
        for (MaintainableCollectionDefinition maintainableCollectionDefinition : this.maintenanceDocumentDictionaryService.getMaintainableCollections(documentTypeName)) {
            if (!maintainableCollectionDefinition.getBusinessObjectClass().equals(object.getClass())) continue;
            theCollectionDefinition = maintainableCollectionDefinition;
            break;
        }
        if (theCollectionDefinition != null) {
            for (MaintainableCollectionDefinition subCollDef : theCollectionDefinition.getMaintainableCollections()) {
                String name = subCollDef.getName();
                String capitalFirst = name.substring(0, 1).toUpperCase();
                String methodName = "get" + capitalFirst + name.substring(1);
                List subCollectionList = new ArrayList();
                try {
                    subCollectionList = (List)object.getClass().getMethod(methodName, new Class[0]).invoke(object, new Object[0]);
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                index += subCollectionList.size();
            }
        }
        return index;
    }

    public ActionForward deleteLine(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        KualiMaintenanceForm maintenanceForm = (KualiMaintenanceForm)form;
        MaintenanceDocument document = (MaintenanceDocument)maintenanceForm.getDocument();
        Maintainable oldMaintainable = document.getOldMaintainableObject();
        Maintainable newMaintainable = document.getNewMaintainableObject();
        String collectionName = this.extractCollectionName(request, "deleteLine");
        if (collectionName == null) {
            LOG.error((Object)"Unable to get find collection name in request.");
            throw new RuntimeException("Unable to get find collection class in request.");
        }
        PersistableBusinessObject bo = newMaintainable.getBusinessObject();
        Collection maintCollection = this.extractCollection(bo, collectionName);
        if (collectionName == null) {
            LOG.error((Object)"Collection is null in parent business object.");
            throw new RuntimeException("Collection is null in parent business object.");
        }
        int deleteRecordIndex = this.getLineToDelete(request);
        if ((deleteRecordIndex < 0 || deleteRecordIndex > maintCollection.size() - 1) && collectionName == null) {
            LOG.error((Object)("Invalid index for deletion of collection record: " + deleteRecordIndex));
            throw new RuntimeException("Invalid index for deletion of collection record: " + deleteRecordIndex);
        }
        ((List)maintCollection).remove(deleteRecordIndex);
        if ("Edit".equals(maintenanceForm.getMaintenanceAction()) || "Copy".equals(maintenanceForm.getMaintenanceAction())) {
            bo = oldMaintainable.getBusinessObject();
            maintCollection = this.extractCollection(bo, collectionName);
            if (collectionName == null) {
                LOG.error((Object)"Collection is null in parent business object.");
                throw new RuntimeException("Collection is null in parent business object.");
            }
            ((List)maintCollection).remove(deleteRecordIndex);
        }
        this.doProcessingAfterPost((KualiForm)((KualiMaintenanceForm)form), request);
        return mapping.findForward("basic");
    }

    public ActionForward toggleInactiveRecordDisplay(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        KualiMaintenanceForm maintenanceForm = (KualiMaintenanceForm)form;
        MaintenanceDocument document = (MaintenanceDocument)maintenanceForm.getDocument();
        Maintainable oldMaintainable = document.getOldMaintainableObject();
        Maintainable newMaintainable = document.getNewMaintainableObject();
        String collectionName = this.extractCollectionName(request, "toggleInactiveRecordDisplay");
        if (collectionName == null) {
            LOG.error((Object)"Unable to get find collection name in request.");
            throw new RuntimeException("Unable to get find collection class in request.");
        }
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        boolean showInactive = Boolean.parseBoolean(StringUtils.substringBetween((String)parameterName, (String)"(!!", (String)"."));
        oldMaintainable.setShowInactiveRecords(collectionName, showInactive);
        newMaintainable.setShowInactiveRecords(collectionName, showInactive);
        return mapping.findForward("basic");
    }

    protected void clearPrimaryKeyFields(MaintenanceDocument document) {
        PersistableBusinessObject bo = document.getNewMaintainableObject().getBusinessObject();
        List<String> keyFieldNames = this.getBusinessObjectMetaDataService().listPrimaryKeyFieldNames(bo.getClass());
        for (String keyFieldName : keyFieldNames) {
            try {
                ObjectUtils.setObjectProperty(bo, keyFieldName, null);
            }
            catch (Exception e) {
                LOG.error((Object)("Unable to clear primary key field: " + e.getMessage()));
                throw new RuntimeException("Unable to clear primary key field: " + e.getMessage());
            }
        }
        bo.setObjectId(null);
        bo.setVersionNumber(new Long(1L));
    }

    protected void clearUnauthorizedNewFields(MaintenanceDocument document) {
        Person user = GlobalVariables.getUserSession().getPerson();
        MaintenanceDocumentAuthorizer documentAuthorizer = (MaintenanceDocumentAuthorizer)((Object)this.getDocumentHelperService().getDocumentAuthorizer(document));
        MaintenanceDocumentRestrictions maintenanceDocumentRestrictions = this.getBusinessObjectAuthorizationService().getMaintenanceDocumentRestrictions(document, user);
        PersistableBusinessObject newBo = document.getNewMaintainableObject().getBusinessObject();
        document.getNewMaintainableObject().clearBusinessObjectOfRestrictedValues(maintenanceDocumentRestrictions);
    }

    @Override
    protected void doProcessingAfterPost(KualiForm form, HttpServletRequest request) {
        MaintenanceDocument document = (MaintenanceDocument)((KualiMaintenanceForm)form).getDocument();
        Maintainable maintainable = document.getNewMaintainableObject();
        PersistableBusinessObject bo = maintainable.getBusinessObject();
        this.getBusinessObjectService().linkUserFields(bo);
        maintainable.processAfterPost(document, (Map<String, String[]>)request.getParameterMap());
    }

    protected void doProcessingAfterPost(KualiForm form, Map<String, String[]> parameters) {
        MaintenanceDocument document = (MaintenanceDocument)((KualiMaintenanceForm)form).getDocument();
        Maintainable maintainable = document.getNewMaintainableObject();
        PersistableBusinessObject bo = maintainable.getBusinessObject();
        this.getBusinessObjectService().linkUserFields(bo);
        maintainable.processAfterPost(document, parameters);
    }

    @Override
    protected void populateAuthorizationFields(KualiDocumentFormBase formBase) {
        super.populateAuthorizationFields(formBase);
        KualiMaintenanceForm maintenanceForm = (KualiMaintenanceForm)formBase;
        MaintenanceDocument maintenanceDocument = (MaintenanceDocument)maintenanceForm.getDocument();
        MaintenanceDocumentAuthorizer maintenanceDocumentAuthorizer = (MaintenanceDocumentAuthorizer)((Object)this.getDocumentHelperService().getDocumentAuthorizer(maintenanceDocument));
        Person user = GlobalVariables.getUserSession().getPerson();
        maintenanceForm.setReadOnly(!formBase.getDocumentActions().containsKey("canEdit"));
        MaintenanceDocumentRestrictions maintenanceDocumentAuthorizations = this.getBusinessObjectAuthorizationService().getMaintenanceDocumentRestrictions(maintenanceDocument, user);
        maintenanceForm.setAuthorizations(maintenanceDocumentAuthorizations);
    }

    public LookupService getLookupService() {
        if (this.lookupService == null) {
            this.lookupService = KRADServiceLocatorWeb.getLookupService();
        }
        return this.lookupService;
    }

    public LookupResultsService getLookupResultsService() {
        if (this.lookupResultsService == null) {
            this.lookupResultsService = KNSServiceLocator.getLookupResultsService();
        }
        return this.lookupResultsService;
    }
}

