/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.bo;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.krad.bo.KualiCode;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;

@MappedSuperclass
public class KualiCodeBase
extends PersistableBusinessObjectBase
implements KualiCode {
    private static final long serialVersionUID = 1194744068788100482L;
    @Id
    @Column(name="CODE")
    protected String code;
    @Column(name="NM")
    protected String name;
    @Column(name="ACTV_IND")
    protected boolean active = true;

    public KualiCodeBase() {
    }

    public KualiCodeBase(String code) {
        this();
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    @Override
    public void setCode(String code) {
        this.code = code;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean a) {
        this.active = a;
    }

    public String getCodeAndDescription() {
        return KualiCodeBase.getCodeAndDescription(this.getCode(), this.getName());
    }

    public static String getCodeAndDescription(String code, String desc) {
        if (code != null) {
            if (desc == null) {
                return code;
            }
            return code + " - " + desc;
        }
        return "";
    }

    public boolean equals(Object obj) {
        if (obj instanceof KualiCodeBase) {
            return StringUtils.equals((String)this.getCode(), (String)((KualiCodeBase)obj).getCode());
        }
        return false;
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.getCode() != null) {
            hashCode = this.getCode().hashCode();
        }
        return hashCode;
    }
}

