/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.dao.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryFactory;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.dao.BusinessObjectDao;
import org.kuali.kfs.krad.dao.DocumentDao;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.DocumentAdHocService;
import org.kuali.kfs.krad.service.KRADServiceLocatorInternal;
import org.kuali.kfs.krad.util.OjbCollectionAware;
import org.kuali.rice.core.framework.persistence.ojb.dao.PlatformAwareDaoBaseOjb;
import org.springframework.dao.DataAccessException;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class DocumentDaoOjb
extends PlatformAwareDaoBaseOjb
implements DocumentDao,
OjbCollectionAware {
    private static final Logger LOG = Logger.getLogger(DocumentDaoOjb.class);
    protected BusinessObjectDao businessObjectDao;
    protected DocumentAdHocService documentAdHocService;

    public DocumentDaoOjb(BusinessObjectDao businessObjectDao, DocumentAdHocService documentAdHocService) {
        this.businessObjectDao = businessObjectDao;
        this.documentAdHocService = documentAdHocService;
    }

    @Override
    public <T extends Document> T save(T document) throws DataAccessException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("About to store document: " + document), new Throwable());
        }
        Object retrievedDocument = this.findByDocumentHeaderId(document.getClass(), document.getDocumentNumber());
        KRADServiceLocatorInternal.getOjbCollectionHelper().processCollections(this, document, (PersistableBusinessObject)retrievedDocument);
        this.getPersistenceBrokerTemplate().store(document);
        return document;
    }

    @Override
    public <T extends Document> T findByDocumentHeaderId(Class<T> clazz, String id) {
        ArrayList<String> idList = new ArrayList<String>();
        idList.add(id);
        List<T> documentList = this.findByDocumentHeaderIds(clazz, idList);
        Document document = null;
        if (null != documentList && documentList.size() > 0) {
            document = (Document)documentList.get(0);
        }
        return (T)document;
    }

    @Override
    public <T extends Document> List<T> findByDocumentHeaderIds(Class<T> clazz, List<String> idList) {
        Criteria criteria = new Criteria();
        criteria.addIn("documentNumber", idList);
        QueryByCriteria query = QueryFactory.newQuery(clazz, (Criteria)criteria);
        ArrayList tempList = new ArrayList(this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query));
        for (Document doc : tempList) {
            this.documentAdHocService.addAdHocs(doc);
        }
        return tempList;
    }

    @Override
    public BusinessObjectDao getBusinessObjectDao() {
        return this.businessObjectDao;
    }

    public void setBusinessObjectDao(BusinessObjectDao businessObjectDao) {
        this.businessObjectDao = businessObjectDao;
    }

    @Override
    public DocumentAdHocService getDocumentAdHocService() {
        return this.documentAdHocService;
    }

    public void setDocumentAdHocService(DocumentAdHocService dahs) {
        this.documentAdHocService = dahs;
    }
}

