/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.datadictionary;

import com.google.common.base.CaseFormat;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.krad.datadictionary.BusinessObjectEntry;
import org.kuali.kfs.krad.datadictionary.DocumentEntry;
import org.kuali.kfs.krad.datadictionary.MaintenanceDocumentEntry;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.maintenance.MaintenanceDocument;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.service.ModuleService;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.doctype.DocumentType;
import org.kuali.rice.kew.api.doctype.DocumentTypeService;

public class ApiNamesGenerator {
    private KualiModuleService kualiModuleService = KRADServiceLocatorWeb.getKualiModuleService();
    private DocumentTypeService documentTypeService = KewApiServiceLocator.getDocumentTypeService();

    public String convertBusinessObjectEntryToUrlBoName(BusinessObjectEntry boEntry) {
        String beanName = boEntry.getJstlKey();
        return this.convertBusinessObjectClassNameToUrlBoName(beanName);
    }

    public String convertBusinessObjectClassNameToUrlBoName(String boClass) {
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_HYPHEN, boClass) + "s";
    }

    public String convertBusinessObjectEntryToModuleName(BusinessObjectEntry boEntry) {
        return this.generateUrlModuleNameForClass(boEntry.getBusinessObjectClass());
    }

    public String generateUrlModuleNameForClass(Class<?> businessObjectClass) {
        ModuleService moduleService = this.kualiModuleService.getResponsibleModuleService(businessObjectClass);
        if (moduleService == null) {
            return null;
        }
        return this.generateModuleName(moduleService);
    }

    private String generateModuleName(ModuleService moduleService) {
        String moduleServiceName = this.retrieveModuleName(moduleService);
        if (moduleServiceName.contains("-")) {
            moduleServiceName = StringUtils.substringAfter((String)moduleServiceName, (String)"-");
        }
        return moduleServiceName;
    }

    private String retrieveModuleName(ModuleService moduleService) {
        return moduleService.getModuleConfiguration().getNamespaceCode().toLowerCase();
    }

    public String convertDocumentEntryToUrlDocumentName(DocumentEntry documentEntry) {
        String documentTypeLabel = this.getDocumentLabelFromDocumentClass(documentEntry);
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_HYPHEN, documentTypeLabel);
    }

    private String getDocumentLabelFromDocumentClass(DocumentEntry documentEntry) {
        return this.isMaintenanceDocument(documentEntry) ? ((org.kuali.kfs.kns.datadictionary.MaintenanceDocumentEntry)documentEntry).getBusinessObjectClass().getSimpleName() + "sMaintenance" : documentEntry.getDocumentClass().getSimpleName().replaceFirst("Document$", "") + "s";
    }

    private String getDocumentLabelFromDocumentType(DocumentEntry documentEntry) {
        DocumentType documentType = this.documentTypeService.getDocumentTypeByName(documentEntry.getDocumentTypeName());
        return documentType.getLabel().replaceAll("[^A-Za-z0-9]", "");
    }

    private boolean isMaintenanceDocument(DocumentEntry documentEntry) {
        return documentEntry instanceof MaintenanceDocumentEntry && MaintenanceDocument.class.isAssignableFrom(documentEntry.getDocumentClass());
    }

    public String convertDocumentEntryToModuleName(DocumentEntry documentEntry) {
        Class<? extends Document> documentClass = this.isMaintenanceDocument(documentEntry) ? ((org.kuali.kfs.kns.datadictionary.MaintenanceDocumentEntry)documentEntry).getBusinessObjectClass() : documentEntry.getDocumentClass();
        return this.generateUrlModuleNameForClass(documentClass);
    }
}

