/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.keyvalues;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.kuali.kfs.krad.keyvalues.KeyValuesFinder;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;

public final class KeyValuesFinderFactory {
    private KeyValuesFinderFactory() {
        throw new UnsupportedOperationException("do not call");
    }

    public static KeyValuesFinder fromMap(Map<String, String> map) {
        if (map == null) {
            throw new IllegalArgumentException("map is null");
        }
        return new MapBased(map);
    }

    private static final class MapBased
    implements KeyValuesFinder {
        private final Map<String, String> map;

        private MapBased(Map<String, String> map) {
            this.map = ImmutableMap.copyOf(map);
        }

        @Override
        public List<KeyValue> getKeyValues() {
            Collection kvs = this.map.entrySet().stream().map(new Function<Map.Entry<String, String>, KeyValue>(){

                @Override
                public KeyValue apply(Map.Entry<String, String> input) {
                    return new ConcreteKeyValue(input);
                }
            }).collect(Collectors.toList());
            return ImmutableList.copyOf((Collection)kvs);
        }

        @Override
        public List<KeyValue> getKeyValues(boolean includeActiveOnly) {
            return this.getKeyValues();
        }

        @Override
        public Map<String, String> getKeyLabelMap() {
            return this.map;
        }

        @Override
        public String getKeyLabel(String key) {
            return this.map.get(key);
        }

        @Override
        public void clearInternalCache() {
        }
    }
}

