/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.kim;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.kns.kim.permission.PermissionTypeServiceBase;
import org.kuali.rice.kim.api.permission.Permission;
import org.kuali.rice.kim.impl.permission.PermissionBo;

public class ViewGroupPermissionTypeServiceImpl
extends PermissionTypeServiceBase {
    @Override
    protected List<String> getRequiredAttributes() {
        ArrayList<String> attributes = new ArrayList<String>(super.getRequiredAttributes());
        attributes.add("viewId");
        return Collections.unmodifiableList(attributes);
    }

    @Override
    protected List<Permission> performPermissionMatches(Map<String, String> requestedDetails, List<Permission> permissionsList) {
        String requestedGroupId = null;
        if (requestedDetails.containsKey("groupId")) {
            requestedGroupId = requestedDetails.get("groupId");
        }
        String requestedCollectionPropertyName = null;
        if (requestedDetails.containsKey("collectionPropertyName")) {
            requestedCollectionPropertyName = requestedDetails.get("collectionPropertyName");
        }
        ArrayList<Permission> matchingPermissions = new ArrayList<Permission>();
        for (Permission permission : permissionsList) {
            PermissionBo bo = PermissionBo.from((Permission)permission);
            String permissionGroupId = null;
            if (bo.getDetails().containsKey("groupId")) {
                permissionGroupId = (String)bo.getDetails().get("groupId");
            }
            String permissionCollectionPropertyName = null;
            if (bo.getDetails().containsKey("collectionPropertyName")) {
                permissionCollectionPropertyName = (String)bo.getDetails().get("collectionPropertyName");
            }
            if (requestedGroupId != null && permissionGroupId != null && StringUtils.equals((String)requestedGroupId, (String)permissionGroupId)) {
                matchingPermissions.add(permission);
                continue;
            }
            if (requestedCollectionPropertyName == null || permissionCollectionPropertyName == null || !StringUtils.equals((String)requestedCollectionPropertyName, (String)permissionCollectionPropertyName)) continue;
            matchingPermissions.add(permission);
        }
        return super.performPermissionMatches(requestedDetails, matchingPermissions);
    }
}

