/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.service.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Logger;
import org.kuali.kfs.kns.web.struts.action.KualiPropertyMessageResources;
import org.kuali.kfs.kns.web.struts.action.KualiPropertyMessageResourcesFactory;
import org.kuali.kfs.krad.exception.DuplicateKeyException;
import org.kuali.kfs.krad.exception.PropertiesException;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.util.Truth;

public class ConfigurationServiceImpl
implements ConfigurationService {
    private final PropertyHolder propertyHolder = new PropertyHolder();

    public ConfigurationServiceImpl() {
        this.propertyHolder.getHeldProperties().putAll((Map<?, ?>)ConfigContext.getCurrentContextConfig().getProperties());
        KualiPropertyMessageResourcesFactory propertyMessageFactory = new KualiPropertyMessageResourcesFactory();
        KualiPropertyMessageResources messageResources = (KualiPropertyMessageResources)propertyMessageFactory.createResources("");
        this.propertyHolder.getHeldProperties().putAll((Map<?, ?>)messageResources.getKualiProperties(null));
    }

    public String getPropertyValueAsString(String key) {
        if (key == null) {
            throw new IllegalArgumentException("invalid (null) key");
        }
        return this.propertyHolder.getProperty(key);
    }

    public boolean getPropertyValueAsBoolean(String key, boolean defaultValue) {
        if (key == null) {
            throw new IllegalArgumentException("invalid (null) key");
        }
        String property = this.propertyHolder.getProperty(key);
        return Truth.strToBooleanIgnoreCase((String)property, (Boolean)defaultValue);
    }

    public boolean getPropertyValueAsBoolean(String key) {
        return this.getPropertyValueAsBoolean(key, false);
    }

    public Map<String, String> getAllProperties() {
        return Collections.unmodifiableMap(this.propertyHolder.getHeldProperties());
    }

    static class FilePropertySource
    implements PropertySource {
        private static Log log = LogFactory.getLog(FilePropertySource.class);
        private String fileName;
        private boolean allowOverrides;

        FilePropertySource() {
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public String getFileName() {
            return this.fileName;
        }

        public boolean isAllowOverrides() {
            return this.allowOverrides;
        }

        public void setAllowOverrides(boolean allowOverrides) {
            this.allowOverrides = allowOverrides;
        }

        @Override
        public Properties loadProperties() {
            if (StringUtils.isBlank((String)this.getFileName())) {
                throw new IllegalStateException("invalid (blank) fileName");
            }
            Properties properties = new Properties();
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            URL url = loader.getResource(this.getFileName());
            if (url == null) {
                throw new PropertiesException("unable to locate properties file '" + this.getFileName() + "'");
            }
            InputStream in = null;
            try {
                in = url.openStream();
                properties.load(in);
            }
            catch (IOException e) {
                throw new PropertiesException("error loading from properties file '" + this.getFileName() + "'", e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        log.error((Object)("caught exception closing InputStream: " + e));
                    }
                }
            }
            return properties;
        }
    }

    static class PropertyHolder {
        private static Logger LOG = Logger.getLogger(PropertyHolder.class);
        Properties heldProperties = new Properties();

        public boolean isEmpty() {
            return this.heldProperties.isEmpty();
        }

        public boolean containsKey(String key) {
            this.validateKey(key);
            return this.heldProperties.containsKey(key);
        }

        public String getProperty(String key) {
            this.validateKey(key);
            return this.heldProperties.getProperty(key);
        }

        public void setProperty(String key, String value) {
            this.setProperty(null, key, value);
        }

        public void setProperty(PropertySource source, String key, String value) {
            this.validateKey(key);
            this.validateValue(value);
            if (this.containsKey(key)) {
                if (source != null && source instanceof FilePropertySource && ((FilePropertySource)source).isAllowOverrides()) {
                    LOG.info((Object)("Duplicate Key: Override is enabled [key=" + key + ", new value=" + value + ", old value=" + this.heldProperties.getProperty(key) + "]"));
                } else {
                    throw new DuplicateKeyException("duplicate key '" + key + "'");
                }
            }
            this.heldProperties.setProperty(key, value);
        }

        public void clearProperty(String key) {
            this.validateKey(key);
            this.heldProperties.remove(key);
        }

        public void loadProperties(PropertySource source) {
            if (source == null) {
                throw new IllegalArgumentException("invalid (null) source");
            }
            Properties newProperties = source.loadProperties();
            for (String string : newProperties.keySet()) {
                this.setProperty(source, string, newProperties.getProperty(string));
            }
        }

        public void clearProperties() {
            this.heldProperties.clear();
        }

        public Iterator getKeys() {
            return this.heldProperties.keySet().iterator();
        }

        private void validateKey(String key) {
            if (key == null) {
                throw new IllegalArgumentException("invalid (null) key");
            }
        }

        private void validateValue(String value) {
            if (value == null) {
                throw new IllegalArgumentException("invalid (null) value");
            }
        }

        public Properties getHeldProperties() {
            return this.heldProperties;
        }

        public void setHeldProperties(Properties heldProperties) {
            this.heldProperties = heldProperties;
        }
    }

    static interface PropertySource {
        public Properties loadProperties();
    }
}

