/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.uif.field;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.krad.datadictionary.AttributeDefinition;
import org.kuali.kfs.krad.datadictionary.validation.capability.CaseConstrainable;
import org.kuali.kfs.krad.datadictionary.validation.capability.LengthConstrainable;
import org.kuali.kfs.krad.datadictionary.validation.capability.MustOccurConstrainable;
import org.kuali.kfs.krad.datadictionary.validation.capability.PrerequisiteConstrainable;
import org.kuali.kfs.krad.datadictionary.validation.capability.RangeConstrainable;
import org.kuali.kfs.krad.datadictionary.validation.capability.SimpleConstrainable;
import org.kuali.kfs.krad.datadictionary.validation.capability.ValidCharactersConstrainable;
import org.kuali.kfs.krad.datadictionary.validation.constraint.CaseConstraint;
import org.kuali.kfs.krad.datadictionary.validation.constraint.MustOccurConstraint;
import org.kuali.kfs.krad.datadictionary.validation.constraint.PrerequisiteConstraint;
import org.kuali.kfs.krad.datadictionary.validation.constraint.SimpleConstraint;
import org.kuali.kfs.krad.datadictionary.validation.constraint.ValidCharactersConstraint;
import org.kuali.kfs.krad.keyvalues.KeyValuesFinder;
import org.kuali.kfs.krad.uif.component.Component;
import org.kuali.kfs.krad.uif.control.Control;
import org.kuali.kfs.krad.uif.control.MultiValueControlBase;
import org.kuali.kfs.krad.uif.control.TextControl;
import org.kuali.kfs.krad.uif.control.UifKeyValuesFinder;
import org.kuali.kfs.krad.uif.field.AttributeQuery;
import org.kuali.kfs.krad.uif.field.DataField;
import org.kuali.kfs.krad.uif.field.ErrorsField;
import org.kuali.kfs.krad.uif.field.MessageField;
import org.kuali.kfs.krad.uif.util.ClientValidationUtils;
import org.kuali.kfs.krad.uif.util.ComponentUtils;
import org.kuali.kfs.krad.uif.util.ObjectPropertyUtils;
import org.kuali.kfs.krad.uif.view.View;
import org.kuali.kfs.krad.uif.view.ViewModel;
import org.kuali.kfs.krad.uif.widget.DirectInquiry;
import org.kuali.kfs.krad.uif.widget.QuickFinder;
import org.kuali.kfs.krad.uif.widget.Suggest;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.rice.core.api.data.DataType;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.core.api.util.type.TypeUtils;

public class InputField
extends DataField
implements SimpleConstrainable,
CaseConstrainable,
PrerequisiteConstrainable,
MustOccurConstrainable,
LengthConstrainable,
RangeConstrainable,
ValidCharactersConstrainable {
    private static final long serialVersionUID = -3703656713706343840L;
    private String customValidatorClass;
    private ValidCharactersConstraint validCharactersConstraint;
    private CaseConstraint caseConstraint;
    private List<PrerequisiteConstraint> dependencyConstraints;
    private List<MustOccurConstraint> mustOccurConstraints;
    private SimpleConstraint simpleConstraint = new SimpleConstraint();
    private DataType dataType;
    private Control control;
    private KeyValuesFinder optionsFinder;
    private boolean performUppercase;
    private ErrorsField errorsField;
    private String constraintText;
    private String instructionalText;
    private MessageField instructionalMessageField;
    private MessageField constraintMessageField;
    private AttributeQuery fieldAttributeQuery;
    private QuickFinder fieldLookup;
    private DirectInquiry fieldDirectInquiry;
    private Suggest fieldSuggest;
    private Boolean directInquiryRender = true;

    @Override
    public void performFinalize(View view, Object model, Component parent) {
        Object fieldValue;
        MultiValueControlBase multiValueControl;
        super.performFinalize(view, model, parent);
        this.setupIds();
        ArrayList<KeyValue> fieldOptions = new ArrayList();
        if (this.control != null && this.control instanceof MultiValueControlBase && (multiValueControl = (MultiValueControlBase)this.control).getOptions() != null && !multiValueControl.getOptions().isEmpty()) {
            fieldOptions = multiValueControl.getOptions();
        }
        if (fieldOptions.isEmpty() && this.optionsFinder != null) {
            if (this.optionsFinder instanceof UifKeyValuesFinder) {
                fieldOptions = ((UifKeyValuesFinder)this.optionsFinder).getKeyValues((ViewModel)model);
                if (((UifKeyValuesFinder)this.optionsFinder).isAddBlankOption()) {
                    fieldOptions.add(0, (KeyValue)new ConcreteKeyValue("", ""));
                }
            } else {
                fieldOptions = this.optionsFinder.getKeyValues();
            }
            if (this.control != null && this.control instanceof MultiValueControlBase) {
                ((MultiValueControlBase)this.control).setOptions(fieldOptions);
            }
        }
        if (this.isReadOnly() && !fieldOptions.isEmpty() && StringUtils.isBlank((String)this.getAlternateDisplayValue()) && StringUtils.isBlank((String)this.getAdditionalDisplayValue()) && StringUtils.isBlank((String)this.getAlternateDisplayPropertyName()) && StringUtils.isBlank((String)this.getAdditionalDisplayPropertyName()) && (fieldValue = ObjectPropertyUtils.getPropertyValue(model, this.getBindingInfo().getBindingPath())) != null && TypeUtils.isSimpleType(fieldValue.getClass())) {
            for (KeyValue keyValue : fieldOptions) {
                if (!StringUtils.equals((String)fieldValue.toString(), (String)keyValue.getKey())) continue;
                this.setAlternateDisplayValue(keyValue.getValue());
                break;
            }
        }
        if (this.isReadOnly() || this.getControl() == null) {
            return;
        }
        if (StringUtils.isNotBlank((String)this.instructionalText)) {
            this.instructionalMessageField.setMessageText(this.instructionalText);
        }
        if (StringUtils.isNotBlank((String)this.constraintText)) {
            this.constraintMessageField.setMessageText(this.constraintText);
        }
        this.adjustPrerequisiteConstraintBinding(this.dependencyConstraints);
        this.adjustMustOccurConstraintBinding(this.mustOccurConstraints);
        if (this.caseConstraint != null) {
            String propertyName = this.getBindingInfo().getPropertyAdjustedBindingPath(this.caseConstraint.getPropertyName());
            this.caseConstraint.setPropertyName(propertyName);
        }
        this.setupFieldQuery();
        ClientValidationUtils.processAndApplyConstraints(this, view);
    }

    protected void adjustMustOccurConstraintBinding(List<MustOccurConstraint> mustOccurConstraints) {
        if (mustOccurConstraints != null) {
            for (MustOccurConstraint mustOccurConstraint : mustOccurConstraints) {
                this.adjustPrerequisiteConstraintBinding(mustOccurConstraint.getPrerequisiteConstraints());
                this.adjustMustOccurConstraintBinding(mustOccurConstraint.getMustOccurConstraints());
            }
        }
    }

    protected void adjustPrerequisiteConstraintBinding(List<PrerequisiteConstraint> prerequisiteConstraints) {
        if (prerequisiteConstraints != null) {
            for (PrerequisiteConstraint prerequisiteConstraint : prerequisiteConstraints) {
                String propertyName = this.getBindingInfo().getPropertyAdjustedBindingPath(prerequisiteConstraint.getPropertyName());
                prerequisiteConstraint.setPropertyName(propertyName);
            }
        }
    }

    protected void setupFieldQuery() {
        if (this.getFieldAttributeQuery() != null) {
            this.getFieldAttributeQuery().updateQueryFieldMapping(this.getBindingInfo());
            this.getFieldAttributeQuery().updateReturnFieldMapping(this.getBindingInfo());
            this.getFieldAttributeQuery().updateQueryMethodArgumentFieldList(this.getBindingInfo());
            String script = "executeFieldQuery('" + this.getControl().getId() + "',";
            script = script + "'" + this.getId() + "'," + this.getFieldAttributeQuery().getQueryFieldMappingJsString() + ",";
            script = script + this.getFieldAttributeQuery().getQueryMethodArgumentFieldsJsString() + ",";
            script = script + this.getFieldAttributeQuery().getReturnFieldMappingJsString() + ");";
            if (StringUtils.isNotBlank((String)this.getControl().getOnBlurScript())) {
                script = this.getControl().getOnBlurScript() + script;
            }
            this.getControl().setOnBlurScript(script);
        }
    }

    protected void setupIds() {
        if (this.getControl() != null) {
            this.getControl().setId(this.getId());
        }
        this.setNestedComponentIdAndSuffix(this.getErrorsField(), "_errors");
        this.setNestedComponentIdAndSuffix(this.getLabelField(), "_label");
        this.setNestedComponentIdAndSuffix(this.getInstructionalMessageField(), "_instructional");
        this.setNestedComponentIdAndSuffix(this.getConstraintMessageField(), "_constraint");
        this.setNestedComponentIdAndSuffix(this.getFieldLookup(), "_quickfinder");
        this.setNestedComponentIdAndSuffix(this.getFieldDirectInquiry(), "_directinquiry");
        this.setNestedComponentIdAndSuffix(this.getFieldSuggest(), "_suggest");
        this.setId(this.getId() + "_attribute");
    }

    private void setNestedComponentIdAndSuffix(Component component, String suffix) {
        if (component != null) {
            String fieldId = this.getId();
            fieldId = fieldId + suffix;
            component.setId(fieldId);
        }
    }

    @Override
    public void copyFromAttributeDefinition(View view, AttributeDefinition attributeDefinition) {
        super.copyFromAttributeDefinition(view, attributeDefinition);
        if (this.getMaxLength() == null) {
            this.setMaxLength(attributeDefinition.getMaxLength());
        }
        if (this.getMinLength() == null) {
            this.setMinLength(attributeDefinition.getMinLength());
        }
        if (this.getValidCharactersConstraint() == null) {
            this.setValidCharactersConstraint(attributeDefinition.getValidCharactersConstraint());
        }
        if (this.getCaseConstraint() == null) {
            this.setCaseConstraint(attributeDefinition.getCaseConstraint());
        }
        if (this.getDependencyConstraints() == null) {
            this.setDependencyConstraints(attributeDefinition.getPrerequisiteConstraints());
        }
        if (this.getMustOccurConstraints() == null) {
            this.setMustOccurConstraints(attributeDefinition.getMustOccurConstraints());
        }
        if (this.getRequired() == null) {
            this.setRequired(attributeDefinition.isRequired());
            if (this.getRequired() == null) {
                this.setRequired(false);
            }
        }
        if (this.dataType == null) {
            this.setDataType(attributeDefinition.getDataType());
            if (this.dataType == null && this.control instanceof TextControl && ((TextControl)this.control).getDatePicker() != null) {
                this.setDataType(DataType.DATE);
            }
        }
        if (this.getControl() == null && attributeDefinition.getControlField() != null) {
            Control control = attributeDefinition.getControlField();
            view.assignComponentIds(control);
            this.setControl(ComponentUtils.copy(control));
        }
        if (StringUtils.isEmpty((String)this.getConstraintText())) {
            this.setConstraintText(attributeDefinition.getConstraintText());
            this.getConstraintMessageField().setMessageText(attributeDefinition.getConstraintText());
        }
        if (this.getOptionsFinder() == null) {
            this.setOptionsFinder(attributeDefinition.getOptionsFinder());
        }
    }

    @Override
    public List<Component> getComponentsForLifecycle() {
        List<Component> components = super.getComponentsForLifecycle();
        components.add(this.control);
        components.add(this.errorsField);
        components.add(this.fieldLookup);
        components.add(this.fieldDirectInquiry);
        components.add(this.fieldSuggest);
        return components;
    }

    @Override
    public boolean isInputAllowed() {
        return true;
    }

    public Control getControl() {
        return this.control;
    }

    public void setControl(Control control) {
        this.control = control;
    }

    public ErrorsField getErrorsField() {
        return this.errorsField;
    }

    public void setErrorsField(ErrorsField errorsField) {
        this.errorsField = errorsField;
    }

    public KeyValuesFinder getOptionsFinder() {
        return this.optionsFinder;
    }

    public void setOptionsFinder(KeyValuesFinder optionsFinder) {
        this.optionsFinder = optionsFinder;
    }

    public void setOptionsFinderClass(Class<? extends KeyValuesFinder> optionsFinderClass) {
        this.optionsFinder = ObjectUtils.newInstance(optionsFinderClass);
    }

    @Override
    public boolean getSupportsOnLoad() {
        return true;
    }

    public QuickFinder getFieldLookup() {
        return this.fieldLookup;
    }

    public void setFieldLookup(QuickFinder fieldLookup) {
        this.fieldLookup = fieldLookup;
    }

    public Suggest getFieldSuggest() {
        return this.fieldSuggest;
    }

    public void setFieldSuggest(Suggest fieldSuggest) {
        this.fieldSuggest = fieldSuggest;
    }

    public String getInstructionalText() {
        return this.instructionalText;
    }

    public void setInstructionalText(String instructionalText) {
        this.instructionalText = instructionalText;
    }

    public MessageField getInstructionalMessageField() {
        return this.instructionalMessageField;
    }

    public void setInstructionalMessageField(MessageField instructionalMessageField) {
        this.instructionalMessageField = instructionalMessageField;
    }

    public String getConstraintText() {
        return this.constraintText;
    }

    public void setConstraintText(String constraintText) {
        this.constraintText = constraintText;
    }

    public MessageField getConstraintMessageField() {
        return this.constraintMessageField;
    }

    public void setConstraintMessageField(MessageField constraintMessageField) {
        this.constraintMessageField = constraintMessageField;
    }

    @Override
    public ValidCharactersConstraint getValidCharactersConstraint() {
        return this.validCharactersConstraint;
    }

    public void setValidCharactersConstraint(ValidCharactersConstraint validCharactersConstraint) {
        this.validCharactersConstraint = validCharactersConstraint;
    }

    @Override
    public CaseConstraint getCaseConstraint() {
        return this.caseConstraint;
    }

    public void setCaseConstraint(CaseConstraint caseConstraint) {
        this.caseConstraint = caseConstraint;
    }

    public List<PrerequisiteConstraint> getDependencyConstraints() {
        return this.dependencyConstraints;
    }

    public void setDependencyConstraints(List<PrerequisiteConstraint> dependencyConstraints) {
        this.dependencyConstraints = dependencyConstraints;
    }

    @Override
    public List<MustOccurConstraint> getMustOccurConstraints() {
        return this.mustOccurConstraints;
    }

    public void setMustOccurConstraints(List<MustOccurConstraint> mustOccurConstraints) {
        this.mustOccurConstraints = mustOccurConstraints;
    }

    @Override
    public SimpleConstraint getSimpleConstraint() {
        return this.simpleConstraint;
    }

    public void setSimpleConstraint(SimpleConstraint simpleConstraint) {
        this.simpleConstraint = simpleConstraint;
    }

    @Override
    public Integer getMaxLength() {
        return this.simpleConstraint.getMaxLength();
    }

    public void setMaxLength(Integer maxLength) {
        this.simpleConstraint.setMaxLength(maxLength);
    }

    @Override
    public Integer getMinLength() {
        return this.simpleConstraint.getMinLength();
    }

    public void setMinLength(Integer minLength) {
        this.simpleConstraint.setMinLength(minLength);
    }

    public Boolean getDirectInquiryRender() {
        return this.directInquiryRender;
    }

    public void setDirectInquiryRender(Boolean directInquiryRender) {
        this.directInquiryRender = directInquiryRender;
    }

    @Override
    public Boolean getRequired() {
        return this.simpleConstraint.getRequired();
    }

    @Override
    public void setRequired(Boolean required) {
        this.simpleConstraint.setRequired(required);
    }

    @Override
    public String getExclusiveMin() {
        return this.simpleConstraint.getExclusiveMin();
    }

    public void setExclusiveMin(String exclusiveMin) {
        this.simpleConstraint.setExclusiveMin(exclusiveMin);
    }

    @Override
    public String getInclusiveMax() {
        return this.simpleConstraint.getInclusiveMax();
    }

    public void setInclusiveMax(String inclusiveMax) {
        this.simpleConstraint.setInclusiveMax(inclusiveMax);
    }

    public DirectInquiry getFieldDirectInquiry() {
        return this.fieldDirectInquiry;
    }

    public void setFieldDirectInquiry(DirectInquiry fieldDirectInquiry) {
        this.fieldDirectInquiry = fieldDirectInquiry;
    }

    public AttributeQuery getFieldAttributeQuery() {
        return this.fieldAttributeQuery;
    }

    public void setFieldAttributeQuery(AttributeQuery fieldAttributeQuery) {
        this.fieldAttributeQuery = fieldAttributeQuery;
    }

    public boolean isPerformUppercase() {
        return this.performUppercase;
    }

    public void setPerformUppercase(boolean performUppercase) {
        this.performUppercase = performUppercase;
    }

    @Override
    public String getName() {
        return this.getBindingInfo().getBindingPath();
    }

    @Override
    public List<PrerequisiteConstraint> getPrerequisiteConstraints() {
        return this.dependencyConstraints;
    }

    public void setDataType(DataType dataType) {
        this.simpleConstraint.setDataType(dataType);
    }

    public void setDataType(String dataType) {
        this.simpleConstraint.setDataType(DataType.valueOf((String)dataType));
    }

    @Override
    public DataType getDataType() {
        return this.simpleConstraint.getDataType();
    }
}

