/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.uif.modifier;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.kuali.kfs.krad.uif.component.Component;
import org.kuali.kfs.krad.uif.modifier.ComponentModifierBase;
import org.kuali.kfs.krad.uif.util.ComponentUtils;
import org.kuali.kfs.krad.uif.util.ObjectPropertyUtils;
import org.kuali.kfs.krad.uif.view.View;

public class ComponentConvertModifier
extends ComponentModifierBase {
    private static final long serialVersionUID = -7566547737669924605L;
    private Class<? extends Component> componentTypeToReplace;
    private Component componentReplacementPrototype;

    @Override
    public void performModification(View view, Object model, Component component) {
        if (component == null) {
            return;
        }
        int idSuffix = 0;
        this.convertToReplacement(component, idSuffix);
    }

    protected void convertToReplacement(Component component, int idSuffix) {
        if (component == null) {
            return;
        }
        List<String> componentProperties = ComponentUtils.getComponentPropertyNames(component.getClass());
        for (String propertyPath : componentProperties) {
            Object propValue = ObjectPropertyUtils.getPropertyValue(component, propertyPath);
            if (propValue == null || !this.getComponentTypeToReplace().isAssignableFrom(propValue.getClass())) continue;
            this.performConversion(component, propertyPath, idSuffix++);
        }
        for (Component nestedComponent : component.getComponentsForLifecycle()) {
            this.convertToReplacement(nestedComponent, idSuffix);
        }
    }

    protected void performConversion(Component component, String componentProperty, int idSuffix) {
        Component componentReplacement = ComponentUtils.copy(this.getComponentReplacementPrototype(), Integer.toString(idSuffix));
        ObjectPropertyUtils.setPropertyValue(component, componentProperty, componentReplacement);
    }

    @Override
    public Set<Class<? extends Component>> getSupportedComponents() {
        HashSet<Class<? extends Component>> components = new HashSet<Class<? extends Component>>();
        components.add(Component.class);
        return components;
    }

    @Override
    public List<Component> getComponentPrototypes() {
        ArrayList<Component> components = new ArrayList<Component>();
        components.add(this.componentReplacementPrototype);
        return components;
    }

    public Class<? extends Component> getComponentTypeToReplace() {
        return this.componentTypeToReplace;
    }

    public void setComponentTypeToReplace(Class<? extends Component> componentTypeToReplace) {
        this.componentTypeToReplace = componentTypeToReplace;
    }

    public Component getComponentReplacementPrototype() {
        return this.componentReplacementPrototype;
    }

    public void setComponentReplacementPrototype(Component componentReplacementPrototype) {
        this.componentReplacementPrototype = componentReplacementPrototype;
    }
}

