/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.workflow.service.impl;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.StopWatch;
import org.apache.log4j.Logger;
import org.kuali.kfs.krad.bo.AdHocRoutePerson;
import org.kuali.kfs.krad.bo.AdHocRouteRecipient;
import org.kuali.kfs.krad.bo.AdHocRouteWorkgroup;
import org.kuali.kfs.krad.exception.UnknownDocumentIdException;
import org.kuali.kfs.krad.service.KRADServiceLocator;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.workflow.service.WorkflowDocumentService;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.action.ActionRequestType;
import org.kuali.rice.kew.api.action.ActionType;
import org.kuali.rice.kew.api.document.node.RouteNodeInstance;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class WorkflowDocumentServiceImpl
implements WorkflowDocumentService {
    private static Logger LOG = Logger.getLogger(WorkflowDocumentServiceImpl.class);

    @Override
    public boolean workflowDocumentExists(String documentId) {
        boolean exists = false;
        if (StringUtils.isBlank((String)documentId)) {
            throw new IllegalArgumentException("invalid (blank) documentId");
        }
        exists = KewApiServiceLocator.getWorkflowDocumentService().doesDocumentExist(documentId);
        return exists;
    }

    @Override
    public WorkflowDocument createWorkflowDocument(String documentTypeName, Person person) {
        String watchName = "createWorkflowDocument";
        StopWatch watch = new StopWatch();
        watch.start();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(watchName + ": started"));
        }
        if (StringUtils.isBlank((String)documentTypeName)) {
            throw new IllegalArgumentException("invalid (blank) documentTypeName");
        }
        if (person == null) {
            throw new IllegalArgumentException("invalid (null) person");
        }
        if (StringUtils.isBlank((String)person.getPrincipalName())) {
            throw new IllegalArgumentException("invalid (empty) PrincipalName");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("creating workflowDoc(" + documentTypeName + "," + person.getPrincipalName() + ")"));
        }
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)person.getPrincipalId(), (String)documentTypeName);
        watch.stop();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(watchName + ": " + watch.toString()));
        }
        return document;
    }

    @Override
    public WorkflowDocument loadWorkflowDocument(String documentId, Person user) {
        if (documentId == null) {
            throw new IllegalArgumentException("invalid (null) documentHeaderId");
        }
        if (user == null) {
            throw new IllegalArgumentException("invalid (null) workflowUser");
        }
        if (StringUtils.isEmpty((String)user.getPrincipalName())) {
            throw new IllegalArgumentException("invalid (empty) workflowUser");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("retrieving document(" + documentId + "," + user.getPrincipalName() + ")"));
        }
        try {
            return WorkflowDocumentFactory.loadDocument((String)user.getPrincipalId(), (String)documentId);
        }
        catch (IllegalArgumentException e) {
            throw new UnknownDocumentIdException("unable to locate document with documentHeaderId '" + documentId + "'");
        }
    }

    @Override
    public void acknowledge(WorkflowDocument workflowDocument, String annotation, List<AdHocRouteRecipient> adHocRecipients) throws WorkflowException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("acknowleding document(" + workflowDocument.getDocumentId() + ",'" + annotation + "')"));
        }
        this.handleAdHocRouteRequests(workflowDocument, annotation, this.filterAdHocRecipients(adHocRecipients, new String[]{"K", "F"}));
        workflowDocument.acknowledge(annotation);
    }

    @Override
    public void approve(WorkflowDocument workflowDocument, String annotation, List<AdHocRouteRecipient> adHocRecipients) throws WorkflowException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("approving document(" + workflowDocument.getDocumentId() + ",'" + annotation + "')"));
        }
        this.handleAdHocRouteRequests(workflowDocument, annotation, this.filterAdHocRecipients(adHocRecipients, new String[]{"K", "F", "A"}));
        workflowDocument.approve(annotation);
    }

    @Override
    public void superUserApprove(WorkflowDocument workflowDocument, String annotation) throws WorkflowException {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("super user approve document(" + workflowDocument.getDocumentId() + ",'" + annotation + "')"));
        }
        workflowDocument.superUserBlanketApprove(annotation);
    }

    @Override
    public void superUserCancel(WorkflowDocument workflowDocument, String annotation) throws WorkflowException {
        LOG.info((Object)("super user cancel document(" + workflowDocument.getDocumentId() + ",'" + annotation + "')"));
        workflowDocument.superUserCancel(annotation);
    }

    @Override
    public void superUserDisapprove(WorkflowDocument workflowDocument, String annotation) throws WorkflowException {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("super user disapprove document(" + workflowDocument.getDocumentId() + ",'" + annotation + "')"));
        }
        workflowDocument.superUserDisapprove(annotation);
    }

    @Override
    public void blanketApprove(WorkflowDocument workflowDocument, String annotation, List<AdHocRouteRecipient> adHocRecipients) throws WorkflowException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("blanket approving document(" + workflowDocument.getDocumentId() + ",'" + annotation + "')"));
        }
        this.handleAdHocRouteRequests(workflowDocument, annotation, this.filterAdHocRecipients(adHocRecipients, new String[]{"K", "F"}));
        workflowDocument.blanketApprove(annotation);
    }

    @Override
    public void cancel(WorkflowDocument workflowDocument, String annotation) throws WorkflowException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("canceling document(" + workflowDocument.getDocumentId() + ",'" + annotation + "')"));
        }
        workflowDocument.cancel(annotation);
    }

    @Override
    public void recall(WorkflowDocument workflowDocument, String annotation, boolean cancel) throws WorkflowException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("recalling document(" + workflowDocument.getDocumentId() + ",'" + annotation + "', '" + cancel + "')"));
        }
        workflowDocument.recall(annotation, cancel);
    }

    @Override
    public void clearFyi(WorkflowDocument workflowDocument, List<AdHocRouteRecipient> adHocRecipients) throws WorkflowException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("clearing FYI for document(" + workflowDocument.getDocumentId() + ")"));
        }
        this.handleAdHocRouteRequests(workflowDocument, "", this.filterAdHocRecipients(adHocRecipients, new String[]{"F"}));
        workflowDocument.fyi();
    }

    @Override
    public void sendWorkflowNotification(WorkflowDocument workflowDocument, String annotation, List<AdHocRouteRecipient> adHocRecipients) throws WorkflowException {
        this.sendWorkflowNotification(workflowDocument, annotation, adHocRecipients, null);
    }

    @Override
    public void sendWorkflowNotification(WorkflowDocument workflowDocument, String annotation, List<AdHocRouteRecipient> adHocRecipients, String notificationLabel) throws WorkflowException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("sending FYI for document(" + workflowDocument.getDocumentId() + ")"));
        }
        this.handleAdHocRouteRequests(workflowDocument, annotation, adHocRecipients, notificationLabel);
    }

    @Override
    public void disapprove(WorkflowDocument workflowDocument, String annotation) throws WorkflowException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("disapproving document(" + workflowDocument.getDocumentId() + ",'" + annotation + "')"));
        }
        workflowDocument.disapprove(annotation);
    }

    @Override
    public void route(WorkflowDocument workflowDocument, String annotation, List<AdHocRouteRecipient> adHocRecipients) throws WorkflowException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("routing document(" + workflowDocument.getDocumentId() + ",'" + annotation + "')"));
        }
        this.handleAdHocRouteRequests(workflowDocument, annotation, this.filterAdHocRecipients(adHocRecipients, new String[]{"K", "F", "A", "C"}));
        workflowDocument.route(annotation);
    }

    @Override
    public void save(WorkflowDocument workflowDocument, String annotation) throws WorkflowException {
        if (workflowDocument.isValidAction(ActionType.SAVE)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("saving document(" + workflowDocument.getDocumentId() + ",'" + annotation + "')"));
            }
            workflowDocument.saveDocument(annotation);
        } else {
            this.saveRoutingData(workflowDocument);
        }
    }

    @Override
    public void saveRoutingData(WorkflowDocument workflowDocument) throws WorkflowException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("saving document(" + workflowDocument.getDocumentId() + ")"));
        }
        workflowDocument.saveDocumentData();
    }

    @Override
    public String getCurrentRouteLevelName(WorkflowDocument workflowDocument) throws WorkflowException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getting current route level name for document(" + workflowDocument.getDocumentId()));
        }
        WorkflowDocument freshCopyWorkflowDoc = this.loadWorkflowDocument(workflowDocument.getDocumentId(), GlobalVariables.getUserSession().getPerson());
        return this.getCurrentRouteNodeNames(freshCopyWorkflowDoc);
    }

    @Override
    public String getCurrentRouteNodeNames(WorkflowDocument workflowDocument) {
        Set nodeNames = workflowDocument.getNodeNames();
        if (nodeNames.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (String nodeName : nodeNames) {
            builder.append(nodeName).append(", ");
        }
        builder.setLength(builder.length() - 2);
        return builder.toString();
    }

    private void handleAdHocRouteRequests(WorkflowDocument workflowDocument, String annotation, List<AdHocRouteRecipient> adHocRecipients) throws WorkflowException {
        this.handleAdHocRouteRequests(workflowDocument, annotation, adHocRecipients, null);
    }

    private void handleAdHocRouteRequests(WorkflowDocument workflowDocument, String annotation, List<AdHocRouteRecipient> adHocRecipients, String notificationLabel) throws WorkflowException {
        if (adHocRecipients != null && adHocRecipients.size() > 0) {
            String currentNode = null;
            HashSet<String> currentNodes = workflowDocument.getNodeNames();
            if (currentNodes.isEmpty()) {
                List nodes = KewApiServiceLocator.getWorkflowDocumentService().getTerminalRouteNodeInstances(workflowDocument.getDocumentId());
                currentNodes = new HashSet<String>();
                for (RouteNodeInstance node : nodes) {
                    currentNodes.add(node.getName());
                }
            }
            currentNode = (String)currentNodes.iterator().next();
            ArrayList<AdHocRoutePerson> adHocRoutePersons = new ArrayList<AdHocRoutePerson>();
            ArrayList<AdHocRouteWorkgroup> adHocRouteWorkgroups = new ArrayList<AdHocRouteWorkgroup>();
            for (AdHocRouteRecipient recipient : adHocRecipients) {
                if (!StringUtils.isNotEmpty((String)recipient.getId())) continue;
                String newAnnotation = annotation;
                if (StringUtils.isBlank((String)annotation)) {
                    try {
                        String message = KRADServiceLocator.getKualiConfigurationService().getPropertyValueAsString("message.adhoc.annotation");
                        newAnnotation = MessageFormat.format(message, GlobalVariables.getUserSession().getPrincipalName());
                    }
                    catch (Exception ex) {
                        LOG.warn((Object)"Unable to set annotation", (Throwable)ex);
                    }
                }
                if (AdHocRouteRecipient.PERSON_TYPE.equals(recipient.getType())) {
                    Principal principal = KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName(recipient.getId());
                    if (principal == null) {
                        throw new RiceRuntimeException("Could not locate principal with name '" + recipient.getId() + "'");
                    }
                    workflowDocument.adHocToPrincipal(ActionRequestType.fromCode((String)recipient.getActionRequested()), currentNode, newAnnotation, principal.getPrincipalId(), "", true, notificationLabel);
                    AdHocRoutePerson personRecipient = (AdHocRoutePerson)recipient;
                    adHocRoutePersons.add(personRecipient);
                    continue;
                }
                Group group = KimApiServiceLocator.getGroupService().getGroup(recipient.getId());
                if (group == null) {
                    throw new RiceRuntimeException("Could not locate group with id '" + recipient.getId() + "'");
                }
                workflowDocument.adHocToGroup(ActionRequestType.fromCode((String)recipient.getActionRequested()), currentNode, newAnnotation, group.getId(), "", true, notificationLabel);
                AdHocRouteWorkgroup groupRecipient = (AdHocRouteWorkgroup)recipient;
                adHocRouteWorkgroups.add(groupRecipient);
            }
            KRADServiceLocator.getBusinessObjectService().delete(adHocRoutePersons);
            KRADServiceLocator.getBusinessObjectService().delete(adHocRouteWorkgroups);
        }
    }

    private List<AdHocRouteRecipient> filterAdHocRecipients(List<AdHocRouteRecipient> adHocRecipients, String[] validTypes) {
        ArrayList<AdHocRouteRecipient> realAdHocRecipients = new ArrayList<AdHocRouteRecipient>();
        if (adHocRecipients != null) {
            for (AdHocRouteRecipient proposedRecipient : adHocRecipients) {
                if (!StringUtils.isNotBlank((String)proposedRecipient.getActionRequested())) continue;
                for (int i = 0; i < validTypes.length; ++i) {
                    if (!validTypes[i].equals(proposedRecipient.getActionRequested())) continue;
                    realAdHocRecipients.add(proposedRecipient);
                }
            }
        }
        return realAdHocRecipients;
    }

    @Override
    public void complete(WorkflowDocument workflowDocument, String annotation, List adHocRecipients) throws WorkflowException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("routing flexDoc(" + workflowDocument.getDocumentId() + ",'" + annotation + "')"));
        }
        this.handleAdHocRouteRequests(workflowDocument, annotation, this.filterAdHocRecipients(adHocRecipients, new String[]{"C", "K", "F", "A"}));
        workflowDocument.complete(annotation);
    }
}

