/**
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2018 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.kns.bo.lookup;

import org.kuali.kfs.krad.keyvalues.KeyValuesBase;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.location.api.campus.CampusService;
import org.kuali.rice.location.api.campus.CampusType;
import org.kuali.rice.location.api.services.LocationApiServiceLocator;
import org.kuali.rice.location.framework.campus.CampusTypeComparator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CampusTypeValuesFinder extends KeyValuesBase {

    @Override
    public List<KeyValue> getKeyValues() {

        // get a list of all CampusTypes
        CampusService campusService = LocationApiServiceLocator.getCampusService();
        List<CampusType> campusTypes = campusService.findAllCampusTypes();

        //copy list for sorting (list from service is unmodifiable
        List<CampusType> campusTypeSort = new ArrayList<CampusType>(campusTypes);
        // sort using comparator.
        Collections.sort(campusTypeSort, CampusTypeComparator.INSTANCE);

        // create a new list (code, descriptive-name)
        List<KeyValue> labels = new ArrayList<KeyValue>();

        for (CampusType campusType : campusTypeSort) {
            labels.add(new ConcreteKeyValue(campusType.getCode(), campusType.getCode() + " - " + campusType.getName()));
        }

        return labels;
    }
}
