/**
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2018 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.kns.service;

import org.kuali.kfs.kns.datadictionary.FieldDefinition;
import org.kuali.kfs.kns.inquiry.InquiryAuthorizer;
import org.kuali.kfs.kns.inquiry.InquiryPresentationController;
import org.kuali.kfs.krad.valuefinder.ValueFinder;
import org.kuali.rice.krad.bo.BusinessObject;

import java.util.List;

/**
 * This interface defines the API for the interacting with the data dictionary.
 */
@Deprecated
public interface BusinessObjectDictionaryService {

    <T extends BusinessObject> InquiryPresentationController getInquiryPresentationController(Class<T> businessObjectClass);

    <T extends BusinessObject> InquiryAuthorizer getInquiryAuthorizer(Class<T> businessObjectClass);

    /**
     * @return the list of business object class names being maintained
     */
    List getBusinessObjectClassnames();

    /**
     * @return whether business object has lookup defined
     */
    Boolean isLookupable(Class businessObjectClass);

    /**
     * @return whether business object has inquiry defined
     */
    Boolean isInquirable(Class businessObjectClass);

    /**
     * @return whether business object has maintainable defined
     */
    Boolean isMaintainable(Class businessObjectClass);

    /**
     * @return whether business object has an exporter defined
     */
    Boolean isExportable(Class businessObjectClass);

    /**
     * @return the list defined as lookup fields for the business object.
     */
    List getLookupFieldNames(Class businessObjectClass);

    /**
     * @return the text to be displayed for the title of business object lookup.
     */
    String getLookupTitle(Class businessObjectClass);

    /**
     * @return menu bar html defined for the business object.
     */
    String getLookupMenuBar(Class businessObjectClass);

    /**
     * @return source for optional extra button
     */
    String getExtraButtonSource(Class businessObjectClass);

    /**
     * @return parameters for optional extra button
     */
    String getExtraButtonParams(Class businessObjectClass);

    /**
     * @return the property names of the bo used to sort the initial result set
     */
    List getLookupDefaultSortFieldNames(Class businessObjectClass);

    /**
     * @return the list defined as lookup result fields for the business object.
     */
    List<String> getLookupResultFieldNames(Class businessObjectClass);

    /**
     * This method returns the maximum display length of the value of the given field in the lookup results.  While the
     * actual value may be longer than the specified length, this value specifies the maximum length substring that
     * should be displayed. It is up to the UI layer to interpret the results of the field
     *
     * @param businessObjectClass
     * @param resultFieldName
     * @return the maximum length of the lookup results field that should be displayed.  Returns null if this value has
     *         not been defined.  If negative, denotes that the is maximum length is unlimited.
     */
    Integer getLookupResultFieldMaxLength(Class businessObjectClass, String resultFieldName);

    /**
     * @return boolean indicating whether lookup result field marked to force an inquiry
     */
    Boolean forceLookupResultFieldInquiry(Class businessObjectClass, String attributeName);

    /**
     * @return boolean indicating whether lookup result field marked to not do an inquiry
     */
    Boolean noLookupResultFieldInquiry(Class businessObjectClass, String attributeName);

    /**
     * @return boolean indicating whether lookup search field marked to force a lookup
     */
    Boolean forceLookupFieldLookup(Class businessObjectClass, String attributeName);

    /**
     * @return boolean indicating whether lookup search field marked to force an inquiry
     */
    Boolean forceInquiryFieldLookup(Class businessObjectClass, String attributeName);

    /**
     * @return boolean indicating whether lookup search field marked to not do a lookup
     */
    Boolean noLookupFieldLookup(Class businessObjectClass, String attributeName);

    /**
     * @return boolean indicating whether lookup search field marked to not do a direct inquiry
     */
    Boolean noDirectInquiryFieldLookup(Class businessObjectClass, String attributeName);

    /**
     * @return boolean indicating whether inquiry result field marked to force an inquiry
     */
    Boolean forceInquiryFieldInquiry(Class businessObjectClass, String attributeName);

    /**
     * @return boolean indicating whether inquiry result field marked to not do an inquiry
     */
    Boolean noInquiryFieldInquiry(Class businessObjectClass, String attributeName);

    /**
     * @return boolean indicating whether lookup result field to use shortLabel
     */
    Boolean getLookupResultFieldUseShortLabel(Class businessObjectClass, String attributeName);

    /**
     * @return boolean indicating whether lookup result field should be totaled
     */
    Boolean getLookupResultFieldTotal(Class businessObjectClass, String attributeName);

    /**
     * @return String indicating the default search value for the lookup field
     */
    String getLookupFieldDefaultValue(Class businessObjectClass, String attributeName);

    /**
     * @return Class used to generate a lookup field default value
     */
    Class getLookupFieldDefaultValueFinderClass(Class businessObjectClass, String attributeName);

    /**
     * @return String indicating the default search value for the lookup field.
     * @see FieldDefinition#getQuickfinderParameterString()
     */
    String getLookupFieldQuickfinderParameterString(Class businessObjectClass, String attributeName);

    /**
     * @return Class used to generate quickfinder lookup field default values.
     * @see FieldDefinition#getQuickfinderParameterStringBuilderClass()
     */
    Class<? extends ValueFinder> getLookupFieldQuickfinderParameterStringBuilderClass(Class businessObjectClass,
            String attributeName);

    /**
     * @return String indicating the result set limit for the lookup
     */
    Integer getLookupResultSetLimit(Class businessObjectClass);

    /**
     * @return Integer indicating the result set limit for a multiple values lookup
     */
    Integer getMultipleValueLookupResultSetLimit(Class businessObjectClass);

    /**
     * @return number of search columns configured for the lookup associated with the class
     */
    Integer getLookupNumberOfColumns(Class businessObjectClass);

    /**
     * @return String indicating the location of the lookup icon.
     */
    String getSearchIconOverride(Class businessObjectClass);

    /**
     * @return whether a field is required for a lookup
     */
    Boolean getLookupAttributeRequired(Class businessObjectClass, String attributeName);

    /**
     * @return whether a field is read only for a lookup
     */
    Boolean getLookupAttributeReadOnly(Class businessObjectClass, String attributeName);

    /**
     * @return the list defined as inquiry fields for the business object and inquiry section.
     */
    List getInquiryFieldNames(Class businessObjectClass, String sectionTitle);

    /**
     * @return the list defined as inquiry sections for the business object.
     */
    List getInquirySections(Class businessObjectClass);

    /**
     * @return the text to be displayed for the title of business object inquiry.
     */
    String getInquiryTitle(Class businessObjectClass);

    /**
     * @return the class to be used for building inquiry pages.
     */
    Class getInquirableClass(Class businessObjectClass);

    /**
     * @return the text to be displayed for the title of business object maintenance document.
     */
    String getMaintainableLabel(Class businessObjectClass);

    /**
     * @return the attribute to be associated with for object level markings
     */
    String getTitleAttribute(Class businessObjectClass);

    /**
     * @return the Lookupable implementation id for the associated Lookup, if one has been specified
     */
    String getLookupableID(Class businessObjectClass);

    /**
     * This method takes any business object and recursively walks through it checking to see if any attributes need to
     * be forced to uppercase based on settings in the data dictionary
     *
     * @param bo
     */
    void performForceUppercase(BusinessObject bo);

    /**
     * @param businessObjectClass
     * @param attributeName
     * @return whether on a lookup, field/attribute values with wildcards and operators should treat them as literal
     *         characters
     */
    boolean isLookupFieldTreatWildcardsAndOperatorsAsLiteral(Class businessObjectClass, String attributeName);

    /**
     * @return String giving alternate display attribute name for lookup field if configured, or null
     */
    String getLookupFieldAlternateDisplayAttributeName(Class businessObjectClass, String attributeName);

    /**
     * @return String giving alternate display attribute name for inquiry field if configured, or null
     */
    String getInquiryFieldAlternateDisplayAttributeName(Class businessObjectClass, String attributeName);

    /**
     * @return String giving additional display attribute name for lookup field if configured, or null
     */
    String getLookupFieldAdditionalDisplayAttributeName(Class businessObjectClass, String attributeName);

    /**
     * @return String giving additional display attribute name for inquiry field if configured, or null
     */
    String getInquiryFieldAdditionalDisplayAttributeName(Class businessObjectClass, String attributeName);

    /**
     * @param businessObjectClass business object class for lookup definition
     * @return Boolean indicating whether translating of codes is configured to true in lookup definition
     */
    Boolean tranlateCodesInLookup(Class businessObjectClass);

    /**
     * @param businessObjectClass business object class for inquiry definition
     * @return Boolean indicating whether translating of codes is configured to true in inquiry definition
     */
    Boolean tranlateCodesInInquiry(Class businessObjectClass);

    /**
     * Indicates whether a lookup field has been configured to trigger on value change
     *
     * @param businessObjectClass Class for business object to lookup
     * @param attributeName       name of attribute in the business object to check configuration for
     * @return true if field is configured to trigger on value change, false if not
     */
    boolean isLookupFieldTriggerOnChange(Class businessObjectClass, String attributeName);

    /**
     * Indicates whether the search and clear buttons should be disabled based on the data dictionary configuration
     *
     * @param businessObjectClass business object class for lookup definition
     * @return Boolean indicating whether disable search buttons is configured to true in lookup
     * definition
     */
    boolean disableSearchButtonsInLookup(Class businessObjectClass);

}
