/**
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2018 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.kns.service;

import org.kuali.kfs.kns.datadictionary.MaintainableCollectionDefinition;
import org.kuali.kfs.kns.datadictionary.MaintainableFieldDefinition;
import org.kuali.kfs.kns.datadictionary.MaintainableItemDefinition;
import org.kuali.kfs.kns.datadictionary.MaintainableSectionDefinition;
import org.kuali.kfs.kns.datadictionary.MaintenanceDocumentEntry;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;

import java.util.Collection;
import java.util.List;

/**
 * Defines methods that a MaintenanceDocumentDictionary Service must provide. Defines the API for the interacting
 * with Document-related entries in the data dictionary.
 */
@Deprecated
public interface MaintenanceDocumentDictionaryService {

    /**
     * @param docTypeName - doc type to retrieve label for
     * @return String doc type label for the maintenance document type
     */
    String getMaintenanceLabel(String docTypeName);

    /**
     * @param dataObjectClass
     * @return The document type name for the class as a String.
     */
    String getDocumentTypeName(Class dataObjectClass);

    /**
     * @param docTypeName
     * @return The description of the maintenance document as a String.
     */
    String getMaintenanceDescription(String docTypeName);

    /**
     * @param dataObjectClass
     * @return A Collection of ReferenceDefinitions defined as DefaultExistenceChecks for the MaintenanceDocument
     */
    Collection getDefaultExistenceChecks(Class dataObjectClass);

    /**
     * @param docTypeName
     * @return A Collection of ReferenceDefinitions defined as DefaultExistenceChecks for the MaintenanceDocument
     */
    Collection getDefaultExistenceChecks(String docTypeName);

    /**
     * @param docTypeName
     * @return A List of String field names used as locking keys
     */
    List getLockingKeys(String docTypeName);

    /**
     * @param docTypeName
     * @return The class instance associated with the document type name.
     */
    Class getDataObjectClass(String docTypeName);

    /**
     * Returns whether or not this document's data dictionary file has flagged it to allow document copies
     *
     * @param document maintenance document instance to check copy flag for
     * @return boolean true if copies are allowed, false otherwise
     */
    Boolean getAllowsCopy(MaintenanceDocument document);

    /**
     * Returns whether or not this document's data dictionary file has flagged it to allow maintenance new
     * or copy actions
     *
     * @param docTypeName maintenance document instance to check new or copy flag for
     * @return boolean true if new or copy maintenance actions are allowed
     */
    Boolean getAllowsNewOrCopy(String docTypeName);

    MaintenanceDocumentEntry getMaintenanceDocumentEntry(String docTypeName);

    /**
     * Indicates whether the configured locking keys for a class should be cleared on a maintenance copy action or
     * values carried forward
     *
     * @param dataObjectClass class for the data object to check
     * @return boolean true if locking keys should be copied, false if they should be cleared
     */
    boolean getPreserveLockingKeysOnCopy(Class dataObjectClass);

    /**
     * Indicates whether the given data object class is configured to allow record deletions
     *
     * @param dataObjectClass class for the data object to check
     * @return Boolean true if record deletion is allowed, false if not allowed, null if not configured
     */
    Boolean getAllowsRecordDeletion(Class dataObjectClass);

    /**
     * Indicates whether the given maintenance document is configured to allow record deletions
     *
     * @param document maintenance document instance to check
     * @return Boolean true if record deletion is allowed, false if not allowed, null if not configured
     */
    Boolean getAllowsRecordDeletion(MaintenanceDocument document);

    /**
     * Retrieves an instance of the class that represents the maintenance document. This is done by
     *
     * @param docTypeName
     * @return A class instance.
     */
    Class getMaintainableClass(String docTypeName);

    /**
     * @param docTypeName
     * @return A List of maintainable section object instances corresponding to the document type name.
     */
    @Deprecated
    List<MaintainableSectionDefinition> getMaintainableSections(String docTypeName);

    /**
     * This method returns the defaultValue as it would appear in the UI on a maintenance document.
     * <p>
     * If both a defaultValue and a defaultValueFinderClass is present in the MaintainableFieldDefinition instance, then
     * the defaultValue will be preferentially returned. If only one is present, then that will be returned.
     * <p>
     * Note that if a defaultValueFinderClass value is present, then this method will attempt to create a new instance
     * of the specified class. If this attempt to generate a new instance fails, the error will be suppressed, and a
     * null result will be returned.
     *
     * @param boClass   the class of BO being maintained
     * @param fieldName the fieldName of the attribute for which the default is desired
     * @return the default if one is available, null otherwise
     */
    @Deprecated
    String getFieldDefaultValue(Class boClass, String fieldName);

    /**
     * This method returns the defaultValue as it would appear in the UI on a maintenance document.
     * <p>
     * If both a defaultValue and a defaultValueFinderClass is present in the MaintainableFieldDefinition instance, then
     * the defaultValue will be preferentially returned. If only one is present, then that will be returned.
     * <p>
     * Note that if a defaultValueFinderClass value is present, then this method will attempt to create a new instance
     * of the specified class. If this attempt to generate a new instance fails, the error will be suppressed, and a
     * null result will be returned.
     *
     * @param docTypeName the document type name of the maintainable
     * @param fieldName   the fieldName of the attribute for which the default is desired
     * @return the default if one is available, null otherwise
     */
    @Deprecated
    String getFieldDefaultValue(String docTypeName, String fieldName);

    /**
     * This method returns the defaultValue as it would appear in the UI on a maintenance document for a collection.
     * <p>
     * If both a defaultValue and a defaultValueFinderClass is present in the MaintainableFieldDefinition instance, then
     * the defaultValue will be preferentially returned. If only one is present, then that will be returned.
     * <p>
     * Note that if a defaultValueFinderClass value is present, then this method will attempt to create a new instance
     * of the specified class. If this attempt to generate a new instance fails, the error will be suppressed, and a
     * null result will be returned.
     *
     * @param docTypeName    the document type name of the maintainable
     * @param collectionName the name attribute of the collection to which the field belongs
     * @param fieldName      the fieldName of the attribute for which the default is desired
     * @return the default if one is available, null otherwise
     */
    @Deprecated
    String getCollectionFieldDefaultValue(String docTypeName, String collectionName, String fieldName);

    /**
     * @param docTypeName
     * @param collectionName
     * @return the business object used to store the values for the given collection.
     */
    @Deprecated
    Class getCollectionBusinessObjectClass(String docTypeName, String collectionName);

    /**
     * Returns the definition for the maintainable item identified by "itemName".
     *
     * @param docTypeName
     * @param itemName
     * @return The item or <b>null</b> if the item does not exist.
     */
    @Deprecated
    MaintainableItemDefinition getMaintainableItem(String docTypeName, String itemName);

    /**
     * Returns the definition for the maintainable field identified by "fieldName".
     *
     * @param docTypeName
     * @param fieldName
     * @return The field or <b>null</b> if the item does not exist or is not a field.
     */
    @Deprecated
    MaintainableFieldDefinition getMaintainableField(String docTypeName, String fieldName);

    /**
     * Returns the definition for the maintainable collection identified by "collectionName".
     *
     * @param docTypeName
     * @param collectionName
     * @return The collection or <b>null</b> if the item does not exist or is not a collection.
     */
    @Deprecated
    MaintainableCollectionDefinition getMaintainableCollection(String docTypeName, String collectionName);

    /**
     * @param docTypeName
     * @return a List of all top-level maintainable collections on the document
     */
    @Deprecated
    List<MaintainableCollectionDefinition> getMaintainableCollections(String docTypeName);

    /**
     * @param parentCollection
     * @return a List of all collections within the given collection
     */
    @Deprecated
    List<MaintainableCollectionDefinition> getMaintainableCollections(MaintainableCollectionDefinition parentCollection);

    /**
     * Validates the maintenance document contains values for the fields declared as required in the maintenance
     * document data dictionary file.
     *
     * @param document
     */
    @Deprecated
    void validateMaintenanceRequiredFields(MaintenanceDocument document);

    /**
     * validates the collections of the maintenance document checking to see if duplicate entries in the collection exist
     *
     * @param document
     */
    void validateMaintainableCollectionsForDuplicateEntries(MaintenanceDocument document);

    @Deprecated
    void validateMaintainableCollectionsAddLineRequiredFields(MaintenanceDocument document,
            PersistableBusinessObject businessObject, String collectionName);

    /**
     * @param businessObjectClass - business object class for maintenance definition
     * @return Boolean indicating whether translating of codes is configured to true in maintenance definition
     */
    @Deprecated
    Boolean translateCodes(Class businessObjectClass);

}
