/**
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2018 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.krad.datadictionary.control;

import org.kuali.kfs.krad.datadictionary.DataDictionaryDefinition;

@Deprecated
public interface ControlDefinition extends DataDictionaryDefinition {

    boolean isDatePicker();

    void setDatePicker(boolean datePicker);

    boolean isExpandedTextArea();

    void setExpandedTextArea(boolean eTextArea);

    /**
     * @return true if this ControlDefinition instance represents an HTML checkbox control
     */
    boolean isCheckbox();

    /**
     * @return true if this ControlDefinition instance represents an HTML hidden control
     */
    boolean isHidden();

    /**
     * @return true if this ControlDefinition instance represents an HTML radiobutton control
     */
    boolean isRadio();

    /**
     * @return true if this ControlDefinition instance represents an HTML select control
     */
    boolean isSelect();

    /**
     * @return true if this ControlDefinition instance represents an HTML select control
     */
    boolean isMultiselect();

    /**
     * @return true if this ControlDefinition instance represents an HTML text control
     */
    boolean isText();

    /**
     * @return true if this ControlDefinition instance represents an HTML textarea control
     */
    boolean isTextarea();

    /**
     * @return any Script associated with this control
     */
    String getScript();

    /**
     * @return true if the ControlDefinition instance represents a currency control
     */
    boolean isCurrency();

    /**
     * @return true if the ControlDefinition instance represents a kualiUser control
     */
    boolean isKualiUser();

    /**
     * @return true if the ControlDefinition instance represents a workflow workgroup control
     */
    boolean isWorkflowWorkgroup();

    /**
     * @return true if this ControlDefinition instance represents an HTML File control
     */
    boolean isFile();

    /**
     * @return true if the ControlDefinition instance represents a lookupHidden control
     */
    boolean isLookupHidden();

    /**
     * @return true if the ControlDefinition instance represents a lookupReadonly control
     */
    boolean isLookupReadonly();

    /**
     * @return true if the ControlDefinition instance represents a button control
     */
    boolean isButton();

    /**
     * @return true if the ControlDefinition instance represents a link control
     */
    boolean isLink();

    /**
     * @return true if the ControlDefinition instance represents a ranged (will render from and to fields) date control
     */
    boolean isRanged();

    boolean isTitleLinkedText();

    /**
     * Sets the Class used to retrieve the complete range of values for radiobutton and select controls.
     *
     * @param valuesFinderClass
     */
    void setValuesFinderClass(String valuesFinderClass);

    /**
     * Sets the BO Class used for the KeyLabelBusinessObjectValueFinder to retrieve the complete range of values for
     * radiobutton and select controls.
     *
     * @param businessObjectClass
     */
    void setBusinessObjectClass(String businessObjectClass);

    /**
     * Sets the keyAttribute used for building radiobutton and select controls.
     *
     * @param keyAttribute
     */
    void setKeyAttribute(String keyAttribute);

    /**
     * Sets the labelAttribute used for building radiobutton and select controls.
     *
     * @param labelAttribute
     */
    void setLabelAttribute(String labelAttribute);

    void setIncludeBlankRow(Boolean includeBlankRow);

    /**
     * @param includeKeyInLabel whether to include the key with the label to be displayed or not.
     */
    void setIncludeKeyInLabel(Boolean includeKeyInLabel);

    /**
     * Sets the Script
     *
     * @param script
     */
    void setScript(String script);

    /**
     * @return Class used to retrieve the complete range of values for radiobutton and select controls.
     */
    String getValuesFinderClass();

    /**
     * @return BO Class used for the KeyLabelBusinessObjectValueFinder to retrieve the complete range of values for
     * radiobutton and select controls.
     */
    String getBusinessObjectClass();

    /**
     * @return the keyAttribute used for radiobutton and select controls.
     */
    String getKeyAttribute();

    /**
     * @return the labelAttribute used for radiobutton and select controls.
     */
    String getLabelAttribute();

    Boolean getIncludeBlankRow();

    /**
     * @return the flag that indicates if the labels the ValuesFinder class returns should include the key.
     */
    Boolean getIncludeKeyInLabel();

    /**
     * Sets the size parameter for text controls.
     *
     * @param size
     */
    void setSize(Integer size);

    /**
     * @return size parameters for text controls
     */
    Integer getSize();

    /**
     * Sets the rows parameter for textarea controls.
     *
     * @param rows
     */
    void setRows(Integer rows);

    /**
     * @return rows parameters for textarea controls
     */
    Integer getRows();

    /**
     * Sets the cols parameter for textarea controls.
     *
     * @param cols
     */
    void setCols(Integer cols);

    /**
     * @return cols parameter for textarea controls.
     */
    Integer getCols();

}
