/**
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2018 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.krad.document;

/**
 * Determines what actions are applicable to the given document, irrespective of user or other state.  These initial
 * actions are used as inputs for further filtering depending on context.
 *
 * @see DocumentAuthorizer
 */
public interface DocumentPresentationController {

    boolean canInitiate(String documentTypeName);

    boolean canEdit(Document document);

    boolean canAnnotate(Document document);

    boolean canReload(Document document);

    boolean canClose(Document document);

    boolean canSave(Document document);

    boolean canRoute(Document document);

    boolean canCancel(Document document);

    boolean canCopy(Document document);

    boolean canPerformRouteReport(Document document);

    boolean canAddAdhocRequests(Document document);

    boolean canBlanketApprove(Document document);

    boolean canApprove(Document document);

    boolean canDisapprove(Document document);

    boolean canSendAdhocRequests(Document document);

    boolean canSendNoteFyi(Document document);

    boolean canEditDocumentOverview(Document document);

    boolean canFyi(Document document);

    boolean canAcknowledge(Document document);

    boolean canComplete(Document document);

    /**
     * @since 2.1
     */
    boolean canRecall(Document document);
}
