/**
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2018 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.krad.maintenance;

import org.kuali.kfs.krad.document.Document;

/**
 * Common interface for all maintenance documents.
 */
public interface MaintenanceDocument extends Document {

    /**
     * @return String containing the xml representation of the maintenance document
     */
    String getXmlDocumentContents();

    /**
     * @return Maintainable which holds the new maintenance record
     */
    Maintainable getNewMaintainableObject();

    /**
     * @return Maintainable which holds the old maintenance record
     */
    Maintainable getOldMaintainableObject();

    /**
     * @param documentContents xml contents of the maintenance document to set.
     */
    void setXmlDocumentContents(String documentContents);

    /**
     * @param newMaintainableObject Initializes the new maintainable
     */
    void setNewMaintainableObject(Maintainable newMaintainableObject);

    /**
     * @param oldMaintainableObject Initializes the old maintainable
     */
    void setOldMaintainableObject(Maintainable oldMaintainableObject);

    /**
     * Returns a reference to the data object that this MaintenanceDocument is maintaining
     */
    Object getDocumentDataObject();

    /**
     * Builds the xml document string from the contents of the old and new maintainables.
     */
    void populateXmlDocumentContentsFromMaintainables();

    /**
     * Populates the old and new maintainables from the xml document contents string.
     */
    void populateMaintainablesFromXmlDocumentContents();

    /**
     * @return boolean indicates whether this is an edit or new maintenace document by the existence of an old
     *         maintainable
     */
    boolean isOldDataObjectInDocument();

    /**
     * @return true if this maintenance document is creating a new Business Object, false if its an edit.
     */
    boolean isNew();

    /**
     * @return true if this maintenance document is editing an existing Business Object, false if its creating a new one.
     */
    boolean isEdit();

    /**
     * @return true if this maintenance document is creating a new Business Object out of an existing Business Object,
     *         for example, a new division vendor out of an existing parent vendor.
     */
    boolean isNewWithExisting();

    /**
     * A flag which indicates whether the primary keys have been cleared on a Copy-type of document. This will be true
     * if the 'clear keys on a copy' has been done, and it will be false if not.
     *
     * @return true if the primary keys have been cleared already, false if not.
     */
    boolean isFieldsClearedOnCopy();

    /**
     * @param keysClearedOnCopy true or false
     */
    void setFieldsClearedOnCopy(boolean keysClearedOnCopy);

    /**
     * @return
     */
    boolean getDisplayTopicFieldInNotes();

    void setDisplayTopicFieldInNotes(boolean displayTopicFieldInNotes);

}
