/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.coreservice.impl.service;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.coreservice.api.CoreServiceApiServiceLocator;
import org.kuali.kfs.coreservice.api.component.Component;
import org.kuali.kfs.coreservice.api.component.ComponentService;
import org.kuali.kfs.coreservice.api.namespace.Namespace;
import org.kuali.kfs.coreservice.api.namespace.NamespaceService;
import org.kuali.kfs.coreservice.api.parameter.Parameter;
import org.kuali.kfs.coreservice.api.parameter.ParameterKey;
import org.kuali.kfs.coreservice.api.parameter.ParameterQueryResults;
import org.kuali.kfs.coreservice.api.parameter.ParameterRepositoryService;
import org.kuali.kfs.coreservice.framework.component.ComponentEbo;
import org.kuali.kfs.coreservice.framework.namespace.NamespaceEbo;
import org.kuali.kfs.coreservice.framework.parameter.ParameterEbo;
import org.kuali.kfs.coreservice.framework.parameter.ParameterTypeEbo;
import org.kuali.kfs.coreservice.impl.component.ComponentBo;
import org.kuali.kfs.coreservice.impl.namespace.NamespaceBo;
import org.kuali.kfs.coreservice.impl.parameter.ParameterBo;
import org.kuali.kfs.coreservice.impl.parameter.ParameterTypeBo;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.KRADServiceLocator;
import org.kuali.kfs.krad.service.impl.RemoteModuleServiceBase;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.krad.bo.ExternalizableBusinessObject;

public class CoreServiceRemoteModuleService
extends RemoteModuleServiceBase {
    private static final Logger LOG = Logger.getLogger(CoreServiceRemoteModuleService.class);
    private static final String CODE = "code";
    private static final String NAMESPACE_CODE = "namespaceCode";
    private static final String COMPONENT_CODE = "componentCode";
    private static final String NAME = "name";
    private static final String APPLICATION_ID = "applicationId";

    @Override
    public <T extends ExternalizableBusinessObject> T getExternalizableBusinessObject(Class<T> businessObjectClass, Map<String, Object> fieldValues) {
        PersistableBusinessObjectBase result = null;
        if (NamespaceEbo.class.isAssignableFrom(businessObjectClass) && CoreServiceRemoteModuleService.isNonBlankValueForKey(fieldValues, CODE)) {
            Namespace namespace = this.getNamespaceService().getNamespace((String)fieldValues.get(CODE));
            result = NamespaceBo.from(namespace);
        }
        if (ParameterEbo.class.isAssignableFrom(businessObjectClass) && CoreServiceRemoteModuleService.isNonBlankValueForKey(fieldValues, APPLICATION_ID) && CoreServiceRemoteModuleService.isNonBlankValueForKey(fieldValues, NAMESPACE_CODE) && CoreServiceRemoteModuleService.isNonBlankValueForKey(fieldValues, COMPONENT_CODE) && CoreServiceRemoteModuleService.isNonBlankValueForKey(fieldValues, NAME)) {
            ParameterKey key = ParameterKey.create((String)fieldValues.get(APPLICATION_ID), (String)fieldValues.get(NAMESPACE_CODE), (String)fieldValues.get(COMPONENT_CODE), (String)fieldValues.get(NAME));
            Parameter parameter = this.getParameterRepositoryService().getParameter(key);
            result = ParameterBo.from(parameter);
        }
        if (ComponentEbo.class.isAssignableFrom(businessObjectClass) && CoreServiceRemoteModuleService.isNonBlankValueForKey(fieldValues, CODE) && CoreServiceRemoteModuleService.isNonBlankValueForKey(fieldValues, NAMESPACE_CODE)) {
            Component component = this.getComponentService().getComponentByCode((String)fieldValues.get(NAMESPACE_CODE), (String)fieldValues.get(CODE));
            result = ComponentBo.from(component);
        }
        if (ParameterTypeEbo.class.isAssignableFrom(businessObjectClass) && CoreServiceRemoteModuleService.isNonBlankValueForKey(fieldValues, CODE)) {
            ParameterTypeBo parameterType = this.getBusinessObjectService().findBySinglePrimaryKey(ParameterTypeBo.class, (String)fieldValues.get(CODE));
            result = parameterType;
        }
        return (T)result;
    }

    @Override
    public <T extends ExternalizableBusinessObject> List<T> getExternalizableBusinessObjectsList(Class<T> businessObjectClass, Map<String, Object> fieldValues) {
        if (NamespaceEbo.class.isAssignableFrom(businessObjectClass)) {
            List<Namespace> namespaces = this.getNamespaceService().findAllNamespaces();
            ArrayList<NamespaceBo> results = new ArrayList<NamespaceBo>(namespaces.size());
            for (Namespace namespace : namespaces) {
                NamespaceBo namespaceBo = NamespaceBo.from(namespace);
                boolean fieldsMatch = true;
                for (Map.Entry<String, Object> fieldValue : fieldValues.entrySet()) {
                    if (this.fieldMatches(namespaceBo, fieldValue)) continue;
                    fieldsMatch = false;
                    break;
                }
                if (!fieldsMatch) continue;
                results.add(namespaceBo);
            }
            return results;
        }
        if (ParameterEbo.class.isAssignableFrom(businessObjectClass)) {
            QueryByCriteria queryCriteria = QueryByCriteria.Builder.fromPredicates((Predicate[])new Predicate[]{PredicateFactory.like((String)NAME, (CharSequence)"*")});
            ParameterQueryResults parameterResults = this.getParameterRepositoryService().findParameters(queryCriteria);
            List<Parameter> parameters = parameterResults.getResults();
            ArrayList<ParameterBo> results = new ArrayList<ParameterBo>(parameters.size());
            for (Parameter parameter : parameters) {
                ParameterBo parameterBo = ParameterBo.from(parameter);
                boolean fieldsMatch = true;
                for (Map.Entry<String, Object> fieldValue : fieldValues.entrySet()) {
                    if (this.fieldMatches(parameterBo, fieldValue)) continue;
                    fieldsMatch = false;
                    break;
                }
                if (!fieldsMatch) continue;
                results.add(parameterBo);
            }
            return results;
        }
        return Collections.emptyList();
    }

    private boolean fieldMatches(Object ebo, Map.Entry<String, Object> fieldValue) {
        try {
            return Objects.equals(fieldValue.getValue(), BeanUtils.getProperty((Object)ebo, (String)fieldValue.getKey()));
        }
        catch (IllegalAccessException e) {
            LOG.warn((Object)("querying " + ebo.getClass().getName() + " for an inaccessible field called '" + fieldValue.getKey() + "'"));
        }
        catch (InvocationTargetException e) {
            LOG.warn((Object)("exception querying " + ebo.getClass().getName() + " for a field called '" + fieldValue.getKey() + "'"));
        }
        catch (NoSuchMethodException e) {
            LOG.warn((Object)("querying " + ebo.getClass().getName() + " for an invalid field called '" + fieldValue.getKey() + "'"));
        }
        return false;
    }

    @Override
    public boolean isExternalizableBusinessObjectLookupable(Class boClass) {
        if (NamespaceEbo.class.isAssignableFrom(boClass)) {
            return true;
        }
        if (ParameterEbo.class.isAssignableFrom(boClass)) {
            return true;
        }
        if (ComponentEbo.class.isAssignableFrom(boClass)) {
            return true;
        }
        return ParameterTypeEbo.class.isAssignableFrom(boClass);
    }

    @Override
    public boolean isExternalizableBusinessObjectInquirable(Class boClass) {
        if (NamespaceEbo.class.isAssignableFrom(boClass)) {
            return true;
        }
        if (ParameterEbo.class.isAssignableFrom(boClass)) {
            return true;
        }
        if (ComponentEbo.class.isAssignableFrom(boClass)) {
            return true;
        }
        return ParameterTypeEbo.class.isAssignableFrom(boClass);
    }

    private NamespaceService getNamespaceService() {
        return NamespaceServiceHolder.namespaceService;
    }

    private ParameterRepositoryService getParameterRepositoryService() {
        return ParameterRepositoryServiceHolder.parameterRepositoryService;
    }

    private ComponentService getComponentService() {
        return ComponentServiceHolder.componentService;
    }

    private BusinessObjectService getBusinessObjectService() {
        return BusinessObjectServiceHolder.businessObjectService;
    }

    private static class BusinessObjectServiceHolder {
        static final BusinessObjectService businessObjectService = KRADServiceLocator.getBusinessObjectService();

        private BusinessObjectServiceHolder() {
        }
    }

    private static class ComponentServiceHolder {
        static final ComponentService componentService = CoreServiceApiServiceLocator.getComponentService();

        private ComponentServiceHolder() {
        }
    }

    private static class ParameterRepositoryServiceHolder {
        static final ParameterRepositoryService parameterRepositoryService = CoreServiceApiServiceLocator.getParameterRepositoryService();

        private ParameterRepositoryServiceHolder() {
        }
    }

    private static class NamespaceServiceHolder {
        static final NamespaceService namespaceService = CoreServiceApiServiceLocator.getNamespaceService();

        private NamespaceServiceHolder() {
        }
    }
}

