/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.coreservice.web.parameter;

import java.util.Collections;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.coreservice.api.CoreServiceApiServiceLocator;
import org.kuali.kfs.coreservice.api.component.Component;
import org.kuali.kfs.coreservice.impl.parameter.ParameterBo;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.maintenance.rules.MaintenanceDocumentRuleBase;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

public class ParameterRule
extends MaintenanceDocumentRuleBase {
    @Override
    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        boolean result = super.processCustomRouteDocumentBusinessRules(document);
        result &= this.checkAllowsMaintenanceEdit(document.getDocumentHeader().getWorkflowDocument().getInitiatorPrincipalId(), (ParameterBo)document.getNewMaintainableObject().getDataObject());
        return result &= this.checkComponent((ParameterBo)document.getNewMaintainableObject().getDataObject());
    }

    protected boolean checkAllowsMaintenanceEdit(String initiatorPrincipalId, ParameterBo newBO) {
        boolean allowsEdit = false;
        ParameterBo parm = newBO;
        HashMap<String, String> permissionDetails = new HashMap<String, String>();
        permissionDetails.put("namespaceCode", parm.getNamespaceCode());
        permissionDetails.put("componentName", parm.getComponentCode());
        permissionDetails.put("parameterName", parm.getName());
        allowsEdit = KimApiServiceLocator.getPermissionService().isAuthorizedByTemplate(GlobalVariables.getUserSession().getPerson().getPrincipalId(), "KR-NS", "Maintain System Parameter", permissionDetails, Collections.emptyMap());
        if (!allowsEdit) {
            this.putGlobalError("error.authorization.parameter");
        }
        return allowsEdit;
    }

    public boolean checkComponent(ParameterBo param) {
        String componentCode = param.getComponentCode();
        String namespace = param.getNamespaceCode();
        boolean result = false;
        if (StringUtils.isNotBlank((CharSequence)componentCode) && StringUtils.isNotBlank((CharSequence)namespace)) {
            Component component = CoreServiceApiServiceLocator.getComponentService().getComponentByCode(namespace, componentCode);
            if (component != null) {
                result = true;
            }
            if (!result) {
                this.putFieldError("componentCode", "error.document.parameter.detailType.invalid", componentCode);
            }
        }
        return result;
    }
}

