/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.kns.datadictionary.validation.charlevel;

import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.krad.datadictionary.exporter.ExportMap;
import org.kuali.kfs.krad.datadictionary.validation.CharacterLevelValidationPattern;
import org.kuali.kfs.krad.datadictionary.validation.ValidationPattern;

public class RegexValidationPattern
extends CharacterLevelValidationPattern {
    private static final long serialVersionUID = -5642894236634278352L;
    private static final Logger LOG = Logger.getLogger(RegexValidationPattern.class);
    private String pattern;
    private String validationErrorMessageKey;

    @Override
    public void extendExportMap(ExportMap exportMap) {
        String message;
        if (LOG.isTraceEnabled()) {
            message = String.format("ENTRY %s", exportMap == null ? "null" : exportMap.toString());
            LOG.trace((Object)message);
        }
        exportMap.set("type", "regex");
        exportMap.set("pattern", this.getPattern());
        if (LOG.isTraceEnabled()) {
            message = String.format("EXIT %s", exportMap == null ? "null" : exportMap.toString());
            LOG.trace((Object)message);
        }
    }

    public String getPatternXml() {
        if (LOG.isTraceEnabled()) {
            String message = String.format("ENTRY", new Object[0]);
            LOG.trace((Object)message);
        }
        StringBuffer xml = new StringBuffer("<regex ");
        xml.append(this.pattern);
        xml.append("/>");
        if (LOG.isTraceEnabled()) {
            String message = String.format("EXIT %s", xml.toString());
            LOG.trace((Object)message);
        }
        return xml.toString();
    }

    @Override
    protected String getRegexString() {
        String message;
        if (LOG.isTraceEnabled()) {
            message = String.format("ENTRY %s", this.pattern == null ? "null" : this.pattern.toString());
            LOG.trace((Object)message);
        }
        if (StringUtils.isEmpty((CharSequence)this.pattern)) {
            throw new IllegalStateException(this.getClass().getName() + ".pattern is empty");
        }
        if (LOG.isTraceEnabled()) {
            message = String.format("EXIT", new Object[0]);
            LOG.trace((Object)message);
        }
        return this.pattern;
    }

    public final String getPattern() {
        return this.pattern;
    }

    public final void setPattern(String pattern) {
        this.pattern = pattern;
    }

    @Override
    public String getValidationErrorMessageKey() {
        return this.validationErrorMessageKey;
    }

    public void setValidationErrorMessageKey(String validationErrorMessageKey) {
        this.validationErrorMessageKey = validationErrorMessageKey;
    }

    @Override
    public void completeValidation() {
        super.completeValidation();
        if (StringUtils.isBlank((CharSequence)this.validationErrorMessageKey)) {
            throw new ValidationPattern.ValidationPatternException("Regex Validation Patterns must have a validation error message key defined");
        }
    }
}

