/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.kns.lookup;

import java.security.GeneralSecurityException;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.kns.document.authorization.BusinessObjectRestrictions;
import org.kuali.kfs.kns.document.authorization.FieldRestriction;
import org.kuali.kfs.kns.inquiry.Inquirable;
import org.kuali.kfs.kns.lookup.HtmlData;
import org.kuali.kfs.kns.lookup.LookupResultsService;
import org.kuali.kfs.kns.lookup.LookupUtils;
import org.kuali.kfs.kns.lookup.LookupableHelperService;
import org.kuali.kfs.kns.service.BusinessObjectAuthorizationService;
import org.kuali.kfs.kns.service.BusinessObjectDictionaryService;
import org.kuali.kfs.kns.service.BusinessObjectMetaDataService;
import org.kuali.kfs.kns.service.KNSServiceLocator;
import org.kuali.kfs.kns.service.MaintenanceDocumentDictionaryService;
import org.kuali.kfs.kns.util.FieldUtils;
import org.kuali.kfs.kns.util.WebUtils;
import org.kuali.kfs.kns.web.comparator.CellComparatorHelper;
import org.kuali.kfs.kns.web.struts.form.LookupForm;
import org.kuali.kfs.kns.web.struts.form.MultipleValueLookupForm;
import org.kuali.kfs.kns.web.ui.Column;
import org.kuali.kfs.kns.web.ui.Field;
import org.kuali.kfs.kns.web.ui.ResultRow;
import org.kuali.kfs.kns.web.ui.Row;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.datadictionary.AttributeSecurity;
import org.kuali.kfs.krad.datadictionary.mask.MaskFormatter;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DataDictionaryService;
import org.kuali.kfs.krad.service.KRADServiceLocator;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.service.LookupService;
import org.kuali.kfs.krad.service.PersistenceStructureService;
import org.kuali.kfs.krad.service.SequenceAccessorService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.encryption.EncryptionService;
import org.kuali.rice.core.api.search.SearchOperator;
import org.kuali.rice.core.api.util.cache.CopiedObject;
import org.kuali.rice.core.api.util.type.TypeUtils;
import org.kuali.rice.core.web.format.DateFormatter;
import org.kuali.rice.core.web.format.Formatter;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.bo.BusinessObject;

public abstract class AbstractLookupableHelperServiceImpl
implements LookupableHelperService {
    protected static final String TITLE_RETURN_URL_PREPENDTEXT_PROPERTY = "title.return.url.value.prependtext";
    protected static final String TITLE_ACTION_URL_PREPENDTEXT_PROPERTY = "title.action.url.value.prependtext";
    protected static final String ACTION_URLS_CHILDREN_SEPARATOR = "&nbsp;|&nbsp;";
    protected static final String ACTION_URLS_CHILDREN_STARTER = "&nbsp;[";
    protected static final String ACTION_URLS_CHILDREN_END = "]";
    protected static final String ACTION_URLS_SEPARATOR = "&nbsp;&nbsp;";
    protected static final String ACTION_URLS_EMPTY = "&nbsp;";
    protected static final Logger LOG = Logger.getLogger(AbstractLookupableHelperServiceImpl.class);
    protected static Integer RESULTS_DEFAULT_MAX_COLUMN_LENGTH = null;
    protected BusinessObjectAuthorizationService businessObjectAuthorizationService;
    protected BusinessObjectDictionaryService businessObjectDictionaryService;
    protected BusinessObjectMetaDataService businessObjectMetaDataService;
    protected BusinessObjectService businessObjectService;
    protected ConfigurationService configurationService;
    protected DataDictionaryService dataDictionaryService;
    protected EncryptionService encryptionService;
    protected LookupService lookupService;
    protected LookupResultsService lookupResultsService;
    protected MaintenanceDocumentDictionaryService maintenanceDocumentDictionaryService;
    protected ParameterService parameterService;
    protected PersistenceStructureService persistenceStructureService;
    protected SequenceAccessorService sequenceAccessorService;
    protected String backLocation;
    protected Class businessObjectClass;
    protected String docFormKey;
    protected String docNum;
    protected Map fieldConversions;
    protected Inquirable kualiInquirable;
    protected Map<String, String[]> parameters;
    protected List<String> readOnlyFieldsList;
    protected String referencesToRefresh;
    protected List<Row> rows = null;
    protected HashMap<String, Boolean> forceLookupResultFieldInquiryCache = new HashMap();
    protected HashMap<Class, Class> inquirableClassCache = new HashMap();
    protected HashMap<String, Boolean> noLookupResultFieldInquiryCache = new HashMap();
    protected CopiedObject<ArrayList<Column>> resultColumns = null;

    @Override
    public String getDocNum() {
        return this.docNum;
    }

    @Override
    public void setDocNum(String docNum) {
        this.docNum = docNum;
    }

    @Override
    public boolean checkForAdditionalFields(Map<String, String> fieldValues) {
        return false;
    }

    @Override
    public Class getBusinessObjectClass() {
        return this.businessObjectClass;
    }

    @Override
    public void setBusinessObjectClass(Class businessObjectClass) {
        this.businessObjectClass = businessObjectClass;
        this.setRows();
    }

    @Override
    public Map<String, String[]> getParameters() {
        return this.parameters;
    }

    @Override
    public void setParameters(Map<String, String[]> parameters) {
        this.parameters = parameters;
    }

    @Override
    public DataDictionaryService getDataDictionaryService() {
        return this.dataDictionaryService != null ? this.dataDictionaryService : KRADServiceLocatorWeb.getDataDictionaryService();
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    @Override
    public BusinessObjectDictionaryService getBusinessObjectDictionaryService() {
        return this.businessObjectDictionaryService != null ? this.businessObjectDictionaryService : KNSServiceLocator.getBusinessObjectDictionaryService();
    }

    public void setBusinessObjectDictionaryService(BusinessObjectDictionaryService businessObjectDictionaryService) {
        this.businessObjectDictionaryService = businessObjectDictionaryService;
    }

    public BusinessObjectMetaDataService getBusinessObjectMetaDataService() {
        return this.businessObjectMetaDataService != null ? this.businessObjectMetaDataService : KNSServiceLocator.getBusinessObjectMetaDataService();
    }

    public void setBusinessObjectMetaDataService(BusinessObjectMetaDataService businessObjectMetaDataService) {
        this.businessObjectMetaDataService = businessObjectMetaDataService;
    }

    protected PersistenceStructureService getPersistenceStructureService() {
        return this.persistenceStructureService != null ? this.persistenceStructureService : KRADServiceLocator.getPersistenceStructureService();
    }

    public void setPersistenceStructureService(PersistenceStructureService persistenceStructureService) {
        this.persistenceStructureService = persistenceStructureService;
    }

    protected EncryptionService getEncryptionService() {
        return this.encryptionService != null ? this.encryptionService : CoreApiServiceLocator.getEncryptionService();
    }

    public void setEncryptionService(EncryptionService encryptionService) {
        this.encryptionService = encryptionService;
    }

    public MaintenanceDocumentDictionaryService getMaintenanceDocumentDictionaryService() {
        if (this.maintenanceDocumentDictionaryService == null) {
            this.maintenanceDocumentDictionaryService = KNSServiceLocator.getMaintenanceDocumentDictionaryService();
        }
        return this.maintenanceDocumentDictionaryService;
    }

    public BusinessObjectAuthorizationService getBusinessObjectAuthorizationService() {
        if (this.businessObjectAuthorizationService == null) {
            this.businessObjectAuthorizationService = KNSServiceLocator.getBusinessObjectAuthorizationService();
        }
        return this.businessObjectAuthorizationService;
    }

    public Inquirable getKualiInquirable() {
        if (this.kualiInquirable == null) {
            this.kualiInquirable = KNSServiceLocator.getKualiInquirable();
        }
        return this.kualiInquirable;
    }

    public void setMaintenanceDocumentDictionaryService(MaintenanceDocumentDictionaryService maintenanceDocumentDictionaryService) {
        this.maintenanceDocumentDictionaryService = maintenanceDocumentDictionaryService;
    }

    public void setKualiInquirable(Inquirable kualiInquirable) {
        this.kualiInquirable = kualiInquirable;
    }

    public ConfigurationService getKualiConfigurationService() {
        if (this.configurationService == null) {
            this.configurationService = KRADServiceLocator.getKualiConfigurationService();
        }
        return this.configurationService;
    }

    public void setParameterService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = CoreFrameworkServiceLocator.getParameterService();
        }
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    @Override
    public boolean allowsMaintenanceNewOrCopyAction() {
        boolean allowsNewOrCopy = false;
        String maintDocTypeName = this.getMaintenanceDocumentTypeName();
        Class boClass = this.getBusinessObjectClass();
        if (StringUtils.isNotBlank((CharSequence)maintDocTypeName)) {
            allowsNewOrCopy = this.getBusinessObjectAuthorizationService().canCreate(boClass, GlobalVariables.getUserSession().getPerson(), maintDocTypeName);
        }
        return allowsNewOrCopy;
    }

    protected boolean allowsMaintenanceEditAction(BusinessObject businessObject) {
        boolean allowsEdit = false;
        String maintDocTypeName = this.getMaintenanceDocumentTypeName();
        if (StringUtils.isNotBlank((CharSequence)maintDocTypeName)) {
            allowsEdit = this.getBusinessObjectAuthorizationService().canMaintain(businessObject, GlobalVariables.getUserSession().getPerson(), maintDocTypeName);
        }
        return allowsEdit;
    }

    @Override
    public final String getMaintenanceUrl(BusinessObject businessObject, HtmlData htmlData, List pkNames, BusinessObjectRestrictions businessObjectRestrictions) {
        htmlData.setTitle(this.getActionUrlTitleText(businessObject, htmlData.getDisplayText(), pkNames, businessObjectRestrictions));
        return htmlData.constructCompleteHtmlTag();
    }

    @Override
    public final String getActionUrls(BusinessObject businessObject, List pkNames, BusinessObjectRestrictions businessObjectRestrictions) {
        StringBuffer actions = new StringBuffer();
        List<HtmlData> htmlDataList = this.getCustomActionUrls(businessObject, pkNames);
        for (HtmlData htmlData : htmlDataList) {
            actions.append(this.getMaintenanceUrl(businessObject, htmlData, pkNames, businessObjectRestrictions));
            if (htmlData.getChildUrlDataList() != null && htmlData.getChildUrlDataList().size() > 0) {
                actions.append(ACTION_URLS_CHILDREN_STARTER);
                for (HtmlData childURLData : htmlData.getChildUrlDataList()) {
                    actions.append(this.getMaintenanceUrl(businessObject, childURLData, pkNames, businessObjectRestrictions));
                    actions.append(ACTION_URLS_CHILDREN_SEPARATOR);
                }
                if (actions.toString().endsWith(ACTION_URLS_CHILDREN_SEPARATOR)) {
                    actions.delete(actions.length() - ACTION_URLS_CHILDREN_SEPARATOR.length(), actions.length());
                }
                actions.append(ACTION_URLS_CHILDREN_END);
            }
            actions.append(ACTION_URLS_SEPARATOR);
        }
        if (actions.toString().endsWith(ACTION_URLS_SEPARATOR)) {
            actions.delete(actions.length() - ACTION_URLS_SEPARATOR.length(), actions.length());
        }
        return actions.toString();
    }

    @Override
    public List<HtmlData> getCustomActionUrls(BusinessObject businessObject, List pkNames) {
        ArrayList<HtmlData> htmlDataList = new ArrayList<HtmlData>();
        if (this.allowsMaintenanceEditAction(businessObject)) {
            htmlDataList.add(this.getUrlData(businessObject, "edit", pkNames));
        }
        if (this.allowsMaintenanceNewOrCopyAction()) {
            htmlDataList.add(this.getUrlData(businessObject, "copy", pkNames));
        }
        if (this.allowsMaintenanceDeleteAction(businessObject)) {
            htmlDataList.add(this.getUrlData(businessObject, "delete", pkNames));
        }
        return htmlDataList;
    }

    protected boolean allowsMaintenanceDeleteAction(BusinessObject businessObject) {
        boolean allowsMaintain = false;
        boolean allowsDelete = false;
        String maintDocTypeName = this.getMaintenanceDocumentTypeName();
        if (StringUtils.isNotBlank((CharSequence)maintDocTypeName)) {
            allowsMaintain = this.getBusinessObjectAuthorizationService().canMaintain(businessObject, GlobalVariables.getUserSession().getPerson(), maintDocTypeName);
        }
        return (allowsDelete = KNSServiceLocator.getMaintenanceDocumentDictionaryService().getAllowsRecordDeletion(this.businessObjectClass).booleanValue()) && allowsMaintain;
    }

    protected HtmlData.AnchorHtmlData getUrlData(BusinessObject businessObject, String methodToCall, String displayText, List pkNames) {
        String href = this.getActionUrlHref(businessObject, methodToCall, pkNames);
        HtmlData.AnchorHtmlData anchorHtmlData = new HtmlData.AnchorHtmlData(href, methodToCall, displayText);
        return anchorHtmlData;
    }

    protected HtmlData.AnchorHtmlData getUrlData(BusinessObject businessObject, String methodToCall, List pkNames) {
        return this.getUrlData(businessObject, methodToCall, methodToCall, pkNames);
    }

    protected List<HtmlData> getEmptyActionUrls() {
        return new ArrayList<HtmlData>();
    }

    protected HtmlData getEmptyAnchorHtmlData() {
        return new HtmlData.AnchorHtmlData();
    }

    protected String getActionUrlHref(BusinessObject businessObject, String methodToCall, List pkNames) {
        Properties parameters = new Properties();
        parameters.put("methodToCall", methodToCall);
        parameters.put("businessObjectClassName", businessObject.getClass().getName());
        parameters.putAll((Map<?, ?>)this.getParametersFromPrimaryKey(businessObject, pkNames));
        if (StringUtils.isNotBlank((CharSequence)this.getReturnLocation())) {
            parameters.put("returnLocation", this.getReturnLocation());
        }
        return UrlFactory.parameterizeUrl("maintenance.do", parameters);
    }

    protected Properties getParametersFromPrimaryKey(BusinessObject businessObject, List pkNames) {
        Properties parameters = new Properties();
        for (String fieldNm : pkNames) {
            if (this.getDataDictionaryService().getAttributeDefinition(this.businessObjectClass.getName(), fieldNm) == null) {
                String errorMessage = "The field " + fieldNm + " could not be found in the data dictionary for class " + this.businessObjectClass.getName() + ", and thus it could not be determined whether it is a secure field.";
                if (ConfigContext.getCurrentContextConfig().getBooleanProperty("rice.kns.exceptionOnMissingFieldConversionAttribute", false)) {
                    throw new RuntimeException(errorMessage);
                }
                LOG.error((Object)errorMessage);
                continue;
            }
            Object fieldVal = ObjectUtils.getPropertyValue(businessObject, fieldNm);
            if (fieldVal == null) {
                fieldVal = "";
            }
            if (fieldVal instanceof Date) {
                String formattedString = "";
                if (Formatter.findFormatter(fieldVal.getClass()) != null) {
                    Formatter formatter = Formatter.getFormatter(fieldVal.getClass());
                    formattedString = (String)formatter.format(fieldVal);
                    fieldVal = formattedString;
                }
            }
            if (this.getBusinessObjectAuthorizationService().attributeValueNeedsToBeEncryptedOnFormsAndLinks(this.businessObjectClass, fieldNm)) {
                LOG.warn((Object)("field name " + fieldNm + " is a secure value and not included in pk parameter results"));
                continue;
            }
            parameters.put(fieldNm, fieldVal.toString());
        }
        return parameters;
    }

    protected String getActionUrlTitleText(BusinessObject businessObject, String displayText, List pkNames, BusinessObjectRestrictions businessObjectRestrictions) {
        String prependTitleText = displayText + " " + this.getDataDictionaryService().getDataDictionary().getBusinessObjectEntry(this.getBusinessObjectClass().getName()).getObjectLabel() + " " + this.getKualiConfigurationService().getPropertyValueAsString(TITLE_ACTION_URL_PREPENDTEXT_PROPERTY);
        return HtmlData.getTitleText(prependTitleText, businessObject, pkNames, businessObjectRestrictions);
    }

    protected String getMaintenanceDocumentTypeName() {
        MaintenanceDocumentDictionaryService dd = this.getMaintenanceDocumentDictionaryService();
        String maintDocTypeName = dd.getDocumentTypeName(this.getBusinessObjectClass());
        return maintDocTypeName;
    }

    @Override
    public List<String> getReadOnlyFieldsList() {
        return this.readOnlyFieldsList;
    }

    @Override
    public void setReadOnlyFieldsList(List<String> readOnlyFieldsList) {
        this.readOnlyFieldsList = readOnlyFieldsList;
    }

    @Override
    public HtmlData getInquiryUrl(BusinessObject bo, String propertyName) {
        HtmlData inquiryUrl = new HtmlData.AnchorHtmlData();
        String cacheKey = bo.getClass().getName() + "." + propertyName;
        Boolean noLookupResultFieldInquiry = this.noLookupResultFieldInquiryCache.get(cacheKey);
        if (noLookupResultFieldInquiry == null) {
            noLookupResultFieldInquiry = this.getBusinessObjectDictionaryService().noLookupResultFieldInquiry(bo.getClass(), propertyName);
            if (noLookupResultFieldInquiry == null) {
                noLookupResultFieldInquiry = Boolean.TRUE;
            }
            this.noLookupResultFieldInquiryCache.put(cacheKey, noLookupResultFieldInquiry);
        }
        if (!noLookupResultFieldInquiry.booleanValue()) {
            Class inquirableClass = this.inquirableClassCache.get(bo.getClass());
            if (!this.inquirableClassCache.containsKey(bo.getClass())) {
                inquirableClass = this.getBusinessObjectDictionaryService().getInquirableClass(bo.getClass());
                this.inquirableClassCache.put(bo.getClass(), inquirableClass);
            }
            Inquirable inq = null;
            try {
                if (inquirableClass != null) {
                    inq = (Inquirable)inquirableClass.newInstance();
                } else {
                    inq = this.getKualiInquirable();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Default Inquirable Class: " + inq.getClass()));
                    }
                }
                Boolean forceLookupResultFieldInquiry = this.forceLookupResultFieldInquiryCache.get(cacheKey);
                if (forceLookupResultFieldInquiry == null) {
                    forceLookupResultFieldInquiry = this.getBusinessObjectDictionaryService().forceLookupResultFieldInquiry(bo.getClass(), propertyName);
                    if (forceLookupResultFieldInquiry == null) {
                        forceLookupResultFieldInquiry = Boolean.FALSE;
                    }
                    this.forceLookupResultFieldInquiryCache.put(cacheKey, forceLookupResultFieldInquiry);
                }
                inquiryUrl = inq.getInquiryUrl(bo, propertyName, forceLookupResultFieldInquiry);
            }
            catch (Exception ex) {
                LOG.error((Object)"unable to create inquirable to get inquiry URL", (Throwable)ex);
            }
        }
        return inquiryUrl;
    }

    @Override
    public List<Column> getColumns() {
        if (this.resultColumns == null) {
            ArrayList<Column> columns = new ArrayList<Column>();
            for (String attributeName : this.getBusinessObjectDictionaryService().getLookupResultFieldNames(this.getBusinessObjectClass())) {
                String additionalDisplayPropertyName;
                String alternateDisplayPropertyName;
                Column column = new Column();
                column.setPropertyName(attributeName);
                String columnTitle = this.getDataDictionaryService().getAttributeLabel(this.getBusinessObjectClass(), attributeName);
                Boolean useShortLabel = this.getBusinessObjectDictionaryService().getLookupResultFieldUseShortLabel(this.businessObjectClass, attributeName);
                if (useShortLabel != null && useShortLabel.booleanValue()) {
                    columnTitle = this.getDataDictionaryService().getAttributeShortLabel(this.getBusinessObjectClass(), attributeName);
                }
                if (StringUtils.isBlank((CharSequence)columnTitle)) {
                    columnTitle = this.getDataDictionaryService().getCollectionLabel(this.getBusinessObjectClass(), attributeName);
                }
                column.setColumnTitle(columnTitle);
                column.setMaxLength(this.getColumnMaxLength(attributeName));
                if (!this.businessObjectClass.isInterface()) {
                    try {
                        column.setFormatter(ObjectUtils.getFormatterWithDataDictionary(this.getBusinessObjectClass().newInstance(), attributeName));
                    }
                    catch (InstantiationException e) {
                        LOG.info((Object)("Unable to get new instance of business object class: " + this.businessObjectClass.getName()), (Throwable)e);
                    }
                    catch (IllegalAccessException e) {
                        LOG.info((Object)("Unable to get new instance of business object class: " + this.businessObjectClass.getName()), (Throwable)e);
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)(alternateDisplayPropertyName = this.getBusinessObjectDictionaryService().getLookupFieldAlternateDisplayAttributeName(this.getBusinessObjectClass(), attributeName)))) {
                    column.setAlternateDisplayPropertyName(alternateDisplayPropertyName);
                }
                if (StringUtils.isNotBlank((CharSequence)(additionalDisplayPropertyName = this.getBusinessObjectDictionaryService().getLookupFieldAdditionalDisplayAttributeName(this.getBusinessObjectClass(), attributeName)))) {
                    column.setAdditionalDisplayPropertyName(additionalDisplayPropertyName);
                } else {
                    boolean translateCodes = this.getBusinessObjectDictionaryService().tranlateCodesInLookup(this.getBusinessObjectClass());
                    if (translateCodes) {
                        FieldUtils.setAdditionalDisplayPropertyForCodes(this.getBusinessObjectClass(), attributeName, column);
                    }
                }
                column.setTotal(this.getBusinessObjectDictionaryService().getLookupResultFieldTotal(this.getBusinessObjectClass(), attributeName));
                columns.add(column);
            }
            this.resultColumns = ObjectUtils.deepCopyForCaching(columns);
            return columns;
        }
        return (List)((Object)this.resultColumns.getContent());
    }

    protected int getColumnMaxLength(String attributeName) {
        Integer fieldDefinedMaxLength = this.getBusinessObjectDictionaryService().getLookupResultFieldMaxLength(this.getBusinessObjectClass(), attributeName);
        if (fieldDefinedMaxLength == null) {
            if (RESULTS_DEFAULT_MAX_COLUMN_LENGTH == null) {
                try {
                    RESULTS_DEFAULT_MAX_COLUMN_LENGTH = Integer.valueOf(this.getParameterService().getParameterValueAsString("KR-NS", "Lookup", "RESULTS_DEFAULT_MAX_COLUMN_LENGTH"));
                }
                catch (NumberFormatException ex) {
                    LOG.error((Object)"Lookup field max length parameter not found and unable to parse default set in system parameters (RESULTS_DEFAULT_MAX_COLUMN_LENGTH).");
                }
            }
            return RESULTS_DEFAULT_MAX_COLUMN_LENGTH;
        }
        return fieldDefinedMaxLength;
    }

    @Override
    public String getBackLocation() {
        return WebUtils.sanitizeBackLocation(this.backLocation);
    }

    @Override
    public void setBackLocation(String backLocation) {
        this.backLocation = backLocation;
    }

    @Override
    public String getReturnLocation() {
        return this.backLocation;
    }

    @Override
    public final HtmlData getReturnUrl(BusinessObject businessObject, Map fieldConversions, String lookupImpl, List returnKeys, BusinessObjectRestrictions businessObjectRestrictions) {
        String href = this.getReturnHref(businessObject, fieldConversions, lookupImpl, returnKeys);
        String returnUrlAnchorLabel = this.getKualiConfigurationService().getPropertyValueAsString(TITLE_RETURN_URL_PREPENDTEXT_PROPERTY);
        HtmlData.AnchorHtmlData anchor = new HtmlData.AnchorHtmlData(href, HtmlData.getTitleText(returnUrlAnchorLabel, businessObject, returnKeys, businessObjectRestrictions));
        anchor.setDisplayText(returnUrlAnchorLabel);
        return anchor;
    }

    protected final String getReturnHref(BusinessObject businessObject, Map fieldConversions, String lookupImpl, List returnKeys) {
        if (StringUtils.isNotBlank((CharSequence)this.backLocation)) {
            return UrlFactory.parameterizeUrl(this.backLocation, this.getParameters(businessObject, fieldConversions, lookupImpl, returnKeys));
        }
        return "";
    }

    @Override
    public HtmlData getReturnUrl(BusinessObject businessObject, LookupForm lookupForm, List returnKeys, BusinessObjectRestrictions businessObjectRestrictions) {
        Properties parameters = this.getParameters(businessObject, lookupForm.getFieldConversions(), lookupForm.getLookupableImplServiceName(), returnKeys);
        if (StringUtils.isEmpty((CharSequence)lookupForm.getHtmlDataType()) || HtmlData.ANCHOR_HTML_DATA_TYPE.equals(lookupForm.getHtmlDataType())) {
            return this.getReturnAnchorHtmlData(businessObject, parameters, lookupForm, returnKeys, businessObjectRestrictions);
        }
        return this.getReturnInputHtmlData(businessObject, parameters, lookupForm, returnKeys, businessObjectRestrictions);
    }

    protected HtmlData getReturnInputHtmlData(BusinessObject businessObject, Properties parameters, LookupForm lookupForm, List returnKeys, BusinessObjectRestrictions businessObjectRestrictions) {
        String returnUrlAnchorLabel = this.getKualiConfigurationService().getPropertyValueAsString(TITLE_RETURN_URL_PREPENDTEXT_PROPERTY);
        String name = "selectedObjId-" + lookupForm.getLookupObjectId();
        HtmlData.InputHtmlData input = new HtmlData.InputHtmlData(name, "checkbox");
        input.setTitle(HtmlData.getTitleText(returnUrlAnchorLabel, businessObject, returnKeys, businessObjectRestrictions));
        if (((MultipleValueLookupForm)lookupForm).getCompositeObjectIdMap() == null || ((MultipleValueLookupForm)lookupForm).getCompositeObjectIdMap().get(((PersistableBusinessObject)businessObject).getObjectId()) == null) {
            input.setChecked("");
        } else {
            input.setChecked("checked");
        }
        input.setValue("checked");
        return input;
    }

    protected HtmlData getReturnAnchorHtmlData(BusinessObject businessObject, Properties parameters, LookupForm lookupForm, List returnKeys, BusinessObjectRestrictions businessObjectRestrictions) {
        String returnUrlAnchorLabel = this.getKualiConfigurationService().getPropertyValueAsString(TITLE_RETURN_URL_PREPENDTEXT_PROPERTY);
        HtmlData.AnchorHtmlData anchor = new HtmlData.AnchorHtmlData(this.getReturnHref(parameters, lookupForm, returnKeys), HtmlData.getTitleText(returnUrlAnchorLabel, businessObject, returnKeys, businessObjectRestrictions));
        anchor.setDisplayText(returnUrlAnchorLabel);
        return anchor;
    }

    protected String getReturnHref(Properties parameters, LookupForm lookupForm, List returnKeys) {
        if (StringUtils.isNotBlank((CharSequence)this.backLocation)) {
            String href = UrlFactory.parameterizeUrl(this.backLocation, parameters);
            return this.addToReturnHref(href, lookupForm);
        }
        return "";
    }

    protected String addToReturnHref(String href, LookupForm lookupForm) {
        String lookupAnchor = "";
        if (StringUtils.isNotEmpty((CharSequence)lookupForm.getAnchor())) {
            lookupAnchor = lookupForm.getAnchor();
        }
        href = href + "&anchor=" + lookupAnchor + "&docNum=" + (StringUtils.isEmpty((CharSequence)this.getDocNum()) ? "" : this.getDocNum());
        return href;
    }

    protected Properties getParameters(BusinessObject bo, Map<String, String> fieldConversions, String lookupImpl, List returnKeys) {
        Properties parameters = new Properties();
        parameters.put("methodToCall", "refresh");
        if (this.getDocFormKey() != null) {
            parameters.put("docFormKey", this.getDocFormKey());
        }
        if (lookupImpl != null) {
            parameters.put("refreshCaller", lookupImpl);
        }
        if (this.getDocNum() != null) {
            parameters.put("docNum", this.getDocNum());
        }
        if (this.getReferencesToRefresh() != null) {
            parameters.put("referencesToRefresh", this.getReferencesToRefresh());
        }
        for (String fieldNm : this.getReturnKeys()) {
            if (this.getDataDictionaryService().getAttributeDefinition(this.businessObjectClass.getName(), fieldNm) == null) {
                String errorMessage = "The field " + fieldNm + " could not be found in the data dictionary for class " + this.businessObjectClass.getName() + ", and thus it could not be determined whether it is a secure field.";
                if (ConfigContext.getCurrentContextConfig().getBooleanProperty("rice.kns.exceptionOnMissingFieldConversionAttribute", false)) {
                    throw new RuntimeException(errorMessage);
                }
                LOG.error((Object)errorMessage);
                continue;
            }
            Object fieldVal = ObjectUtils.getPropertyValue(bo, fieldNm);
            if (fieldVal == null) {
                fieldVal = "";
            }
            if (this.getBusinessObjectAuthorizationService().attributeValueNeedsToBeEncryptedOnFormsAndLinks(this.businessObjectClass, fieldNm)) {
                LOG.warn((Object)("field name " + fieldNm + " is a secure value and not included in parameter results"));
                continue;
            }
            if (fieldVal instanceof Date) {
                DateFormatter dateFormatter = new DateFormatter();
                fieldVal = dateFormatter.format(fieldVal);
            }
            if (fieldConversions.containsKey(fieldNm)) {
                fieldNm = fieldConversions.get(fieldNm);
            }
            parameters.put(fieldNm, fieldVal.toString());
        }
        return parameters;
    }

    @Override
    public List<String> getReturnKeys() {
        List<String> returnKeys = this.fieldConversions != null && !this.fieldConversions.isEmpty() ? new ArrayList(this.fieldConversions.keySet()) : this.getBusinessObjectMetaDataService().listPrimaryKeyFieldNames(this.getBusinessObjectClass());
        return returnKeys;
    }

    @Override
    public String getDocFormKey() {
        return this.docFormKey;
    }

    @Override
    public void setDocFormKey(String docFormKey) {
        this.docFormKey = docFormKey;
    }

    @Override
    public void setFieldConversions(Map fieldConversions) {
        this.fieldConversions = fieldConversions;
    }

    protected LookupService getLookupService() {
        return this.lookupService != null ? this.lookupService : KRADServiceLocatorWeb.getLookupService();
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    @Override
    public List<String> getDefaultSortColumns() {
        return this.getBusinessObjectDictionaryService().getLookupDefaultSortFieldNames(this.getBusinessObjectClass());
    }

    @Override
    public void validateSearchParameters(Map<String, String> fieldValues) {
        List<String> lookupFieldAttributeList = null;
        if (this.getBusinessObjectMetaDataService().isLookupable(this.getBusinessObjectClass())) {
            lookupFieldAttributeList = this.getBusinessObjectMetaDataService().getLookupableFieldNames(this.getBusinessObjectClass());
        }
        if (lookupFieldAttributeList == null) {
            throw new RuntimeException("Lookup not defined for business object " + this.getBusinessObjectClass());
        }
        for (String attributeName : lookupFieldAttributeList) {
            if (!fieldValues.containsKey(attributeName)) continue;
            String attributeLabel = this.getDataDictionaryService().getAttributeLabel(this.getBusinessObjectClass(), attributeName);
            String attributeValue = fieldValues.get(attributeName);
            if (StringUtils.isBlank((CharSequence)attributeValue) && this.getBusinessObjectDictionaryService().getLookupAttributeRequired(this.getBusinessObjectClass(), attributeName).booleanValue()) {
                GlobalVariables.getMessageMap().putError(attributeName, "error.required", attributeLabel);
            }
            this.validateSearchParameterWildcardAndOperators(attributeName, attributeValue);
        }
        if (GlobalVariables.getMessageMap().hasErrors()) {
            throw new ValidationException("errors in search criteria");
        }
    }

    protected void validateSearchParameterWildcardAndOperators(String attributeName, String attributeValue) {
        if (StringUtils.isBlank((CharSequence)attributeValue)) {
            return;
        }
        boolean found = false;
        for (SearchOperator op : SearchOperator.QUERY_CHARACTERS) {
            String queryCharacter = op.op();
            if (!attributeValue.contains(queryCharacter)) continue;
            found = true;
        }
        if (!found) {
            return;
        }
        String attributeLabel = this.getDataDictionaryService().getAttributeLabel(this.getBusinessObjectClass(), attributeName);
        if (this.getBusinessObjectDictionaryService().isLookupFieldTreatWildcardsAndOperatorsAsLiteral(this.businessObjectClass, attributeName)) {
            BusinessObject example = null;
            try {
                example = (BusinessObject)this.businessObjectClass.newInstance();
            }
            catch (Exception e) {
                LOG.error((Object)("Exception caught instantiating " + this.businessObjectClass.getName()), (Throwable)e);
                throw new RuntimeException("Cannot instantiate " + this.businessObjectClass.getName(), e);
            }
            Class propertyType = ObjectUtils.getPropertyType(example, attributeName, this.getPersistenceStructureService());
            if (TypeUtils.isIntegralClass((Class)propertyType) || TypeUtils.isDecimalClass((Class)propertyType) || TypeUtils.isTemporalClass((Class)propertyType)) {
                GlobalVariables.getMessageMap().putError(attributeName, "error.wildcards.and.operators.not.allowed.on.field", attributeLabel);
            }
            if (TypeUtils.isStringClass((Class)propertyType)) {
                GlobalVariables.getMessageMap().putInfo(attributeName, "info.wildcards.and.operators.treated.literally", attributeLabel);
            }
        } else if (this.getBusinessObjectAuthorizationService().attributeValueNeedsToBeEncryptedOnFormsAndLinks(this.businessObjectClass, attributeName) && !attributeValue.endsWith("(&^#&)")) {
            GlobalVariables.getMessageMap().putError(attributeName, "error.secureField", attributeLabel);
        }
    }

    protected void setRows() {
        List<String> lookupFieldAttributeList = null;
        if (this.getBusinessObjectMetaDataService().isLookupable(this.getBusinessObjectClass())) {
            lookupFieldAttributeList = this.getBusinessObjectMetaDataService().getLookupableFieldNames(this.getBusinessObjectClass());
        }
        if (lookupFieldAttributeList == null) {
            throw new RuntimeException("Lookup not defined for business object " + this.getBusinessObjectClass());
        }
        ArrayList<Field> fields = new ArrayList();
        try {
            fields = FieldUtils.createAndPopulateFieldsForLookup(lookupFieldAttributeList, this.getReadOnlyFieldsList(), this.getBusinessObjectClass());
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Unable to create instance of business object class" + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to create instance of business object class" + e.getMessage());
        }
        int numCols = this.getBusinessObjectDictionaryService().getLookupNumberOfColumns(this.getBusinessObjectClass());
        this.rows = FieldUtils.wrapFields(fields, numCols);
    }

    @Override
    public List<Row> getRows() {
        return this.rows;
    }

    @Override
    public abstract List<? extends BusinessObject> getSearchResults(Map<String, String> var1);

    @Override
    public List<? extends BusinessObject> getSearchResultsUnbounded(Map<String, String> fieldValues) {
        throw new UnsupportedOperationException("Lookupable helper services do not always support getSearchResultsUnbounded");
    }

    @Override
    public Collection<? extends BusinessObject> performLookup(LookupForm lookupForm, Collection<ResultRow> resultTable, boolean bounded) {
        Map lookupFormFields = lookupForm.getFieldsForLookup();
        this.setBackLocation((String)lookupFormFields.get("backLocation"));
        this.setDocFormKey((String)lookupFormFields.get("docFormKey"));
        LookupUtils.preProcessRangeFields(lookupFormFields);
        List<? extends BusinessObject> displayList = bounded ? this.getSearchResults(lookupFormFields) : this.getSearchResultsUnbounded(lookupFormFields);
        boolean hasReturnableRow = false;
        List<String> returnKeys = this.getReturnKeys();
        List<String> pkNames = this.getBusinessObjectMetaDataService().listPrimaryKeyFieldNames(this.getBusinessObjectClass());
        Person user = GlobalVariables.getUserSession().getPerson();
        Iterator iterator = displayList.iterator();
        while (iterator.hasNext()) {
            BusinessObject element;
            BusinessObject baseElement = element = (BusinessObject)iterator.next();
            String lookupId = KNSServiceLocator.getLookupResultsService().getLookupId(baseElement);
            if (lookupId != null) {
                lookupForm.setLookupObjectId(lookupId);
            }
            BusinessObjectRestrictions businessObjectRestrictions = this.getBusinessObjectAuthorizationService().getLookupResultRestrictions(element, user);
            HtmlData returnUrl = this.getReturnUrl(element, lookupForm, returnKeys, businessObjectRestrictions);
            String actionUrls = this.getActionUrls(element, pkNames, businessObjectRestrictions);
            if ("".equals(actionUrls)) {
                actionUrls = ACTION_URLS_EMPTY;
            }
            List<Column> columns = this.getColumns();
            for (Column col : columns) {
                String propValue = ObjectUtils.getFormattedPropertyValue(element, col.getPropertyName(), col.getFormatter());
                Class propClass = this.getPropertyClass(element, col.getPropertyName());
                col.setComparator(CellComparatorHelper.getAppropriateComparatorForPropertyClass(propClass));
                col.setValueComparator(CellComparatorHelper.getAppropriateValueComparatorForPropertyClass(propClass));
                String propValueBeforePotientalMasking = propValue;
                propValue = this.maskValueIfNecessary(element, col.getPropertyName(), propValue, businessObjectRestrictions);
                col.setPropertyValue(propValue);
                if (StringUtils.equals((CharSequence)propValueBeforePotientalMasking, (CharSequence)propValue)) {
                    if (StringUtils.isNotBlank((CharSequence)col.getAlternateDisplayPropertyName())) {
                        String alternatePropertyValue = ObjectUtils.getFormattedPropertyValue(element, col.getAlternateDisplayPropertyName(), null);
                        col.setPropertyValue(alternatePropertyValue);
                    }
                    if (StringUtils.isNotBlank((CharSequence)col.getAdditionalDisplayPropertyName())) {
                        String additionalPropertyValue = ObjectUtils.getFormattedPropertyValue(element, col.getAdditionalDisplayPropertyName(), null);
                        col.setPropertyValue(col.getPropertyValue() + " *-* " + additionalPropertyValue);
                    }
                } else {
                    col.setTotal(false);
                }
                if (col.isTotal()) {
                    Object unformattedPropValue = ObjectUtils.getPropertyValue(element, col.getPropertyName());
                    col.setUnformattedPropertyValue(unformattedPropValue);
                }
                if (!StringUtils.isNotBlank((CharSequence)propValue)) continue;
                col.setColumnAnchor(this.getInquiryUrl(element, col.getPropertyName()));
            }
            ResultRow row = new ResultRow(columns, returnUrl.constructCompleteHtmlTag(), actionUrls);
            row.setRowId(returnUrl.getName());
            row.setReturnUrlHtmlData(returnUrl);
            if (this.getBusinessObjectDictionaryService().isExportable(this.getBusinessObjectClass()).booleanValue()) {
                row.setBusinessObject(element);
            }
            if (lookupId != null) {
                row.setObjectId(lookupId);
            }
            boolean rowReturnable = this.isResultReturnable(element);
            row.setRowReturnable(rowReturnable);
            if (rowReturnable) {
                hasReturnableRow = true;
            }
            resultTable.add(row);
        }
        lookupForm.setHasReturnableRow(hasReturnableRow);
        return displayList;
    }

    protected Class getPropertyClass(BusinessObject element, String propertyName) {
        Class propClass = null;
        try {
            propClass = ObjectUtils.getPropertyType(element, propertyName, this.getPersistenceStructureService());
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot access PropertyType for property '" + propertyName + "'  on an instance of '" + element.getClass().getName() + "'.", e);
        }
        return propClass;
    }

    protected String maskValueIfNecessary(BusinessObject businessObject, String propertyName, String propertyValue, BusinessObjectRestrictions businessObjectRestrictions) {
        FieldRestriction fieldRestriction;
        String maskedPropertyValue = propertyValue;
        if (businessObjectRestrictions != null && (fieldRestriction = businessObjectRestrictions.getFieldRestriction(propertyName)) != null && (fieldRestriction.isMasked() || fieldRestriction.isPartiallyMasked())) {
            maskedPropertyValue = fieldRestriction.getMaskFormatter().maskValue(propertyValue);
        }
        KNSServiceLocator.getSecurityLoggingService().logFieldAccess(businessObject, propertyName, null, businessObjectRestrictions, false, null);
        return maskedPropertyValue;
    }

    protected void setReferencesToRefresh(String referencesToRefresh) {
        this.referencesToRefresh = referencesToRefresh;
    }

    public String getReferencesToRefresh() {
        return this.referencesToRefresh;
    }

    protected SequenceAccessorService getSequenceAccessorService() {
        return this.sequenceAccessorService != null ? this.sequenceAccessorService : KRADServiceLocator.getSequenceAccessorService();
    }

    public void setSequenceAccessorService(SequenceAccessorService sequenceAccessorService) {
        this.sequenceAccessorService = sequenceAccessorService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService != null ? this.businessObjectService : KRADServiceLocator.getBusinessObjectService();
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    protected LookupResultsService getLookupResultsService() {
        return this.lookupResultsService != null ? this.lookupResultsService : KNSServiceLocator.getLookupResultsService();
    }

    public void setLookupResultsService(LookupResultsService lookupResultsService) {
        this.lookupResultsService = lookupResultsService;
    }

    @Override
    public boolean isSearchUsingOnlyPrimaryKeyValues() {
        return false;
    }

    @Override
    public String getPrimaryKeyFieldLabels() {
        return "N/A";
    }

    @Override
    public boolean isResultReturnable(BusinessObject object) {
        return true;
    }

    @Override
    public void performClear(LookupForm lookupForm) {
        for (Row row : this.getRows()) {
            for (Field field : row.getFields()) {
                if (field.isSecure()) {
                    field.setSecure(false);
                    field.setDisplayMaskValue(null);
                    field.setEncryptedValue(null);
                }
                if (field.getFieldType().equals("radio")) continue;
                field.setPropertyValue(field.getDefaultValue());
                if (!field.getFieldType().equals("multiselect")) continue;
                field.setPropertyValues(null);
            }
        }
    }

    @Override
    public boolean shouldDisplayHeaderNonMaintActions() {
        return true;
    }

    @Override
    public boolean shouldDisplayLookupCriteria() {
        return true;
    }

    @Override
    public String getSupplementalMenuBar() {
        return new String();
    }

    @Override
    public String getTitle() {
        return this.getBusinessObjectDictionaryService().getLookupTitle(this.getBusinessObjectClass());
    }

    @Override
    public boolean performCustomAction(boolean ignoreErrors) {
        return false;
    }

    @Override
    public Field getExtraField() {
        return null;
    }

    @Override
    public boolean allowsNewOrCopyAction(String documentTypeName) {
        throw new UnsupportedOperationException("Function not supported.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void applyFieldAuthorizationsFromNestedLookups(Field field) {
        BusinessObjectAuthorizationService boAuthzService = this.getBusinessObjectAuthorizationService();
        if (!Field.MULTI_VALUE_FIELD_TYPES.contains(field.getFieldType())) {
            MaskFormatter maskFormatter;
            if (field.getPropertyValue() == null || !field.getPropertyValue().endsWith("(&^#&)")) return;
            if (!boAuthzService.attributeValueNeedsToBeEncryptedOnFormsAndLinks(this.businessObjectClass, field.getPropertyName())) throw new RuntimeException("Field " + field.getPersonNameAttributeName() + " was encrypted on " + this.businessObjectClass.getName() + " lookup was encrypted when it should not have been encrypted according to the data dictionary.");
            AttributeSecurity attributeSecurity = this.getDataDictionaryService().getAttributeSecurity(this.businessObjectClass.getName(), field.getPropertyName());
            Person user = GlobalVariables.getUserSession().getPerson();
            String decryptedValue = "";
            try {
                String cipherText = StringUtils.removeEnd((String)field.getPropertyValue(), (String)"(&^#&)");
                if (CoreApiServiceLocator.getEncryptionService().isEnabled()) {
                    decryptedValue = this.getEncryptionService().decrypt(cipherText);
                }
            }
            catch (GeneralSecurityException e) {
                throw new RuntimeException("Error decrypting value for business object " + this.businessObjectClass + " attribute " + field.getPropertyName(), e);
            }
            if (attributeSecurity.isMask() && !boAuthzService.canFullyUnmaskField(user, this.businessObjectClass, field.getPropertyName(), null)) {
                maskFormatter = attributeSecurity.getMaskFormatter();
                field.setEncryptedValue(field.getPropertyValue());
                field.setDisplayMaskValue(maskFormatter.maskValue(decryptedValue));
                field.setSecure(true);
                return;
            } else if (attributeSecurity.isPartialMask() && !boAuthzService.canPartiallyUnmaskField(user, this.businessObjectClass, field.getPropertyName(), null)) {
                maskFormatter = attributeSecurity.getPartialMaskFormatter();
                field.setEncryptedValue(field.getPropertyValue());
                field.setDisplayMaskValue(maskFormatter.maskValue(decryptedValue));
                field.setSecure(true);
                return;
            } else {
                field.setPropertyValue(org.kuali.kfs.krad.lookup.LookupUtils.forceUppercase(this.businessObjectClass, field.getPropertyName(), decryptedValue));
            }
            return;
        }
        if (!boAuthzService.attributeValueNeedsToBeEncryptedOnFormsAndLinks(this.businessObjectClass, field.getPropertyName())) return;
        LOG.error((Object)"Cannot handle multiple value field types that have field authorizations, please implement custom lookupable helper service");
        throw new RuntimeException("Cannot handle multiple value field types that have field authorizations.");
    }

    @Override
    public void applyConditionalLogicForFieldDisplay() {
        Set<String> readOnlyFields = this.getConditionallyReadOnlyPropertyNames();
        Set<String> requiredFields = this.getConditionallyRequiredPropertyNames();
        Set<String> hiddenFields = this.getConditionallyHiddenPropertyNames();
        for (Row row : this.getRows()) {
            for (Field field : row.getFields()) {
                if (readOnlyFields != null && readOnlyFields.contains(field.getPropertyName())) {
                    field.setReadOnly(true);
                }
                if (requiredFields != null && requiredFields.contains(field.getPropertyName())) {
                    field.setFieldRequired(true);
                }
                if (hiddenFields == null || !hiddenFields.contains(field.getPropertyName())) continue;
                field.setFieldType("hidden");
            }
        }
    }

    public Set<String> getConditionallyReadOnlyPropertyNames() {
        return new HashSet<String>();
    }

    public Set<String> getConditionallyRequiredPropertyNames() {
        return new HashSet<String>();
    }

    public Set<String> getConditionallyHiddenPropertyNames() {
        return new HashSet<String>();
    }

    protected String getCurrentSearchFieldValue(String propertyName) {
        String currentValue = null;
        boolean fieldFound = false;
        for (Row row : this.getRows()) {
            for (Field field : row.getFields()) {
                if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)field.getPropertyName())) {
                    currentValue = Field.MULTI_VALUE_FIELD_TYPES.contains(field.getFieldType()) ? StringUtils.join((Object[])field.getPropertyValues(), (String)";") : field.getPropertyValue();
                    fieldFound = true;
                }
                if (!fieldFound) continue;
                break;
            }
            if (!fieldFound) continue;
            break;
        }
        return currentValue;
    }
}

