/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.kns.maintenance.rules;

import java.security.GeneralSecurityException;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.document.authorization.MaintenanceDocumentAuthorizer;
import org.kuali.kfs.kns.maintenance.Maintainable;
import org.kuali.kfs.kns.rule.AddCollectionLineRule;
import org.kuali.kfs.kns.rules.DocumentRuleBase;
import org.kuali.kfs.kns.rules.MaintenanceDocumentRule;
import org.kuali.kfs.kns.service.BusinessObjectAuthorizationService;
import org.kuali.kfs.kns.service.BusinessObjectDictionaryService;
import org.kuali.kfs.kns.service.BusinessObjectMetaDataService;
import org.kuali.kfs.kns.service.DictionaryValidationService;
import org.kuali.kfs.kns.service.DocumentHelperService;
import org.kuali.kfs.kns.service.KNSServiceLocator;
import org.kuali.kfs.kns.service.MaintenanceDocumentDictionaryService;
import org.kuali.kfs.kns.util.RouteToCompletionUtil;
import org.kuali.kfs.krad.bo.GlobalBusinessObject;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.datadictionary.InactivationBlockingMetadata;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.rules.rule.event.ApproveDocumentEvent;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DataDictionaryService;
import org.kuali.kfs.krad.service.DataObjectMetaDataService;
import org.kuali.kfs.krad.service.InactivationBlockingDetectionService;
import org.kuali.kfs.krad.service.KRADServiceLocator;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.service.PersistenceStructureService;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.ForeignKeyFieldsPopulationState;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.MessageMap;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.kfs.krad.workflow.service.WorkflowDocumentService;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.mo.common.active.MutableInactivatable;
import org.kuali.rice.core.web.format.Formatter;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.bo.BusinessObject;
import org.springframework.util.AutoPopulatingList;

public class MaintenanceDocumentRuleBase
extends DocumentRuleBase
implements MaintenanceDocumentRule,
AddCollectionLineRule {
    protected static Logger LOG = Logger.getLogger(MaintenanceDocumentRuleBase.class);
    public static final String MAINTAINABLE_ERROR_PREFIX = "document.newMaintainableObject.";
    public static final String DOCUMENT_ERROR_PREFIX = "document.";
    public static final String MAINTAINABLE_ERROR_PATH = "document.newMaintainableObject";
    protected PersistenceStructureService persistenceStructureService;
    protected DataDictionaryService ddService;
    protected DocumentHelperService documentHelperService;
    protected BusinessObjectService boService;
    protected DictionaryValidationService dictionaryValidationService;
    protected ConfigurationService configService;
    protected MaintenanceDocumentDictionaryService maintDocDictionaryService;
    protected WorkflowDocumentService workflowDocumentService;
    protected PersonService personService;
    protected RoleService roleService;
    protected DataObjectMetaDataService dataObjectMetaDataService;
    protected BusinessObjectAuthorizationService businessObjectAuthorizationService;
    protected BusinessObjectMetaDataService businessObjectMetaDataService;
    protected BusinessObjectDictionaryService boDictionaryService;
    private Object oldBo;
    private Object newBo;
    private Class boClass;
    protected List priorErrorPath = new ArrayList();

    public MaintenanceDocumentRuleBase() {
        try {
            this.setPersistenceStructureService(KRADServiceLocator.getPersistenceStructureService());
            this.setDdService(KRADServiceLocatorWeb.getDataDictionaryService());
            this.setBusinessObjectMetaDataService(KNSServiceLocator.getBusinessObjectMetaDataService());
            this.setBoService(KRADServiceLocator.getBusinessObjectService());
            this.setBoDictionaryService(KNSServiceLocator.getBusinessObjectDictionaryService());
            this.setDictionaryValidationService(super.getDictionaryValidationService());
            this.setConfigService(KRADServiceLocator.getKualiConfigurationService());
            this.setDocumentHelperService(KNSServiceLocator.getDocumentHelperService());
            this.setMaintDocDictionaryService(KNSServiceLocator.getMaintenanceDocumentDictionaryService());
            this.setWorkflowDocumentService(KRADServiceLocatorWeb.getWorkflowDocumentService());
            this.setPersonService(KimApiServiceLocator.getPersonService());
            this.setBusinessObjectAuthorizationService(KNSServiceLocator.getBusinessObjectAuthorizationService());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean processSaveDocument(Document document) {
        MaintenanceDocument maintenanceDocument = (MaintenanceDocument)document;
        this.clearErrorPath();
        this.setupBaseConvenienceObjects(maintenanceDocument);
        if (!this.isDocumentValidForSave(maintenanceDocument)) {
            this.resumeErrorPath();
            return false;
        }
        this.processCustomSaveDocumentBusinessRules(maintenanceDocument);
        this.resumeErrorPath();
        return true;
    }

    @Override
    public boolean processRouteDocument(Document document) {
        LOG.info((Object)"processRouteDocument called");
        MaintenanceDocument maintenanceDocument = (MaintenanceDocument)document;
        boolean completeRequestPending = RouteToCompletionUtil.checkIfAtleastOneAdHocCompleteRequestExist(maintenanceDocument);
        if (completeRequestPending) {
            return true;
        }
        MaintenanceDocumentAuthorizer documentAuthorizer = (MaintenanceDocumentAuthorizer)((Object)this.getDocumentHelperService().getDocumentAuthorizer(document));
        this.clearErrorPath();
        this.setupBaseConvenienceObjects(maintenanceDocument);
        this.processGlobalSaveDocumentBusinessRules(maintenanceDocument);
        boolean success = true;
        WorkflowDocument workflowDocument = document.getDocumentHeader().getWorkflowDocument();
        if ((workflowDocument.isInitiated() || workflowDocument.isSaved()) && !(success &= documentAuthorizer.canCreateOrMaintain((MaintenanceDocument)document, GlobalVariables.getUserSession().getPerson()))) {
            GlobalVariables.getMessageMap().putError("document.document*,document.explanation*,document.reversal*,document.selected*,document.header*", "error.authorization.document", GlobalVariables.getUserSession().getPerson().getPrincipalName(), "Create/Maintain", this.getMaintDocDictionaryService().getDocumentTypeName(this.newBo.getClass()));
        }
        success &= this.processGlobalRouteDocumentBusinessRules(maintenanceDocument);
        success &= this.processCustomRouteDocumentBusinessRules(maintenanceDocument);
        this.resumeErrorPath();
        return success &= this.processInactivationBlockChecking(maintenanceDocument);
    }

    protected boolean isDocumentInactivatingBusinessObject(MaintenanceDocument maintenanceDocument) {
        Class boClass;
        if (maintenanceDocument.isEdit() && (boClass = maintenanceDocument.getNewMaintainableObject().getDataObjectClass()) != null && MutableInactivatable.class.isAssignableFrom(boClass)) {
            MutableInactivatable oldInactivateableBO = (MutableInactivatable)this.oldBo;
            MutableInactivatable newInactivateableBO = (MutableInactivatable)this.newBo;
            return oldInactivateableBO.isActive() && !newInactivateableBO.isActive();
        }
        return false;
    }

    protected boolean processInactivationBlockChecking(MaintenanceDocument maintenanceDocument) {
        Class boClass;
        Set<InactivationBlockingMetadata> inactivationBlockingMetadatas;
        if (this.isDocumentInactivatingBusinessObject(maintenanceDocument) && (inactivationBlockingMetadatas = this.ddService.getAllInactivationBlockingDefinitions(boClass = maintenanceDocument.getNewMaintainableObject().getDataObjectClass())) != null) {
            for (InactivationBlockingMetadata inactivationBlockingMetadata : inactivationBlockingMetadatas) {
                if (this.processInactivationBlockChecking(maintenanceDocument, inactivationBlockingMetadata)) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean processInactivationBlockChecking(MaintenanceDocument maintenanceDocument, InactivationBlockingMetadata inactivationBlockingMetadata) {
        if (this.newBo instanceof PersistableBusinessObject) {
            InactivationBlockingDetectionService inactivationBlockingDetectionService;
            boolean foundBlockingRecord;
            String inactivationBlockingDetectionServiceBeanName = inactivationBlockingMetadata.getInactivationBlockingDetectionServiceBeanName();
            if (StringUtils.isBlank((CharSequence)inactivationBlockingDetectionServiceBeanName)) {
                inactivationBlockingDetectionServiceBeanName = "cf.inactivationBlockingDetectionService";
            }
            if (foundBlockingRecord = (inactivationBlockingDetectionService = KRADServiceLocatorWeb.getInactivationBlockingDetectionService(inactivationBlockingDetectionServiceBeanName)).hasABlockingRecord((PersistableBusinessObject)this.newBo, inactivationBlockingMetadata)) {
                this.putInactivationBlockingErrorOnPage(maintenanceDocument, inactivationBlockingMetadata);
            }
            return !foundBlockingRecord;
        }
        return true;
    }

    protected void putInactivationBlockingErrorOnPage(MaintenanceDocument document, InactivationBlockingMetadata inactivationBlockingMetadata) {
        if (!this.persistenceStructureService.hasPrimaryKeyFieldValues(this.newBo)) {
            throw new RuntimeException("Maintenance document did not have all primary key values filled in.");
        }
        Properties parameters = new Properties();
        parameters.put("businessObjectClassName", inactivationBlockingMetadata.getBlockedBusinessObjectClass().getName());
        parameters.put("methodToCall", "displayAllInactivationBlockers");
        List keys = new ArrayList();
        if (this.getPersistenceStructureService().isPersistable(this.newBo.getClass())) {
            keys = this.getPersistenceStructureService().listPrimaryKeyFieldNames(this.newBo.getClass());
        }
        String keyName2 = null;
        for (String keyName2 : keys) {
            Object keyValue = null;
            if (keyName2 != null) {
                keyValue = ObjectUtils.getPropertyValue(this.newBo, keyName2);
            }
            if (keyValue == null) {
                keyValue = "";
            } else if (keyValue instanceof Date) {
                if (Formatter.findFormatter(keyValue.getClass()) != null) {
                    Formatter formatter = Formatter.getFormatter(keyValue.getClass());
                    keyValue = (String)formatter.format(keyValue);
                }
            } else {
                keyValue = keyValue.toString();
            }
            if (this.businessObjectAuthorizationService.attributeValueNeedsToBeEncryptedOnFormsAndLinks(inactivationBlockingMetadata.getBlockedBusinessObjectClass(), keyName2)) {
                try {
                    if (CoreApiServiceLocator.getEncryptionService().isEnabled()) {
                        keyValue = CoreApiServiceLocator.getEncryptionService().encrypt(keyValue);
                    }
                }
                catch (GeneralSecurityException e) {
                    LOG.error((Object)"Exception while trying to encrypted value for inquiry framework.", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
            parameters.put(keyName2, keyValue);
        }
        String blockingUrl = UrlFactory.parameterizeUrl("inactivationBlockers.do", parameters);
        GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.inactivation.blocked", blockingUrl);
    }

    @Override
    public boolean processApproveDocument(ApproveDocumentEvent approveEvent) {
        MaintenanceDocument maintenanceDocument = (MaintenanceDocument)approveEvent.getDocument();
        this.clearErrorPath();
        this.setupBaseConvenienceObjects(maintenanceDocument);
        this.processGlobalSaveDocumentBusinessRules(maintenanceDocument);
        boolean success = true;
        success &= this.processGlobalApproveDocumentBusinessRules(maintenanceDocument);
        this.resumeErrorPath();
        return success &= this.processCustomApproveDocumentBusinessRules(maintenanceDocument);
    }

    protected void putGlobalError(String errorConstant) {
        if (!this.errorAlreadyExists("document.document*,document.explanation*,document.reversal*,document.selected*,document.header*", errorConstant)) {
            GlobalVariables.getMessageMap().putErrorWithoutFullErrorPath("document.document*,document.explanation*,document.reversal*,document.selected*,document.header*", errorConstant, new String[0]);
        }
    }

    protected void putGlobalError(String errorConstant, String parameter) {
        if (!this.errorAlreadyExists("document.document*,document.explanation*,document.reversal*,document.selected*,document.header*", errorConstant)) {
            GlobalVariables.getMessageMap().putErrorWithoutFullErrorPath("document.document*,document.explanation*,document.reversal*,document.selected*,document.header*", errorConstant, parameter);
        }
    }

    protected void putGlobalError(String errorConstant, String[] parameters) {
        if (!this.errorAlreadyExists("document.document*,document.explanation*,document.reversal*,document.selected*,document.header*", errorConstant)) {
            GlobalVariables.getMessageMap().putErrorWithoutFullErrorPath("document.document*,document.explanation*,document.reversal*,document.selected*,document.header*", errorConstant, parameters);
        }
    }

    protected void putFieldError(String propertyName, String errorConstant) {
        if (!this.errorAlreadyExists(MAINTAINABLE_ERROR_PREFIX + propertyName, errorConstant)) {
            GlobalVariables.getMessageMap().putErrorWithoutFullErrorPath(MAINTAINABLE_ERROR_PREFIX + propertyName, errorConstant, new String[0]);
        }
    }

    protected void putFieldError(String propertyName, String errorConstant, String parameter) {
        if (!this.errorAlreadyExists(MAINTAINABLE_ERROR_PREFIX + propertyName, errorConstant)) {
            GlobalVariables.getMessageMap().putErrorWithoutFullErrorPath(MAINTAINABLE_ERROR_PREFIX + propertyName, errorConstant, parameter);
        }
    }

    protected void putFieldError(String propertyName, String errorConstant, String[] parameters) {
        if (!this.errorAlreadyExists(MAINTAINABLE_ERROR_PREFIX + propertyName, errorConstant)) {
            GlobalVariables.getMessageMap().putErrorWithoutFullErrorPath(MAINTAINABLE_ERROR_PREFIX + propertyName, errorConstant, parameters);
        }
    }

    protected void putFieldErrorWithShortLabel(String propertyName, String errorConstant) {
        String shortLabel = this.ddService.getAttributeShortLabel(this.boClass, propertyName);
        this.putFieldError(propertyName, errorConstant, shortLabel);
    }

    protected void putDocumentError(String propertyName, String errorConstant, String parameter) {
        if (!this.errorAlreadyExists(DOCUMENT_ERROR_PREFIX + propertyName, errorConstant)) {
            GlobalVariables.getMessageMap().putError(DOCUMENT_ERROR_PREFIX + propertyName, errorConstant, parameter);
        }
    }

    protected void putDocumentError(String propertyName, String errorConstant, String[] parameters) {
        GlobalVariables.getMessageMap().putError(DOCUMENT_ERROR_PREFIX + propertyName, errorConstant, parameters);
    }

    protected boolean errorAlreadyExists(String propertyName, String errorConstant) {
        return GlobalVariables.getMessageMap().fieldHasMessage(propertyName, errorConstant);
    }

    protected void putGlobalsError(String propertyName, String errorConstant) {
        if (!this.errorAlreadyExists(propertyName, errorConstant)) {
            GlobalVariables.getMessageMap().putErrorWithoutFullErrorPath(propertyName, errorConstant, new String[0]);
        }
    }

    protected void putGlobalsError(String propertyName, String errorConstant, String parameter) {
        if (!this.errorAlreadyExists(propertyName, errorConstant)) {
            GlobalVariables.getMessageMap().putErrorWithoutFullErrorPath(propertyName, errorConstant, parameter);
        }
    }

    protected void clearErrorPath() {
        this.priorErrorPath.addAll(GlobalVariables.getMessageMap().getErrorPath());
        GlobalVariables.getMessageMap().getErrorPath().clear();
    }

    protected void resumeErrorPath() {
        GlobalVariables.getMessageMap().getErrorPath().addAll(this.priorErrorPath);
    }

    protected boolean dataDictionaryValidate(MaintenanceDocument document) {
        LOG.debug((Object)"MaintenanceDocument validation beginning");
        GlobalVariables.getMessageMap().addToErrorPath(MAINTAINABLE_ERROR_PATH);
        Maintainable newMaintainable = document.getNewMaintainableObject();
        if (newMaintainable == null) {
            GlobalVariables.getMessageMap().removeFromErrorPath(MAINTAINABLE_ERROR_PATH);
            throw new ValidationException("Maintainable object from Maintenance Document '" + document.getDocumentTitle() + "' is null, unable to proceed.");
        }
        Object dataObject = newMaintainable.getDataObject();
        if (dataObject == null) {
            GlobalVariables.getMessageMap().removeFromErrorPath(MAINTAINABLE_ERROR_PREFIX);
            throw new ValidationException("Maintainable's component business object is null.");
        }
        if (this.newBo instanceof PersistableBusinessObject && CollectionUtils.isNotEmpty(this.maintDocDictionaryService.getMaintainableSections(document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName()))) {
            BusinessObject businessObject = (BusinessObject)this.newBo;
            this.maintDocDictionaryService.validateMaintenanceRequiredFields(document);
            this.maintDocDictionaryService.validateMaintainableCollectionsForDuplicateEntries(document);
            this.dictionaryValidationService.validateBusinessObjectOnMaintenanceDocument(businessObject, document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName());
            this.dictionaryValidationService.validateDefaultExistenceChecks(businessObject);
        } else {
            GlobalVariables.getMessageMap().addToErrorPath("dataObject");
            this.dictionaryValidationService.validate(this.newBo);
            GlobalVariables.getMessageMap().removeFromErrorPath("dataObject");
        }
        GlobalVariables.getMessageMap().removeFromErrorPath(MAINTAINABLE_ERROR_PATH);
        LOG.debug((Object)"MaintenanceDocument validation ending");
        return true;
    }

    protected boolean primaryKeyCheck(MaintenanceDocument document) {
        boolean success = true;
        Class boClass = document.getNewMaintainableObject().getDataObjectClass();
        Object oldBo = document.getOldMaintainableObject().getDataObject();
        Object newBo = document.getNewMaintainableObject().getDataObject();
        if (newBo instanceof GlobalBusinessObject) {
            return success;
        }
        if (document.isEdit()) {
            if (!this.getDataObjectMetaDataService().equalsByPrimaryKeys(oldBo, newBo)) {
                this.putDocumentError("document.document*,document.explanation*,document.reversal*,document.selected*,document.header*", "error.document.maintenance.general.primaryKeysChangedOnEdit", this.getHumanReadablePrimaryKeyFieldNames(boClass));
                success &= false;
            }
        } else if (document.isNew() && newBo instanceof PersistableBusinessObject) {
            Map<String, ?> newPkFields = this.getDataObjectMetaDataService().getPrimaryKeyFieldValues(newBo);
            PersistableBusinessObject testBo = this.boService.findByPrimaryKey(boClass.asSubclass(PersistableBusinessObject.class), newPkFields);
            if (testBo != null) {
                this.putDocumentError("document.document*,document.explanation*,document.reversal*,document.selected*,document.header*", "error.document.maintenance.general.objectAlreadyExistsByPrimaryKeysOnCreateNew", this.getHumanReadablePrimaryKeyFieldNames(boClass));
                success &= false;
            }
        }
        return success;
    }

    protected String getHumanReadablePrimaryKeyFieldNames(Class<?> boClass) {
        String delim = "";
        StringBuffer pkFieldNames = new StringBuffer();
        List<String> pkFields = this.getDataObjectMetaDataService().listPrimaryKeyFieldNames(boClass);
        for (String pkFieldName : pkFields) {
            String humanReadableFieldName = this.ddService.getAttributeLabel(boClass, pkFieldName);
            pkFieldNames.append(delim + humanReadableFieldName);
            if (!delim.equalsIgnoreCase("")) continue;
            delim = ", ";
        }
        return pkFieldNames.toString();
    }

    protected boolean processGlobalApproveDocumentBusinessRules(MaintenanceDocument document) {
        return true;
    }

    protected boolean processGlobalRouteDocumentBusinessRules(MaintenanceDocument document) {
        boolean success = true;
        return success &= this.checkEmptyDocumentField("documentHeader.documentDescription", document.getDocumentHeader().getDocumentDescription(), "Description");
    }

    protected boolean processGlobalSaveDocumentBusinessRules(MaintenanceDocument document) {
        boolean success = true;
        this.primaryKeyCheck(document);
        this.dataDictionaryValidate(document);
        return success;
    }

    protected boolean processCustomSaveDocumentBusinessRules(MaintenanceDocument document) {
        return true;
    }

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        return true;
    }

    protected boolean processCustomApproveDocumentBusinessRules(MaintenanceDocument document) {
        return true;
    }

    protected boolean isDocumentValidForSave(MaintenanceDocument maintenanceDocument) {
        boolean success = true;
        success &= super.isDocumentOverviewValid(maintenanceDocument);
        success &= this.validateDocumentStructure(maintenanceDocument);
        success &= this.validateMaintenanceDocument(maintenanceDocument);
        return success &= this.validateGlobalBusinessObjectPersistable(maintenanceDocument);
    }

    protected boolean validateDocumentStructure(Document document) {
        boolean success = true;
        String documentHeaderId = document.getDocumentNumber();
        if (documentHeaderId == null || StringUtils.isEmpty((CharSequence)documentHeaderId)) {
            throw new ValidationException("Document has no document number, unable to proceed.");
        }
        return success;
    }

    protected boolean validateMaintenanceDocument(MaintenanceDocument maintenanceDocument) {
        boolean success = true;
        Maintainable newMaintainable = maintenanceDocument.getNewMaintainableObject();
        if (newMaintainable == null) {
            throw new ValidationException("Maintainable object from Maintenance Document '" + maintenanceDocument.getDocumentTitle() + "' is null, unable to proceed.");
        }
        if (newMaintainable.getDataObject() == null) {
            throw new ValidationException("Maintainable's component data object is null.");
        }
        return success;
    }

    protected boolean validateGlobalBusinessObjectPersistable(MaintenanceDocument document) {
        boolean success = true;
        if (document.getNewMaintainableObject() == null) {
            return success;
        }
        if (document.getNewMaintainableObject().getDataObject() == null) {
            return success;
        }
        if (!(document.getNewMaintainableObject().getDataObject() instanceof GlobalBusinessObject)) {
            return success;
        }
        PersistableBusinessObject bo = (PersistableBusinessObject)document.getNewMaintainableObject().getDataObject();
        GlobalBusinessObject gbo = (GlobalBusinessObject)((Object)bo);
        return gbo.isPersistable();
    }

    protected boolean isCorrectMaintenanceClass(MaintenanceDocument document, Class clazz) {
        if (document == null || clazz == null) {
            throw new IllegalArgumentException("Null arguments were passed in.");
        }
        return clazz.toString().equals(document.getNewMaintainableObject().getDataObjectClass().toString());
    }

    protected boolean checkEmptyBOField(String propertyName, Object valueToTest, String parameter) {
        boolean success = true;
        success = this.checkEmptyValue(valueToTest);
        if (!success) {
            this.putFieldError(propertyName, "error.required", parameter);
        }
        return success;
    }

    protected boolean checkEmptyDocumentField(String propertyName, Object valueToTest, String parameter) {
        boolean success = true;
        success = this.checkEmptyValue(valueToTest);
        if (!success) {
            this.putDocumentError(propertyName, "error.required", parameter);
        }
        return success;
    }

    protected boolean checkEmptyValue(Object valueToTest) {
        boolean success = true;
        if (valueToTest == null) {
            success = false;
        } else if (valueToTest instanceof String && StringUtils.isBlank((CharSequence)((String)valueToTest))) {
            success = false;
        }
        return success;
    }

    protected void showErrorMap() {
        if (GlobalVariables.getMessageMap().hasNoErrors()) {
            return;
        }
        for (Map.Entry<String, AutoPopulatingList<ErrorMessage>> e : GlobalVariables.getMessageMap().getAllPropertiesAndErrors()) {
            AutoPopulatingList<ErrorMessage> errorList = e.getValue();
            for (ErrorMessage em : errorList) {
                if (em.getMessageParameters() == null) {
                    LOG.error((Object)(e.getKey().toString() + " = " + em.getErrorKey()));
                    continue;
                }
                LOG.error((Object)(e.getKey().toString() + " = " + em.getErrorKey() + " : " + em.getMessageParameters().toString()));
            }
        }
    }

    @Override
    public void setupBaseConvenienceObjects(MaintenanceDocument document) {
        this.oldBo = document.getOldMaintainableObject().getDataObject();
        if (this.oldBo != null && this.oldBo instanceof PersistableBusinessObject) {
            ((PersistableBusinessObject)this.oldBo).refreshNonUpdateableReferences();
        }
        this.newBo = document.getNewMaintainableObject().getDataObject();
        if (this.newBo instanceof PersistableBusinessObject) {
            ((PersistableBusinessObject)this.newBo).refreshNonUpdateableReferences();
        }
        this.boClass = document.getNewMaintainableObject().getDataObjectClass();
        this.setupConvenienceObjects();
    }

    @Override
    public void setupConvenienceObjects() {
    }

    protected boolean checkForPartiallyFilledOutReferenceForeignKeys(String referenceName) {
        ForeignKeyFieldsPopulationState fkFieldsState;
        boolean success = true;
        if (this.newBo instanceof PersistableBusinessObject && (fkFieldsState = this.persistenceStructureService.getForeignKeyFieldsPopulationState((PersistableBusinessObject)this.newBo, referenceName)).isAnyFieldsPopulated() && !fkFieldsState.isAllFieldsPopulated()) {
            success = false;
            ArrayList fKeys = new ArrayList(this.persistenceStructureService.getForeignKeysForReference(this.newBo.getClass().asSubclass(PersistableBusinessObject.class), referenceName).keySet());
            String fKeysReadable = this.consolidateFieldNames(fKeys, ", ").toString();
            for (String fieldName : fkFieldsState.getUnpopulatedFieldNames()) {
                String fieldNameReadable = this.ddService.getAttributeLabel(this.newBo.getClass(), fieldName);
                this.putFieldError(fieldName, "error.document.maintenance.partiallyFilledOutReferenceForeignKeys", new String[]{fieldNameReadable, fKeysReadable});
            }
        }
        return success;
    }

    protected StringBuffer consolidateFieldNames(List fieldNames, String delimiter) {
        StringBuffer sb = new StringBuffer();
        boolean firstPass = true;
        String delim = "";
        for (String fieldName : fieldNames) {
            sb.append(delim + this.ddService.getAttributeLabel(this.newBo.getClass(), fieldName));
            if (!firstPass) continue;
            delim = delimiter;
            firstPass = false;
        }
        return sb;
    }

    protected String getFieldLabel(String fieldName) {
        return this.ddService.getAttributeLabel(this.newBo.getClass(), fieldName) + "(" + this.ddService.getAttributeShortLabel(this.newBo.getClass(), fieldName) + ")";
    }

    protected String getFieldLabel(Class boClass, String fieldName) {
        return this.ddService.getAttributeLabel(boClass, fieldName) + "(" + this.ddService.getAttributeShortLabel(boClass, fieldName) + ")";
    }

    protected final BusinessObjectService getBoService() {
        return this.boService;
    }

    public final void setBoService(BusinessObjectService boService) {
        this.boService = boService;
    }

    protected final ConfigurationService getConfigService() {
        return this.configService;
    }

    public final void setConfigService(ConfigurationService configService) {
        this.configService = configService;
    }

    protected final DataDictionaryService getDdService() {
        return this.ddService;
    }

    public final void setDdService(DataDictionaryService ddService) {
        this.ddService = ddService;
    }

    @Override
    protected final DictionaryValidationService getDictionaryValidationService() {
        return this.dictionaryValidationService;
    }

    public final void setDictionaryValidationService(DictionaryValidationService dictionaryValidationService) {
        this.dictionaryValidationService = dictionaryValidationService;
    }

    protected final MaintenanceDocumentDictionaryService getMaintDocDictionaryService() {
        return this.maintDocDictionaryService;
    }

    public final void setMaintDocDictionaryService(MaintenanceDocumentDictionaryService maintDocDictionaryService) {
        this.maintDocDictionaryService = maintDocDictionaryService;
    }

    protected final Object getNewBo() {
        return this.newBo;
    }

    protected void setNewBo(Object newBo) {
        this.newBo = newBo;
    }

    protected final Object getOldBo() {
        return this.oldBo;
    }

    protected final PersistenceStructureService getPersistenceStructureService() {
        return this.persistenceStructureService;
    }

    public final void setPersistenceStructureService(PersistenceStructureService persistenceStructureService) {
        this.persistenceStructureService = persistenceStructureService;
    }

    public WorkflowDocumentService getWorkflowDocumentService() {
        return this.workflowDocumentService;
    }

    public void setWorkflowDocumentService(WorkflowDocumentService workflowDocumentService) {
        this.workflowDocumentService = workflowDocumentService;
    }

    @Override
    public boolean processAddCollectionLineBusinessRules(MaintenanceDocument document, String collectionName, PersistableBusinessObject bo) {
        LOG.debug((Object)"processAddCollectionLineBusinessRules");
        this.setupBaseConvenienceObjects(document);
        this.validateMaintenanceDocument(document);
        boolean success = true;
        MessageMap map = GlobalVariables.getMessageMap();
        int errorCount = map.getErrorCount();
        map.addToErrorPath(MAINTAINABLE_ERROR_PATH);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("processAddCollectionLineBusinessRules - BO: " + bo));
            LOG.debug((Object)("Before Validate: " + map));
        }
        this.getMaintDocDictionaryService().validateMaintainableCollectionsAddLineRequiredFields(document, document.getNewMaintainableObject().getBusinessObject(), collectionName);
        String errorPath = "add." + collectionName;
        map.addToErrorPath(errorPath);
        this.getDictionaryValidationService().validateBusinessObject(bo, false);
        success &= map.getErrorCount() == errorCount;
        success &= this.dictionaryValidationService.validateDefaultExistenceChecksForNewCollectionItem(document.getNewMaintainableObject().getBusinessObject(), (BusinessObject)bo, collectionName);
        success &= this.validateDuplicateIdentifierInDataDictionary(document, collectionName, bo);
        success &= this.processCustomAddCollectionLineBusinessRules(document, collectionName, bo);
        map.removeFromErrorPath(errorPath);
        map.removeFromErrorPath(MAINTAINABLE_ERROR_PATH);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("After Validate: " + map));
            LOG.debug((Object)("processAddCollectionLineBusinessRules returning: " + success));
        }
        return success;
    }

    protected boolean validateDuplicateIdentifierInDataDictionary(MaintenanceDocument document, String collectionName, PersistableBusinessObject bo) {
        boolean valid = true;
        PersistableBusinessObject maintBo = document.getNewMaintainableObject().getBusinessObject();
        Collection maintCollection = (Collection)ObjectUtils.getPropertyValue(maintBo, collectionName);
        List<String> duplicateIdentifier = document.getNewMaintainableObject().getDuplicateIdentifierFieldsFromDataDictionary(document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName(), collectionName);
        if (duplicateIdentifier.size() > 0) {
            List<String> existingIdentifierString = document.getNewMaintainableObject().getMultiValueIdentifierList(maintCollection, duplicateIdentifier);
            if (document.getNewMaintainableObject().hasBusinessObjectExisted(bo, existingIdentifierString, duplicateIdentifier)) {
                valid = false;
                GlobalVariables.getMessageMap().putError(duplicateIdentifier.get(0), "error.duplicate.element", "entries in ", document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName());
            }
        }
        return valid;
    }

    public boolean processCustomAddCollectionLineBusinessRules(MaintenanceDocument document, String collectionName, PersistableBusinessObject line) {
        return true;
    }

    @Override
    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public DateTimeService getDateTimeService() {
        return CoreApiServiceLocator.getDateTimeService();
    }

    public DocumentHelperService getDocumentHelperService() {
        return this.documentHelperService;
    }

    public void setDocumentHelperService(DocumentHelperService documentHelperService) {
        this.documentHelperService = documentHelperService;
    }

    protected RoleService getRoleService() {
        if (this.roleService == null) {
            this.roleService = KimApiServiceLocator.getRoleService();
        }
        return this.roleService;
    }

    protected DataObjectMetaDataService getDataObjectMetaDataService() {
        if (this.dataObjectMetaDataService == null) {
            this.dataObjectMetaDataService = KRADServiceLocatorWeb.getDataObjectMetaDataService();
        }
        return this.dataObjectMetaDataService;
    }

    public void setDataObjectMetaDataService(DataObjectMetaDataService dataObjectMetaDataService) {
        this.dataObjectMetaDataService = dataObjectMetaDataService;
    }

    public void setBusinessObjectAuthorizationService(BusinessObjectAuthorizationService businessObjectAuthorizationService) {
        this.businessObjectAuthorizationService = businessObjectAuthorizationService;
    }

    public void setBusinessObjectMetaDataService(BusinessObjectMetaDataService businessObjectMetaDataService) {
        this.businessObjectMetaDataService = businessObjectMetaDataService;
    }

    public void setBoDictionaryService(BusinessObjectDictionaryService boDictionaryService) {
        this.boDictionaryService = boDictionaryService;
    }
}

