/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.kns.service.impl;

import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.kns.datadictionary.KNSDocumentEntry;
import org.kuali.kfs.kns.datadictionary.MaintenanceDocumentEntry;
import org.kuali.kfs.kns.datadictionary.TransactionalDocumentEntry;
import org.kuali.kfs.kns.document.authorization.DocumentAuthorizer;
import org.kuali.kfs.kns.document.authorization.DocumentAuthorizerBase;
import org.kuali.kfs.kns.document.authorization.DocumentPresentationController;
import org.kuali.kfs.kns.document.authorization.DocumentPresentationControllerBase;
import org.kuali.kfs.kns.document.authorization.MaintenanceDocumentAuthorizerBase;
import org.kuali.kfs.kns.document.authorization.MaintenanceDocumentPresentationControllerBase;
import org.kuali.kfs.kns.document.authorization.TransactionalDocumentAuthorizerBase;
import org.kuali.kfs.kns.document.authorization.TransactionalDocumentPresentationControllerBase;
import org.kuali.kfs.kns.service.DocumentHelperService;
import org.kuali.kfs.krad.datadictionary.DataDictionary;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.DataDictionaryService;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;

public class DocumentHelperServiceImpl
implements DocumentHelperService {
    private DataDictionaryService dataDictionaryService;

    @Override
    public DocumentAuthorizer getDocumentAuthorizer(String documentType) {
        DataDictionary dataDictionary = this.getDataDictionaryService().getDataDictionary();
        if (StringUtils.isBlank((CharSequence)documentType)) {
            throw new IllegalArgumentException("invalid (blank) documentType");
        }
        KNSDocumentEntry documentEntry = (KNSDocumentEntry)((Object)dataDictionary.getDocumentEntry(documentType));
        if (documentEntry == null) {
            throw new IllegalArgumentException("unknown documentType '" + documentType + "'");
        }
        Class<? extends DocumentAuthorizer> documentAuthorizerClass = documentEntry.getDocumentAuthorizerClass();
        DocumentAuthorizer documentAuthorizer = null;
        try {
            documentAuthorizer = documentAuthorizerClass != null ? documentAuthorizerClass.newInstance() : (documentEntry instanceof MaintenanceDocumentEntry ? new MaintenanceDocumentAuthorizerBase() : (documentEntry instanceof TransactionalDocumentEntry ? new TransactionalDocumentAuthorizerBase() : new DocumentAuthorizerBase()));
        }
        catch (Exception e) {
            throw new RuntimeException("unable to instantiate documentAuthorizer '" + documentAuthorizerClass.getName() + "' for doctype '" + documentType + "'", e);
        }
        return documentAuthorizer;
    }

    @Override
    public DocumentAuthorizer getDocumentAuthorizer(Document document) {
        if (document == null) {
            throw new IllegalArgumentException("invalid (null) document");
        }
        if (document.getDocumentHeader() == null) {
            throw new IllegalArgumentException("invalid (null) document.documentHeader");
        }
        if (!document.getDocumentHeader().hasWorkflowDocument()) {
            throw new IllegalArgumentException("invalid (null) document.documentHeader.workflowDocument");
        }
        String documentType = document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName();
        DocumentAuthorizer documentAuthorizer = this.getDocumentAuthorizer(documentType);
        return documentAuthorizer;
    }

    @Override
    public DocumentPresentationController getDocumentPresentationController(String documentType) {
        DataDictionary dataDictionary = this.getDataDictionaryService().getDataDictionary();
        DocumentPresentationController documentPresentationController = null;
        if (StringUtils.isBlank((CharSequence)documentType)) {
            throw new IllegalArgumentException("invalid (blank) documentType");
        }
        KNSDocumentEntry documentEntry = (KNSDocumentEntry)((Object)dataDictionary.getDocumentEntry(documentType));
        if (documentEntry == null) {
            throw new IllegalArgumentException("unknown documentType '" + documentType + "'");
        }
        Class<? extends DocumentPresentationController> documentPresentationControllerClass = null;
        try {
            KNSDocumentEntry doc;
            documentPresentationControllerClass = documentEntry.getDocumentPresentationControllerClass();
            documentPresentationController = documentPresentationControllerClass != null ? documentPresentationControllerClass.newInstance() : ((doc = (KNSDocumentEntry)((Object)dataDictionary.getDocumentEntry(documentType))) instanceof TransactionalDocumentEntry ? new TransactionalDocumentPresentationControllerBase() : (doc instanceof MaintenanceDocumentEntry ? new MaintenanceDocumentPresentationControllerBase() : new DocumentPresentationControllerBase()));
        }
        catch (Exception e) {
            throw new RuntimeException("unable to instantiate documentPresentationController '" + documentPresentationControllerClass.getName() + "' for doctype '" + documentType + "'", e);
        }
        return documentPresentationController;
    }

    @Override
    public DocumentPresentationController getDocumentPresentationController(Document document) {
        if (document == null) {
            throw new IllegalArgumentException("invalid (null) document");
        }
        if (document.getDocumentHeader() == null) {
            throw new IllegalArgumentException("invalid (null) document.documentHeader");
        }
        if (!document.getDocumentHeader().hasWorkflowDocument()) {
            throw new IllegalArgumentException("invalid (null) document.documentHeader.workflowDocument");
        }
        String documentType = document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName();
        DocumentPresentationController documentPresentationController = this.getDocumentPresentationController(documentType);
        return documentPresentationController;
    }

    public DataDictionaryService getDataDictionaryService() {
        if (this.dataDictionaryService == null) {
            this.dataDictionaryService = KRADServiceLocatorWeb.getDataDictionaryService();
        }
        return this.dataDictionaryService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }
}

