/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.kns.util.documentserlializer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.kns.datadictionary.MaintainableCollectionDefinition;
import org.kuali.kfs.kns.datadictionary.MaintainableFieldDefinition;
import org.kuali.kfs.kns.datadictionary.MaintainableItemDefinition;
import org.kuali.kfs.kns.datadictionary.MaintainableSectionDefinition;
import org.kuali.kfs.kns.datadictionary.MaintainableSubSectionHeaderDefinition;
import org.kuali.kfs.kns.datadictionary.MaintenanceDocumentEntry;
import org.kuali.kfs.krad.datadictionary.DataDictionary;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.util.documentserializer.PropertySerializabilityEvaluator;
import org.kuali.kfs.krad.util.documentserializer.PropertySerializabilityEvaluatorBase;
import org.kuali.kfs.krad.util.documentserializer.PropertySerializerTrie;
import org.kuali.kfs.krad.util.documentserializer.PropertyType;
import org.kuali.rice.krad.bo.BusinessObject;

public class MaintenanceDocumentPropertySerializibilityEvaluator
extends PropertySerializabilityEvaluatorBase
implements PropertySerializabilityEvaluator {
    @Override
    public void initializeEvaluatorForDataObject(Object businessObject) {
        DataDictionary dictionary = KRADServiceLocatorWeb.getDataDictionaryService().getDataDictionary();
        MaintenanceDocumentEntry maintenanceDocumentEntry = (MaintenanceDocumentEntry)dictionary.getMaintenanceDocumentEntryForBusinessObjectClass(businessObject.getClass());
        this.serializableProperties = new PropertySerializerTrie();
        this.populateSerializableProperties(maintenanceDocumentEntry.getMaintainableSections());
        this.serializableProperties.addSerializablePropertyName("boNotes", true);
        this.serializableProperties.addSerializablePropertyName("boNotes.attachment", true);
    }

    @Override
    public PropertyType determinePropertyType(Object propertyValue) {
        if (propertyValue == null) {
            return PropertyType.PRIMITIVE;
        }
        if (propertyValue instanceof BusinessObject) {
            return PropertyType.BUSINESS_OBJECT;
        }
        if (propertyValue instanceof Collection) {
            return PropertyType.COLLECTION;
        }
        if (propertyValue instanceof Map) {
            return PropertyType.PRIMITIVE;
        }
        return PropertyType.PRIMITIVE;
    }

    private void populateSerializableProperties(List<MaintainableSectionDefinition> maintainableSectionDefinitions) {
        for (MaintainableSectionDefinition maintainableSectionDefinition : maintainableSectionDefinitions) {
            this.populateSerializablePropertiesWithItems("", maintainableSectionDefinition.getMaintainableItems());
        }
    }

    private void populateSerializablePropertiesWithItems(String basePath, List<MaintainableItemDefinition> maintainableItems) {
        for (MaintainableItemDefinition maintainableItemDefinition : maintainableItems) {
            if (maintainableItemDefinition instanceof MaintainableFieldDefinition) {
                this.serializableProperties.addSerializablePropertyName(this.getFullItemName(basePath, maintainableItemDefinition.getName()), true);
                continue;
            }
            if (maintainableItemDefinition instanceof MaintainableCollectionDefinition) {
                this.serializableProperties.addSerializablePropertyName(this.getFullItemName(basePath, maintainableItemDefinition.getName()), true);
                this.populateSerializablePropertiesWithItems(this.getFullItemName(basePath, maintainableItemDefinition.getName()), this.getAllMaintainableFieldDefinitionsForSerialization((MaintainableCollectionDefinition)maintainableItemDefinition));
                continue;
            }
            if (!(maintainableItemDefinition instanceof MaintainableSubSectionHeaderDefinition)) continue;
        }
    }

    private String getFullItemName(String basePath, String itemName) {
        return StringUtils.isEmpty((CharSequence)basePath) ? itemName : basePath + "." + itemName;
    }

    public List<MaintainableItemDefinition> getAllMaintainableFieldDefinitionsForSerialization(MaintainableCollectionDefinition maintainableCollectionDefinition) {
        ArrayList<MaintainableItemDefinition> allMaintainableItemDefinitions = new ArrayList<MaintainableItemDefinition>();
        if (maintainableCollectionDefinition.getMaintainableFields() != null) {
            allMaintainableItemDefinitions.addAll(maintainableCollectionDefinition.getMaintainableFields());
        }
        if (maintainableCollectionDefinition.getSummaryFields() != null) {
            allMaintainableItemDefinitions.addAll(maintainableCollectionDefinition.getSummaryFields());
        }
        if (maintainableCollectionDefinition.getDuplicateIdentificationFields() != null) {
            allMaintainableItemDefinitions.addAll(maintainableCollectionDefinition.getDuplicateIdentificationFields());
        }
        if (maintainableCollectionDefinition.getMaintainableCollections() != null) {
            allMaintainableItemDefinitions.addAll(maintainableCollectionDefinition.getMaintainableCollections());
        }
        return allMaintainableItemDefinitions;
    }
}

