/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.kns.web.struts.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kfs.kns.lookup.HtmlData;
import org.kuali.kfs.kns.lookup.LookupResultsService;
import org.kuali.kfs.kns.lookup.LookupUtils;
import org.kuali.kfs.kns.lookup.Lookupable;
import org.kuali.kfs.kns.service.KNSServiceLocator;
import org.kuali.kfs.kns.web.struts.action.KualiLookupAction;
import org.kuali.kfs.kns.web.struts.action.KualiTableRenderAction;
import org.kuali.kfs.kns.web.struts.form.MultipleValueLookupForm;
import org.kuali.kfs.kns.web.ui.Column;
import org.kuali.kfs.kns.web.ui.ResultRow;
import org.kuali.kfs.krad.lookup.CollectionIncomplete;
import org.kuali.kfs.krad.service.KRADServiceLocator;
import org.kuali.kfs.krad.service.SequenceAccessorService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.rice.krad.bo.BusinessObject;

public class KualiMultipleValueLookupAction
extends KualiLookupAction
implements KualiTableRenderAction {
    private static final Logger LOG = Logger.getLogger(KualiMultipleValueLookupAction.class);
    public static final int DEFAULT_MAX_ROWS_PER_PAGE = 50;

    @Override
    public ActionForward search(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Lookupable kualiLookupable;
        MultipleValueLookupForm multipleValueLookupForm = (MultipleValueLookupForm)form;
        String methodToCall = this.findMethodToCall(form, request);
        if (methodToCall.equalsIgnoreCase("search")) {
            GlobalVariables.getUserSession().removeObjectsByPrefix("search");
        }
        if ((kualiLookupable = multipleValueLookupForm.getLookupable()) == null) {
            LOG.error((Object)"Lookupable is null.");
            throw new RuntimeException("Lookupable is null.");
        }
        Collection displayList = new ArrayList();
        ArrayList<ResultRow> resultTable = new ArrayList<ResultRow>();
        kualiLookupable.validateSearchParameters(multipleValueLookupForm.getFields());
        boolean bounded = true;
        displayList = this.performMultipleValueLookup(multipleValueLookupForm, resultTable, this.getMaxRowsPerPage(multipleValueLookupForm), bounded);
        if (kualiLookupable.isSearchUsingOnlyPrimaryKeyValues()) {
            multipleValueLookupForm.setSearchUsingOnlyPrimaryKeyValues(true);
            multipleValueLookupForm.setPrimaryKeyFieldLabels(kualiLookupable.getPrimaryKeyFieldLabels());
        } else {
            multipleValueLookupForm.setSearchUsingOnlyPrimaryKeyValues(false);
            multipleValueLookupForm.setPrimaryKeyFieldLabels("");
        }
        if (displayList instanceof CollectionIncomplete) {
            request.setAttribute("reqSearchResultsActualSize", (Object)((CollectionIncomplete)displayList).getActualSizeIfTruncated());
        } else {
            request.setAttribute("reqSearchResultsActualSize", (Object)displayList.size());
        }
        request.setAttribute("reqSearchResults", resultTable);
        if (displayList instanceof CollectionIncomplete) {
            multipleValueLookupForm.setResultsActualSize((int)((CollectionIncomplete)displayList).getActualSizeIfTruncated().longValue());
        } else {
            multipleValueLookupForm.setResultsActualSize(displayList.size());
        }
        multipleValueLookupForm.setResultsLimitedSize(resultTable.size());
        if (request.getParameter("searchResultKey") != null) {
            GlobalVariables.getUserSession().removeObject(request.getParameter("searchResultKey"));
        }
        request.setAttribute("searchResultKey", (Object)GlobalVariables.getUserSession().addObjectWithGeneratedKey(resultTable, "searchResults"));
        request.getParameter("refreshCaller");
        return mapping.findForward("basic");
    }

    @Override
    public ActionForward switchToPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MultipleValueLookupForm multipleValueLookupForm = (MultipleValueLookupForm)form;
        List<ResultRow> resultTable = this.switchToPage(multipleValueLookupForm, this.getMaxRowsPerPage(multipleValueLookupForm));
        request.setAttribute("reqSearchResults", resultTable);
        return mapping.findForward("basic");
    }

    @Override
    public ActionForward sort(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MultipleValueLookupForm multipleValueLookupForm = (MultipleValueLookupForm)form;
        List<ResultRow> resultTable = this.sort(multipleValueLookupForm, this.getMaxRowsPerPage(multipleValueLookupForm));
        request.setAttribute("reqSearchResults", resultTable);
        return mapping.findForward("basic");
    }

    public ActionForward prepareToReturnSelectedResults(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MultipleValueLookupForm multipleValueLookupForm = (MultipleValueLookupForm)form;
        if (StringUtils.isBlank((CharSequence)multipleValueLookupForm.getLookupResultsSequenceNumber())) {
            return this.prepareToReturnNone(mapping, form, request, response);
        }
        this.prepareToReturnSelectedResultBOs(multipleValueLookupForm);
        Properties parameters = new Properties();
        parameters.put("lookupResultsBOClassName", multipleValueLookupForm.getBusinessObjectClassName());
        parameters.put("lookupResultsSequenceNumber", multipleValueLookupForm.getLookupResultsSequenceNumber());
        parameters.put("docFormKey", multipleValueLookupForm.getFormKey());
        parameters.put("methodToCall", "refresh");
        parameters.put("refreshCaller", "multipleValues");
        if (!StringUtils.isBlank((CharSequence)multipleValueLookupForm.getLookupAnchor())) {
            parameters.put("anchor", multipleValueLookupForm.getLookupAnchor());
        }
        parameters.put("lookedUpCollectionName", multipleValueLookupForm.getLookedUpCollectionName());
        if (multipleValueLookupForm.getDocNum() != null) {
            parameters.put("docNum", multipleValueLookupForm.getDocNum());
        }
        String backUrl = UrlFactory.parameterizeUrl(multipleValueLookupForm.getBackLocation(), parameters);
        return new ActionForward(backUrl, true);
    }

    public ActionForward selectAll(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MultipleValueLookupForm multipleValueLookupForm = (MultipleValueLookupForm)form;
        List<ResultRow> resultTable = this.selectAll(multipleValueLookupForm, this.getMaxRowsPerPage(multipleValueLookupForm));
        request.setAttribute("reqSearchResults", resultTable);
        return mapping.findForward("basic");
    }

    public ActionForward unselectAll(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MultipleValueLookupForm multipleValueLookupForm = (MultipleValueLookupForm)form;
        List<ResultRow> resultTable = this.unselectAll(multipleValueLookupForm, this.getMaxRowsPerPage(multipleValueLookupForm));
        request.setAttribute("reqSearchResults", resultTable);
        return mapping.findForward("basic");
    }

    @Override
    public ActionForward cancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.prepareToReturnNone(mapping, form, request, response);
    }

    public ActionForward prepareToReturnNone(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MultipleValueLookupForm multipleValueLookupForm = (MultipleValueLookupForm)form;
        this.prepareToReturnNone(multipleValueLookupForm);
        Properties parameters = new Properties();
        parameters.put("docFormKey", multipleValueLookupForm.getFormKey());
        parameters.put("methodToCall", "refresh");
        parameters.put("refreshCaller", "multipleValues");
        if (!StringUtils.isBlank((CharSequence)multipleValueLookupForm.getLookupAnchor())) {
            parameters.put("anchor", multipleValueLookupForm.getLookupAnchor());
        }
        if (multipleValueLookupForm.getDocNum() != null) {
            parameters.put("docNum", multipleValueLookupForm.getDocNum());
        }
        String backUrl = UrlFactory.parameterizeUrl(multipleValueLookupForm.getBackLocation(), parameters);
        return new ActionForward(backUrl, true);
    }

    public ActionForward export(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MultipleValueLookupForm multipleValueLookupForm = (MultipleValueLookupForm)form;
        List<ResultRow> resultTable = this.prepareToExport(multipleValueLookupForm);
        request.setAttribute("reqSearchResults", resultTable);
        return mapping.findForward("basic");
    }

    protected Collection performMultipleValueLookup(MultipleValueLookupForm multipleValueLookupForm, List<ResultRow> resultTable, int maxRowsPerPage, boolean bounded) {
        Lookupable lookupable = multipleValueLookupForm.getLookupable();
        Collection<? extends BusinessObject> displayList = lookupable.performLookup(multipleValueLookupForm, resultTable, bounded);
        List<String> defaultSortColumns = lookupable.getDefaultSortColumns();
        if (defaultSortColumns != null && !defaultSortColumns.isEmpty() && resultTable != null && !resultTable.isEmpty()) {
            String firstSortColumn = defaultSortColumns.get(0);
            int firstSortColumnIdx = -1;
            List<Column> columnsForFirstResultRow = resultTable.get(0).getColumns();
            for (int i = 0; i < columnsForFirstResultRow.size(); ++i) {
                if (!StringUtils.equals((CharSequence)firstSortColumn, (CharSequence)columnsForFirstResultRow.get(i).getPropertyName())) continue;
                firstSortColumnIdx = i;
                break;
            }
            multipleValueLookupForm.setColumnToSortIndex(firstSortColumnIdx);
        } else {
            multipleValueLookupForm.setColumnToSortIndex(-1);
        }
        multipleValueLookupForm.jumpToFirstPage(resultTable.size(), maxRowsPerPage);
        SequenceAccessorService sas = KRADServiceLocator.getSequenceAccessorService();
        Long nextSeq = sas.getNextAvailableSequenceNumber("KRNS_LOOKUP_RSLT_S");
        String lookupResultsSequenceNumber = nextSeq.toString();
        multipleValueLookupForm.setLookupResultsSequenceNumber(lookupResultsSequenceNumber);
        try {
            LookupResultsService lookupResultsService = KNSServiceLocator.getLookupResultsService();
            lookupResultsService.persistResultsTable(lookupResultsSequenceNumber, resultTable, GlobalVariables.getUserSession().getPerson().getPrincipalId());
        }
        catch (Exception e) {
            LOG.error((Object)"error occured trying to persist multiple lookup results", (Throwable)e);
            throw new RuntimeException("error occured trying to persist multiple lookup results");
        }
        multipleValueLookupForm.setCompositeObjectIdMap(new HashMap<String, String>());
        return displayList;
    }

    protected List<ResultRow> switchToPage(MultipleValueLookupForm multipleValueLookupForm, int maxRowsPerPage) {
        String lookupResultsSequenceNumber = multipleValueLookupForm.getLookupResultsSequenceNumber();
        List<ResultRow> resultTable = null;
        try {
            resultTable = KNSServiceLocator.getLookupResultsService().retrieveResultsTable(lookupResultsSequenceNumber, GlobalVariables.getUserSession().getPerson().getPrincipalId());
        }
        catch (Exception e) {
            LOG.error((Object)"error occured trying to retrieve multiple lookup results", (Throwable)e);
            throw new RuntimeException("error occured trying to retrieve multiple lookup results");
        }
        multipleValueLookupForm.jumpToPage(multipleValueLookupForm.getSwitchToPageNumber(), resultTable.size(), maxRowsPerPage);
        multipleValueLookupForm.setColumnToSortIndex(Integer.parseInt(multipleValueLookupForm.getPreviouslySortedColumnIndex()));
        multipleValueLookupForm.setCompositeObjectIdMap(LookupUtils.generateCompositeSelectedObjectIds(multipleValueLookupForm.getPreviouslySelectedObjectIdSet(), multipleValueLookupForm.getDisplayedObjectIdSet(), multipleValueLookupForm.getSelectedObjectIdSet()));
        return resultTable;
    }

    protected List<ResultRow> sort(MultipleValueLookupForm multipleValueLookupForm, int maxRowsPerPage) {
        String lookupResultsSequenceNumber = multipleValueLookupForm.getLookupResultsSequenceNumber();
        LookupResultsService lookupResultsService = KNSServiceLocator.getLookupResultsService();
        List<ResultRow> resultTable = null;
        try {
            resultTable = lookupResultsService.retrieveResultsTable(lookupResultsSequenceNumber, GlobalVariables.getUserSession().getPerson().getPrincipalId());
        }
        catch (Exception e) {
            LOG.error((Object)"error occured trying to retrieve multiple lookup results", (Throwable)e);
            throw new RuntimeException("error occured trying to retrieve multiple lookup results");
        }
        int columnToSortOn = multipleValueLookupForm.getColumnToSortIndex();
        int columnCurrentlySortedOn = Integer.parseInt(multipleValueLookupForm.getPreviouslySortedColumnIndex());
        if (columnToSortOn == columnCurrentlySortedOn) {
            Collections.reverse(resultTable);
        } else {
            Collections.sort(resultTable, new BeanComparator("columns[" + columnToSortOn + "].propertyValue", LookupUtils.findBestValueComparatorForColumn(resultTable, columnToSortOn)));
        }
        try {
            lookupResultsService.persistResultsTable(lookupResultsSequenceNumber, resultTable, GlobalVariables.getUserSession().getPerson().getPrincipalId());
        }
        catch (Exception e) {
            LOG.error((Object)"error occured trying to persist multiple lookup results", (Throwable)e);
            throw new RuntimeException("error occured trying to persist multiple lookup results");
        }
        multipleValueLookupForm.jumpToFirstPage(resultTable.size(), maxRowsPerPage);
        multipleValueLookupForm.setCompositeObjectIdMap(LookupUtils.generateCompositeSelectedObjectIds(multipleValueLookupForm.getPreviouslySelectedObjectIdSet(), multipleValueLookupForm.getDisplayedObjectIdSet(), multipleValueLookupForm.getSelectedObjectIdSet()));
        return resultTable;
    }

    protected void prepareToReturnSelectedResultBOs(MultipleValueLookupForm multipleValueLookupForm) {
        String lookupResultsSequenceNumber = multipleValueLookupForm.getLookupResultsSequenceNumber();
        if (StringUtils.isBlank((CharSequence)lookupResultsSequenceNumber)) {
            return;
        }
        Map<String, String> compositeObjectIdMap = LookupUtils.generateCompositeSelectedObjectIds(multipleValueLookupForm.getPreviouslySelectedObjectIdSet(), multipleValueLookupForm.getDisplayedObjectIdSet(), multipleValueLookupForm.getSelectedObjectIdSet());
        Set<String> compositeObjectIds = compositeObjectIdMap.keySet();
        try {
            LookupResultsService lookupResultsService = KNSServiceLocator.getLookupResultsService();
            lookupResultsService.persistSelectedObjectIds(lookupResultsSequenceNumber, compositeObjectIds, GlobalVariables.getUserSession().getPerson().getPrincipalId());
        }
        catch (Exception e) {
            LOG.error((Object)"error occured trying to retrieve selected multiple lookup results", (Throwable)e);
            throw new RuntimeException("error occured trying to retrieve selected multiple lookup results");
        }
    }

    protected void prepareToReturnNone(MultipleValueLookupForm multipleValueLookupForm) {
        String lookupResultsSequenceNumber = multipleValueLookupForm.getLookupResultsSequenceNumber();
        try {
            if (StringUtils.isNotBlank((CharSequence)lookupResultsSequenceNumber)) {
                LookupResultsService lookupResultsService = KNSServiceLocator.getLookupResultsService();
                lookupResultsService.clearPersistedLookupResults(lookupResultsSequenceNumber);
                multipleValueLookupForm.setLookupResultsSequenceNumber(null);
            }
        }
        catch (Exception e) {
            LOG.error((Object)("error occured trying to clear lookup results seq nbr " + lookupResultsSequenceNumber), (Throwable)e);
        }
    }

    protected List<ResultRow> prepareToExport(MultipleValueLookupForm multipleValueLookupForm) {
        String lookupResultsSequenceNumber = multipleValueLookupForm.getLookupResultsSequenceNumber();
        List<ResultRow> resultTable = null;
        try {
            LookupResultsService lookupResultsService = KNSServiceLocator.getLookupResultsService();
            resultTable = lookupResultsService.retrieveResultsTable(lookupResultsSequenceNumber, GlobalVariables.getUserSession().getPerson().getPrincipalId());
        }
        catch (Exception e) {
            LOG.error((Object)"error occured trying to export multiple lookup results", (Throwable)e);
            throw new RuntimeException("error occured trying to export multiple lookup results");
        }
        return resultTable;
    }

    protected List<ResultRow> selectAll(MultipleValueLookupForm multipleValueLookupForm, int maxRowsPerPage) {
        String lookupResultsSequenceNumber = multipleValueLookupForm.getLookupResultsSequenceNumber();
        List<ResultRow> resultTable = null;
        try {
            LookupResultsService lookupResultsService = KNSServiceLocator.getLookupResultsService();
            resultTable = lookupResultsService.retrieveResultsTable(lookupResultsSequenceNumber, GlobalVariables.getUserSession().getPerson().getPrincipalId());
        }
        catch (Exception e) {
            LOG.error((Object)"error occured trying to export multiple lookup results", (Throwable)e);
            throw new RuntimeException("error occured trying to export multiple lookup results");
        }
        HashMap<String, String> selectedObjectIds = new HashMap<String, String>();
        for (ResultRow row : resultTable) {
            String objId = row.getObjectId();
            HtmlData.InputHtmlData returnUrl = (HtmlData.InputHtmlData)row.getReturnUrlHtmlData();
            returnUrl.setChecked("checked");
            row.setReturnUrl(returnUrl.constructCompleteHtmlTag());
            if (objId == null) continue;
            selectedObjectIds.put(objId, objId);
        }
        multipleValueLookupForm.jumpToPage(multipleValueLookupForm.getViewedPageNumber(), resultTable.size(), maxRowsPerPage);
        multipleValueLookupForm.setColumnToSortIndex(Integer.parseInt(multipleValueLookupForm.getPreviouslySortedColumnIndex()));
        multipleValueLookupForm.setCompositeObjectIdMap(selectedObjectIds);
        return resultTable;
    }

    @Override
    public ActionForward clearValues(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        MultipleValueLookupForm multipleValueLookupForm = (MultipleValueLookupForm)form;
        this.prepareToReturnNone(multipleValueLookupForm);
        return super.clearValues(mapping, form, request, response);
    }

    protected List<ResultRow> unselectAll(MultipleValueLookupForm multipleValueLookupForm, int maxRowsPerPage) {
        String lookupResultsSequenceNumber = multipleValueLookupForm.getLookupResultsSequenceNumber();
        List<ResultRow> resultTable = null;
        try {
            LookupResultsService lookupResultsService = KNSServiceLocator.getLookupResultsService();
            resultTable = lookupResultsService.retrieveResultsTable(lookupResultsSequenceNumber, GlobalVariables.getUserSession().getPerson().getPrincipalId());
        }
        catch (Exception e) {
            LOG.error((Object)"error occured trying to export multiple lookup results", (Throwable)e);
            throw new RuntimeException("error occured trying to export multiple lookup results");
        }
        HashMap<String, String> selectedObjectIds = new HashMap<String, String>();
        multipleValueLookupForm.jumpToPage(multipleValueLookupForm.getViewedPageNumber(), resultTable.size(), maxRowsPerPage);
        multipleValueLookupForm.setColumnToSortIndex(Integer.parseInt(multipleValueLookupForm.getPreviouslySortedColumnIndex()));
        multipleValueLookupForm.setCompositeObjectIdMap(selectedObjectIds);
        return resultTable;
    }

    protected int getMaxRowsPerPage(MultipleValueLookupForm multipleValueLookupForm) {
        Integer appMaxRowsPerPage = LookupUtils.getApplicationMaximumSearchResulsPerPageForMultipleValueLookups();
        if (appMaxRowsPerPage == null) {
            LOG.warn((Object)"Couldn't find application results per page for MV lookups.  Using default of 50");
            appMaxRowsPerPage = new Integer(50);
        }
        return appMaxRowsPerPage;
    }
}

