/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.dao.impl;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryFactory;
import org.apache.ojb.broker.query.ReportQueryByCriteria;
import org.kuali.kfs.kns.lookup.LookupUtils;
import org.kuali.kfs.kns.service.KNSServiceLocator;
import org.kuali.kfs.krad.bo.InactivatableFromTo;
import org.kuali.kfs.krad.criteria.OjbUtility;
import org.kuali.kfs.krad.dao.LookupDao;
import org.kuali.kfs.krad.lookup.CollectionIncomplete;
import org.kuali.kfs.krad.service.DataDictionaryService;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.service.PersistenceStructureService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.search.SearchOperator;
import org.kuali.rice.core.api.util.type.TypeUtils;
import org.kuali.rice.core.framework.persistence.ojb.conversion.OjbCharBooleanConversion;
import org.kuali.rice.core.framework.persistence.ojb.dao.PlatformAwareDaoBaseOjb;
import org.kuali.rice.core.framework.persistence.platform.DatabasePlatform;
import org.kuali.rice.krad.bo.BusinessObject;
import org.springframework.dao.DataIntegrityViolationException;
import org.springmodules.orm.ojb.OjbOperationException;

public class LookupDaoOjb
extends PlatformAwareDaoBaseOjb
implements LookupDao,
OjbUtility {
    private static final Logger LOG = Logger.getLogger(LookupDaoOjb.class);
    private DateTimeService dateTimeService;
    private PersistenceStructureService persistenceStructureService;
    private DataDictionaryService dataDictionaryService;

    public Collection findCollectionBySearchHelper(Class businessObjectClass, Map formProps, boolean unbounded, boolean usePrimaryKeyValuesOnly) {
        LOG.debug((Object)"findCollectionBySearchHelper() started");
        BusinessObject businessObject = this.checkBusinessObjectClass(businessObjectClass);
        if (usePrimaryKeyValuesOnly) {
            return this.executeSearch(businessObjectClass, this.getCollectionCriteriaFromMapUsingPrimaryKeysOnly(businessObjectClass, formProps), unbounded);
        }
        Criteria crit = this.getCollectionCriteriaFromMap(businessObject, formProps);
        return this.executeSearch(businessObjectClass, crit, unbounded);
    }

    @Override
    public <T> T findObjectByMap(T example, Map<String, String> formProps) {
        LOG.debug((Object)"findObjectByMap() started");
        if (this.persistenceStructureService.isPersistable(example.getClass())) {
            Criteria criteria = new Criteria();
            for (Map.Entry<String, String> formProp : formProps.entrySet()) {
                String propertyName = formProp.getKey();
                String searchValue = "";
                if (formProp.getValue() != null) {
                    searchValue = formProp.getValue();
                }
                if (!(StringUtils.isNotBlank((CharSequence)searchValue) & PropertyUtils.isWriteable(example, (String)propertyName))) continue;
                Class propertyType = ObjectUtils.getPropertyType(example, propertyName, this.persistenceStructureService);
                if (TypeUtils.isIntegralClass((Class)propertyType) || TypeUtils.isDecimalClass((Class)propertyType)) {
                    criteria.addEqualTo(propertyName, (Object)this.cleanNumeric(searchValue));
                    continue;
                }
                if (TypeUtils.isTemporalClass((Class)propertyType)) {
                    criteria.addEqualTo(propertyName, (Object)this.parseDate(ObjectUtils.clean(searchValue)));
                    continue;
                }
                criteria.addEqualTo(propertyName, (Object)searchValue);
            }
            QueryByCriteria query = QueryFactory.newQuery(example.getClass(), (Criteria)criteria);
            return (T)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)query);
        }
        return null;
    }

    public Long findCountByMap(Object example, Map formProps) {
        LOG.debug((Object)"findCountByMap() started");
        Criteria criteria = new Criteria();
        for (String propertyName : formProps.keySet()) {
            Class propertyType;
            String searchValue = (String)formProps.get(propertyName);
            if (StringUtils.isBlank((CharSequence)searchValue) || !PropertyUtils.isWriteable((Object)example, (String)propertyName) || (propertyType = ObjectUtils.getPropertyType(example, propertyName, this.persistenceStructureService)) == null) continue;
            Boolean caseInsensitive = Boolean.TRUE;
            if (KRADServiceLocatorWeb.getDataDictionaryService().isAttributeDefined(example.getClass(), propertyName).booleanValue()) {
                caseInsensitive = KRADServiceLocatorWeb.getDataDictionaryService().getAttributeForceUppercase(example.getClass(), propertyName) == false;
            }
            if (caseInsensitive == null) {
                caseInsensitive = Boolean.TRUE;
            }
            boolean treatWildcardsAndOperatorsAsLiteral = KNSServiceLocator.getBusinessObjectDictionaryService().isLookupFieldTreatWildcardsAndOperatorsAsLiteral(example.getClass(), propertyName);
            if (!caseInsensitive.booleanValue()) {
                searchValue = searchValue.toUpperCase();
            }
            this.addCriteria(propertyName, searchValue, propertyType, caseInsensitive, treatWildcardsAndOperatorsAsLiteral, criteria);
        }
        QueryByCriteria query = QueryFactory.newQuery(example.getClass(), (Criteria)criteria);
        return new Long(this.getPersistenceBrokerTemplate().getCount((Query)query));
    }

    @Override
    public boolean createCriteria(Object example, String searchValue, String propertyName, Object criteria) {
        LOG.debug((Object)"createCriteria() started");
        return this.createCriteria(example, searchValue, propertyName, false, false, criteria);
    }

    @Override
    public boolean createCriteria(Object example, String searchValue, String propertyName, boolean caseInsensitive, boolean treatWildcardsAndOperatorsAsLiteral, Object criteria) {
        LOG.debug((Object)"createCriteria() started");
        return this.createCriteria(example, searchValue, propertyName, caseInsensitive, treatWildcardsAndOperatorsAsLiteral, criteria, null);
    }

    @Override
    public Criteria getCollectionCriteriaFromMap(BusinessObject example, Map formProps) {
        LOG.debug((Object)"getCollectionCriteriaFromMap() started");
        Criteria criteria = new Criteria();
        for (String propertyName : formProps.keySet()) {
            Boolean caseInsensitive = Boolean.TRUE;
            if (KRADServiceLocatorWeb.getDataDictionaryService().isAttributeDefined(example.getClass(), propertyName).booleanValue()) {
                caseInsensitive = KRADServiceLocatorWeb.getDataDictionaryService().getAttributeForceUppercase(example.getClass(), propertyName) == false;
            }
            if (caseInsensitive == null) {
                caseInsensitive = Boolean.TRUE;
            }
            boolean treatWildcardsAndOperatorsAsLiteral = KNSServiceLocator.getBusinessObjectDictionaryService().isLookupFieldTreatWildcardsAndOperatorsAsLiteral(example.getClass(), propertyName);
            if (formProps.get(propertyName) instanceof Collection) {
                for (String searchValue : (Collection)formProps.get(propertyName)) {
                    if (!caseInsensitive.booleanValue()) {
                        searchValue = searchValue.toUpperCase();
                    }
                    if (this.createCriteria(example, searchValue, propertyName, caseInsensitive, treatWildcardsAndOperatorsAsLiteral, criteria, formProps)) continue;
                    throw new RuntimeException("Invalid value in Collection");
                }
                continue;
            }
            String searchValue = (String)formProps.get(propertyName);
            if (!caseInsensitive.booleanValue()) {
                searchValue = searchValue.toUpperCase();
            }
            if (this.createCriteria(example, searchValue, propertyName, caseInsensitive, treatWildcardsAndOperatorsAsLiteral, criteria, formProps)) continue;
        }
        return criteria;
    }

    protected Criteria getCollectionCriteriaFromMapUsingPrimaryKeysOnly(Class businessObjectClass, Map formProps) {
        BusinessObject businessObject = this.checkBusinessObjectClass(businessObjectClass);
        Criteria criteria = new Criteria();
        List<String> pkFields = KRADServiceLocatorWeb.getDataObjectMetaDataService().listPrimaryKeyFieldNames(businessObjectClass);
        for (String pkFieldName : pkFields) {
            String pkValue = (String)formProps.get(pkFieldName);
            if (StringUtils.isBlank((CharSequence)pkValue)) {
                throw new RuntimeException("Missing pk value for field " + pkFieldName + " when a search based on PK values only is performed.");
            }
            for (SearchOperator op : SearchOperator.QUERY_CHARACTERS) {
                if (!pkValue.contains(op.op())) continue;
                throw new RuntimeException("Value \"" + pkValue + "\" for PK field " + pkFieldName + " contains wildcard/operator characters.");
            }
            boolean treatWildcardsAndOperatorsAsLiteral = KNSServiceLocator.getBusinessObjectDictionaryService().isLookupFieldTreatWildcardsAndOperatorsAsLiteral(businessObjectClass, pkFieldName);
            this.createCriteria(businessObject, pkValue, pkFieldName, false, treatWildcardsAndOperatorsAsLiteral, criteria);
        }
        return criteria;
    }

    protected BusinessObject checkBusinessObjectClass(Class businessObjectClass) {
        if (businessObjectClass == null) {
            throw new IllegalArgumentException("BusinessObject class passed to LookupDaoOjb findCollectionBySearchHelper... method was null");
        }
        BusinessObject businessObject = null;
        try {
            businessObject = (BusinessObject)businessObjectClass.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("LookupDaoOjb could not get instance of " + businessObjectClass.getName(), e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("LookupDaoOjb could not get instance of " + businessObjectClass.getName(), e);
        }
        return businessObject;
    }

    protected Integer getSearchResultsLimit(Class businessObjectClass) {
        return LookupUtils.getSearchResultsLimit(businessObjectClass);
    }

    protected int getCount(Class businessObjectClass, Criteria criteria) {
        return this.getPersistenceBrokerTemplate().getCount((Query)QueryFactory.newQuery((Class)businessObjectClass, (Criteria)criteria));
    }

    protected void applySearchResultsLimit(Class businessObjectClass, Criteria criteria, DatabasePlatform databasePlatform) {
        LookupUtils.applySearchResultsLimit(businessObjectClass, criteria, databasePlatform);
    }

    protected Collection getCollectionByQuery(Class businessObjectClass, Criteria criteria) {
        return this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)QueryFactory.newQuery((Class)businessObjectClass, (Criteria)criteria));
    }

    protected Collection executeSearch(Class businessObjectClass, Criteria criteria, boolean unbounded) {
        try {
            Long matchingResultsCount = null;
            Integer searchResultsLimit = this.getSearchResultsLimit(businessObjectClass);
            if (!unbounded && searchResultsLimit != null && searchResultsLimit >= 0) {
                matchingResultsCount = new Long(this.getCount(businessObjectClass, criteria));
                this.applySearchResultsLimit(businessObjectClass, criteria, this.getDbPlatform());
            }
            if (matchingResultsCount == null || matchingResultsCount.intValue() <= searchResultsLimit) {
                matchingResultsCount = 0L;
            }
            Collection searchResults = this.getCollectionByQuery(businessObjectClass, criteria);
            ArrayList bos = new ArrayList();
            bos.addAll(searchResults);
            return new CollectionIncomplete(bos, matchingResultsCount);
        }
        catch (DataIntegrityViolationException | OjbOperationException e) {
            LOG.error((Object)"executeSearch() Error:", e);
            throw new RuntimeException("LookupDaoOjb encountered exception during executeSearch", e);
        }
    }

    protected boolean createCriteria(Object example, String searchValue, String propertyName, boolean caseInsensitive, boolean treatWildcardsAndOperatorsAsLiteral, Object criteria, Map searchValues) {
        if (!(criteria instanceof Criteria) || StringUtils.isBlank((CharSequence)searchValue) || !ObjectUtils.isWriteable(example, propertyName, this.persistenceStructureService)) {
            return false;
        }
        Class propertyType = ObjectUtils.getPropertyType(example, propertyName, this.persistenceStructureService);
        if (propertyType == null) {
            return false;
        }
        if (example instanceof InactivatableFromTo) {
            if ("active".equals(propertyName)) {
                this.addInactivateableFromToActiveCriteria(example, searchValue, (Criteria)criteria, searchValues);
            } else if ("current".equals(propertyName)) {
                this.addInactivateableFromToCurrentCriteria(example, searchValue, (Criteria)criteria, searchValues);
            } else if (!"activeAsOfDate".equals(propertyName)) {
                this.addCriteria(propertyName, searchValue, propertyType, caseInsensitive, treatWildcardsAndOperatorsAsLiteral, (Criteria)criteria);
            }
        } else {
            this.addCriteria(propertyName, searchValue, propertyType, caseInsensitive, treatWildcardsAndOperatorsAsLiteral, (Criteria)criteria);
        }
        return true;
    }

    protected void addCriteria(String propertyName, String propertyValue, Class propertyType, boolean caseInsensitive, boolean treatWildcardsAndOperatorsAsLiteral, Criteria criteria) {
        if (!treatWildcardsAndOperatorsAsLiteral && StringUtils.contains((CharSequence)propertyValue, (CharSequence)SearchOperator.OR.op())) {
            this.addOrCriteria(propertyName, propertyValue, propertyType, caseInsensitive, criteria);
            return;
        }
        if (!treatWildcardsAndOperatorsAsLiteral && StringUtils.contains((CharSequence)propertyValue, (CharSequence)SearchOperator.AND.op())) {
            this.addAndCriteria(propertyName, propertyValue, propertyType, caseInsensitive, criteria);
            return;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)propertyValue, (CharSequence)SearchOperator.NULL.op()) || StringUtils.equalsIgnoreCase((CharSequence)propertyValue, (CharSequence)SearchOperator.NOT_NULL.op())) {
            if (StringUtils.contains((CharSequence)propertyValue, (CharSequence)SearchOperator.NOT.op())) {
                criteria.addNotNull(propertyName);
            } else {
                criteria.addIsNull(propertyName);
            }
        } else if (TypeUtils.isStringClass((Class)propertyType)) {
            if (caseInsensitive) {
                propertyName = this.getDbPlatform().getUpperCaseFunction() + "(" + propertyName + ")";
                propertyValue = propertyValue.toUpperCase();
            }
            if (!treatWildcardsAndOperatorsAsLiteral && StringUtils.contains((CharSequence)propertyValue, (CharSequence)SearchOperator.NOT.op())) {
                this.addNotCriteria(propertyName, propertyValue, propertyType, caseInsensitive, criteria);
            } else if (!treatWildcardsAndOperatorsAsLiteral && propertyValue != null && (StringUtils.contains((CharSequence)propertyValue, (CharSequence)SearchOperator.BETWEEN.op()) || propertyValue.startsWith(">") || propertyValue.startsWith("<"))) {
                this.addStringRangeCriteria(propertyName, propertyValue, criteria);
            } else {
                if (treatWildcardsAndOperatorsAsLiteral) {
                    propertyValue = StringUtils.replace((String)propertyValue, (String)"*", (String)"\\*");
                }
                criteria.addLike((Object)propertyName, (Object)propertyValue);
            }
        } else if (TypeUtils.isIntegralClass((Class)propertyType) || TypeUtils.isDecimalClass((Class)propertyType)) {
            this.addNumericRangeCriteria(propertyName, propertyValue, treatWildcardsAndOperatorsAsLiteral, criteria);
        } else if (TypeUtils.isTemporalClass((Class)propertyType)) {
            this.addDateRangeCriteria(propertyName, propertyValue, treatWildcardsAndOperatorsAsLiteral, criteria);
        } else if (TypeUtils.isBooleanClass((Class)propertyType)) {
            criteria.addEqualTo(propertyName, (Object)ObjectUtils.clean(propertyValue));
        } else {
            LOG.error((Object)("not adding criterion for: " + propertyName + "," + propertyType + "," + propertyValue));
        }
    }

    protected void addInactivateableFromToActiveCriteria(Object example, String activeSearchValue, Criteria criteria, Map searchValues) {
        Timestamp activeTimestamp = org.kuali.kfs.krad.lookup.LookupUtils.getActiveDateTimestampForCriteria(searchValues);
        String activeBooleanStr = (String)new OjbCharBooleanConversion().javaToSql((Object)activeSearchValue);
        if ("Y".equals(activeBooleanStr)) {
            Criteria criteriaBeginDate = new Criteria();
            criteriaBeginDate.addLessOrEqualThan((Object)"activeFromDate", (Object)activeTimestamp);
            Criteria criteriaBeginDateNull = new Criteria();
            criteriaBeginDateNull.addIsNull("activeFromDate");
            criteriaBeginDate.addOrCriteria(criteriaBeginDateNull);
            criteria.addAndCriteria(criteriaBeginDate);
            Criteria criteriaEndDate = new Criteria();
            criteriaEndDate.addGreaterThan((Object)"activeToDate", (Object)activeTimestamp);
            Criteria criteriaEndDateNull = new Criteria();
            criteriaEndDateNull.addIsNull("activeToDate");
            criteriaEndDate.addOrCriteria(criteriaEndDateNull);
            criteria.addAndCriteria(criteriaEndDate);
        } else if ("N".equals(activeBooleanStr)) {
            Criteria criteriaNonActive = new Criteria();
            criteriaNonActive.addGreaterThan((Object)"activeFromDate", (Object)activeTimestamp);
            Criteria criteriaEndDate = new Criteria();
            criteriaEndDate.addLessOrEqualThan((Object)"activeToDate", (Object)activeTimestamp);
            criteriaNonActive.addOrCriteria(criteriaEndDate);
            criteria.addAndCriteria(criteriaNonActive);
        }
    }

    protected void addInactivateableFromToCurrentCriteria(Object example, String currentSearchValue, Criteria criteria, Map searchValues) {
        Criteria maxBeginDateCriteria = new Criteria();
        Timestamp activeTimestamp = org.kuali.kfs.krad.lookup.LookupUtils.getActiveDateTimestampForCriteria(searchValues);
        maxBeginDateCriteria.addLessOrEqualThan((Object)"activeFromDate", (Object)activeTimestamp);
        List<String> groupByFieldList = this.dataDictionaryService.getGroupByAttributesForEffectiveDating(example.getClass());
        if (groupByFieldList == null) {
            return;
        }
        String[] groupBy = new String[groupByFieldList.size()];
        for (int i = 0; i < groupByFieldList.size(); ++i) {
            String groupByField;
            groupBy[i] = groupByField = groupByFieldList.get(i);
            maxBeginDateCriteria.addEqualToField(groupByField, "parentQuery." + groupByField);
        }
        String[] columns = new String[]{"max(activeFromDate)"};
        ReportQueryByCriteria query = QueryFactory.newReportQuery(example.getClass(), (String[])columns, (Criteria)maxBeginDateCriteria, (boolean)true);
        query.addGroupBy(groupBy);
        String currentBooleanStr = (String)new OjbCharBooleanConversion().javaToSql((Object)currentSearchValue);
        if ("Y".equals(currentBooleanStr)) {
            criteria.addIn((Object)"activeFromDate", (Query)query);
        } else if ("N".equals(currentBooleanStr)) {
            criteria.addNotIn("activeFromDate", (Query)query);
        }
    }

    protected void addOrCriteria(String propertyName, String propertyValue, Class propertyType, boolean caseInsensitive, Criteria criteria) {
        this.addLogicalOperatorCriteria(propertyName, propertyValue, propertyType, caseInsensitive, criteria, SearchOperator.OR.op());
    }

    protected void addAndCriteria(String propertyName, String propertyValue, Class propertyType, boolean caseInsensitive, Criteria criteria) {
        this.addLogicalOperatorCriteria(propertyName, propertyValue, propertyType, caseInsensitive, criteria, SearchOperator.AND.op());
    }

    protected void addNotCriteria(String propertyName, String propertyValue, Class propertyType, boolean caseInsensitive, Criteria criteria) {
        Object[] splitPropVal = StringUtils.split((String)propertyValue, (String)SearchOperator.NOT.op());
        int strLength = splitPropVal.length;
        if (strLength > 1) {
            String expandedNot = SearchOperator.NOT + StringUtils.join((Object[])splitPropVal, (String)(SearchOperator.AND.op() + SearchOperator.NOT.op()));
            this.addCriteria(propertyName, expandedNot, propertyType, caseInsensitive, false, criteria);
        } else {
            criteria.addNotLike(propertyName, (Object)splitPropVal[0]);
        }
    }

    protected void addLogicalOperatorCriteria(String propertyName, String propertyValue, Class propertyType, boolean caseInsensitive, Criteria criteria, String splitValue) {
        String[] splitPropVal = StringUtils.split((String)propertyValue, (String)splitValue);
        Criteria subCriteria = new Criteria();
        for (int i = 0; i < splitPropVal.length; ++i) {
            Criteria predicate = new Criteria();
            this.addCriteria(propertyName, splitPropVal[i], propertyType, caseInsensitive, false, predicate);
            if (splitValue.equals(SearchOperator.OR.op())) {
                subCriteria.addOrCriteria(predicate);
            }
            if (!splitValue.equals(SearchOperator.AND.op())) continue;
            subCriteria.addAndCriteria(predicate);
        }
        criteria.addAndCriteria(subCriteria);
    }

    protected Date parseDate(String dateString) {
        dateString = dateString.trim();
        try {
            return this.dateTimeService.convertToSqlDate(dateString);
        }
        catch (ParseException ex) {
            return null;
        }
    }

    protected void addDateRangeCriteria(String propertyName, String propertyValue, boolean treatWildcardsAndOperatorsAsLiteral, Criteria criteria) {
        if (StringUtils.contains((CharSequence)propertyValue, (CharSequence)SearchOperator.BETWEEN.op())) {
            if (treatWildcardsAndOperatorsAsLiteral) {
                throw new RuntimeException("Wildcards and operators are not allowed on this date field: " + propertyName);
            }
            String[] rangeValues = StringUtils.split((String)propertyValue, (String)SearchOperator.BETWEEN.op());
            criteria.addBetween((Object)propertyName, (Object)this.parseDate(ObjectUtils.clean(rangeValues[0])), (Object)this.parseDate(ObjectUtils.clean(rangeValues[1])));
        } else if (propertyValue.startsWith(SearchOperator.GREATER_THAN_EQUAL.op())) {
            if (treatWildcardsAndOperatorsAsLiteral) {
                throw new RuntimeException("Wildcards and operators are not allowed on this date field: " + propertyName);
            }
            criteria.addGreaterOrEqualThan((Object)propertyName, (Object)this.parseDate(ObjectUtils.clean(propertyValue)));
        } else if (propertyValue.startsWith(SearchOperator.LESS_THAN_EQUAL.op())) {
            if (treatWildcardsAndOperatorsAsLiteral) {
                throw new RuntimeException("Wildcards and operators are not allowed on this date field: " + propertyName);
            }
            criteria.addLessOrEqualThan((Object)propertyName, (Object)this.parseDate(ObjectUtils.clean(propertyValue)));
        } else if (propertyValue.startsWith(SearchOperator.GREATER_THAN.op())) {
            if (treatWildcardsAndOperatorsAsLiteral) {
                throw new RuntimeException("Wildcards and operators are not allowed on this date field: " + propertyName);
            }
            criteria.addGreaterThan((Object)propertyName, (Object)this.parseDate(ObjectUtils.clean(propertyValue)));
        } else if (propertyValue.startsWith(SearchOperator.LESS_THAN.op())) {
            if (treatWildcardsAndOperatorsAsLiteral) {
                throw new RuntimeException("Wildcards and operators are not allowed on this date field: " + propertyName);
            }
            criteria.addLessThan((Object)propertyName, (Object)this.parseDate(ObjectUtils.clean(propertyValue)));
        } else {
            criteria.addEqualTo(propertyName, (Object)this.parseDate(ObjectUtils.clean(propertyValue)));
        }
    }

    protected BigDecimal cleanNumeric(String value) {
        String cleanedValue = value;
        if (cleanedValue.lastIndexOf(45) > 0) {
            cleanedValue = cleanedValue.charAt(0) == '-' ? "-" + cleanedValue.replaceAll("-", "") : cleanedValue.replaceAll("-", "");
        }
        int decimalLoc = cleanedValue.lastIndexOf(46);
        if (cleanedValue.indexOf(46) != decimalLoc) {
            cleanedValue = cleanedValue.substring(0, decimalLoc).replaceAll("\\.", "") + cleanedValue.substring(decimalLoc);
        }
        try {
            return new BigDecimal(cleanedValue);
        }
        catch (NumberFormatException ex) {
            GlobalVariables.getMessageMap().putError("document.document*,document.explanation*,document.reversal*,document.selected*,document.header*", "error.custom", "Invalid Numeric Input: " + value);
            return null;
        }
    }

    protected void addNumericRangeCriteria(String propertyName, String propertyValue, boolean treatWildcardsAndOperatorsAsLiteral, Criteria criteria) {
        if (StringUtils.contains((CharSequence)propertyValue, (CharSequence)SearchOperator.BETWEEN.op())) {
            if (treatWildcardsAndOperatorsAsLiteral) {
                throw new RuntimeException("Cannot use wildcards and operators on numeric field " + propertyName);
            }
            String[] rangeValues = StringUtils.split((String)propertyValue, (String)SearchOperator.BETWEEN.op());
            criteria.addBetween((Object)propertyName, (Object)this.cleanNumeric(rangeValues[0]), (Object)this.cleanNumeric(rangeValues[1]));
        } else if (propertyValue.startsWith(SearchOperator.GREATER_THAN_EQUAL.op())) {
            if (treatWildcardsAndOperatorsAsLiteral) {
                throw new RuntimeException("Cannot use wildcards and operators on numeric field " + propertyName);
            }
            criteria.addGreaterOrEqualThan((Object)propertyName, (Object)this.cleanNumeric(this.stripNumericRangeOperator(propertyValue, SearchOperator.GREATER_THAN_EQUAL)));
        } else if (propertyValue.startsWith(SearchOperator.LESS_THAN_EQUAL.op())) {
            if (treatWildcardsAndOperatorsAsLiteral) {
                throw new RuntimeException("Cannot use wildcards and operators on numeric field " + propertyName);
            }
            criteria.addLessOrEqualThan((Object)propertyName, (Object)this.cleanNumeric(this.stripNumericRangeOperator(propertyValue, SearchOperator.LESS_THAN_EQUAL)));
        } else if (propertyValue.startsWith(SearchOperator.GREATER_THAN.op())) {
            if (treatWildcardsAndOperatorsAsLiteral) {
                throw new RuntimeException("Cannot use wildcards and operators on numeric field " + propertyName);
            }
            criteria.addGreaterThan((Object)propertyName, (Object)this.cleanNumeric(this.stripNumericRangeOperator(propertyValue, SearchOperator.GREATER_THAN)));
        } else if (propertyValue.startsWith(SearchOperator.LESS_THAN.op())) {
            if (treatWildcardsAndOperatorsAsLiteral) {
                throw new RuntimeException("Cannot use wildcards and operators on numeric field " + propertyName);
            }
            criteria.addLessThan((Object)propertyName, (Object)this.cleanNumeric(this.stripNumericRangeOperator(propertyValue, SearchOperator.LESS_THAN)));
        } else {
            criteria.addEqualTo(propertyName, (Object)this.cleanNumeric(propertyValue));
        }
    }

    protected String stripNumericRangeOperator(String propertyValue, SearchOperator operator) {
        String propertyValueWithoutOperator = StringUtils.replace((String)propertyValue, (String)operator.op(), (String)"");
        return propertyValueWithoutOperator;
    }

    protected void addStringRangeCriteria(String propertyName, String propertyValue, Criteria criteria) {
        if (StringUtils.contains((CharSequence)propertyValue, (CharSequence)SearchOperator.BETWEEN.op())) {
            String[] rangeValues = StringUtils.split((String)propertyValue, (String)SearchOperator.BETWEEN.op());
            criteria.addBetween((Object)propertyName, (Object)rangeValues[0], (Object)rangeValues[1]);
        } else if (propertyValue.startsWith(SearchOperator.GREATER_THAN_EQUAL.op())) {
            criteria.addGreaterOrEqualThan((Object)propertyName, (Object)ObjectUtils.clean(propertyValue));
        } else if (propertyValue.startsWith(SearchOperator.LESS_THAN_EQUAL.op())) {
            criteria.addLessOrEqualThan((Object)propertyName, (Object)ObjectUtils.clean(propertyValue));
        } else if (propertyValue.startsWith(SearchOperator.GREATER_THAN.op())) {
            criteria.addGreaterThan((Object)propertyName, (Object)ObjectUtils.clean(propertyValue));
        } else if (propertyValue.startsWith(SearchOperator.LESS_THAN.op())) {
            criteria.addLessThan((Object)propertyName, (Object)ObjectUtils.clean(propertyValue));
        } else {
            criteria.addEqualTo(propertyName, (Object)ObjectUtils.clean(propertyValue));
        }
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public void setPersistenceStructureService(PersistenceStructureService persistenceStructureService) {
        this.persistenceStructureService = persistenceStructureService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }
}

