/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.datadictionary;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.krad.datadictionary.DataDictionaryEntryBase;
import org.kuali.kfs.krad.datadictionary.DataDictionaryException;
import org.kuali.kfs.krad.datadictionary.ReferenceDefinition;
import org.kuali.kfs.krad.datadictionary.WorkflowAttributes;
import org.kuali.kfs.krad.datadictionary.WorkflowProperties;
import org.kuali.kfs.krad.datadictionary.exception.DuplicateEntryException;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.document.DocumentAuthorizer;
import org.kuali.kfs.krad.document.DocumentAuthorizerBase;
import org.kuali.kfs.krad.document.DocumentPresentationController;
import org.kuali.kfs.krad.document.DocumentPresentationControllerBase;
import org.kuali.kfs.krad.keyvalues.KeyValuesFinder;
import org.kuali.kfs.krad.rules.rule.BusinessRule;

public abstract class DocumentEntry
extends DataDictionaryEntryBase {
    private static final long serialVersionUID = 8231730871830055356L;
    private static final Logger LOG = Logger.getLogger(DocumentEntry.class);
    protected String documentTypeName;
    protected Class<? extends Document> documentClass;
    protected Class<? extends Document> baseDocumentClass;
    protected Class<? extends BusinessRule> businessRulesClass;
    protected boolean allowsNoteAttachments = true;
    protected boolean allowsNoteFYI = false;
    protected Class<? extends KeyValuesFinder> attachmentTypesValuesFinderClass;
    protected boolean displayTopicFieldInNotes = false;
    protected boolean encryptDocumentDataInPersistentSessionStorage = false;
    protected boolean allowsCopy = false;
    protected WorkflowProperties workflowProperties;
    protected WorkflowAttributes workflowAttributes;
    protected Class<? extends DocumentAuthorizer> documentAuthorizerClass = DocumentAuthorizerBase.class;
    protected Class<? extends DocumentPresentationController> documentPresentationControllerClass = DocumentPresentationControllerBase.class;
    protected List<ReferenceDefinition> defaultExistenceChecks = new ArrayList<ReferenceDefinition>();
    protected Map<String, ReferenceDefinition> defaultExistenceCheckMap = new LinkedHashMap<String, ReferenceDefinition>();

    @Override
    public String getJstlKey() {
        return this.documentTypeName;
    }

    public void setDocumentClass(Class<? extends Document> documentClass) {
        if (documentClass == null) {
            throw new IllegalArgumentException("invalid (null) documentClass");
        }
        this.documentClass = documentClass;
    }

    public Class<? extends Document> getDocumentClass() {
        return this.documentClass;
    }

    public void setBaseDocumentClass(Class<? extends Document> baseDocumentClass) {
        this.baseDocumentClass = baseDocumentClass;
    }

    public Class<? extends Document> getBaseDocumentClass() {
        return this.baseDocumentClass;
    }

    public void setBusinessRulesClass(Class<? extends BusinessRule> businessRulesClass) {
        this.businessRulesClass = businessRulesClass;
    }

    public Class<? extends BusinessRule> getBusinessRulesClass() {
        return this.businessRulesClass;
    }

    public void setDocumentTypeName(String documentTypeName) {
        if (StringUtils.isBlank((CharSequence)documentTypeName)) {
            throw new IllegalArgumentException("invalid (blank) documentTypeName");
        }
        this.documentTypeName = documentTypeName;
    }

    public String getDocumentTypeName() {
        return this.documentTypeName;
    }

    @Override
    public void completeValidation() {
        super.completeValidation();
        if (this.workflowProperties != null && this.workflowAttributes != null) {
            throw new DataDictionaryException(this.documentTypeName + ": workflowProperties and workflowAttributes cannot both be defined for a document");
        }
    }

    @Override
    public String getFullClassName() {
        if (this.getBaseDocumentClass() != null) {
            return this.getBaseDocumentClass().getName();
        }
        if (this.getDocumentClass() != null) {
            return this.getDocumentClass().getName();
        }
        return "";
    }

    public Class getEntryClass() {
        return this.getDocumentClass();
    }

    public String toString() {
        return "DocumentEntry for documentType " + this.documentTypeName;
    }

    public boolean getDisplayTopicFieldInNotes() {
        return this.displayTopicFieldInNotes;
    }

    public void setDisplayTopicFieldInNotes(boolean displayTopicFieldInNotes) {
        this.displayTopicFieldInNotes = displayTopicFieldInNotes;
    }

    public void setAttachmentTypesValuesFinderClass(Class<? extends KeyValuesFinder> attachmentTypesValuesFinderClass) {
        if (attachmentTypesValuesFinderClass == null) {
            throw new IllegalArgumentException("invalid (null) attachmentTypesValuesFinderClass");
        }
        this.attachmentTypesValuesFinderClass = attachmentTypesValuesFinderClass;
    }

    public Class<? extends KeyValuesFinder> getAttachmentTypesValuesFinderClass() {
        return this.attachmentTypesValuesFinderClass;
    }

    public void setAllowsCopy(boolean allowsCopy) {
        this.allowsCopy = allowsCopy;
    }

    public boolean getAllowsCopy() {
        return this.allowsCopy;
    }

    public boolean getAllowsNoteAttachments() {
        return this.allowsNoteAttachments;
    }

    public void setAllowsNoteAttachments(boolean allowsNoteAttachments) {
        this.allowsNoteAttachments = allowsNoteAttachments;
    }

    public boolean getAllowsNoteFYI() {
        return this.allowsNoteFYI;
    }

    public void setAllowsNoteFYI(boolean allowsNoteFYI) {
        this.allowsNoteFYI = allowsNoteFYI;
    }

    public WorkflowProperties getWorkflowProperties() {
        return this.workflowProperties;
    }

    public void setWorkflowProperties(WorkflowProperties workflowProperties) {
        this.workflowProperties = workflowProperties;
    }

    public WorkflowAttributes getWorkflowAttributes() {
        return this.workflowAttributes;
    }

    public void setWorkflowAttributes(WorkflowAttributes workflowAttributes) {
        this.workflowAttributes = workflowAttributes;
    }

    public Class<? extends DocumentAuthorizer> getDocumentAuthorizerClass() {
        return this.documentAuthorizerClass;
    }

    public void setDocumentAuthorizerClass(Class<? extends DocumentAuthorizer> documentAuthorizerClass) {
        this.documentAuthorizerClass = documentAuthorizerClass;
    }

    public Class<? extends DocumentPresentationController> getDocumentPresentationControllerClass() {
        return this.documentPresentationControllerClass;
    }

    public void setDocumentPresentationControllerClass(Class<? extends DocumentPresentationController> documentPresentationControllerClass) {
        this.documentPresentationControllerClass = documentPresentationControllerClass;
    }

    public List<ReferenceDefinition> getDefaultExistenceChecks() {
        return this.defaultExistenceChecks;
    }

    public void setDefaultExistenceChecks(List<ReferenceDefinition> defaultExistenceChecks) {
        this.defaultExistenceChecks = defaultExistenceChecks;
    }

    public List<String> getDefaultExistenceCheckFieldNames() {
        ArrayList<String> fieldNames = new ArrayList<String>();
        fieldNames.addAll(this.defaultExistenceCheckMap.keySet());
        return fieldNames;
    }

    public boolean isEncryptDocumentDataInPersistentSessionStorage() {
        return this.encryptDocumentDataInPersistentSessionStorage;
    }

    public void setEncryptDocumentDataInPersistentSessionStorage(boolean encryptDocumentDataInPersistentSessionStorage) {
        this.encryptDocumentDataInPersistentSessionStorage = encryptDocumentDataInPersistentSessionStorage;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        if (this.defaultExistenceChecks != null) {
            this.defaultExistenceCheckMap.clear();
            for (ReferenceDefinition reference : this.defaultExistenceChecks) {
                String keyName;
                if (reference == null) {
                    throw new IllegalArgumentException("invalid (null) defaultExistenceCheck");
                }
                String string = keyName = reference.isCollectionReference() ? reference.getCollection() + "." + reference.getAttributeName() : reference.getAttributeName();
                if (this.defaultExistenceCheckMap.containsKey(keyName)) {
                    throw new DuplicateEntryException("duplicate defaultExistenceCheck entry for attribute '" + keyName + "'");
                }
                reference.setBusinessObjectClass(this.getEntryClass());
                this.defaultExistenceCheckMap.put(keyName, reference);
            }
        }
    }
}

