/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.rules.rule.event;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;

public abstract class KualiDocumentEventBase
implements KualiDocumentEvent {
    private static final Logger LOG = Logger.getLogger(KualiDocumentEventBase.class);
    private final String description;
    private final String errorPathPrefix;
    protected Document document;

    protected KualiDocumentEventBase(String description, String errorPathPrefix) {
        this.description = description;
        this.errorPathPrefix = errorPathPrefix;
    }

    public KualiDocumentEventBase(String description, String errorPathPrefix, Document document) {
        this.description = description;
        this.errorPathPrefix = errorPathPrefix;
        this.document = document;
        LOG.debug((Object)description);
    }

    @Override
    public final Document getDocument() {
        return this.document;
    }

    @Override
    public final String getName() {
        return this.getClass().getName();
    }

    @Override
    public final String getDescription() {
        return this.description;
    }

    @Override
    public String getErrorPathPrefix() {
        return this.errorPathPrefix;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public void validate() {
        if (this.getDocument() == null) {
            throw new IllegalArgumentException("invalid (null) event document");
        }
    }

    @Override
    public List<KualiDocumentEvent> generateEvents() {
        return new ArrayList<KualiDocumentEvent>();
    }

    protected static String getDocumentId(Document document) {
        String docId = "(null document)";
        if (document != null) {
            String documentNumber = document.getDocumentNumber();
            docId = StringUtils.isBlank((CharSequence)documentNumber) ? "(blank documentNumber)" : documentNumber;
        }
        return docId;
    }
}

