/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.krad.bo.DataObjectRelationship;
import org.kuali.kfs.krad.datadictionary.InactivationBlockingMetadata;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DataObjectMetaDataService;
import org.kuali.kfs.krad.service.InactivationBlockingDetectionService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.rice.core.api.mo.common.active.MutableInactivatable;
import org.kuali.rice.krad.bo.BusinessObject;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class InactivationBlockingDetectionServiceImpl
implements InactivationBlockingDetectionService {
    private static final Logger LOG = Logger.getLogger(InactivationBlockingDetectionServiceImpl.class);
    protected DataObjectMetaDataService dataObjectMetaDataService;
    protected BusinessObjectService businessObjectService;

    @Override
    public Collection<BusinessObject> listAllBlockerRecords(BusinessObject blockedBo, InactivationBlockingMetadata inactivationBlockingMetadata) {
        ArrayList<BusinessObject> blockingRecords = new ArrayList<BusinessObject>();
        Map<String, String> queryMap = this.buildInactivationBlockerQueryMap(blockedBo, inactivationBlockingMetadata);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Checking for blocker records for object: " + blockedBo));
            LOG.debug((Object)("    With Metadata: " + inactivationBlockingMetadata));
            LOG.debug((Object)("    Resulting Query Map: " + queryMap));
        }
        if (queryMap != null) {
            Collection potentialBlockingRecords = this.businessObjectService.findMatching(inactivationBlockingMetadata.getBlockingReferenceBusinessObjectClass(), queryMap);
            for (MutableInactivatable businessObject : potentialBlockingRecords) {
                if (!businessObject.isActive()) continue;
                blockingRecords.add((BusinessObject)businessObject);
            }
        }
        return blockingRecords;
    }

    @Override
    public boolean hasABlockingRecord(BusinessObject blockedBo, InactivationBlockingMetadata inactivationBlockingMetadata) {
        boolean hasBlockingRecord = false;
        Map<String, String> queryMap = this.buildInactivationBlockerQueryMap(blockedBo, inactivationBlockingMetadata);
        if (queryMap != null) {
            Collection potentialBlockingRecords = this.businessObjectService.findMatching(inactivationBlockingMetadata.getBlockingReferenceBusinessObjectClass(), queryMap);
            for (MutableInactivatable businessObject : potentialBlockingRecords) {
                if (!businessObject.isActive()) continue;
                hasBlockingRecord = true;
                break;
            }
        }
        return hasBlockingRecord;
    }

    protected Map<String, String> buildInactivationBlockerQueryMap(BusinessObject blockedBo, InactivationBlockingMetadata inactivationBlockingMetadata) {
        BusinessObject blockingBo = (BusinessObject)ObjectUtils.createNewObjectFromClass(inactivationBlockingMetadata.getBlockingReferenceBusinessObjectClass());
        DataObjectRelationship dataObjectRelationship = this.dataObjectMetaDataService.getDataObjectRelationship(blockingBo, blockedBo.getClass(), inactivationBlockingMetadata.getBlockedReferencePropertyName(), "", true, false, false);
        if (dataObjectRelationship != null) {
            Map<String, String> parentToChildReferences = dataObjectRelationship.getParentToChildReferences();
            HashMap<String, String> queryMap = new HashMap<String, String>();
            for (Map.Entry<String, String> parentToChildReference : parentToChildReferences.entrySet()) {
                String fieldName = parentToChildReference.getKey();
                Object fieldValue = ObjectUtils.getPropertyValue(blockedBo, parentToChildReference.getValue());
                if (fieldValue != null && StringUtils.isNotBlank((CharSequence)fieldValue.toString())) {
                    queryMap.put(fieldName, fieldValue.toString());
                    continue;
                }
                LOG.error((Object)("Found null value for foreign key field " + fieldName + " while building inactivation blocking query map."));
                throw new RuntimeException("Found null value for foreign key field '" + fieldName + "' while building inactivation blocking query map.");
            }
            return queryMap;
        }
        return null;
    }

    public void setDataObjectMetaDataService(DataObjectMetaDataService dataObjectMetaDataService) {
        this.dataObjectMetaDataService = dataObjectMetaDataService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

