/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.kns.document.authorization.BusinessObjectRestrictions;
import org.kuali.kfs.kns.document.authorization.FieldRestriction;
import org.kuali.kfs.kns.service.BusinessObjectAuthorizationService;
import org.kuali.kfs.kns.service.KNSServiceLocator;
import org.kuali.kfs.krad.datadictionary.InactivationBlockingMetadata;
import org.kuali.kfs.krad.datadictionary.mask.MaskFormatter;
import org.kuali.kfs.krad.service.DataDictionaryService;
import org.kuali.kfs.krad.service.InactivationBlockingDetectionService;
import org.kuali.kfs.krad.service.InactivationBlockingDisplayService;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.service.PersistenceService;
import org.kuali.kfs.krad.service.PersistenceStructureService;
import org.kuali.kfs.krad.service.impl.InactivationBlockingDetectionServiceImpl;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.rice.core.web.format.Formatter;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.bo.BusinessObject;

public class InactivationBlockingDisplayServiceImpl
implements InactivationBlockingDisplayService {
    private static final Logger LOG = Logger.getLogger(InactivationBlockingDetectionServiceImpl.class);
    private PersistenceService persistenceService;
    private DataDictionaryService dataDictionaryService;
    private PersistenceStructureService persistenceStructureService;
    private BusinessObjectAuthorizationService businessObjectAuthorizationService;

    @Override
    public List<String> listAllBlockerRecords(BusinessObject blockedBo, InactivationBlockingMetadata inactivationBlockingMetadata) {
        String inactivationBlockingDetectionServiceBeanName = inactivationBlockingMetadata.getInactivationBlockingDetectionServiceBeanName();
        if (StringUtils.isBlank((CharSequence)inactivationBlockingDetectionServiceBeanName)) {
            inactivationBlockingDetectionServiceBeanName = "cf.inactivationBlockingDetectionService";
        }
        InactivationBlockingDetectionService inactivationBlockingDetectionService = KRADServiceLocatorWeb.getInactivationBlockingDetectionService(inactivationBlockingDetectionServiceBeanName);
        Collection<BusinessObject> collection = inactivationBlockingDetectionService.listAllBlockerRecords(blockedBo, inactivationBlockingMetadata);
        Map<String, Formatter> formatters = this.getFormattersForPrimaryKeyFields(inactivationBlockingMetadata.getBlockingReferenceBusinessObjectClass());
        ArrayList<String> displayValues = new ArrayList<String>();
        List pkFieldNames = this.persistenceStructureService.listPrimaryKeyFieldNames(inactivationBlockingMetadata.getBlockingReferenceBusinessObjectClass());
        Person user = GlobalVariables.getUserSession().getPerson();
        for (BusinessObject element : collection) {
            StringBuilder buf = new StringBuilder();
            BusinessObjectRestrictions businessObjectRestrictions = this.getBusinessObjectAuthorizationService().getLookupResultRestrictions(element, user);
            for (int i = 0; i < pkFieldNames.size(); ++i) {
                String pkFieldName = (String)pkFieldNames.get(i);
                Object value = ObjectUtils.getPropertyValue(element, pkFieldName);
                String displayValue = null;
                if (!businessObjectRestrictions.hasRestriction(pkFieldName)) {
                    Formatter formatter = formatters.get(pkFieldName);
                    displayValue = formatter != null ? (String)formatter.format(value) : String.valueOf(value);
                } else {
                    FieldRestriction fieldRestriction = businessObjectRestrictions.getFieldRestriction(pkFieldName);
                    if (fieldRestriction.isMasked() || fieldRestriction.isPartiallyMasked()) {
                        MaskFormatter maskFormatter = fieldRestriction.getMaskFormatter();
                        displayValue = maskFormatter.maskValue(value);
                    } else {
                        LOG.warn((Object)("Restriction was defined for class: " + element.getClass() + " field name: " + pkFieldName + ", but it was not honored by the inactivation blocking display framework"));
                    }
                }
                buf.append(displayValue);
                if (i >= pkFieldNames.size() - 1) continue;
                buf.append(" - ");
            }
            displayValues.add(buf.toString());
        }
        return displayValues;
    }

    protected Map<String, Formatter> getFormattersForPrimaryKeyFields(Class boClass) {
        List keyNames = this.persistenceStructureService.listPrimaryKeyFieldNames(boClass);
        HashMap<String, Formatter> formattersForPrimaryKeyFields = new HashMap<String, Formatter>();
        for (String pkFieldName : keyNames) {
            Formatter formatter = null;
            Class<? extends Formatter> formatterClass = this.dataDictionaryService.getAttributeFormatter(boClass, pkFieldName);
            if (formatterClass == null) continue;
            try {
                formatter = formatterClass.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return formattersForPrimaryKeyFields;
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public void setPersistenceStructureService(PersistenceStructureService persistenceStructureService) {
        this.persistenceStructureService = persistenceStructureService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    protected BusinessObjectAuthorizationService getBusinessObjectAuthorizationService() {
        if (this.businessObjectAuthorizationService == null) {
            this.businessObjectAuthorizationService = KNSServiceLocator.getBusinessObjectAuthorizationService();
        }
        return this.businessObjectAuthorizationService;
    }
}

