/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.service.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.krad.bo.AdHocRoutePerson;
import org.kuali.kfs.krad.bo.AdHocRouteWorkgroup;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.document.TransactionalDocument;
import org.kuali.kfs.krad.exception.InfrastructureException;
import org.kuali.kfs.krad.maintenance.MaintenanceDocument;
import org.kuali.kfs.krad.rules.MaintenanceDocumentRuleBase;
import org.kuali.kfs.krad.rules.TransactionalDocumentRuleBase;
import org.kuali.kfs.krad.rules.rule.BusinessRule;
import org.kuali.kfs.krad.rules.rule.event.AddAdHocRoutePersonEvent;
import org.kuali.kfs.krad.rules.rule.event.AddAdHocRouteWorkgroupEvent;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.krad.service.DataDictionaryService;
import org.kuali.kfs.krad.service.DocumentDictionaryService;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.service.KualiRuleService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.MessageMap;

public class KualiRuleServiceImpl
implements KualiRuleService {
    private static final Logger LOG = Logger.getLogger(KualiRuleServiceImpl.class);
    private DocumentDictionaryService documentDictionaryService;
    private DataDictionaryService dataDictionaryService;

    @Override
    public boolean applyRules(KualiDocumentEvent event) {
        if (event == null) {
            throw new IllegalArgumentException("invalid (null) event");
        }
        event.validate();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("calling applyRules for event " + event));
        }
        BusinessRule rule = this.getBusinessRulesInstance(event.getDocument(), event.getRuleInterfaceClass());
        boolean success = true;
        if (rule != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("processing " + event.getName() + " with rule " + rule.getClass().getName()));
            }
            this.increaseErrorPath(event.getErrorPathPrefix());
            List<KualiDocumentEvent> events = event.generateEvents();
            for (KualiDocumentEvent generatedEvent : events) {
                success &= this.applyRules(generatedEvent);
            }
            this.decreaseErrorPath(event.getErrorPathPrefix());
            if (!(success &= event.invokeRuleMethod(rule))) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(event.getName() + " businessRule " + rule.getClass().getName() + " failed"));
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("processed " + event.getName() + " for rule " + rule.getClass().getName()));
            }
        }
        return success;
    }

    @Override
    public List<AddAdHocRoutePersonEvent> generateAdHocRoutePersonEvents(Document document) {
        List<AdHocRoutePerson> adHocRoutePersons = document.getAdHocRoutePersons();
        ArrayList<AddAdHocRoutePersonEvent> events = new ArrayList<AddAdHocRoutePersonEvent>();
        for (int i = 0; i < adHocRoutePersons.size(); ++i) {
            events.add(new AddAdHocRoutePersonEvent("adHocRoutePerson[" + i + "]", document, adHocRoutePersons.get(i)));
        }
        return events;
    }

    @Override
    public List<AddAdHocRouteWorkgroupEvent> generateAdHocRouteWorkgroupEvents(Document document) {
        List<AdHocRouteWorkgroup> adHocRouteWorkgroups = document.getAdHocRouteWorkgroups();
        ArrayList<AddAdHocRouteWorkgroupEvent> events = new ArrayList<AddAdHocRouteWorkgroupEvent>();
        for (int i = 0; i < adHocRouteWorkgroups.size(); ++i) {
            events.add(new AddAdHocRouteWorkgroupEvent("adHocRouteWorkgroup[" + i + "]", document, adHocRouteWorkgroups.get(i)));
        }
        return events;
    }

    @Override
    public BusinessRule getBusinessRulesInstance(Document document, Class<? extends BusinessRule> ruleInterface) {
        Class<? extends BusinessRule> businessRulesClass = null;
        if (document instanceof TransactionalDocument) {
            TransactionalDocument transactionalDocument = (TransactionalDocument)document;
            businessRulesClass = this.getDocumentDictionaryService().getBusinessRulesClass(transactionalDocument);
            if (businessRulesClass == null) {
                return new TransactionalDocumentRuleBase();
            }
        } else if (document instanceof MaintenanceDocument) {
            MaintenanceDocument maintenanceDocument = (MaintenanceDocument)document;
            businessRulesClass = this.getDocumentDictionaryService().getBusinessRulesClass(maintenanceDocument);
            if (businessRulesClass == null) {
                return new MaintenanceDocumentRuleBase();
            }
        } else {
            LOG.error((Object)("unable to get businessRulesClass for unknown document type '" + document.getClass().getName() + "'"));
        }
        BusinessRule rule = null;
        if (businessRulesClass != null) {
            try {
                if (ruleInterface.isAssignableFrom(businessRulesClass)) {
                    rule = businessRulesClass.newInstance();
                }
            }
            catch (IllegalAccessException e) {
                throw new InfrastructureException("error processing business rules", e);
            }
            catch (InstantiationException e) {
                throw new InfrastructureException("error processing business rules", e);
            }
        }
        return rule;
    }

    private void increaseErrorPath(String errorPathPrefix) {
        MessageMap errorMap = GlobalVariables.getMessageMap();
        if (!StringUtils.isBlank((CharSequence)errorPathPrefix)) {
            errorMap.addToErrorPath(errorPathPrefix);
        }
    }

    private void decreaseErrorPath(String errorPathPrefix) {
        MessageMap errorMap = GlobalVariables.getMessageMap();
        if (!StringUtils.isBlank((CharSequence)errorPathPrefix)) {
            errorMap.removeFromErrorPath(errorPathPrefix);
        }
    }

    public DocumentDictionaryService getDocumentDictionaryService() {
        if (this.documentDictionaryService == null) {
            this.documentDictionaryService = KRADServiceLocatorWeb.getDocumentDictionaryService();
        }
        return this.documentDictionaryService;
    }

    public void setDocumentDictionaryService(DocumentDictionaryService documentDictionaryService) {
        this.documentDictionaryService = documentDictionaryService;
    }

    public DataDictionaryService getDataDictionaryService() {
        return this.dataDictionaryService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }
}

